/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.CacheUtils;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=PluginArtifactsCache.class)
public class DefaultPluginArtifactsCache
implements PluginArtifactsCache {
    protected final Map<PluginArtifactsCache.Key, PluginArtifactsCache.CacheRecord> cache = new HashMap<PluginArtifactsCache.Key, PluginArtifactsCache.CacheRecord>();

    @Override
    public PluginArtifactsCache.Key createKey(Plugin plugin, DependencyFilter extensionFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
        return new CacheKey(plugin, extensionFilter, repositories, session);
    }

    @Override
    public PluginArtifactsCache.CacheRecord get(PluginArtifactsCache.Key key) throws PluginResolutionException {
        PluginArtifactsCache.CacheRecord cacheRecord = this.cache.get(key);
        if (cacheRecord != null && cacheRecord.exception != null) {
            throw cacheRecord.exception;
        }
        return cacheRecord;
    }

    @Override
    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, List<Artifact> pluginArtifacts) {
        if (pluginArtifacts == null) {
            throw new NullPointerException();
        }
        this.assertUniqueKey(key);
        PluginArtifactsCache.CacheRecord record = new PluginArtifactsCache.CacheRecord(Collections.unmodifiableList(new ArrayList<Artifact>(pluginArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    protected void assertUniqueKey(PluginArtifactsCache.Key key) {
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate artifact resolution result for plugin " + key);
        }
    }

    @Override
    public PluginArtifactsCache.CacheRecord put(PluginArtifactsCache.Key key, PluginResolutionException exception) {
        if (exception == null) {
            throw new NullPointerException();
        }
        this.assertUniqueKey(key);
        PluginArtifactsCache.CacheRecord record = new PluginArtifactsCache.CacheRecord(exception);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project, PluginArtifactsCache.CacheRecord record) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheKey
    implements PluginArtifactsCache.Key {
        private final Plugin plugin;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final DependencyFilter filter;
        private final int hashCode;

        public CacheKey(Plugin plugin, DependencyFilter extensionFilter, List<RemoteRepository> repositories, RepositorySystemSession session) {
            this.plugin = plugin.clone();
            this.workspace = CacheUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.filter = extensionFilter;
            int hash = 17;
            hash = hash * 31 + CacheUtils.pluginHashCode(plugin);
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + CacheKey.hash(this.localRepo);
            hash = hash * 31 + CacheUtils.repositoriesHashCode(repositories);
            this.hashCode = hash = hash * 31 + CacheKey.hash(extensionFilter);
        }

        public String toString() {
            return this.plugin.getId();
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return CacheUtils.pluginEquals(this.plugin, that.plugin) && CacheKey.eq(this.workspace, that.workspace) && CacheKey.eq(this.localRepo, that.localRepo) && CacheUtils.repositoriesEquals(this.repositories, that.repositories) && CacheKey.eq(this.filter, that.filter);
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

