/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.filtering;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.FilteringUtils;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.codehaus.plexus.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;

@Singleton
@Named
public class DefaultMavenResourcesFiltering
implements MavenResourcesFiltering {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMavenResourcesFiltering.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private final List<String> defaultNonFilteredFileExtensions;
    private final MavenFileFilter mavenFileFilter;
    private final BuildContext buildContext;

    @Inject
    public DefaultMavenResourcesFiltering(MavenFileFilter mavenFileFilter, BuildContext buildContext) {
        this.mavenFileFilter = Objects.requireNonNull(mavenFileFilter);
        this.buildContext = Objects.requireNonNull(buildContext);
        this.defaultNonFilteredFileExtensions = new ArrayList<String>(5);
        this.defaultNonFilteredFileExtensions.add("jpg");
        this.defaultNonFilteredFileExtensions.add("jpeg");
        this.defaultNonFilteredFileExtensions.add("gif");
        this.defaultNonFilteredFileExtensions.add("bmp");
        this.defaultNonFilteredFileExtensions.add("png");
        this.defaultNonFilteredFileExtensions.add("ico");
    }

    @Override
    public boolean filteredFileExtension(String fileName, List<String> userNonFilteredFileExtensions) {
        String extension;
        boolean filteredFileExtension;
        ArrayList<String> nonFilteredFileExtensions = new ArrayList<String>(this.getDefaultNonFilteredFileExtensions());
        if (userNonFilteredFileExtensions != null) {
            nonFilteredFileExtensions.addAll(userNonFilteredFileExtensions);
        }
        boolean bl = filteredFileExtension = !nonFilteredFileExtensions.contains(extension = DefaultMavenResourcesFiltering.getExtension(fileName));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("file " + fileName + " has a" + (filteredFileExtension ? " " : " non ") + "filtered file extension");
        }
        return filteredFileExtension;
    }

    private static String getExtension(String fileName) {
        String rawExt = FilenameUtils.getExtension((String)fileName);
        return rawExt == null ? null : rawExt.toLowerCase(Locale.ROOT);
    }

    @Override
    public List<String> getDefaultNonFilteredFileExtensions() {
        return this.defaultNonFilteredFileExtensions;
    }

    @Override
    public void filterResources(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        if (mavenResourcesExecution == null) {
            throw new MavenFilteringException("mavenResourcesExecution cannot be null");
        }
        if (mavenResourcesExecution.getResources() == null) {
            LOGGER.info("No resources configured skip copying/filtering");
            return;
        }
        if (mavenResourcesExecution.getOutputDirectory() == null) {
            throw new MavenFilteringException("outputDirectory cannot be null");
        }
        if (mavenResourcesExecution.isUseDefaultFilterWrappers()) {
            this.handleDefaultFilterWrappers(mavenResourcesExecution);
        }
        if (mavenResourcesExecution.getEncoding() == null || mavenResourcesExecution.getEncoding().length() < 1) {
            LOGGER.warn("Using platform encoding (" + System.getProperty("file.encoding") + " actually) to copy filtered resources, i.e. build is platform dependent!");
        } else {
            LOGGER.debug("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered resources.");
        }
        if (mavenResourcesExecution.getPropertiesEncoding() == null || mavenResourcesExecution.getPropertiesEncoding().length() < 1) {
            LOGGER.debug("Using '" + mavenResourcesExecution.getEncoding() + "' encoding to copy filtered properties files.");
        } else {
            LOGGER.debug("Using '" + mavenResourcesExecution.getPropertiesEncoding() + "' encoding to copy filtered properties files.");
        }
        boolean isFilteringUsed = false;
        ArrayList<File> propertiesFiles = new ArrayList<File>();
        for (Resource resource : mavenResourcesExecution.getResources()) {
            File destinationFile;
            File resourceDirectory;
            if (LOGGER.isDebugEnabled()) {
                String ls = System.lineSeparator();
                StringBuilder debugMessage = new StringBuilder("resource with targetPath ").append(resource.getTargetPath()).append(ls);
                debugMessage.append("directory ").append(resource.getDirectory()).append(ls);
                debugMessage.append("excludes ").append(resource.getExcludes() == null ? " empty " : resource.getExcludes().toString()).append(ls);
                debugMessage.append("includes ").append(resource.getIncludes() == null ? " empty " : resource.getIncludes().toString());
                LOGGER.debug(debugMessage.toString());
            }
            String targetPath = resource.getTargetPath();
            File file = resourceDirectory = resource.getDirectory() == null ? null : new File(resource.getDirectory());
            if (resourceDirectory != null && !resourceDirectory.isAbsolute()) {
                resourceDirectory = new File(mavenResourcesExecution.getResourcesBaseDirectory(), resourceDirectory.getPath());
            }
            if (resourceDirectory == null || !resourceDirectory.exists()) {
                LOGGER.info("skip non existing resourceDirectory " + resourceDirectory);
                continue;
            }
            File outputDirectory = mavenResourcesExecution.getOutputDirectory();
            boolean outputExists = outputDirectory.exists();
            if (!outputExists && !outputDirectory.mkdirs()) {
                throw new MavenFilteringException("Cannot create resource output directory: " + outputDirectory);
            }
            if (resource.isFiltering()) {
                isFilteringUsed = true;
            }
            boolean ignoreDelta = !outputExists || this.buildContext.hasDelta(mavenResourcesExecution.getFileFilters()) || this.buildContext.hasDelta(this.getRelativeOutputDirectory(mavenResourcesExecution));
            LOGGER.debug("ignoreDelta " + ignoreDelta);
            Scanner scanner = this.buildContext.newScanner(resourceDirectory, ignoreDelta);
            this.setupScanner(resource, scanner, mavenResourcesExecution.isAddDefaultExcludes());
            scanner.scan();
            if (mavenResourcesExecution.isIncludeEmptyDirs()) {
                try {
                    File targetDirectory = targetPath == null ? outputDirectory : new File(outputDirectory, targetPath);
                    this.copyDirectoryLayout(resourceDirectory, targetDirectory, scanner);
                }
                catch (IOException e) {
                    throw new MavenFilteringException("Cannot copy directory structure from " + resourceDirectory.getPath() + " to " + outputDirectory.getPath());
                }
            }
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            LOGGER.info("Copying " + includedFiles.size() + " resource" + (includedFiles.size() > 1 ? "s" : "") + (targetPath == null ? "" : " to " + targetPath));
            for (String name : includedFiles) {
                LOGGER.debug("Copying file " + name);
                File source = new File(resourceDirectory, name);
                destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                if (mavenResourcesExecution.isFlatten() && destinationFile.exists()) {
                    if (mavenResourcesExecution.isOverwrite()) {
                        LOGGER.warn("existing file " + destinationFile.getName() + " will be overwritten by " + name);
                    } else {
                        throw new MavenFilteringException("existing file " + destinationFile.getName() + " will be overwritten by " + name + " and overwrite was not set to true");
                    }
                }
                boolean filteredExt = this.filteredFileExtension(source.getName(), mavenResourcesExecution.getNonFilteredFileExtensions());
                if (resource.isFiltering() && DefaultMavenResourcesFiltering.isPropertiesFile(source)) {
                    propertiesFiles.add(source);
                }
                String encoding = DefaultMavenResourcesFiltering.getEncoding(source, mavenResourcesExecution.getEncoding(), mavenResourcesExecution.getPropertiesEncoding());
                LOGGER.debug("Using '" + encoding + "' encoding to copy filtered resource '" + source.getName() + "'.");
                this.mavenFileFilter.copyFile(source, destinationFile, resource.isFiltering() && filteredExt, mavenResourcesExecution.getFilterWrappers(), encoding, mavenResourcesExecution.isOverwrite());
            }
            scanner = this.buildContext.newDeleteScanner(resourceDirectory);
            this.setupScanner(resource, scanner, mavenResourcesExecution.isAddDefaultExcludes());
            scanner.scan();
            List<String> deletedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : deletedFiles) {
                destinationFile = this.getDestinationFile(outputDirectory, targetPath, name, mavenResourcesExecution);
                destinationFile.delete();
                this.buildContext.refresh(destinationFile);
            }
        }
        if ((mavenResourcesExecution.getPropertiesEncoding() == null || mavenResourcesExecution.getPropertiesEncoding().length() < 1) && !mavenResourcesExecution.getNonFilteredFileExtensions().contains("properties") && isFilteringUsed && propertiesFiles.size() > 0) {
            LOGGER.info("The encoding used to copy filtered properties files have not been set. This means that the same encoding will be used to copy filtered properties files as when copying other filtered resources. This might not be what you want! Run your build with --debug to see which files might be affected. Read more at https://maven.apache.org/plugins/maven-resources-plugin/examples/filtering-properties-files.html");
            StringBuilder affectedFiles = new StringBuilder();
            affectedFiles.append("Here is a list of the filtered properties files in you project that might be affected by encoding problems: ");
            for (File propertiesFile : propertiesFiles) {
                affectedFiles.append(System.lineSeparator()).append(" - ").append(propertiesFile.getPath());
            }
            LOGGER.debug(affectedFiles.toString());
        }
    }

    static String getEncoding(File file, String encoding, String propertiesEncoding) {
        if (DefaultMavenResourcesFiltering.isPropertiesFile(file)) {
            if (propertiesEncoding == null) {
                return encoding;
            }
            return propertiesEncoding;
        }
        return encoding;
    }

    static boolean isPropertiesFile(File file) {
        return "properties".equals(DefaultMavenResourcesFiltering.getExtension(file.getName()));
    }

    private void handleDefaultFilterWrappers(MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        ArrayList<FilterWrapper> filterWrappers = new ArrayList<FilterWrapper>();
        if (mavenResourcesExecution.getFilterWrappers() != null) {
            filterWrappers.addAll(mavenResourcesExecution.getFilterWrappers());
        }
        filterWrappers.addAll(this.mavenFileFilter.getDefaultFilterWrappers(mavenResourcesExecution));
        mavenResourcesExecution.setFilterWrappers(filterWrappers);
    }

    private File getDestinationFile(File outputDirectory, String targetPath, String name, MavenResourcesExecution mavenResourcesExecution) throws MavenFilteringException {
        File destinationFile;
        String destination;
        if (!mavenResourcesExecution.isFlatten()) {
            destination = name;
        } else {
            Path path = Paths.get(name, new String[0]);
            Path filePath = path.getFileName();
            destination = filePath.toString();
        }
        if (mavenResourcesExecution.isFilterFilenames() && mavenResourcesExecution.getFilterWrappers().size() > 0) {
            destination = this.filterFileName(destination, mavenResourcesExecution.getFilterWrappers());
        }
        if (targetPath != null) {
            destination = targetPath + "/" + destination;
        }
        if (!(destinationFile = new File(destination)).isAbsolute()) {
            destinationFile = new File(outputDirectory, destination);
        }
        if (!destinationFile.getParentFile().exists()) {
            destinationFile.getParentFile().mkdirs();
        }
        return destinationFile;
    }

    private String[] setupScanner(Resource resource, Scanner scanner, boolean addDefaultExcludes) {
        String[] includes = null;
        includes = resource.getIncludes() != null && !resource.getIncludes().isEmpty() ? resource.getIncludes().toArray(EMPTY_STRING_ARRAY) : DEFAULT_INCLUDES;
        scanner.setIncludes(includes);
        String[] excludes = null;
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            excludes = resource.getExcludes().toArray(EMPTY_STRING_ARRAY);
            scanner.setExcludes(excludes);
        }
        if (addDefaultExcludes) {
            scanner.addDefaultExcludes();
        }
        return includes;
    }

    private void copyDirectoryLayout(File sourceDirectory, File destinationDirectory, Scanner scanner) throws IOException {
        if (sourceDirectory == null) {
            throw new IOException("source directory can't be null.");
        }
        if (destinationDirectory == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (sourceDirectory.equals(destinationDirectory)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        List<String> includedDirectories = Arrays.asList(scanner.getIncludedDirectories());
        for (String name : includedDirectories) {
            File source = new File(sourceDirectory, name);
            if (source.equals(sourceDirectory)) continue;
            File destination = new File(destinationDirectory, name);
            destination.mkdirs();
        }
    }

    private String getRelativeOutputDirectory(MavenResourcesExecution execution) {
        String relOutDir = execution.getOutputDirectory().getAbsolutePath();
        if (execution.getMavenProject() != null && execution.getMavenProject().getBasedir() != null) {
            String basedir = execution.getMavenProject().getBasedir().getAbsolutePath();
            relOutDir = FilteringUtils.getRelativeFilePath(basedir, relOutDir);
            relOutDir = relOutDir == null ? execution.getOutputDirectory().getPath() : relOutDir.replace('\\', '/');
        }
        return relOutDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String filterFileName(String name, List<FilterWrapper> wrappers) throws MavenFilteringException {
        Reader reader = new StringReader(name);
        for (FilterWrapper wrapper : wrappers) {
            reader = wrapper.getReader(reader);
        }
        try (StringWriter writer = new StringWriter();){
            IOUtils.copy((Reader)reader, (Writer)writer);
            String filteredFilename = writer.toString();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("renaming filename " + name + " to " + filteredFilename);
            }
            String string = filteredFilename;
            return string;
        }
        catch (IOException e) {
            throw new MavenFilteringException("Failed filtering filename" + name, e);
        }
    }
}

