/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.site.decoration.inheritance;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.maven.doxia.site.decoration.inheritance.PathDescriptor;
import org.codehaus.plexus.util.PathTool;

public abstract class PathUtils {
    private PathUtils() {
    }

    public static final PathDescriptor convertPath(PathDescriptor oldPath, PathDescriptor newPath) throws MalformedURLException {
        String relative = PathUtils.getRelativePath(oldPath, newPath);
        if (relative == null) {
            return oldPath;
        }
        return new PathDescriptor(relative);
    }

    public static final String getRelativePath(PathDescriptor oldPathDescriptor, PathDescriptor newPathDescriptor) {
        if (oldPathDescriptor.isFile()) {
            if (!newPathDescriptor.isFile()) {
                if (oldPathDescriptor.isRelative()) {
                    return oldPathDescriptor.getPath();
                }
                return null;
            }
            if (oldPathDescriptor.isRelative() || newPathDescriptor.isRelative()) {
                return null;
            }
        }
        if (!oldPathDescriptor.isFile()) {
            URL oldUrl = oldPathDescriptor.getPathUrl();
            URL newUrl = newPathDescriptor.getPathUrl();
            if (oldUrl == null || newUrl == null) {
                return null;
            }
            if (newUrl.getProtocol().equalsIgnoreCase(oldUrl.getProtocol()) && newUrl.getHost().equalsIgnoreCase(oldUrl.getHost()) && newUrl.getPort() == oldUrl.getPort()) {
                String oldPath = oldPathDescriptor.getPath();
                String newPath = newPathDescriptor.getPath();
                return PathTool.getRelativeWebPath((String)newPath, (String)oldPath);
            }
            return null;
        }
        String oldPath = oldPathDescriptor.getPath();
        String newPath = newPathDescriptor.getPath();
        if (oldPath == null || newPath == null) {
            return null;
        }
        return PathTool.getRelativeFilePath((String)oldPath, (String)newPath);
    }
}

