/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.java.DefaultJavaToolChain;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.codehaus.plexus.languages.java.jpms.LocationManager;
import org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CompilerMojo
extends AbstractCompilerMojo {
    @Parameter(defaultValue="${project.compileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifact}", readonly=true, required=true)
    private Artifact projectArtifact;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    private File generatedSourcesDirectory;
    @Parameter(property="maven.main.skip")
    private boolean skipMain;
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compilePath;
    @Parameter
    private boolean multiReleaseOutput;
    @Parameter(defaultValue="javac")
    private String debugFileName;
    final LocationManager locationManager = new LocationManager();
    private List<String> classpathElements;
    private List<String> modulepathElements;
    private Map<String, JavaModuleDescriptor> pathElements;

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected List<String> getModulepathElements() {
        return this.modulepathElements;
    }

    @Override
    protected Map<String, JavaModuleDescriptor> getPathElements() {
        return this.pathElements;
    }

    @Override
    protected File getOutputDirectory() {
        File dir = !this.multiReleaseOutput ? this.outputDirectory : new File(this.outputDirectory, "META-INF/versions/" + this.release);
        return dir;
    }

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skipMain) {
            this.getLog().info((CharSequence)"Not compiling main sources");
            return;
        }
        if (this.multiReleaseOutput && this.release == null) {
            throw new MojoExecutionException("When using 'multiReleaseOutput' the release must be set");
        }
        super.execute();
        if (this.outputDirectory.isDirectory()) {
            this.projectArtifact.setFile(this.outputDirectory);
        }
    }

    @Override
    protected void preparePaths(Set<File> sourceFiles) {
        File moduleDescriptorPath = null;
        boolean hasModuleDescriptor = false;
        for (File sourceFile : sourceFiles) {
            if (!"module-info.java".equals(sourceFile.getName())) continue;
            moduleDescriptorPath = sourceFile;
            hasModuleDescriptor = true;
            break;
        }
        if (hasModuleDescriptor) {
            this.modulepathElements = new ArrayList<String>(this.compilePath.size());
            this.classpathElements = new ArrayList<String>(this.compilePath.size());
            this.pathElements = new LinkedHashMap<String, JavaModuleDescriptor>(this.compilePath.size());
            try {
                List<File> dependencyArtifacts = this.getCompileClasspathElements(this.getProject());
                ResolvePathsRequest request = ResolvePathsRequest.ofFiles(dependencyArtifacts).setIncludeStatic(true).setMainModuleDescriptor((Object)moduleDescriptorPath);
                Toolchain toolchain = this.getToolchain();
                if (toolchain instanceof DefaultJavaToolChain) {
                    request.setJdkHome((Object)new File(((DefaultJavaToolChain)toolchain).getJavaHome()));
                }
                ResolvePathsResult resolvePathsResult = this.locationManager.resolvePaths(request);
                for (Map.Entry pathException : resolvePathsResult.getPathExceptions().entrySet()) {
                    Throwable cause = (Throwable)pathException.getValue();
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    String fileName = ((File)pathException.getKey()).getName();
                    this.getLog().warn((CharSequence)("Can't extract module name from " + fileName + ": " + cause.getMessage()));
                }
                JavaModuleDescriptor moduleDescriptor = resolvePathsResult.getMainModuleDescriptor();
                this.detectFilenameBasedAutomodules((ResolvePathsResult<File>)resolvePathsResult, moduleDescriptor);
                for (Map.Entry entry : resolvePathsResult.getPathElements().entrySet()) {
                    this.pathElements.put(((File)entry.getKey()).getPath(), (JavaModuleDescriptor)entry.getValue());
                }
                if (this.compilerArgs == null) {
                    this.compilerArgs = new ArrayList();
                }
                for (File file : resolvePathsResult.getClasspathElements()) {
                    this.classpathElements.add(file.getPath());
                    if (!this.multiReleaseOutput || !this.getOutputDirectory().toPath().startsWith(file.getPath())) continue;
                    this.compilerArgs.add("--patch-module");
                    this.compilerArgs.add(String.format("%s=%s", moduleDescriptor.name(), file.getPath()));
                }
                for (File file : resolvePathsResult.getModulepathElements().keySet()) {
                    this.modulepathElements.add(file.getPath());
                }
                this.compilerArgs.add("--module-version");
                this.compilerArgs.add(this.getProject().getVersion());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)e.getMessage());
            }
        } else {
            this.classpathElements = new ArrayList<String>();
            for (File element : this.getCompileClasspathElements(this.getProject())) {
                this.classpathElements.add(element.getPath());
            }
            this.modulepathElements = Collections.emptyList();
        }
    }

    private void detectFilenameBasedAutomodules(ResolvePathsResult<File> resolvePathsResult, JavaModuleDescriptor moduleDescriptor) {
        ArrayList<String> automodulesDetected = new ArrayList<String>();
        for (Map.Entry entry : resolvePathsResult.getModulepathElements().entrySet()) {
            if (!ModuleNameSource.FILENAME.equals(entry.getValue())) continue;
            automodulesDetected.add(((File)entry.getKey()).getName());
        }
        if (!automodulesDetected.isEmpty()) {
            String message = "Required filename-based automodules detected: " + automodulesDetected + ". Please don't publish this project to a public artifact repository!";
            if (moduleDescriptor.exports().isEmpty()) {
                this.getLog().info((CharSequence)message);
            } else {
                this.writeBoxedWarning(message);
            }
        }
    }

    private List<File> getCompileClasspathElements(MavenProject project) {
        ArrayList<File> list = new ArrayList<File>(project.getArtifacts().size() + 3);
        if (this.multiReleaseOutput) {
            File versionsFolder = new File(project.getBuild().getOutputDirectory(), "META-INF/versions");
            for (int version = Integer.parseInt(this.getRelease()) - 1; version >= 9; --version) {
                File versionSubFolder = new File(versionsFolder, String.valueOf(version));
                if (!versionSubFolder.exists()) continue;
                list.add(versionSubFolder);
            }
        }
        list.add(new File(project.getBuild().getOutputDirectory()));
        for (Artifact a : project.getArtifacts()) {
            list.add(a.getFile());
        }
        return list;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return new StaleSourceScanner((long)staleMillis);
        }
        if (this.includes.isEmpty()) {
            this.includes.add("**/*.java");
        }
        return new StaleSourceScanner((long)staleMillis, this.includes, this.excludes);
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.includes.isEmpty()) {
            this.includes.add(defaultIncludePattern);
        }
        return new SimpleSourceInclusionScanner(this.includes, this.excludes);
    }

    @Override
    protected String getSource() {
        return this.source;
    }

    @Override
    protected String getTarget() {
        return this.target;
    }

    @Override
    protected String getRelease() {
        return this.release;
    }

    @Override
    protected String getCompilerArgument() {
        return this.compilerArgument;
    }

    @Override
    protected Map<String, String> getCompilerArguments() {
        return this.compilerArguments;
    }

    @Override
    protected File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Override
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    private void writeBoxedWarning(String message) {
        String line = StringUtils.repeat((String)"*", (int)(message.length() + 4));
        this.getLog().warn((CharSequence)line);
        this.getLog().warn((CharSequence)("* " + MessageUtils.buffer().strong((Object)message) + " *"));
        this.getLog().warn((CharSequence)line);
    }
}

