/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.booter.Command;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.stream.AbstractStreamDecoder;
import org.apache.maven.surefire.api.stream.MalformedChannelException;
import org.apache.maven.surefire.booter.stream.CommandDecoder;

public class CommandChannelDecoder
implements MasterProcessChannelDecoder {
    private final CommandDecoder decoder;
    private AbstractStreamDecoder.Memento memento;

    public CommandChannelDecoder(@Nonnull ReadableByteChannel channel, @Nonnull ForkNodeArguments arguments) {
        this.decoder = new CommandDecoder(channel, arguments);
    }

    @Nonnull
    public Command decode() throws IOException {
        if (this.memento == null) {
            this.memento = new AbstractStreamDecoder.Memento((AbstractStreamDecoder)this.decoder);
        }
        while (true) {
            try {
                Command command;
                while ((command = this.decoder.decode(this.memento)) == null) {
                }
                return command;
            }
            catch (MalformedChannelException malformedChannelException) {
                continue;
            }
            break;
        }
    }

    public void close() throws IOException {
        this.decoder.close();
    }
}

