/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public class DefaultPluginToolsRequest
implements PluginToolsRequest {
    private static final String DEFAULT_ENCODING = ReaderFactory.FILE_ENCODING;
    private PluginDescriptor pluginDescriptor;
    private MavenProject project;
    private String encoding = DEFAULT_ENCODING;
    private boolean skipErrorNoDescriptorsFound;
    private Set<Artifact> dependencies;
    private List<ArtifactRepository> remoteRepos;
    private ArtifactRepository local;

    public DefaultPluginToolsRequest(MavenProject project, PluginDescriptor pluginDescriptor) {
        this.project = project;
        this.pluginDescriptor = pluginDescriptor;
    }

    @Override
    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    @Override
    public PluginToolsRequest setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
        return this;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public PluginToolsRequest setProject(MavenProject project) {
        this.project = project;
        return this;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public PluginToolsRequest setEncoding(String encoding) {
        this.encoding = StringUtils.isNotEmpty((String)encoding) ? encoding : DEFAULT_ENCODING;
        return this;
    }

    @Override
    public boolean isSkipErrorNoDescriptorsFound() {
        return this.skipErrorNoDescriptorsFound;
    }

    @Override
    public PluginToolsRequest setSkipErrorNoDescriptorsFound(boolean skipErrorNoDescriptorsFound) {
        this.skipErrorNoDescriptorsFound = skipErrorNoDescriptorsFound;
        return this;
    }

    @Override
    public Set<Artifact> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new HashSet<Artifact>();
        }
        return this.dependencies;
    }

    @Override
    public PluginToolsRequest setDependencies(Set<Artifact> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepos() {
        return this.remoteRepos;
    }

    @Override
    public PluginToolsRequest setRemoteRepos(List<ArtifactRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
        return this;
    }

    @Override
    public ArtifactRepository getLocal() {
        return this.local;
    }

    @Override
    public PluginToolsRequest setLocal(ArtifactRepository local) {
        this.local = local;
        return this;
    }
}

