/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.admonition.internal;

import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionCollectingVisitor;
import com.vladsch.flexmark.ext.admonition.internal.AdmonitionOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.PhasedNodeRenderer;
import com.vladsch.flexmark.html.renderer.RenderingPhase;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class AdmonitionNodeRenderer
implements PhasedNodeRenderer {
    public static AttributablePart ADMONITION_SVG_OBJECT_PART = new AttributablePart("ADMONITION_SVG_OBJECT_PART");
    public static AttributablePart ADMONITION_HEADING_PART = new AttributablePart("ADMONITION_HEADING_PART");
    public static AttributablePart ADMONITION_ICON_PART = new AttributablePart("ADMONITION_ICON_PART");
    public static AttributablePart ADMONITION_TITLE_PART = new AttributablePart("ADMONITION_TITLE_PART");
    public static AttributablePart ADMONITION_BODY_PART = new AttributablePart("ADMONITION_BODY_PART");
    private final AdmonitionOptions options;

    public AdmonitionNodeRenderer(DataHolder options) {
        this.options = new AdmonitionOptions(options);
    }

    public Set<RenderingPhase> getRenderingPhases() {
        LinkedHashSet<RenderingPhase> phaseSet = new LinkedHashSet<RenderingPhase>();
        phaseSet.add(RenderingPhase.BODY_TOP);
        return phaseSet;
    }

    public void renderDocument(NodeRendererContext context, HtmlWriter html, Document document, RenderingPhase phase) {
        if (phase == RenderingPhase.BODY_TOP) {
            HashSet<String> resolvedQualifiers = new HashSet<String>();
            Set<String> referencedQualifiers = new AdmonitionCollectingVisitor().collectAndGetQualifiers((Node)document);
            for (String qualifier : referencedQualifiers) {
                String resolvedQualifier = this.options.qualifierTypeMap.get(qualifier);
                if (resolvedQualifier == null) {
                    resolvedQualifier = this.options.unresolvedQualifier;
                }
                resolvedQualifiers.add(resolvedQualifier);
            }
            if (!resolvedQualifiers.isEmpty()) {
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.line()).attr((CharSequence)"xmlns", (CharSequence)"http://www.w3.org/2000/svg")).attr((CharSequence)"class", (CharSequence)"adm-hidden")).withAttr(ADMONITION_SVG_OBJECT_PART).tag((CharSequence)"svg")).indent()).line();
                for (String info : resolvedQualifiers) {
                    String svgContent = this.options.typeSvgMap.get(info);
                    if (svgContent == null || svgContent.isEmpty()) continue;
                    ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"<symbol id=\"adm-")).raw((CharSequence)info)).raw((CharSequence)"\">")).indent()).line()).raw((CharSequence)svgContent)).line()).unIndent()).raw((CharSequence)"</symbol>")).line();
                }
                ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag((CharSequence)"svg")).line();
            }
        }
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(AdmonitionBlock.class, (CustomNodeRenderer)new CustomNodeRenderer<AdmonitionBlock>(){

            public void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
                AdmonitionNodeRenderer.this.render(node, context, html);
            }
        }));
        return set;
    }

    private void render(AdmonitionBlock node, NodeRendererContext context, HtmlWriter html) {
        String title;
        String info = node.getInfo().toString().toLowerCase();
        String type = this.options.qualifierTypeMap.get(info);
        if (type == null) {
            type = this.options.unresolvedQualifier;
        }
        if (node.getTitle().isNull()) {
            title = this.options.qualifierTitleMap.get(info);
            if (title == null) {
                title = info.substring(0, 1).toUpperCase() + info.substring(1);
            }
        } else {
            title = node.getTitle().toString();
        }
        String openClose = node.getOpeningMarker().equals("???") ? " adm-collapsed" : (node.getOpeningMarker().equals("???+") ? "adm-open" : null);
        if (title.isEmpty()) {
            ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr().attr((CharSequence)"class", (CharSequence)"adm-block")).attr((CharSequence)"class", (CharSequence)("adm-" + type))).tag((CharSequence)"div", false).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"adm-body")).withAttr(ADMONITION_BODY_PART).tag((CharSequence)"div")).indent()).line();
            context.renderChildren((Node)node);
            ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag((CharSequence)"div")).line();
            ((HtmlWriter)html.closeTag((CharSequence)"div")).line();
        } else {
            ((HtmlWriter)html.srcPos(node.getChars()).attr((CharSequence)"class", (CharSequence)"adm-block")).attr((CharSequence)"class", (CharSequence)("adm-" + type));
            if (openClose != null) {
                ((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)openClose)).attr((CharSequence)"class", (CharSequence)("adm-" + type));
            }
            html.withAttr().tag((CharSequence)"div", false).line();
            ((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"adm-heading")).withAttr(ADMONITION_HEADING_PART).tag((CharSequence)"div")).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"adm-icon")).withAttr(ADMONITION_ICON_PART).tag((CharSequence)"svg")).raw((CharSequence)"<use xlink:href=\"#adm-")).raw((CharSequence)type)).raw((CharSequence)"\" />")).closeTag((CharSequence)"svg");
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.withAttr(ADMONITION_TITLE_PART).tag((CharSequence)"span")).text((CharSequence)title)).closeTag((CharSequence)"span")).line();
            ((HtmlWriter)html.closeTag((CharSequence)"div")).line();
            ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"class", (CharSequence)"adm-body")).withAttr(ADMONITION_BODY_PART).tag((CharSequence)"div")).indent()).line();
            context.renderChildren((Node)node);
            ((HtmlWriter)((HtmlWriter)html.unIndent()).closeTag((CharSequence)"div")).line();
            ((HtmlWriter)html.closeTag((CharSequence)"div")).line();
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new AdmonitionNodeRenderer(options);
        }
    }
}

