/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=RequireObjectCoercibleNode.class)
public final class RequireObjectCoercibleNodeGen
extends RequireObjectCoercibleNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private Shape cachedShape_cachedShape_;
    @CompilerDirectives.CompilationFinal
    private JSClass cachedJSClass_cachedClass_;

    private RequireObjectCoercibleNodeGen() {
    }

    @Override
    public void executeVoid(Object arg0Value) {
        DynamicObject arg0Value_;
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_2 = (Integer)arg0Value;
            RequireObjectCoercibleNode.doInt(arg0Value_2);
            return;
        }
        if ((state & 2) != 0 && arg0Value instanceof SafeInteger) {
            SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
            RequireObjectCoercibleNode.doSafeInteger(arg0Value_3);
            return;
        }
        if ((state & 4) != 0 && arg0Value instanceof Long) {
            long arg0Value_4 = (Long)arg0Value;
            RequireObjectCoercibleNode.doLong(arg0Value_4);
            return;
        }
        if ((state & 8) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C00) >>> 10, arg0Value)) {
            double arg0Value_5 = JSTypesGen.asImplicitDouble((state & 0x3C00) >>> 10, arg0Value);
            RequireObjectCoercibleNode.doDouble(arg0Value_5);
            return;
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitCharSequence((state & 0x3C000) >>> 14, arg0Value)) {
            CharSequence arg0Value_6 = JSTypesGen.asImplicitCharSequence((state & 0x3C000) >>> 14, arg0Value);
            RequireObjectCoercibleNode.doCharSequence(arg0Value_6);
            return;
        }
        if ((state & 0x20) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_7 = (Boolean)arg0Value;
            RequireObjectCoercibleNode.doBoolean(arg0Value_7);
            return;
        }
        if ((state & 0xC0) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 0x40) != 0) {
                assert (this.cachedShape_cachedShape_ != null);
                if (this.cachedShape_cachedShape_.check(arg0Value_)) {
                    RequireObjectCoercibleNode.doCachedShape(arg0Value_, this.cachedShape_cachedShape_);
                    return;
                }
            }
            if ((state & 0x80) != 0) {
                assert (this.cachedJSClass_cachedClass_ != null);
                if (this.cachedJSClass_cachedClass_.isInstance(arg0Value_)) {
                    RequireObjectCoercibleNode.doCachedJSClass(arg0Value_, this.cachedJSClass_cachedClass_);
                    return;
                }
            }
        }
        if ((state & 0x100) != 0 && !JSGuards.isNullOrUndefined(arg0Value)) {
            RequireObjectCoercibleNode.doObjectCoercible(arg0Value);
            return;
        }
        if ((state & 0x200) != 0 && JSTypes.isDynamicObject(arg0Value) && JSGuards.isNullOrUndefined(arg0Value_ = (DynamicObject)arg0Value)) {
            this.doNullOrUndefined(arg0Value_);
            return;
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value);
    }

    private void executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            DynamicObject arg0Value_;
            if (arg0Value instanceof Integer) {
                int arg0Value_2 = (Integer)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doInt(arg0Value_2);
                return;
            }
            if (arg0Value instanceof SafeInteger) {
                SafeInteger arg0Value_3 = (SafeInteger)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doSafeInteger(arg0Value_3);
                return;
            }
            if (arg0Value instanceof Long) {
                long arg0Value_4 = (Long)arg0Value;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doLong(arg0Value_4);
                return;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_5 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 10;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doDouble(arg0Value_5);
                return;
            }
            int charSequenceCast0 = JSTypesGen.specializeImplicitCharSequence(arg0Value);
            if (charSequenceCast0 != 0) {
                CharSequence arg0Value_6 = JSTypesGen.asImplicitCharSequence(charSequenceCast0, arg0Value);
                state |= charSequenceCast0 << 14;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doCharSequence(arg0Value_6);
                return;
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_7 = (Boolean)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doBoolean(arg0Value_7);
                return;
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_8 = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape cachedShape_cachedShape__;
                    boolean CachedShape_duplicateFound_ = false;
                    if ((state & 0x40) != 0) {
                        assert (this.cachedShape_cachedShape_ != null);
                        if (this.cachedShape_cachedShape_.check(arg0Value_8)) {
                            CachedShape_duplicateFound_ = true;
                        }
                    }
                    if (!CachedShape_duplicateFound_ && (cachedShape_cachedShape__ = RequireObjectCoercibleNode.getShapeIfObject(arg0Value_8)) != null && cachedShape_cachedShape__.check(arg0Value_8) && (state & 0x40) == 0) {
                        this.cachedShape_cachedShape_ = cachedShape_cachedShape__;
                        this.state_ = state |= 0x40;
                        CachedShape_duplicateFound_ = true;
                    }
                    if (CachedShape_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        RequireObjectCoercibleNode.doCachedShape(arg0Value_8, this.cachedShape_cachedShape_);
                        return;
                    }
                }
                if ((exclude & 2) == 0) {
                    JSClass cachedJSClass_cachedClass__;
                    boolean CachedJSClass_duplicateFound_ = false;
                    if ((state & 0x80) != 0) {
                        assert (this.cachedJSClass_cachedClass_ != null);
                        if (this.cachedJSClass_cachedClass_.isInstance(arg0Value_8)) {
                            CachedJSClass_duplicateFound_ = true;
                        }
                    }
                    if (!CachedJSClass_duplicateFound_ && (cachedJSClass_cachedClass__ = JSGuards.getJSClassIfObject(arg0Value_8)) != null && cachedJSClass_cachedClass__.isInstance(arg0Value_8) && (state & 0x80) == 0) {
                        this.cachedJSClass_cachedClass_ = cachedJSClass_cachedClass__;
                        this.exclude_ = exclude |= 1;
                        state &= 0xFFFFFFBF;
                        this.state_ = state |= 0x80;
                        CachedJSClass_duplicateFound_ = true;
                    }
                    if (CachedJSClass_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        RequireObjectCoercibleNode.doCachedJSClass(arg0Value_8, this.cachedJSClass_cachedClass_);
                        return;
                    }
                }
            }
            if (!JSGuards.isNullOrUndefined(arg0Value)) {
                this.exclude_ = exclude |= 3;
                state &= 0xFFFFFF3F;
                this.state_ = state |= 0x100;
                lock.unlock();
                hasLock = false;
                RequireObjectCoercibleNode.doObjectCoercible(arg0Value);
                return;
            }
            if (JSTypes.isDynamicObject(arg0Value) && JSGuards.isNullOrUndefined(arg0Value_ = (DynamicObject)arg0Value)) {
                this.state_ = state |= 0x200;
                lock.unlock();
                hasLock = false;
                this.doNullOrUndefined(arg0Value_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FF & (state & 0x3FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[11];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doCharSequence";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doCachedShape";
        if ((state & 0x40) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            cached.add(Arrays.asList(this.cachedShape_cachedShape_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doCachedJSClass";
        if ((state & 0x80) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.cachedJSClass_cachedClass_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doObjectCoercible";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static RequireObjectCoercibleNode create() {
        return new RequireObjectCoercibleNodeGen();
    }

    @GeneratedBy(value=RequireObjectCoercibleNode.RequireObjectCoercibleWrapperNode.class)
    public static final class RequireObjectCoercibleWrapperNodeGen
    extends RequireObjectCoercibleNode.RequireObjectCoercibleWrapperNode
    implements Introspection.Provider {
        private RequireObjectCoercibleWrapperNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static RequireObjectCoercibleNode.RequireObjectCoercibleWrapperNode create(JavaScriptNode operand) {
            return new RequireObjectCoercibleWrapperNodeGen(operand);
        }
    }
}

