/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.TextBlock;
import org.apache.maven.doxia.module.twiki.parser.WikiWordLinkResolver;
import org.apache.maven.doxia.sink.Sink;

class WikiWordBlock
implements Block {
    private final String wikiword;
    private final Block content;
    private final WikiWordLinkResolver wikiWordLinkResolver;

    WikiWordBlock(String aWikiword, WikiWordLinkResolver resolver) {
        this(aWikiword, aWikiword, resolver);
    }

    WikiWordBlock(String aWikiword, String aText, WikiWordLinkResolver resolver) {
        this(aWikiword, new TextBlock(aText), resolver);
    }

    WikiWordBlock(String aWikiword, Block content, WikiWordLinkResolver resolver) {
        if (aWikiword == null || content == null || resolver == null) {
            throw new IllegalArgumentException("arguments can't be null");
        }
        this.wikiword = aWikiword;
        this.content = content;
        this.wikiWordLinkResolver = resolver;
    }

    @Override
    public final void traverse(Sink sink) {
        sink.link(this.wikiWordLinkResolver.resolveLink(this.wikiword));
        this.content.traverse(sink);
        sink.link_();
    }

    public final boolean equals(Object obj) {
        boolean ret = false;
        if (obj == this) {
            ret = true;
        } else if (obj instanceof WikiWordBlock) {
            WikiWordBlock w = (WikiWordBlock)obj;
            ret = this.wikiword.equals(w.wikiword) && this.content.equals(w.content);
        }
        return ret;
    }

    public final int hashCode() {
        int magic1 = 17;
        int magic2 = 37;
        return 17 + 37 * this.wikiword.hashCode() + 37 * this.content.hashCode();
    }
}

