/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.surefire.booter.IsolatedClassLoader;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.util.UrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classpath
implements Iterable<String> {
    private final List<String> unmodifiableElements;

    public static Classpath join(Classpath firstClasspath, Classpath secondClasspath) {
        LinkedHashSet<String> accumulated = new LinkedHashSet<String>();
        if (firstClasspath != null) {
            firstClasspath.addTo(accumulated);
        }
        if (secondClasspath != null) {
            secondClasspath.addTo(accumulated);
        }
        return new Classpath(accumulated);
    }

    private void addTo(Collection<String> c) {
        c.addAll(this.unmodifiableElements);
    }

    private Classpath() {
        this.unmodifiableElements = Collections.emptyList();
    }

    public Classpath(Classpath other, String additionalElement) {
        ArrayList<String> elems = new ArrayList<String>(other.unmodifiableElements);
        elems.add(additionalElement);
        this.unmodifiableElements = Collections.unmodifiableList(elems);
    }

    public Classpath(Collection<String> elements) {
        ArrayList<String> newCp = new ArrayList<String>(elements.size());
        for (String element : elements) {
            if ((element = element.trim()).length() == 0) continue;
            newCp.add(element);
        }
        this.unmodifiableElements = Collections.unmodifiableList(newCp);
    }

    public static Classpath emptyClasspath() {
        return new Classpath();
    }

    public Classpath addClassPathElementUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null is not a valid class path element url.");
        }
        return !this.unmodifiableElements.contains(path) ? new Classpath(this, path) : this;
    }

    public List<String> getClassPath() {
        return this.unmodifiableElements;
    }

    public List<URL> getAsUrlList() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String url : this.unmodifiableElements) {
            File f = new File(url);
            urls.add(UrlUtils.getURL((File)f));
        }
        return urls;
    }

    public void writeToSystemProperty(String propertyName) {
        StringBuilder sb = new StringBuilder();
        for (String element : this.unmodifiableElements) {
            sb.append(element).append(File.pathSeparatorChar);
        }
        System.setProperty(propertyName, sb.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Classpath classpath = (Classpath)o;
        return this.unmodifiableElements.equals(classpath.unmodifiableElements);
    }

    public ClassLoader createClassLoader(ClassLoader parent, boolean childDelegation, boolean enableAssertions, String roleName) throws SurefireExecutionException {
        try {
            List<URL> urls = this.getAsUrlList();
            IsolatedClassLoader classLoader = new IsolatedClassLoader(parent, childDelegation, roleName);
            for (URL url : urls) {
                classLoader.addURL(url);
            }
            if (parent != null) {
                parent.setDefaultAssertionStatus(enableAssertions);
            }
            classLoader.setDefaultAssertionStatus(enableAssertions);
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new SurefireExecutionException("When creating classloader", e);
        }
    }

    public int hashCode() {
        return this.unmodifiableElements.hashCode();
    }

    public String getLogMessage(String descriptor) {
        StringBuilder result = new StringBuilder();
        result.append(descriptor).append(" classpath:");
        for (String element : this.unmodifiableElements) {
            result.append("  ").append(element);
        }
        return result.toString();
    }

    public String getCompactLogMessage(String descriptor) {
        StringBuilder result = new StringBuilder();
        result.append(descriptor).append(" classpath:");
        for (String element : this.unmodifiableElements) {
            result.append("  ");
            if (element != null) {
                int pos = element.lastIndexOf(File.separatorChar);
                if (pos >= 0) {
                    result.append(element.substring(pos + 1));
                    continue;
                }
                result.append(element);
                continue;
            }
            result.append((String)null);
        }
        return result.toString();
    }

    @Override
    public Iterator<String> iterator() {
        return this.unmodifiableElements.iterator();
    }
}

