/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

public final class DocbookUtils {
    public static String doxiaTableFrameAttribute(String frame) {
        String fr = frame;
        if ("all".equals(fr)) {
            fr = "box";
        } else if ("bottom".equals(fr)) {
            fr = "below";
        } else if ("none".equals(fr)) {
            fr = "void";
        } else if ("sides".equals(fr)) {
            fr = "vsides";
        } else if ("top".equals(fr)) {
            fr = "above";
        } else if ("topbot".equals(fr)) {
            fr = "hsides";
        } else {
            throw new IllegalArgumentException("Not a valid frame attribute: " + fr);
        }
        return fr;
    }

    public static int doxiaListNumbering(String style) {
        if ("loweralpha".equals(style)) {
            return 1;
        }
        if ("lowerroman".equals(style)) {
            return 3;
        }
        if ("upperalpha".equals(style)) {
            return 2;
        }
        if ("upperroman".equals(style)) {
            return 4;
        }
        if ("arabic".equals(style)) {
            return 0;
        }
        throw new IllegalArgumentException("Not a valid numbering style: " + style);
    }

    public static String docbookListNumbering(int numbering) {
        switch (numbering) {
            case 2: {
                return "upperalpha";
            }
            case 1: {
                return "loweralpha";
            }
            case 4: {
                return "upperroman";
            }
            case 3: {
                return "lowerroman";
            }
            case 0: {
                return "arabic";
            }
        }
        throw new IllegalArgumentException("Not a valid numbering: " + numbering);
    }

    public static char trademarkFromClass(String trade) {
        if ("registered".equals(trade)) {
            return '\u00ae';
        }
        if ("copyright".equals(trade)) {
            return '\u00a9';
        }
        if ("service".equals(trade)) {
            return '\u2120';
        }
        if ("trade".equals(trade)) {
            return '\u2122';
        }
        throw new IllegalArgumentException("Not a trademark class: " + trade);
    }

    private DocbookUtils() {
    }
}

