: _* N

For help on a specific command, enter H x where x is the command for
which you need help.  For example, H R will send complete help for the
READ command.

Message commands: (K)ill     (L)ist    (R)ead    (S)end    (REPLY)
File commands:    (D)ownload (U)pload  (W)hat
Misc commands:    (B)ye      (H)elp    (I)nfo    (J) Who?
                  (N) Register  (T)alk to SYSOP  (P)arms
                  (CB) Callbook  LTIME
Further info:     (@) At BBS

Other help topics available by issuing the H command followed
by the topic name:

  SEARCH    -- how to search for messages
  STATUS    -- message status explained
  WILDCARD  -- how wildcards work

Issue H topicname

: WILDCARD N

Patterns are supported in many commands.  With patterns we attempt to
match something with just more than a straight comparison.

   Special characters in the pattern are:

     * -- Matches 0 or more characters of any type
     @ -- a..z, A..Z
     # -- 0..9
     + -- A..z, A..Z, 0..9
     ? -- A-F, a-f, 0-9 (a hex number)
     < -- a..z
     > -- A..Z
     $ -- =@#+?<>$
     = -- Any one character
     " -- Escape.  The next character in the pattern much match exactly.
          wild cards will not be interpreted.
     ( -- Group.  A "(" starts a group and a ")" ends it.  For each
          group, there must be a matching character in the string.
          Example: (abc) matches b.  Wild cards are not interpreted.

Examples:

  95*      --  Will match anything starting with 95 such as 95020,
               95123, 95asb, and 95.
  95===    --  Will match anything that starts with 95 and is 5 characters
               long.  95020 will match but 9502 will not.
  95###    --  Will match anything that starts with 95 and has 5 digits.
               95020 will match but 95ABC will not.
  (WK)6*   --  Will match anything starting with W6 or K6.
  *ARRL*   --  Will match anything with ARRL in it

: STATUS N

When doing any of the "L" type commands, the message status is shown
under the column marked "R".  The status letters are:

  N -- Not read
  Y -- Read
  + -- Selected for forwarding to another BBS
  - -- Being forwarded to another BBS
  F -- Forwarding complete
  * -- Forwarded to the indicated BBS
  K -- Killed
  V -- Held for SYSOP review
  H -- Held for SYSOP action
  O -- Old
  ? -- Bad forwarding information

: SEARCH N

The BBS now allows you to choose messages which satisfy multiple
criteria, as well as messages which do NOT satisfy a selection.  This
ability applies to the READ, KILL, and LIST commands.

NEGATION
--------

You have always been able to specify, for example, that you want to see
all messages of a type -- for example, to list all bulletins, you issue
the "LB" command.  You can also specify that you want to see all
messages which are NOT of a type -- for example, to list all messages
which are NOT bulletins, use "L^ B".

You can use the "negation" symbol (^) to invert almost any search.

MULTIPLE SEARCHES
-------- --------

You can use the "and" symbol (&) to specify only those messages which
satisfy multiple search criteria.  For example:

To list bulletins which are newer than October 1, 1990:

  LB & D > 901001

To list unread messages which are NOT addressed to someone @AA4RE:

  LN & ^ @ AA4RE

To list personal messages that are not to AA4RE or at AA4RE

  LP & ^ @ AA4RE & ^ > AA4RE


Note that you can use negation as part of a multiple search.



TYPES OF SEARCHES
----- -- --------

     _      -- Messages of type ' '
     A  x   -- Messages of type x.  If type is not specified, type "A" will
               be displayed
     B      -- Messages of type 'B'
     D  > d -- Messages newer than date d (See note)
     D  < d -- Messages older than date d (See note)
     E  u   -- Messages to a server.  Same as > but @ must be blank or
               this BBS
     F  n   -- Forwarded messages greater than n
     H  n   -- Held messages greater than n
     K  n   -- Killed messages greater than n
     L  n   -- Last n messages
     M  u   -- Messages of a specific user.  Default is current user
     N  n   -- Messages just sitting here unread greater than n
     O  n   -- Messages of with "old" attribute & number greater n
     P      -- Messages of type 'P'
     Q      -- Read messages to a specific user
     S  s   -- Messages with string in subject
     T      -- NTS messages
     U  u   -- Unread messages to user u.  Current user is default
     Y  n   -- All read messages greater than n
     <  u   -- Messages from a user u.
     >  u   -- Messages to a user u.
     @  b   -- Messages to a user at mailbox b
     %  b   -- Messages from a user at mailbox b
     $  s   -- Messages with string in the BID
     +  n   -- Messages in forwarding progress with number >= n
     ?  n   -- Messages with unknown forwarding with number >= n
     -  n   -- Messages being forwarded right now with number >= n
     .  s   -- Messages addressed to certain H addresses
     #  > n -- Messages with number >= n
     #  < n -- Messages with number >= n
     0      -- Messages since last "L" command
     !S > n -- Messages with size >= n
     !S < n -- Messages with size <= n

Note 1:  Date can be expressed as YYMMDDHHMM HHMM is optional.
Alternatively, the date could be #5 which is 5 days before today.  So,
the command "LB & D > #5" means list bulletins less than 5 days old.

In any search anything but a number is required, you can use a wildcard.
Issue HELP WILDCARD for details.  Example:

   > AA4*

      Will match to callsign that starts with AA4

: "@* N

  @

  Enter this symbol to indicate the BBS of the addressee, for proper
  forwarding of the message to its destination.  The message, no matter
  to whom addressed, will be forwarded to the "@ BBS" location.

: B* N

B    - Log off the MailBox.
        Simply disconnecting has the exact same effect.

: CALLBOOK N

CALLBOOK calls

       Look up callbook for the given call(s).  Show multiple
       calls with a blank between each.  Example:

             CALLBOOK AA4RE WB6ZVW

: CB N

CALLBOOK calls

       Look up callbook for the given call(s).  Show multiple
       calls with a blank between each.  Example:

             CALLBOOK AA4RE WB6ZVW

: DB N

DB type topic ffff.xxx

       Download the file ffff.xxx for the topic requested.  D is
       for ASCII format.  DB is for binary downloads.

       To get a list of topics, use the W command.

       The types for binary download are:  XMODEM, XMODEMCRC,
       YMODEM, YMODEM-BATCH (Alias YMBATCH), and YAPP

: D* N

D topic ffff.xxx
DB type topic ffff.xxx

       Download the file ffff.xxx for the topic requested.  D is
       for ASCII format.  DB is for binary downloads.

       To get a list of topics, use the W command.

       The types for binary download are:  XMODEM, XMODEMCRC,
       YMODEM, YMODEM-BATCH (Alias YMBATCH), and YAPP

DU callsign -- Will display user info on a specific call

: E* N

  ECHO x -- Sends the given string back to the user with variable
       substitution

: H* N

H    - Gives a summary of the Help Subsystem.
H x  - Gives a detailed explanation of a specific command or topic.

: I* N

I    - Gives a paragraph on the hardware, software,
       and rf facilities of this MailBox station.

: J* N

J    - Gives list of ports
Jp   - Where p is a port identifier.
       Gives a short list of stations recently heard on that port.

JL   - Shows calls of stations recently connected to the MailBox.
JN   - SHows calls of stations currently connected

: K* N

K #  - Kills message number #.
         The message number can also be a series of number (eg: 112 115 117)
         and/or a range of numbers (eg: 112 TO 115).  A series can contain
         a range (eg: 112 115 TO 117)
KM   - Kills all messages addressed to you that you have read.
KT # - kills an NTS message.

: LTIME N

Sets the time of your last "L" command.  Can be used to limit
"L" searches.  Data is in the format of YYMMDD.  Example:

     LTIME 911201

A special case of NOW sets the LTIME to the current time.  Example:

     LTIME NOW

: L* N

Generally lists messages in reverse order, newest to oldest.
"Personal" messages not to or from you will not be listed.

L     - Lists all new messages since your previous "L" command.
LM    - "List Mine". Lists all messages addressed to you or by you.
LU    - "List Unread". Lists all messages unread by you.

L #   - Lists messages back to and including number #.
LL #  - Lists the last # messages.

L> call  - Lists all messages to this callsign.
L< call  - Lists all messages from this callsign.

For a list of all the searches you can do, issue H SEARCH

: N* N

NE       - Toggle your "expert user" status.
NH xxxxx - Enter your 'Home BBS'.  Aids in routing mesages to you.
NN xxxxx - Enter your first name into user data base.
NZ xxxxx - Enter your zip code into user data base.
NF x     - Change the format of message listings.
  Allowed values of x are from 0 to 4.
NL x     - Change your language setting (only works if your BBS
           supports multiple languages)
NP xxxxx - Change your telephone modem port password.  Can only be
  issue from modem port.
NS l w   - Change your screen size info.  l = length, w = width

: P* N

PL       - Flip switch which controls adding a LineFeed on the modem port.
           Only works on modem port
: REPLY N

  REPLY xxxx

Send a reply to message 'xxxx'.  You could also say 'SR xxxx'.  You must
enter the number or the system will prompt you for it.

: R* N

REPLY # - Replies to msg number #.

REVIEW -- Display your unread messages for review.  Each message is
        displayed and you are asked to tell what should be done.  Options are
        Kill, Leave, rEply, and Quit.  The last action leaves the message
        untouched and terminates the review command.  Note that the letter "E"
        is used for REPLY.  If the action is REPLY then an automatic SR to the
        message is issued.  After the reply is completed, you will again be
        prompted for an action.  You can then KILL, etc or even REPLY again.

R # - Read message number #.
        The message number can also be a series of number (eg: 112 115 117)
        and/or a range of numbers (eg: 112 TO 115).  A series can contain
        a range (eg: 112 115 TO 117)

RH # - Same as "R" but forwarding headers are shown.

RM    - "Read Mine". Lists all messages addressed to you but unread
RU    - Same as RM

RL #  - Read the last # messages.  Number assumed 1 if omitted

For a list of all the searches you can do, issue H SEARCH

: S* N

  SR xxxx

Send a reply to message 'xxxx'.  You could also say 'REPLY xxxx'.  You
must enter the number

  S? xxxx @ yyy

Send message type '?' to station 'xxxx', at optional BBS 'yyy'.  The
MailBox will prompt for title and ask you to enter text.  End text entry
with a ctrl-Z.

"?" is the "type" of message.  They include:

      B - Bulletins
      P - Personal.  Only the addressee can read or list this type.
      T - NTS Traffic

: T* N

T        - Talk to SYSOP

: U* N

U topic ffff.xxx
UB type topic ffff.xxx

       Upload the file ffff.xxx for the topic requested.  U is
       for ASCII format.  UB is for binary uploads.  The file
       must not exist.

       To get a list of topics, use the W command.

       The types for binary upload are:  XMODEM, XMODEMCRC,
       YMODEM, YMODEM-BATCH (Alias YMBATCH), and YAPP

: W* N

W        - Gives a list of topic areas available on the MailBox.

W topic  - Gives a list of the files for that topic

W topic ffff.xxx  - Gives a list of files for that topic that match
                    the given file specification.

W will show the file size
WD will show the file timestamp instead of the size
WX will include both the timestamp and size


