
#ifndef LINKER_H
#define LINKER_H

#include <stdio.h>
#include "network.h"
#include "cfgfile.h"

#define LJ_SUCCESS 1
#define LJ_FAILURE 2
#define LJ_ABORTED 3
#define LJ_ERROR 4

struct linkjob_t {
	struct csock_t *s;
	
	/* Connection script */
	char *script;
	FILE *f;
	
	/* Arguments read from the script */
	char line[CFGLINE_LEN];
	int linec;
	int argc;
	char *argv[256];
	
	/* Stuff to call after the script is done */
	void (*endfunc)(void *ptr, int res);
	void *ptr;
	
	struct linkjob_t *next;
	struct linkjob_t **prevp;
};

struct csock_t *start_connect(struct stringlist_t *scripts,
			void (*endfunc)(void *ptr, int res), void *ptr,
			int timeout);

extern void done_connect(struct csock_t *s);

#endif
