
/*
 *	db.c
 *
 *	an attempt to make a little bit of separation between the clusse
 *	code and gdbm, so that it would be a little bit easier to replace
 *	gdbm with something else, some day, when need arises.
 */

#include <gdbm.h>
#include <sys/stat.h>

#include "db.h"
#include "hmalloc.h"
#include "log.h"

void db_gdbm_fatal(char *s)
{
	log(L_CRIT, "gdbm fatal: %s (%s)", s, gdbm_strerror(gdbm_errno));
	exit(1);
}

struct db_t *db_open(char *name)
{
	struct db_t *dbp;
	
	dbp = hmalloc(sizeof(struct db_t));
	dbp->name = hstrdup(name);
	
	dbp->f = gdbm_open(dbp->name, 0, GDBM_WRCREAT, S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP, db_gdbm_fatal);
	
	if (!dbp->f) {
		log(L_CRIT, "db_open(): gdbm_open() failed for %s: %s", dbp->name, gdbm_strerror(gdbm_errno));
		hfree(dbp->name);
		hfree(dbp);
		return NULL;
	}
	
	return dbp;
}

void db_close(struct db_t *dbp)
{
	gdbm_close(dbp->f);
	
	hfree(dbp->name);
	hfree(dbp);
}

int db_store(struct db_t *dbp, datum key, datum content)
{
	return gdbm_store(dbp->f, key, content, GDBM_REPLACE);
}

datum db_fetch(struct db_t *dbp, datum key)
{
	return gdbm_fetch(dbp->f, key);
}

int db_exists(struct db_t *dbp, datum key)
{
	return gdbm_exists(dbp->f, key);
}

int db_delete(struct db_t *dbp, datum key)
{
	return gdbm_delete(dbp->f, key);
}

datum db_firstkey(struct db_t *dbp)
{
	return gdbm_firstkey(dbp->f);
}

datum db_nextkey(struct db_t *dbp, datum key)
{
	return gdbm_nextkey(dbp->f, key);
}

void db_reorganize(struct db_t *dbp)
{
	gdbm_reorganize(dbp->f);
}

void db_sync(struct db_t *dbp)
{
	gdbm_sync(dbp->f);
}

