
#include "csock.h"
#include "cluster.h"
#include "help.h"

/*
 *     Help commands
 */

struct cmd help_cmds[] = {
	{ "prompt",             help_prompt             },
	{ NULL,                 NULL,                   }
};

int cmd_commands(struct csock_t *s, int argc, char **argv)
{
	struct cmd *c;
	
	csputs(s, "Commands:\n");
	for (c = cluster_cmds; c->function != NULL; c++)
		csprintf(s, " %s", c->name);
	csputs(s, "\n");
	
	return 0;
}

int cmd_help(struct csock_t *s, int argc, char **argv)
{
	if (argc > 1)
		command(s, help_cmds, argv[1]);
	else
		csprintf(s, "Help is for wimps. Use the source, luke!\n");

	return 0;
}

int help_prompt(struct csock_t *s, int argc, char **argv)
{
	csputs(s, "\nPRompt [<+|-><number>] ... - change the prompt\n\n");
	csputs(s, "You can customize the prompt by selecting one or more\n");
	csputs(s, "of the following items to be displayed:\n\n");
	csputs(s, "0. The basic \"c>\" prompt. Resets other settings.\n");
	csputs(s, "1. Your callsign\n");
	csputs(s, "2. Cluster's callsign\n");
	csputs(s, "3. Current time\n");
	csputs(s, "4. Current date\n");
	csputs(s, "5. Cluster's uptime\n");
	csputs(s, "6. Number of users (local/all)\n");
	csputs(s, "7. None (hides the prompt, preserves other selections.)\n");
	csputs(s, "\nExample: prompt +25-3\n\n");

	return 0;
}
