#!/bin/bash

DIR=`dirname $0`

PATH=$DIR:$PATH

# log file
LOG=/var/log/fpac

# serial port for watchdog
# WDOG_PORT="/dev/ttyS4"
WDOG_PORT=""

# callsign of the sysop
SYSOP="SYSOP"

# route/callsign of the notified BBS
# CONNECT="rose0 f6fbb-1 2080931502"
CONNECT="MYBBS-1"

export PATH SYSOP CONNECT

case "$1" in
restart)
	$0 stop && $0 start
	;;
stop)
	echo -n "Halting FPAC :"
	for PROC_NAME in fpacnode fpacshell
	do
		PID=`/sbin/pidof -x $DIR/$PROC_NAME`
		if [ -n "$PID" ]; then
                        kill -TERM $PID
			sleep 4
		fi
	done
	echo -n " [flexd]"
	kill -TERM `/sbin/pidof -x $DIR/flexd`
	echo -n " [route]"
	kill -TERM `/sbin/pidof -x $DIR/fpacroute`
	echo -n " [stats]"
	kill -TERM `/sbin/pidof -x $DIR/fpacstat`
	echo -n " [wp]"
	kill -TERM `/sbin/pidof -x $DIR/fpacwpd`
	echo -n " [pad]"
	kill -KILL `/sbin/pidof -x $DIR/fpad`
	echo -n " [wdog]"
	kill -TERM `/sbin/pidof -x $DIR/fpacwdog`
	echo " ok"
	;;
status)
        echo -e "\nStatus of FPAC :"

	for PROC_NAME in fpacwdog fpad fpacwpd fpacstat fpacroute flexd
	do
	        PID=`/sbin/pidof -x $DIR/$PROC_NAME`
		if [ -n "$PID" ]; then
			echo -e "$PROC_NAME    \tis running"

		else
			echo -e "$PROC_NAME    \tis not running"
		fi
	done
	echo
        ;;
fpad)
	while [ 1 ]
	do
		$DIR/fpad -d
		sleep 1
	done
	;;
fpacwpd)
	while [ 1 ]
	do
		$DIR/fpacwpd -d
		sleep 1
	done
	;;
-t)
	FPAC_BG="yes"
	export FPAC_BG
	echo -n "Starting FPAC :"
	if [ "_$WDOG_PORT" != "_" ] ; then
		echo -n " [wdog]"
		$DIR/fpacwdog -p 2 $WDOG_PORT >> $LOG 2>&1
	fi
	echo -n " [pad]"
	$DIR/fpac.sh fpad >> $LOG 2>&1 &
	echo -n " [wp]"
	$DIR/fpac.sh fpacwpd >> $LOG 2>&1 &
	echo -n " [stats]"
	$DIR/fpacstat >> $LOG 2>&1
	echo -n " [route]"
	$DIR/fpacroute >> $LOG 2>&1
	echo -n " [flexd]"
	$DIR/flexd >> $LOG 2>&1
	(sleep 60 ; /bin/date | $DIR/mailbbs -d $SYSOP -t "System Reboot" $CONNECT) &
	echo " ok"
	;;
*)
	echo -n "Starting FPAC :"
	if [ "_$WDOG_PORT" != "_" ] ; then
		echo -n " [wdog]"
		$DIR/fpacwdog -p 2 $WDOG_PORT >> $LOG 2>&1
	fi
	echo -n " [pad]"
	$DIR/fpad >> $LOG 2>&1
	echo -n " [wp]"
	$DIR/fpacwpd >> $LOG 2>&1
	echo -n " [stats]"
	$DIR/fpacstat >> $LOG 2>&1
	echo -n " [route]"
	$DIR/fpacroute >> $LOG 2>&1
	echo -n " [flexd]"
	$DIR/flexd >> $LOG 2>&1
	(sleep 60 ; /bin/date | $DIR/mailbbs -d $SYSOP -t "System Reboot" $CONNECT) &
	echo " ok"
	;;
esac


exit 0

