// EditMessage.cpp : implementation file
//

#include "stdafx.h"
#include "fbbw.h"
#include "fbbWDlg.h"
#include "EditMessage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditMessage dialog


CEditMessage::CEditMessage(CWnd* pParent /*=NULL*/)
	: CDialog(CEditMessage::IDD, pParent)
{
	//{{AFX_DATA_INIT(CEditMessage)
	m_MsgBid = _T("");
	m_MsgData = FALSE;
	m_MsgTypeA = FALSE;
	m_MsgTypeB = FALSE;
	m_MsgTypeP = FALSE;
	m_MsgTypeT = FALSE;
	m_MsgStatusD = FALSE;
	m_MsgStatusN = FALSE;
	m_MsgStatusY = FALSE;
	m_MsgStatusF = FALSE;
	m_MsgStatusX = FALSE;
	m_MsgStatusK = FALSE;
	m_MsgStatusA = FALSE;
	m_MsgFrom = _T("");
	m_MsgReceived = _T("");
	m_MsgSent = _T("");
	m_MsgSize = _T("");
	m_MsgTitle = _T("");
	m_MsgTo = _T("");
	m_MsgVia = _T("");
	//}}AFX_DATA_INIT
}


void CEditMessage::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditMessage)
	DDX_Control(pDX, IDOK, m_Ok);
	DDX_Control(pDX, IDC_MSGNUMBER, m_MsgList);
	DDX_Text(pDX, IDC_MSGBID, m_MsgBid);
	DDX_Check(pDX, IDC_MSGDATA, m_MsgData);
	DDX_Check(pDX, IDC_MSGTYPEA, m_MsgTypeA);
	DDX_Check(pDX, IDC_MSGTYPEB, m_MsgTypeB);
	DDX_Check(pDX, IDC_MSGTYPEP, m_MsgTypeP);
	DDX_Check(pDX, IDC_MSGTYPET, m_MsgTypeT);
	DDX_Check(pDX, IDC_MSGSTATUSD, m_MsgStatusD);
	DDX_Check(pDX, IDC_MSGSTATUSN, m_MsgStatusN);
	DDX_Check(pDX, IDC_MSGSTATUSY, m_MsgStatusY);
	DDX_Check(pDX, IDC_MSGSTATUSF, m_MsgStatusF);
	DDX_Check(pDX, IDC_MSGSTATUSX, m_MsgStatusX);
	DDX_Check(pDX, IDC_MSGSTATUSK, m_MsgStatusK);
	DDX_Check(pDX, IDC_MSGSTATUSA, m_MsgStatusA);
	DDX_Text(pDX, IDC_MSGFROM, m_MsgFrom);
	DDX_Text(pDX, IDC_MSGRECEIVED, m_MsgReceived);
	DDX_Text(pDX, IDC_MSGSENT, m_MsgSent);
	DDX_Text(pDX, IDC_MSGSIZE, m_MsgSize);
	DDX_Text(pDX, IDC_MSGTITLE, m_MsgTitle);
	DDX_Text(pDX, IDC_MSGTO, m_MsgTo);
	DDX_Text(pDX, IDC_MSGVIA, m_MsgVia);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditMessage, CDialog)
	//{{AFX_MSG_MAP(CEditMessage)
	ON_LBN_SELCHANGE(IDC_MSGNUMBER, OnSelchangeMsgnumber)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditMessage message handlers

BOOL CEditMessage::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	FILE *fptr;
	char szBuf[80];
	char szNumMsg[80];

	if (fptr = fopen(SERVICE_FILE, "r"))
	{
		while (fgets(szBuf, sizeof(szBuf), fptr))
		{
			if (sscanf(szBuf, "%s", szNumMsg) == 1)
				m_MsgList.AddString(szNumMsg);
		}
		fclose(fptr);
		unlink(SERVICE_FILE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CEditMessage::Answer(char *szBuf, int nNb)
{
	char *ptr;
	int nPos;

	ptr = strtok(szBuf, "\n");
	while (ptr)
	{
		nPos = atoi(ptr);
		while (isdigit(*ptr))
			++ptr;
		while (*ptr && isspace(*ptr))
			++ptr;

		switch (nPos)
		{
		case 1:
			m_MsgTypeA = (*ptr == 'A');
			m_MsgTypeB = (*ptr == 'B');
			m_MsgTypeP = (*ptr == 'P');
			m_MsgTypeT = (*ptr == 'T');
			break;
		case 2:
			m_MsgStatusD = (*ptr == '$');
			m_MsgStatusN = (*ptr == 'N');
			m_MsgStatusY = (*ptr == 'Y');
			m_MsgStatusF = (*ptr == 'F');
			m_MsgStatusX = (*ptr == 'X');
			m_MsgStatusK = (*ptr == 'K');
			m_MsgStatusA = (*ptr == 'A');
			break;
		case 4 :
			m_MsgSize = ptr;
			break;
		case 5 :
			m_MsgReceived = DateToString(ptr);
			break;
		case 7 :
			m_MsgVia = ptr;
			break;
		case 8 :
			m_MsgFrom = ptr;
			break;
		case 9 :
			m_MsgTo = ptr;
			break;
		case 10 :
			m_MsgBid = ptr;
			break;
		case 11 :
			m_MsgTitle = ptr;
			if (!((CFbbWDlg *)GetParent())->m_bAnsi)
				m_MsgTitle.OemToAnsi();
			break;
		case 12 :
			m_MsgData = (*ptr == '1');
			break;
		case 15 :
			m_MsgSent = DateToString(ptr);
			break;
		}
		ptr = strtok(NULL, "\n");
	}
	m_Ok.EnableWindow();
	UpdateData(FALSE);
}

void CEditMessage::OnSelchangeMsgnumber() 
{
	// TODO: Add your control notification handler code here
	char szCall[20];
	m_MsgList.GetText(m_MsgList.GetCurSel(), szCall);

	char szCommand[80];
	wsprintf(szCommand, "GET %s", szCall);
	((CFbbWDlg *)GetParent())->RequestService(7, szCommand);	
}

DWORD CEditMessage::StringToDate(CString Date)
{
	int nDay, nMonth, nYear, nHour, nMinute;

	sscanf(Date, "%d-%d-%d %d:%d", &nDay, &nMonth, &nYear, &nHour, &nMinute);
	CTime Time(nYear, nMonth, nDay, nHour, nMinute, 0);
	return Time.GetTime();
}

CString CEditMessage::DateToString(char *date)
{
	CTime Time(atol(date));
	return Time.Format("%d-%m-%Y %H:%M");
}

void CEditMessage::OnOK() 
{
	// TODO: Add extra validation here
	UpdateData(TRUE);

	char szBuffer[512];
	int nPos = 0;

	char cType;

	if (m_MsgTypeA)
		cType = 'A';
	else if (m_MsgTypeB)
		cType = 'B';
	else if (m_MsgTypeP)
		cType = 'P';
	else if (m_MsgTypeT)
		cType = 'T';
	else
		cType = '?';
	nPos += wsprintf(szBuffer+nPos, "1 %c\n", cType);

	if (m_MsgStatusD)
		cType = '$';
	else if (m_MsgStatusN)
		cType = 'N';
	else if (m_MsgStatusY)
		cType = 'Y';
	else if (m_MsgStatusF)
		cType = 'F';
	else if (m_MsgStatusX)
		cType = 'X';
	else if (m_MsgStatusK)
		cType = 'K';
	else if (m_MsgStatusA)
		cType = 'A';
	else
		cType = '?';
	nPos += wsprintf(szBuffer+nPos, "2 %c\n", cType);
	nPos += wsprintf(szBuffer+nPos, "4 %s\n", m_MsgSize);
	nPos += wsprintf(szBuffer+nPos, "5 %ld\n", StringToDate(m_MsgReceived));
	nPos += wsprintf(szBuffer+nPos, "7 %s\n", m_MsgVia);
	nPos += wsprintf(szBuffer+nPos, "8 %s\n", m_MsgFrom);
	nPos += wsprintf(szBuffer+nPos, "9 %s\n", m_MsgTo);
	nPos += wsprintf(szBuffer+nPos, "10 %s\n", m_MsgBid);

	CString sTemp = m_MsgTitle;
	if (!((CFbbWDlg *)GetParent())->m_bAnsi)
		sTemp.AnsiToOem();
	nPos += wsprintf(szBuffer+nPos, "11 %s\n", sTemp);
	nPos += wsprintf(szBuffer+nPos, "12 %d\n", m_MsgData ? 1 : 0);
	nPos += wsprintf(szBuffer+nPos, "15 %ld\n", StringToDate(m_MsgSent));
	
	char szNumber[20];
	m_MsgList.GetText(m_MsgList.GetCurSel(), szNumber);

	char szCommand[512];
	wsprintf(szCommand, "PUT %s %d\n", szNumber, nPos);
	strcat(szCommand, szBuffer);
	((CFbbWDlg *)GetParent())->RequestService(7, szCommand);	
	
	// CDialog::OnOK();
}
