{$F-} {$R+} {$Q+} {$V-} {$B-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit cmd_User;

  { Implements lots of basic cluster user commands. Check here first. }

Interface
Uses Cluster;

Procedure Announce_Cmd(p:sType);
Procedure Away_Cmd(p:sType);

Procedure Beeps_Cmd(p:sType);
Procedure Bye_Cmd(p:sType);

Procedure CharSet_Cmd(p:sType);
Procedure Convers_Cmd(p:sType);
Procedure Coordinates_Cmd(p:sType);

Procedure Dx_Cmd(p:sType);

Procedure Help_Cmd(p:sType);
Procedure Here_Cmd(p:sType);

Procedure Info_Cmd(p:sType);

Procedure Lann_Cmd(p:sType);
Procedure Lconnections_Cmd(p:sType);
Procedure Locator_Cmd(p:sType);
Procedure Login_Cmd(p:sType);
Procedure Lwwv_Cmd(p:sType);

Procedure Messages_Cmd(p:sType);

Procedure Name_Cmd(p:sType);
Procedure News_Cmd(p:sType);
Procedure Nodes_Cmd(p:sType);

Procedure Prompt_Cmd(p:sType);
Procedure PCMode_Cmd(p:sType);

Procedure Qth_Cmd(p:sType);

Procedure Say_Cmd(p:sType);
Procedure Shout_Cmd(p:sType);

Procedure Talk_Cmd(p:sType);
Procedure Time_Cmd(p:sType);
Procedure Timestamp_Cmd(p:sType);
Procedure Timereset_Cmd(p:sType);

Procedure Uptime_Cmd(p:sType);
Procedure Users_Cmd(p:sType);

Procedure Where_Cmd(p:sType);
Procedure WWV_Cmd(p:sType);

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Implementation
Uses Dos, BPQ, Protocol, Files, Screen, cStrings, cMath, ConfFile, Convers,
     Filters;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { Support routines                                                        }

Function LocSet(p:sType):Boolean;
Begin

 If LUser[p]^.f^.Locator = ''
   then Begin
        Send(p,'Your locator is not set, cannot perform calculations.' + Cr);
        LocSet := False;
        End
   else LocSet := True;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }
 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Announce_Cmd(p:byte); { Cluster announce }
Var
  AInfo   : AnnP;
  b       : Byte;
Begin

 New(AInfo);

 AInfo^.ToPC := UpCaseStr(Parse(1));
 If (AInfo^.ToPC = '')
   then Begin
        ParamError(p);
        Dispose(AInfo);
        Exit;
        End;
 If (AInfo^.ToPC = 'FULL') or (AInfo^.ToPC = 'F') then AInfo^.ToPC := '*';
 If (AInfo^.ToPC = 'LOCAL') or (AInfo^.ToPC = 'L') then AInfo^.ToPC := CluCall;
 If not ( (AInfo^.ToPC = '*') or (AInfo^.ToPc = CluCall) or (GetNode(AInfo^.ToPC) <> nil) )
   then Begin
        Send(p,'Node ' + AInfo^.ToPC + ' not found.' + Cr);
        Dispose(AInfo);
        Exit;
        End;

 b := FindParamStart(2);

 If (b = 0)
   then Begin
        ParamError(p);
        Dispose(AInfo);
        Exit;
        End;

 AInfo^.Msg := Copy(IBuffer,b,Length(IBuffer)-b);

 If LowCaseCh[IBuffer[1]] = 'w'
   then AInfo^.Wx := True
   else AInfo^.Wx := False;

 AInfo^.Sysop := False;
 AInfo^.Time := Now;
 AInfo^.FromPC := CluCall;
 AInfo^.FromLink := nil;
 AInfo^.FromCall := LUser[p]^.f^.Call;
 Protocol.Announce(AInfo);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Away_Cmd(p:Byte);
Var
  b : Byte;
  s : String;
Begin

 b := FindParamStart(1);

 With LUser[p]^ do
 If (not Here) and (b = 0)
  then Send(p,'You are already marked as being away. Use the HERe command to remove the' + Cr
            + 'away mark.' + Cr)
  else Begin
       If (b > 0) { Infoa? }
         then Begin
              s := CutStr(80,Copy(ibuffer,b,length(ibuffer)-b));
              If not assigned(AwayStrP)
                then Begin
                     New(AwayStrP);
                     Inc(LAwayStrings);
                     End;
              AwayStrP^ := s;
              End
         else s := '';
       Locked := True;
       Protocol.SetAway(nil,f^.Call,s);
       Locked := False;
       If here
         then Send(p,'You are marked as being away.' + Cr)
         else Send(p,'Away text changed.' + Cr);
       Here := False;
       End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Beeps_Cmd(p:Byte);
Var
  b     : Byte;
  SetTo : Boolean;
  s     : String;

Begin

 Action(p,'Set Beeps');
 With LUser[p]^.f^ do Begin


 b := 1;
 s := Parse(1);
 SetTo := True;

 While s <> '' do
   Begin
    Case LowCaseCh[s[1]] of
    '+' : SetTo := True;
    '-' : SetTo := False;
    'o' : Case LowCaseCh[s[2]] of
            'n' : Include(Flags,f_Beeps);
            'f' : Exclude(Flags,f_Beeps);
          else Send(p,'Illegal message type "' + s + '".' + Cr);
          End;
    'd' : If SetTo then Include(Beeps,M_Dx)
                   else Exclude(Beeps,M_Dx);
    'a' : If SetTo then Include(Beeps,M_Ann)
                   else Exclude(Beeps,M_Ann);
    'w' : If SetTo then Include(Beeps,M_WWV)
                   else Exclude(Beeps,M_WWV);
    'u' : If SetTo then Include(Beeps,M_User)
                   else Exclude(Beeps,M_User);
    'n' : If SetTo then Include(Beeps,M_Node)
                   else Exclude(Beeps,M_Node);
    'e' : If SetTo then Include(Beeps,M_Wx)
                   else Exclude(Beeps,M_Wx);
    't' : If SetTo then Include(Beeps,M_Talk)
                   else Exclude(Beeps,M_Talk);
    'l' : If SetTo then Include(Beeps,M_Localuser)
                   else Exclude(Beeps,M_Localuser);
    'i' : If SetTo then Include(Beeps,M_Link)
                   else Exclude(Beeps,M_Link);
    else Send(p,'Illegal message type "' + s + '".' + Cr);
    End; { Case }
   Inc(b);
   s := Parse(b);
   End;

 WriteUser(LUser[p]^.f);
 If f_Beeps in LUser[p]^.f^.Flags
   then Begin
        s := '';
        If M_Dx in Beeps then s := s + 'Dx ';
        If M_Ann in Beeps then s := s + 'Announce ';
        If M_WWV in Beeps then s := s + 'Wwv ';
        If M_User in Beeps then s := s + 'User ';
        If M_Node in Beeps then s := s + 'Node ';
        If M_Wx in Beeps then s := s + 'wEather ';
        If M_Talk  in Beeps then s := s + 'Talk ';
        If M_Localuser in Beeps then s := s + 'Localuser ';
        If M_Link in Beeps then s := s + 'lInk ';
        End
   else s := 'Disabled.';

 Send(p,Format(True,'Beeps:',s));

 End; { With.... }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Bye_Cmd(p:Byte);
Begin

 Send(p,'73!' + Cr);
 Kick(p);
 Prompted := False;
 ThrowOut(p);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure CharSet_Cmd(p:Byte);
var
 b       : Byte;
 e       : Integer;
 Changed : Boolean;
Begin

 Action(p,'Charset');
 With LUser[p]^.f^ do Begin

 Val(Parse(1),b,e);
 If (e <> 0) or (b > 5) or ((b > 0) and (CStrings.CharSet[b] = nil))
   then Begin
        Send(p,'Available character sets:' + Cr +
               ' 0: No conversion' + Cr);
        For b := 1 to 5 do
         If Assigned(CStrings.CharSet[b])
          Then Send(p,' ' + Int2Str(b) + ': ' + CStrings.CharSet[b]^.Desc + Cr);
        Changed := False;
        End
   else Begin
        CharSet := b;
        WriteUser(LUser[p]^.f);
        Sock[p]^.CharSet := b;
        Changed := True;
        End;

 Send(p,'Current charset: ' + Int2Str(CharSet));
 If Changed and (CharSet > 0)
    then Send(p,' (' + CStrings.CharSet[CharSet]^.Desc + ')');
 Send(p,Cr);
 End; { While... }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Convers_Cmd(p:Byte);
Begin

 If Permission(p,R_WideAct)
   then Begin { Convers }
        Action(p,'Entered Conference');
        ConvLogin(p);
        Prompted := False;
        End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Coordinates_Cmd(p:sType);
Var
  s : String;
  c : CoordRec;
Begin

  With lUser[p]^.f^
   do Begin
      s := UpCaseStr(Parse(1));
      If not (s = '')
        then Begin
             If Str2Coord(s,c)
               then Begin
                    Loc := c;
                    End
               else Send(p,'Could not parse the coordinates.' + Cr);
             End;

      locator := Coord2Loc(Loc);

      If Locator = ''
        then Send(p,'Your QTH location is not set.' + Cr)
        else Send(p,'Your QTH coordinates are set to ' + Coord2Str(Loc)
                  + ' (' + Locator + ').' + Cr)
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Dx_Cmd(p:Byte);
Var
  DXInfo  : DXInfoP;
  fr      : LongInt;
  b       : Byte;
  invert  : Boolean;
  dat     : DateTime;
  Time    : LongInt;
Begin

 invert := false;
 New(DxInfo);

 fr := Str2Freq(Parse(1));
 if (fr = 0)
   then Begin
        fr := Str2Freq(Parse(2));
        invert := true;
        end;
 If (fr = 0)
   then Begin
        ParamError(p);
        Dispose(DXInfo);
        Exit;
        End;

 If invert
   then DXInfo^.Call := UpCaseStr(Parse(1))
   else DXInfo^.Call := UpCaseStr(Parse(2));

 If (DXInfo^.Call = '')
   then Begin
        ParamError(p);
        Dispose(DXInfo);
        Exit;
        End;

 b := FindParamStart(3);

 If (b > 0) { Infoa? }
   then DxInfo^.info := Copy(ibuffer,b,length(ibuffer)-b)
   else DxInfo^.Info := ' ';

 { Aika. Sekunnit nolliksi, muuten omat spotit tulee mergess takaisin. }
 dat := dt;
 dat.Sec := 0;
 PackTime(dat,time);

 Dxinfo^.Time := Time;
 Dxinfo^.Freq := fr;
 Dxinfo^.FromCall := LUser[p]^.f^.Call;
 Dxinfo^.FromPC := CluCall;
 Dxinfo^.FromLink := nil;

 If OnBand(Dxinfo^.Freq)
   then Begin
        If not Protocol.DX(DxInfo)
          then Send(p,'The cluster already has this spot.' + Cr);
        End
   else Begin
        Send(p,'The frequency is not on a valid amateur band.' + Cr);
        Dispose(DxInfo);
        End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Help_Cmd(p:Byte);
Var
  Keyword : KeyWordType;
Begin

 Keyword := Parse(1);
 If Keyword = '' then Keyword := 'help';
 Action(p,'Help for ' + Keyword);
 Help(p,Keyword);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Here_Cmd(p:Byte);
Begin

 With LUser[p]^ do
 If Here
  then Send(p,'You are already marked as being here. Use the AWay command to set the away' + Cr
            + 'mark.' + Cr)
  else Begin
       Here := True;
       If assigned(AwayStrP)
         then Begin
              Dispose(AwayStrP);
              AwayStrP := nil;
              Dec(LAwayStrings);
              End;
       Locked := True;
       SetHere(nil,f^.Call);
       Locked := False;
       Send(p,'You are marked as being here.' + Cr);
       End;
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Info_Cmd(p:sType);
Begin

 Action(p,'Read info file');
 If not SendFile(p,TextPath + 'info.txt')
   then Send(p,'Could not read info file.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure LAnn_Cmd(p:sType);
Var
  Num : Word;
Begin

  Num := Str2Word(Parse(1));
  If (Num > 100) then Num := 100;
  If Num = 0 then Num := 10;
  Action(p,'LAnn last ' + Int2Str(Num));
  ReadAnnLast(p,Num);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure LConnections_Cmd(p:sType);
Var
  w : Word;
Begin

  w := Str2Word(Parse(1));
  If (w > 500) then w := 500;
  If w = 0 then w := 20;
  Action(p,'LConnections ' + Int2Str(w));
  ReadLastLast(p,w);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Locator_Cmd(p:sType);
Var
  s : LocStr;
  c : CoordRec;
Begin

  With lUser[p]^.f^
   do Begin
      s := UpCaseStr(Parse(1));
      If not (s = '')
        then Begin
             If Loc2Coord(s,c)
               then Begin
                    Locator := s;
                    Loc := c;
                    End
               else Send(p,'Could not parse the locator.' + Cr);
             End;

      If Locator = ''
        then Send(p,'Your QTH locator is not set.' + Cr)
        else Send(p,'Your QTH locator is set to ' + Locator
                  + ' (' + Coord2Str(Loc) + ').' + Cr)
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Login_Cmd(p:Byte);
Var
  b     : Byte;
  SetTo : Boolean;
  s     : String;

Begin

 With LUser[p]^.f^ do Begin

 Action(p,'Set Login');

 b := 1;
 s := Parse(1);
 SetTo := True;

 While s <> '' do
   Begin
    Case LowCaseCh[s[1]] of
    '+' : SetTo := True;
    '-' : SetTo := False;
    'u' : If SetTo then Include(LoginAct,LO_LUser)
                   else Exclude(LoginAct,LO_LUser);
    'n' : If SetTo then Include(LoginAct,LO_LNode)
                   else Exclude(LoginAct,LO_LNode);
    'i' : If SetTo then Include(LoginAct,LO_LLink)
                   else Exclude(LoginAct,LO_LLink);
    'd' : If SetTo then Include(LoginAct,LO_LDx)
                   else Exclude(LoginAct,LO_LDx);
    'a' : If SetTo then Include(LoginAct,LO_LAnn)
                   else Exclude(LoginAct,LO_LAnn);
    'f' : If SetTo then Include(LoginAct,LO_Fortune)
                   else Exclude(LoginAct,LO_Fortune);
    'w' : If SetTo then Include(LoginAct,LO_LWWV)
                   else Exclude(LoginAct,LO_LWWV);
    else Send(p,'Illegal keyword "' + s + '".' + Cr);
    End; { Case }
   Inc(b);
   s := Parse(b);
   End;

 WriteUser(LUser[p]^.f);
 s := 'Your current login messages:' + Cr;

 If LO_LUser   in LoginAct then s := s + ' Users';
 If LO_LNode   in LoginAct then s := s + ' Nodes';
 If LO_LLink   in LoginAct then s := s + ' lInks';
 If LO_LDx     in LoginAct then s := s + ' Dxlist';
 If LO_LAnn    in LoginAct then s := s + ' Annlist';
 If LO_Fortune in LoginAct then s := s + ' Fortune';
 If LO_LWWV    in LoginAct then s := s + ' Wwvlist';

 s := s + Cr;
 Send(p,s);

 End; { With .... }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Lwwv_Cmd(p:sType);
Var
  w : Word;
Begin

  w := Str2Word(Parse(1));
  If (w > 100) then w := 100;
  If w = 0 then w := 1;
  Action(p,'LWwv last ' + Int2Str(w));
  ReadWWVLast(p,w);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Messages_Cmd(p:Byte);
Var
  b     : Byte;
  SetTo : Boolean;
  s     : String;

Begin

 Action(p,'Set Messages');
 With LUser[p]^.f^ do Begin

 b := 1;
 s := Parse(1);
 SetTo := True;

 While s <> '' do
   Begin
    Case LowCaseCh[s[1]] of
    '+' : SetTo := True;
    '-' : SetTo := False;
    'd' : If SetTo then Include(Messages,M_Dx)
                   else Exclude(Messages,M_Dx);
    'a' : If SetTo then Include(Messages,M_Ann)
                   else Exclude(Messages,M_Ann);
    'w' : If SetTo then Include(Messages,M_WWV)
                   else Exclude(Messages,M_WWV);
    'u' : If SetTo then Include(Messages,M_User)
                   else Exclude(Messages,M_User);
    'n' : If SetTo then Include(Messages,M_Node)
                   else Exclude(Messages,M_Node);
    'e' : If SetTo then Include(Messages,M_Wx)
                   else Exclude(Messages,M_Wx);
    't' : If SetTo then Include(Messages,M_Talk)
                   else Exclude(Messages,M_Talk);
    'l' : If SetTo then Include(Messages,M_Localuser)
                   else Exclude(Messages,M_Localuser);
    'i' : If SetTo then Include(Messages,M_Link)
                   else Exclude(Messages,M_Link);
    else Send(p,'Illegal message type "' + s + '".' + Cr);
    End; { Case }
   Inc(b);
   s := Parse(b);
   End;

 WriteUser(LUser[p]^.f);
 s := '';
 If M_Dx in Messages then s := s + 'Dx ';
 If M_Ann in Messages then s := s + 'Announce ';
 If M_WWV in Messages then s := s + 'Wwv ';
 If M_User in Messages then s := s + 'User ';
 If M_Node in Messages then s := s + 'Node ';
 If M_Wx in Messages then s := s + 'wEather ';
 If M_Talk  in Messages then s := s + 'Talk ';
 If M_Localuser in Messages then s := s + 'Localuser ';
 If M_Link in Messages then s := s + 'lInk ';
 Send(p,Format(True,'Messages:',s));

 End; { With .... }

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Name_Cmd(p:sType);
Var s : String;
Begin

 s := Capitalize(Parse(1));
 Action(p,'Name ' + s);
 With LUser[p]^ do
    If s <> ''
      then Begin
           Send(p,'Thanks, ' + s + '.' + Cr);
           SetUserData(n,nil,f^.Call,1,s);
           End
      else With n^ do
             If (Name = '')
               then Send(p,'Name not set.' + Cr)
               else Send(p,'You''re known as ' + Name + '.' + Cr);
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure News_Cmd(p:sType);
Var b : Byte;
Begin

 b := Str2Word(Parse(1));
 if b = 0 then b := 1;
 Action(p,'News (last ' + Int2Str(b) + ')');
 ReadNewsLast(p,b);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Nodes_Cmd(p:sType);
Var s : CallRec;
Begin

 s := Parse(1);

 If s = ''
   then Begin
        Action(p,'Node list');
        Send(p,'Cluster nodes: ' + Int2Str(NodeCount) + ' via ' + Int2Str(PCLinks) + ' links.' + Cr);
        Protocol.Nodelist_Cmd(p);
        End
   else Protocol.NodeInfo_Cmd(p,UpCaseStr(s));

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Prompt_Cmd(p:Byte);
var
  b : Byte;
  s : String;
Begin

 With LUser[p]^.f^ do Begin

 s := Parse(1);
 b := Str2Word(s);
 If (s = '') or (b > PromptsAvail)
   then Begin
        Send(p,'Prompts available: ' + Cr
             + ' 0: No prompt' + Cr
             + ' 1: c>' + Cr
             + ' 2: ' + TimeStrS(now) + '> (UTC time)' + Cr
             + ' 3: ' + CluCall + '> (Node callsign)' + Cr
             + ' 4: ' + Int2Str(NUserCount) + '/' + Int2Str(LUserCount) + '> (Users/Local users)' + Cr
             + ' 5: ' + Int2Str(NUserCount) + '/' + Int2Str(NodeCount) + '> (Users/Nodes)' + Cr
             + ' 6: ' + DateStrS(now) + ' ' + TimeStrS(now) + '> (Date + time)' + Cr
             + ' 7: ' + CluCall + ' ' + TimeStrS(now) + '> (Node callsign + time)' + Cr
             + ' 8: ' + Secs2Str(UpTime) + '> (Uptime)' + Cr);
        End
   else Begin
        Prompt := b;
        WriteUser(LUser[p]^.f);
        End;

 Send(p,'Your prompt: ' + Int2Str(Prompt) + Cr);
 Action(p,'Prompt ' + Int2Str(Prompt));

 End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure PCMode_Cmd(p:Byte);
var
  b : Byte;
  s : String;
Begin

 If Parse(0) <> 'SET/PCMODE'
  then Begin
       Send(p, 'You must type at least SET/PCMODE (in upper case) to use the SET/PCMODE' + Cr
            +  'command.' + Cr);
       Action(p,'SET/PCMODE (nagging)');
       End
 else
 With LUser[p]^.f^
   do Begin
      Action(p,'SET/PCMODE');
      b := Str2Bool(Parse(1));
      If (b = 1) then Include(Flags,f_PCCompat);
      If (b = 0) then Exclude(Flags,f_PCCompat);
      If (f_PCCompat in Flags)
        then s := 'enabled'
        else s := 'disabled';
      Send(p,'PacketCluster (TM) emulation mode is ' + s + '.' + Cr);
      End;


End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure QTH_Cmd(p:Byte);
Var
 b : Byte;
 s : QTHStr;
 f : NUserFP;
Begin

 b := FindParamStart(1);
 Action(p,'QTH');
 If b > 0
   then Begin
        s := Capitalize(Copy(IBuffer,b,Length(IBuffer)-b));
        Send(p,'QTH set to ' + s + '.' + Cr);
        SetUserData(LUser[p]^.n,nil,LUser[p]^.f^.Call,2,s);
        End
   else Begin
        f := ReadNUser(LUser[p]^.f^.Call);
        If f^.QTH = ''
          then Send(p,'QTH not set.' + Cr)
          else Send(p,'QTH set to ' + f^.QTH + '.' + Cr);
        Dispose(f);
        End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Say_Cmd(p:byte); { Full cluster announce }
Var
  AInfo   : AnnP;
  b       : Byte;
Begin

 New(AInfo);
 AInfo^.ToPC := CluCall;

 b := FindParamStart(1);

 If (b = 0)
   then Begin
        ParamError(p);
        Dispose(AInfo);
        Exit;
        End;

 AInfo^.Msg := Copy(IBuffer,b,Length(IBuffer)-b);
 AInfo^.Wx := False;
 AInfo^.Sysop := False;
 AInfo^.Time := Now;
 AInfo^.FromPC := CluCall;
 AInfo^.FromLink := nil;
 AInfo^.FromCall := LUser[p]^.f^.Call;
 Protocol.Announce(AInfo);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Shout_Cmd(p:byte); { Full cluster announce }
Var
  AInfo   : AnnP;
  b       : Byte;
Begin

 New(AInfo);
 AInfo^.ToPC := '*';

 b := FindParamStart(1);

 If (b = 0)
   then Begin
        ParamError(p);
        Dispose(AInfo);
        Exit;
        End;

 With AInfo^
  do Begin
     Msg := Copy(IBuffer,b,Length(IBuffer)-b);
     Wx := False;
     Sysop := False;
     Time := Now;
     FromPC := CluCall;
     FromLink := nil;
     FromCall := LUser[p]^.f^.Call;
     End;

 Protocol.Announce(AInfo);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Talk_Cmd(p:Byte);
Var
  b     : Byte;
  ToPc  : CallRec;
  TInfo : TalkRec;
  s     : String[25];
  u     : NUserRecP;
  TimeS : Boolean;
  MsgPos : Byte;
Begin

 With LUser[p]^ do Begin

 If LowCaseCh[IBuffer[2]] = 'r'
   then Begin { TReply }
        s := LastTalkFrom;
        MsgPos := FindParamStart(1);
        End
   else Begin
        s := UpCaseStr(Parse(1));
        While Pos('!',s) > 0
         do Delete(s,Pos('!',s),1);
        MsgPos := FindParamStart(2);
        End;

 b := Pos('@',s);

 If b > 0
   then Begin { Kyttj antoi noden }
        TInfo.ToCall := Copy(s,1,b-1);
        ToPc := Copy(s,b+1,Length(s)-b+1);
        TInfo.ToPC := GetNode(ToPc);
        If (TInfo.ToPC = nil) { Lytyyk nodea }
          then Begin
               Send(p,'Node ' + ToPc + ' not found.' + Cr);
               Exit;
               End;
        End
   else Begin
        TInfo.ToCall := s;
        u := GuessNUser(TInfo.ToCall);
        If not assigned(u) { Lytyyk kyttj }
          then If GetNode(TInfo.ToCall) = nil { Ei lytynyt, ents node }
                 then Begin
                      Send(p,'User/node ' + TInfo.ToCall + ' not found or abbreviation not unique.' + Cr);
                      Exit;
                      End
                 else TInfo.ToPc := GetNode(TInfo.ToCall)
          else TInfo.ToPc := u^.Pc;
        End;

 If (LowCaseCh[IBuffer[2]] = 't') { Timestamped? }
   then TimeS := True
   else TimeS := False;

 If MsgPos = 0
   then Begin { Talk mode }
        Str := TInfo.ToCall + '@' + TInfo.ToPc^.Call;
        M2 := 1;
        If TimeS
          then M3 := 1
          else M3 := 0;
        MTimer := 0;
        Send(p,'Entering talk mode. All further input is sent to ' + str + '.' + Cr
             + 'Type /ex or <CTRL-Z> in the beginning of a line to exit.' + Cr);
        Prompted := False;
        End
   else Begin
        TInfo.Msg := Copy(IBuffer,MsgPos,Length(IBuffer)-MsgPos);
        While Pos('^',TInfo.Msg) > 0 do TInfo.Msg[Pos('^',TInfo.Msg)] := '"';
        If TimeS
          then TInfo.Msg := '<' + TimeStrS(now) + 'Z> ' + TInfo.Msg;
        TInfo.FromCall := LUser[p]^.f^.Call;
        TInfo.Time := Now;
        TInfo.FromPc := CluCall;
        TInfo.FromLink := nil;
        Talk(TInfo);
        End;
 End; { With .... }
End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Time_Cmd(p:sType);
Begin

 Send(p,DateTimeStr + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Timestamp_Cmd(p:sType);
Var
  s : String[4];
  b : Byte;
Begin

 With LUser[p]^.f^
   do Begin { TIMEStamp }
      b := Str2Bool(Parse(1));
      If (b = 1) then Include(Flags,f_Timestamp);
      If (b = 0) then Exclude(Flags,f_Timestamp);
      If not (f_Timestamp in Flags)
        then s := 'not '
        else s := '';
      Send(p,'Messages are ' + s + 'timestamped.' + Cr);
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Timereset_Cmd(p:sType);
Var
  s : String[8];
  b : Byte;
Begin

 With LUser[p]^.f^
   do Begin { TIMEReset }
      b := Str2Bool(Parse(1));
      If (b = 1) then Include(Flags,f_Timer);
      If (b = 0) then Exclude(Flags,f_Timer);
      If (f_Timer in Flags)
        then s := 'enabled'
        else s := 'disabled';
      Send(p,'Inactivity timer reset is ' + s + '.' + Cr);
      End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Uptime_Cmd(p:sType);
Begin

 Action(p,'Uptime');
 Send(p,'Uptime: ' + Secs2Str(UpTime) + ' - since ' + DateStrS(StartUpTime) + ' '
      + TimeStrL(StartUpTime) + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Users_Cmd(p:Byte);
Var
  s   : String;
  b,l : Byte;
  i : LUserFP;
  u : NUserRecP;
  f : NUserFP;
  n : NodeRecP;
Begin

 s := UpCaseStr(Parse(1));

 If s = ''
   then Begin
        Action(p,'User list');
        Send(p,'Cluster users: ' + Int2Str(NUserCount) + ', ');
        If not (NUserCount = KUserCount)
          then Send(p,Int2Str(KUserCount) + ' known, ');
        Send(p,Int2Str(LUserCount) + ' local. ' + Int2Str(NodeCount) + ' nodes.' + Cr);
        Userlist_Cmd(p);
        End
   else Begin
        Action(p,'User ' + s + ' query');
        n := GetNode(s);
        If Assigned(n)
          then UserlistH_Cmd(p,n)
          else Begin
               u := GuessNUser(s);
               i := ReadUser(s);
               f := ReadNUser(s);
               If Assigned(u) or Assigned(i) or Assigned(f)
                 then Begin
                      Send(p,'User ' + s + ':');
                      { Nimi }
                      If Assigned(f) and (f^.Name <> '')
                        then Send(p,' ' + f^.Name);
                      Send(p,Cr);
                      If Assigned(u)
                        then Begin

                             If u^.Pc = Localnode
                               then b := GetLUser(s)
                               else b := 255;

                             s := ' Presently connected at ' + u^.Pc^.Call + ', since '
                                  + DateStrS(u^.Time) + ' ' + TimeStrS(u^.Time) + 'Z';

                             If b <= UsrPorts
                               then Begin
                                    s := s + ', ';
                                    l := GetSockPort(b);
                                    Case l of
                                      0   : s := s + 'through NET/ROM.';
                                      255 : s := s + 'on the console.';
                                    else s := s + 'on BPQ port ' + Int2Str(l) + '.';
                                    End;
                                    s := s + ' Has been inactive for ' + Mins2Str(Sock[b]^.Usr_Inactive) + '.';
                                    End
                               else s := s + '.';

                             If not u^.Here
                               then Begin
                                    s := s + ' Away since ' + DateStrS(u^.AwayTime)
                                         + ' ' + TimeStrS(u^.AwayTime) + 'Z';
                                    If assigned(u^.AwayStrP)
                                      then s := s + ': "' + u^.AwayStrP^ + '".'
                                      else s := s + '.';
                                    End;
                             End
                        else s := '';

                      { netusers.clu }
                      If Assigned(f)
                        then Begin
                             If (not assigned(u)) and (f^.PCQuality > 0)
                               then s := s + ' Last seen @' + f^.PC + ' ' + DateStrS(f^.Time) + ' '
                                         + TimeStrS(f^.Time) + 'Z.';
                             If f^.QTH <> ''
                               then s := s + ' QTH is "' + f^.QTH + '".';
                             Dispose(f);
                             End;

                      { Kyttjtiedosto }
                      If Assigned(i)
                        then Begin
                             s := s + ' Has logged on this node for ' + Int2Str(i^.Logins) + ' times.' + Cr;
                             Dispose(i);
                             End;
                      Send(p,Format(True,'',s));
                      End
                 else Send(p,'User or node ' + s + ' not found.' + Cr);
               End;
        End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure Where_Cmd(p:sType);
Var
 c, d : CoordRec;
 az   : Real;
Begin

 If Loc2Coord(UpCaseStr(Parse(1)), c)
  then Begin

       If not Loc2Coord(UpCaseStr(Parse(2)), d)
         then If LocSet(p)
                then Begin
                     d := c;
                     c := LUser[p]^.f^.Loc;
                     End
                else Exit;

       Send(p,'Distance ' + Int2Str(DistAz(c,d,az)) + ' km, heading ' + Real2Str(az) + '' + Cr);
       End
  else Send(p,'Could not parse the locator.' + Cr);

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

Procedure WWV_Cmd(p:Byte);
Var
  WWVInfo  : WWVRec;
  b        : Byte;
  s        : String;
  i        : Integer;
Begin

 With WWVInfo do
  Begin
  Time := Now;
  Hour := (dt.Hour div 3) * 3; { WWV is updated every 3 hours... }

  If CheckLastWWV(Hour, dt.Day)
   then Begin
  { We've got our limits... }
        Val(Parse(1),SFI,i);
        If (i = 0) and (SFI >= 60) and (SFI <= 410)
         then Begin
              Val(Parse(2),A,i);
              If (i = 0) and (A >= 1) and (A <= 400)
               then Begin
                    Val(Parse(3),K,i);
                    If (i = 0) and (K <= 9)
                     then Begin
                          b         := FindParamStart(4);
                          If b > 0
                           then Forecast := Copy(IBuffer,b,Length(IBuffer) - b)
                           else Forecast := '';
                          FromCall  := LUser[p]^.f^.Call;
                          FromPC    := CluCall;
                          FromLink := nil;
                          Protocol.WWV(WWVInfo);
                          End
                     else Send(p,'The K value must be between 0 and 9.' + Cr)
                    End
               else Send(p,'The A value must be between 1 and 400.' + Cr)
              End
         else Send(p,'The SFI value must be between 60 and 410.' + Cr)
        End
   else Send(p,'We already have up-to-date WWV data. The WWV report is updated every 3 hours, ' + Cr
             + 'and updates for the Cluster are not accepted, when the DX cluster already' + Cr
             + 'has data for the current 3-hour period.' + Cr);
  End;

End;

 { ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== ===== }

End.