{$F-} {$I-} {$V-} {$B-} {$X+}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Files;

  { Implements most of the clusse binary data file handling, some config
    file reading/parsing, file system functions, a couple of user commands
    to get filesystem status and data from some files (like the DX spot
    list/search facility). Whew, actually quite a LOT of code. }

Interface
Uses Protocol, Dos, ConfFile, cMath;
Const
  FBufSize       = 8192;

Type

  FileBufType = Array[1..FBufSize] of Char;

  LUserFP    = ^LUserFRec;
  LUserFRec  = Record { users.clu }
               Call      : CallRec;     { Callsign }
               Personal  : String[40];  { Some personal description }

               Locator   : LocStr;      { Mainhead locator }
               Loc       : CoordRec;    { Coordinates }

               Group     : Byte;        { Privilege group }
               Messages,                { Messages flags }
               Beeps     : TMessages;   { Beeps flags }
               Flags     : TFlags;      { General flags }
               LoginAct  : TLoginItems; { What to do on login }

               CharSet,                 { Character conversion table }
               Prompt    : Byte;        { Prompt type }
               Pagelen   : Byte;        { Page length }
               Language  : Byte;        { Which language }

               Logins,                  { How many connects }
               Time      : LongInt;     { Last logged in/out (packed datetime) }
               End;

  QTHStr     = String[40];

  NUserFP    = ^NUserFRec;
  NUserFRec  = Record { nusers.clu }
               Call      : CallRec;    { Callsign }
               PC        : CallRec;    { Home node }
               Name      : CallRec;    { Name }
               QTH       : QTHStr;     { QTH }
               PCQuality : Byte;       { How did we get the home node info:
                                         0 - No idea (unreliable)
                                         2 - DX/ANN/WWV etc message
                                         5 - User login message
                                         7 - Set manually by user or sysop }
               Time      : LongInt;    { Last changed }
               Index     : LongInt;    { Position in the file - ONLY used
                                         internally by Clusse when reading
                                         and writing the file, to speed up
                                         actions. Not used when the record
                                         is stored on disk. }
               End;

  NodeFP     = ^NodeFRec;
  NodeFRec   = Record { nodes.clu }
               Call    : CallRec;   { Callsign }
               Via     : CallRec;   { Heard via }
               Hops    : Byte;      { How many hops }
               HopsOK  : Boolean;   { Is the hops count valid }
               Ver     : Word;      { Software version }
               Rtt     : LongInt;   { Round-trip time (sec) }
               Time    : LongInt;   { Last changed }
               End;

  KeyWordType = String[10];
  MidType     = String[10];

  NewsQP       = ^NewsQType;
  NewsQType    = Record
                 Time       : LongInt;  { Aika }
                 Start, Len : LongInt;  { Paikka tiedostossa }
                 Next       : NewsQP;   { Seuraava jonossa }
                 End;

Var
  TempPath,                    { Vliaikaistiedostojen... }
  DataPath,                    { *.clu }
  DataBasePath,                { Tietokannat }
  LogPath,                     { clog*.*, error.log }
  TextPath,                    { *.hlp, *.txt }

  SwapFileName : String;

  PgPath,                      { PG-ohjelmien hakemisto }
  UserPath,                    { Kyttjien hakemisto }
  IncomingPath : PathStr;      { Kyttjien upload hakemisto }

  ConfLineNr   : Word;

  BufDone      : Boolean;              { Joko loppui? }
  BufFilePos   : LongInt;
  BufFileSize  : LongInt;
  BufFile      : File;
  FileBuf      : ^FileBufType;         { Tiedostobufferi }
  BufPos,                              { Miss mennn }
  BufEnd       : Word;                 { Mihin asti saa menn }

  ExpiryOK     : Boolean;

  NewsArticles : Word;           { News-artikkeleita }
  LoginTextLen : Word;           { Login-tekstin pituus }
  MidTableMem  : Word;           { Muistia MID-tablelle }

Const
  MIDTableSize   : Byte = 1;    { Montako tuhatta midi silytetn -1 ! }

Procedure FlushCaches;                  { Tyhjent levycachet }
Function WMatch(exp, str:String):Boolean;

 { Yleiset tiedostonksittelyt }
Function FileExists(Const FileName:string):Boolean;  { Onko tiedosto olemassa }
Function DirExists(Dir:PathStr):Boolean;       { Onko hakemisto olemassa }

 { Lokitoiminnot }
Procedure AppendF(Const Logfilename:PathStr;Const St:String); { Append tiedostoon }
Procedure LogError(Const St:String);                    { Virhelokitiedostoon }
Procedure Log(LogType:LogItems;Const St:String);        { Lokitiedostoon }

 { Tiedoston lukeminen 1 Kb bufferilla }
Procedure FBufInit(RecLen:Word);        { Bufferi valmiiksi }
Procedure FBufClose;                    { Bufferi pois muistista }
Function BReadFile:Char;                { Luetaan merkki tiedostosta bufferilla }
Function BReadLine:String;              { Luetaan rivi }

 { Yleinen tiedostonksittely }
Procedure DelFile(Const FileName:String);

 { Configitiedosto }
Procedure AssignConf(Const Name:String);       { Ottaa conffitiedoston ksittelyyn }
Procedure CloseConf;                     { Sulkee em. tiedoston }
Procedure ReadConfLine;                  { Lukee rivin }
Procedure NeedConfLine;                  { Lukee rivin }
Function GetConfLine:String;             { Lukee rivin }
Function NextConfBlock:Boolean;          { Etsii seuraavan blokin }

 { Status-tiedosto }
Procedure WriteStatus;                   { Pivitt statustiedoston }

 { Kyttjtiedosto users.clu }
Function ReadUser(Const Call:CallRec):LUserFP; { Lukee kyttjn tiedot }
Procedure WriteUser(Info:LUserFP);       { Kirjoittaa }
Procedure DelUser(Const Call:CallRec);         { Poistaa }
Procedure UList_Cmd(p:Byte);          { Kutsulista }

 { netusers.clu }
Function ReadNUser(Const Call:CallRec):NUserFP; { Lukee }
Procedure WriteNUser(Info:NUserFP);       { Kirjoittaa }
Procedure UNetwork_Cmd(p:Byte);              { Kutsulista }

 { nodes.clu }
Procedure WriteNode(Info:NodeFP);         { Kirjoittaa }
Function ReadNode(Const Call:CallRec):NodeFP;   { Lukee }
Procedure nList_Cmd(p:Byte);   { Lukee nodelistan }

 { Tiedoston lhetys streamiin }
Function SendFile(p:Byte;Const Filename:String):Boolean;
Procedure SendFileHead(p:Byte;Const Filename:String;Lines:Word); { Vain n ensimmist rivi }
Procedure SendFileTail(p:Byte;Const Filename:String;Lines:Word); { Vain n viimeist rivi }

 { Historiatiedosto last.clu }
Procedure WriteLast(Const Call:CallRec;Const Event:String);
Procedure ReadLastLast(p:Byte;Num:Word);

 { Aputiedosto clusse.hlp }
Procedure IndexHelpFile;                { Tekee aputiedostosta indeksin }
Procedure Help(p:Byte;Const Keyword:String);  { Lukee aputiedostoa }

 { Merkkikartat }
Procedure MakeCharTableFile;            { Tekee clusse.chr suoran taulun }

 { DX tiedosto dx.clu }
Procedure WriteDx(Info:DXInfoP);                 { Kirjoittaa tiedoston loppuun }

Procedure List_Cmd(p:Byte);
Procedure ReadDxLast(p:Byte;amount:Word);

Procedure SendDXMerge(p:Byte;ToPC:CallRec;Amount:Byte);

 { DX import dx.in }
Procedure ImportDx;                           { Lukee dx.in tiedoston }

 { Announce tiedosto announce.clu }
Procedure WriteAnn(Info:AnnP);                { Kirjoittaa tiedoston loppuun }
Procedure ReadAnnLast(p:Byte;Num:Byte);       { Lukee n viimeist }
Procedure LAString_Cmd(p:Byte);               { Etsii stringi viestist }
Procedure LAFrom_Cmd(p:Byte);                 { Etsii lhettjn mukaan }

 { WWV tiedosto wwv.clu }
Procedure WriteWWV(Info:WWVP);                 { Kirjoittaa tiedoston loppuun }
Procedure ReadWWVLast(p:Byte;Num:Byte);        { Lukee n viimeist }
Function  CheckLastWWV(Hour,Day:Byte):Boolean; { Tarkistaa, onko ko. infoa viel }

 { News }
Procedure ReadNewsAfter(p:Byte;moment:LongInt); { Lukee uutiset ajan mukaan }
Procedure ReadNewsLast(p:Byte;Num:Word);        { Lukee viimeisimmt n uutista }

 { Mid taulu }
Procedure NewMid(m:MidType);          { Lis mid:n tauluun }
Function MidCheck(m:MidType):Boolean; { Tarkistaa onko taulussa, true = ei ole }

 { Fortune }
Procedure Fortune(p:Byte);              { Heitt vitsin }

 { login.txt }
Procedure LoginText(p:Byte);            { Login teksti }

 { Init/Close }
Procedure InitPaths;                    { Hakemistot kuntoon }
Procedure InitFiles;                    { Tiedostot kuntoon }

 { Muut }
Procedure StartExpiry;                  { Vanhat jutut pois tiedostoista }
Procedure MinTimer;                     { Ajasta riippuvaiset 1min }

 { Komennot }
Procedure FileStatus_Cmd(p:Byte);       { Statistiikkaa }

 (* ================================================================ *)
 (* ================================================================ *)

Implementation

Uses CStrings, BPQ, Screen, Config, Database, xmsLib, Filters;

Const

  { Listaheaderit }
  DxListHeader   = '   Freq   Call         Time Date  From   Info' + Cr;
  AnnListHeader  = 'From   Time Date  Distr     Message' + Cr;
  LastListHeader = '';

Type
  HelpIndexRec = Record { helpindx.clu }
                 KeyWord : KeyWordType; { The help keyword }
                 Position : LongInt;    { Where is the actual help text }
                 End;

  LastFP       = ^LastFileRec;
  LastFileRec  = Record { last.clu }
                 Time      : LongInt;   { When }
                 Call      : CallRec;   { Who }
                 Event     : String[40] { What }
                 End;

  MidTableType  = Array[0..999] of MidType; { Midtaulukon pala }
  MidTableTypeP = ^MidTableType;            { Pointteri edelliseen }

  DxTableType   = Array[1..100] of DxInfoRec;
  DxTableP      = ^DxTableType;

  StatusRec    = Record { status.clu }
                 Time      : LongInt;   { Last updated }

                 { Position pointer for the MID file mid.clu: }
                 { the actual position is MidPosT * 1000 + MidPos }
                 MidPosT   : Byte;
                 MidPos    : Word;

                 { Screen windows alignment }
                 EdWinLine : Byte;
                 End;

  ExpiryResultEntry = Record
                      Orig,            { Alkuperinen koko }
                      Dest : LongInt;  { Lopullinen koko }
                      Size : Word;     { Yhden recordin koko }
                      End;

  TimeBounds   = Record
                 hi, lo : LongInt;
                 End;

  DxSearchRec  = Record
                 Call      : DxCallStr;
                 CallT     : Byte;
                 From      : CallRec;
                 FromPc    : CallRec;
                 Time      : TimeBounds;
                 Band      : Byte;
                 InfoStr   : String[80];
                 Last      : Word;
                 Full      : Boolean;
                 End;

Const

  DefDxSearchRec : DxSearchRec = (Call : '*'; CallT : 0; From : '*';
                                  FromPc : '*'; Time : (hi : 2147483647;
                                  lo : 0); Band : 0; InfoStr : ''; Last : 10;
                                  Full    : False);

Var

  cf           : Text;

  NewsQ        : NewsQP;

  Status       : StatusRec;            { Status }

  UserFile     : File of LUserFRec;    { users.clu }
  NUserFile    : File of NUserFRec;    { netusers.clu }
  NodeFile     : File of NodeFRec;     { nodes.clu }
  DxFile       : File of DxInfoRec;    { dx.clu }
  AnnFile      : File of AnnRec;       { announce.clu }
  WWVFile      : File of WWVRec;       { wwv.clu }
  LastFile     : File of LastFileRec;  { last.clu }
  StatusFile   : File of StatusRec;    { status.clu }
  HelpIndex    : File of HelpIndexRec; { helpindx.clu }
  Fortunes     : Boolean;              { Onko tuuria }
  FortuneIndex : File of LongInt;      { frtnindx.clu }

  LoginTextP   : Pointer;

  LastExpiryDay: Byte;                 { Min pivn viimeksi, triggeriin }
  ExpiryPhase  : Byte;                 { Miss vaiheessa menossa }
  ExpiryDelay  : Byte;                 { Laskuri 5 min viiveelle }
  Expired      : Boolean;
  ExpiryResult : Record { Tulokset }
                 Dx,
                 Ann,
                 WWV,
                 Last,
                 LUser,
                 NUser,
                 Node   : ExpiryResultEntry;
                 End;

  { Message ID:t }
  Mid        : Array[0..9] of MidTableTypeP;  { Message ID taulu }
  MidFile    : File of MidType;               { Tiedosto silytyst varten }
  MidHandle  : Word;                          { XMS-handle }

 { ***************************************************************** }
 { Tyhjent tunnetut levycachet (ja vhn muitakin) }

Procedure FlushCaches;
Var regs : Registers;
Begin

 { QuickCache }

  regs.ah := $21;
  Intr($13,regs);

 { Super PC-Kwik v3.20+
   PC Tools PC-Cache v5.x
   Qualitas Qcache v4.00 }

  regs.ah := $a1;
  regs.si := $4358;
  Intr($13,regs);

 { SmartDRV v4.00+
   PC Tools PC-Cache v8.0 }

  regs.ax := $4a10;
  regs.bx := $0001;
  Intr($2f,regs);

 { PC-Cache v6+ }

  regs.ax := $ffa5;
  regs.cx := $ffff;
  Intr($16,regs);

 { Jokin yllolevista nappaa mys NCACHE:n. }

End;

 { ***************************************************************** }
 { Tiedostojen haut                                                  }
 { ***************************************************************** }

Function FileExists(Const FileName:String):Boolean;
Var
  SRec : SearchRec;
begin
  FindFirst(FileName, AnyFile, SRec);
  FileExists := (DosError = 0);
end; { FileExists }

 { ***************************************************************** }

Function DirExists(Dir:PathStr):Boolean;
Var
   f: File;
   wAttr: Word;
Begin
 While Dir[Length(Dir)] = '\' do Dec(Dir[0]);
 Dir := Dir + '\.';
 Assign(f, Dir);
 GetFAttr(f, wAttr);
 DirExists := ((wAttr And Directory) = Directory);
End;

 { ***************************************************************** }

Procedure AppendF(Const Logfilename:PathStr;Const St:String);
Var Logfile     : Text;
Begin

 Assign(Logfile,Logfilename);
 Append(Logfile);
 If IOresult <> 0 then Rewrite(logfile);
 Write(Logfile,St);
 Close(Logfile);
 IOCheck('writing ' + LogFilename);

End;

 { ***************************************************************** }
 { Lokitiedostot                                                     }
 { ***************************************************************** }

Procedure LogError(Const St:String);          { Virhelokitiedostoon }
Var Logfilename : String;
    Logfile     : Text;
    i           : Integer;
Begin

 LogFilename := LogPath + 'error.log';
 Assign(Logfile,Logfilename);
 Append(Logfile);
 If IOresult <> 0 then Rewrite(logfile);
 WriteLn(logfile,DateStr(Now) + ' ' + TimeStrL(Now) + ' ' + St);
 Close(Logfile);
 i := IOResult;

End;

 { ***************************************************************** }

Procedure Log(LogType:LogItems;Const St:String);        { Lokitiedostoon }
Var Logfilename : String;
Begin

 If LogType in Conf^.Adm.LogMask
  then Begin
       LogFilename := LogPath + 'clog' + Int2Str(Dt.Year) + '.' + Int2Str(Dt.Month);
       AppendF(Logfilename,DateStr(Now) + ' ' + TimeStrL(Now) + ' ' + St + CrLf);
       End;

End;

 { ***************************************************************** }
 { Tiedoston luku bufferilla                                         }
 { ***************************************************************** }

Procedure FBufInit(RecLen:Word);
Begin

 New(FileBuf); { Tiedostobufferi kyttn }
 BufEnd := FBufSize;
 BufPos := FBufSize + 1;
 BufFilePos := 0;
 BufDone := False;
 Reset(BufFile,RecLen);
 BufFileSize := FileSize(BufFile);
 IOCheck('opening block file');

End;

Procedure FBufClose;
Begin

 Dispose(FileBuf);
 Close(BufFile);
 IOCheck('closing block file');

End;

 { ***************************************************************** }

Function BReadFile:Char;
var
 Ch : Char;
Begin
If not BufDone then
Begin

 If (BufPos > BufEnd)
   then Begin { Luetaan bufferiin }
        BlockRead(BufFile,FileBuf^,FBufSize,BufEnd);
        IOCheck('reading block file');
        BufPos := 1;
        End;

 Ch := FileBuf^[BufPos];
 Inc(BufPos);
 Inc(BufFilePos);

 If (BufEnd < FBufSize) and (BufPos > BufEnd)
    then BufDone := True;

 BReadFile := Ch;

End;
End;

 { ***************************************************************** }

Function BReadLine:String;
Var
  Ch : Char;
  s  : String;
Begin

 s := '';

 Ch := BReadFile;
 While not ((Ch = Cr) or BufDone)
  do Begin
     s := s + Ch;
     Ch := BReadFile;
     End;
 Ch := BReadFile; { LF hiiteen }
 BReadLine := s;

End;

 { ***************************************************************** }
 { Kopiointi, poisto, siirto                                         }
 { ***************************************************************** }

Procedure DelFile(Const FileName:String);
Var f : File;
Begin

 Assign(f,FileName);
 Erase(f);
 IOCheck('deleting ' + FileName);

End;

 { ***************************************************************** }

Procedure CopyFile(SourceName,DestName:String);
Var
 DestF : File;
Begin

 Assign(BufFile,SourceName);
 FBufInit(1);

 IOCheck('opening ' + SourceName);
 Assign(DestF,DestName);
 Rewrite(DestF,1);
 IOCheck('opening ' + DestName);

 Repeat
   BlockRead(BufFile, FileBuf^, FBufSize, BufEnd);
   IOCheck('reading ' + SourceName);
   BlockWrite(DestF, FileBuf^, BufEnd, BufPos);
   IOCheck('writing ' + DestName);
 until (BufEnd = 0) or (BufEnd <> BufPos);

 Close(DestF);
 IOCheck('closing ' + DestName);

 FBufClose;

End;

 { ***************************************************************** }

Procedure MoveFile(SourceName,DestName:String);
Begin

 CopyFile(SourceName,DestName);
 DelFile(SourceName);

End;

 { ***************************************************************** }

Procedure SpotWriteFile(Victim:String;Pos:LongInt;Len:Word;Data:Pointer);
Var
  f, tf : File;
  buf   : ^FileBufType;
  Got   : Integer;
  App   : Boolean;
Begin

 Assign(f,Victim);
 Reset(f,1);
 App := (Pos >= FileSize(f));

 If not App
  then Begin
       Seek(f,Pos);
       IOCheck('opening ' + Victim);

       Assign(tf,TempPath + 'clusse.tmp');
       Rewrite(tf,1);
       IOCheck('opening clusse.tmp');

       New(Buf);

       Repeat
         BlockRead(f, buf^, FBufSize, Got);
         IOCheck('reading ' + Victim);
         BlockWrite(tf, buf^, Got);
         IOCheck('writing clusse.tmp');
       until (Got <> FBufSize) or eof(f);

       Seek(f,Pos);

       Truncate(f);
       End
  else Seek(f,FileSize(f));

 BlockWrite(f,Data^,Len);
 IOCheck('writing ' + Victim);

 If not App
  then Begin
       Seek(tf,0);

       Repeat
         BlockRead(tf, buf^, FBufSize, Got);
         IOCheck('reading clusse.tmp');
         BlockWrite(f, buf^, Got);
         IOCheck('writing ' + Victim);
       until (Got <> FBufSize) or eof(tf);

       Dispose(buf);

       Close(tf);
       DelFile(TempPath + 'clusse.tmp');
       End;

 Close(f);

End;

 { ***************************************************************** }
 { Yleisen configitiedoston luku                                     }
 { ***************************************************************** }

Procedure AssignConf(Const Name:String);       { Ottaa conffitiedoston ksittelyyn }
Begin

 Assign(cf,Name);
 New(FileBuf);
 SetTextBuf(cf,FileBuf^);
 Reset(cf);
 If IOResult <> 0
   then Begin
        WriteLn(' ' + Name + ' not found!' + CrLf);
        Halt(1);
        End;
 ConfLineNr := 0;
 IBuffer := '';

End;

 { ***************************************************************** }

Procedure CloseConf;                     { Sulkee em. tiedoston }
Begin

 Close(cf);
 Dispose(FileBuf);

End;

 { ***************************************************************** }

Procedure ReadConfLine;            { Lukee rivin }
Begin

  Repeat
    ReadLn(cf,IBuffer);
    IOCheck('reading config file');
    Inc(ConfLineNr);
  Until (IBuffer[1] <> '#') or (Length(IBuffer) = 0) or eof(cf);
  If IBuffer[1] = '#'
    then IBuffer := '';
  IBuffer := CleanStr(IBuffer);

End;

 { ***************************************************************** }

Procedure NeedConfLine;            { Lukee rivin }
Begin

  If eof(cf)
   then Begin
        WriteLn(CrLf + 'Houston, we have a problem: Unexpected end of file!');
        Halt(1);
        End;

  ReadConfLine;

End;

 { ***************************************************************** }

Function GetConfLine:String;
Begin

 NeedConfLine;
 GetConfLine := IBuffer;

End;

 { ***************************************************************** }

Function NextConfBlock:Boolean;          { Etsii seuraavan blokin }
Begin

 NextConfBlock := True;
 While not (eof(cf) or (Copy(IBuffer,1,3) = '---'))
   do ReadConfLine;

 If eof(cf) then NextConfBlock := False;

End;

 { ***************************************************************** }
 { Yksittiset clussen datatiedostot                                 }
 { ***************************************************************** }

Procedure WriteStatus;
Begin

 Status.Time := now;
 Status.EdWinLine := EdWinLine;
 Rewrite(StatusFile);
 Write(StatusFile,Status);
 Close(StatusFile);
 IOCheck('writing status.clu');

End;

 { ***************************************************************** }
 { Paikallisten kyttjien tiedosto users.clu                        }
 { ***************************************************************** }

Function ReadUser(Const Call:CallRec):LUserFP;
Var
  i        : LUserFRec;
  c        : CallRec;
  LUserTmp : LUserFP;     { ReadUser palaute }
Begin

 c := StripSSID(Call);
 i.Call := '';
 Reset(UserFile);
 IOCheck('opening users.clu');

 While (not eof(UserFile)) and (c <> StripSSID(i.Call))
  do Begin
     Read(UserFile,i);
     IOCheck('reading users.clu');
     End;

 If StripSSID(i.Call) = c  then Begin
                                New(LUserTmp);
                                LuserTmp^ := i;
                                ReadUser := LUserTmp;
                                End
                           else ReadUser := nil;
 Close(UserFile);
 IOCheck('closing users.clu');

End;

 { ***************************************************************** }

Procedure WriteUser(Info:LUserFP);
Var
  i : LUserFRec;
  c : CallRec;
Begin

 c := StripSSID(Info^.Call);
 i.Call := '';
 Reset(UserFile);
 IOCheck('opening users.clu');

 While (not eof(UserFile)) and (c <> StripSSID(i.Call))
  do Begin
     Read(UserFile,i);
     IOCheck('reading users.clu');
     End;

 If (c = StripSSID(i.Call))
   then Seek(UserFile,FilePos(Userfile)-1)
   else Seek(UserFile,FileSize(UserFile));

 Write(UserFile,Info^);
 IOCheck('writing users.clu');
 Close(UserFile);
 IOCheck('closing users.clu');

End;

 { ***************************************************************** }

Procedure DelUser(Const Call:CallRec);         { Poistaa }
Var
  i   : LUserFRec;
  Pos : Word;
  f   : File of LUserFRec;
Begin

 i.Call := '';
 Reset(UserFile);
 IOCheck('opening users.clu');

 While (not eof(UserFile)) and (Call <> StripSSID(i.Call))
  do Begin
     Read(UserFile,i);
     IOCheck('reading users.clu');
     End;

 If StripSSID(i.Call) = Call
   then Begin
        Pos := FilePos(UserFile) - 1;
        Assign(f,TempPath + 'users.tmp');
        Rewrite(f);
        While not eof(UserFile)
         do Begin
            Read(UserFile,i);
            Write(f,i);
            End;
        Seek(UserFile,Pos);
        Truncate(UserFile);
        Reset(f);
        While not eof(f)
         do Begin
            Read(f,i);
            Write(UserFile,i);
            End;
        Close(f);
        DelFile(TempPath + 'users.tmp');
        End;

 Close(UserFile);
 IOCheck('closing users.clu');

End;

 { ***************************************************************** }

Procedure UList_Cmd(p:Byte);          { Kutsulista }
Var
  s    : String[80];
  f    : File;
  Buf  : Array[1..48] of LUserFRec;
  b    : Byte;
  Got  : Integer;
  k    : CallRec;
  m    : LongInt;
Begin

 Action(p,'Local user file list');

 s := '';
 m := 0;
 k := UpCaseStr(Parse(1));
 Assign(f,DataPath + 'users.clu');
 Reset(f,SizeOf(LUserFRec));
 IOCheck('opening users.clu');

 Send(p,'Local user file list: '+ Int2Str(FileSize(f)) + ' users' + Cr);

 Got := 48;
 While (not eof(f)) and (Got = 48)
  do Begin
     BlockRead(f,Buf,48,Got);
     IOCheck('reading users.clu');
     For b := 1 to Got
      do Begin
         If Length(s) > 71 then Begin
                                Send(p,s + Cr);
                                s := '';
                                End;
         If (Length(k) = 0) or WMatch(k,Buf[b].Call)
           then Begin
                s := s + PadLeft(7,StripSSID(Buf[b].Call));
                Inc(m);
                End;
         End;
    End;

 If Length(s) > 0 then Send(p,s + Cr);
 If Length(k) <> 0
   then Send(p,Int2Str(m) + ' matches for the key ' + k + '.' + Cr);

 Close(f);
 IOCheck('closing users.clu');

End;

 { ***************************************************************** }
 { Network users file netusers.clu                                   }
 { ***************************************************************** }

Function ReadNUser(Const Call:CallRec):NUserFP;
Var
  f        : File;
  Buf      : Array[1..48] of NUserFRec;
  b        : Byte;
  Hit      : Byte;
  Got      : Integer;
  c        : CallRec;
  NUserTmp : NUserFP;     { ReadNUser palaute }
  Pos      : LongInt;
Begin

 c := StripSSID(Call);
 Assign(f,DataPath + 'netusers.clu');
 Reset(f,SizeOf(NUserFRec));
 IOCheck('opening netusers.clu');

 Pos := 0;
 Got := 48;
 Hit := 0;
 While (not eof(f)) and (Got = 48) and (Hit = 0)
  do Begin
     BlockRead(f,Buf,48,Got);
     IOCheck('reading netusers.clu');
     For b := 1 to Got
      do Begin
         If c = Buf[b].Call
           then Hit := b;
         If Hit = 0
          then Inc(Pos);
         End;
    End;

 If not (Hit = 0)
   then Begin
        New(NUserTmp);
        NuserTmp^ := Buf[Hit];
        NUserTmp^.Index := Pos;
        ReadNUser := NUserTmp;
        End
   else ReadNUser := nil;

 Close(f);
 IOCheck('closing netusers.clu');

End;

 { ***************************************************************** }

Procedure WriteNUser(Info:NUserFP);
Var
  i    : NUserFRec;
  Pos  : LongInt;
  Over,
  Done : Boolean;
Begin

 Info^.Time := now;
 Info^.Call := StripSSID(Info^.Call);
 i.Call := '';
 Over := True;

 If Info^.Index = 0
   then Begin
        Reset(NUserFile);
        IOCheck('opening netusers.clu');

        i.Call := '';
        Pos := 0;
        Done := False;
        Over := False;

        Repeat
          If not eof(NUserFile)
            then Begin
                 Read(NUserFile,i);
                 If Info^.Call = i.Call
                  then Begin
                       Done := True;
                       Over := True;
                       End
                  else If StrOrd(Info^.Call,i.Call)
                         then Done := True
                         else Inc(Pos);
                 End
            else Done := True;
        until Done;

        Close(NUserFile);
        IOCheck('writing netusers.clu');
        Info^.Index := Pos;

        If not Over
          then SpotWriteFile(DataPath + 'netusers.clu',Info^.Index * SizeOf(NUserFRec),SizeOf(NUserFRec),Info);
        End;

 If Over
   then Begin
        Reset(NUserFile);
        Seek(NUserFile,Info^.Index);
        Write(NUserFile,Info^);
        Close(NUserFile);
        IOCheck('writing netusers.clu');
        End;

End;

 { ***************************************************************** }

Procedure UNetwork_Cmd(p:Byte);          { Kutsulista }
Var
  s    : String[80];
  f    : File;
  Buf  : Array[1..48] of NUserFRec;
  b    : Byte;
  Got  : Integer;
  m    : LongInt;
  k    : CallRec;
Begin

 Action(p,'Network user file list');
 s := '';
 m := 0;
 k := UpCaseStr(Parse(1));
 Assign(f,DataPath + 'netusers.clu');
 Reset(f,SizeOf(NUserFRec));
 IOCheck('opening netusers.clu');

 Send(p,'Network user file list: '+ Int2Str(FileSize(f)) + ' users' + Cr);

 Got := 48;
 While (not eof(f)) and (Got = 48)
  do Begin
     BlockRead(f,Buf,48,Got);
     IOCheck('reading netusers.clu');
     For b := 1 to Got
      do Begin
         If Length(s) > 71 then Begin
                                Send(p,s + Cr);
                                s := '';
                                End;
         If (Length(k) = 0) or WMatch(k,Buf[b].Call)
           then Begin
                s := s + PadLeft(7,StripSSID(Buf[b].Call));
                Inc(m);
                End;
         End;
    End;

 If Length(s) > 0 then Send(p,s + Cr);
 If Length(k) <> 0
   then Send(p,Int2Str(m) + ' matches for the key ' + k + '.' + Cr);

 Close(f);
 IOCheck('closing netusers.clu');

End;

 { ***************************************************************** }
 { Nodetiedosto nodes.clu                                            }
 { ***************************************************************** }

Procedure WriteNode(Info:NodeFP);         { Kirjoittaa }
Var
  i    : NodeFRec;
  c    : CallRec;
  Pos  : LongInt;
  Done : Boolean;
Begin

 Info^.Time := now;
 c := Info^.Call;
 i.Call := '';
 Reset(NodeFile);
 IOCheck('opening nodes.clu');

 While (not eof(NodeFile)) and (c <> i.Call)
  do Begin
     Read(NodeFile,i);
     IOCheck('reading nodes.clu');
     End;

 If (c = i.Call)
   then Begin
        Seek(NodeFile,FilePos(NodeFile)-1);
        Write(NodeFile,Info^);
        Close(NodeFile);
        IOCheck('writing nodes.clu');
        End
   else Begin { Aakkosjrjestys! }
        Seek(NodeFile,0);
        i.Call := '';
        Pos := 0;
        Done := False;
        Repeat
         If not eof(NodeFile)
          then Begin
               Read(NodeFile,i);
               If StrOrd(c,i.Call)
                then Done := True
                else Inc(Pos);
               End
          else Done := True;
        until Done;
        Close(NodeFile);
        SpotWriteFile(DataPath + 'nodes.clu',Pos * SizeOf(NodeFRec),SizeOf(NodeFRec),Info);
        End;


End;

 { ***************************************************************** }

Function ReadNode(Const Call:CallRec):NodeFP;   { Lukee }
Var
  i        : NodeFRec;
  c        : CallRec;
  NodeTmp  : NodeFP;     { ReadUser palaute }
Begin

 c := StripSSID(Call);
 i.Call := '';
 Reset(NodeFile);
 IOCheck('opening nodes.clu');

 While (not eof(NodeFile)) and (c <> StripSSID(i.Call))
  do Begin
     Read(NodeFile,i);
     IOCheck('reading nodes.clu');
     End;

 If StripSSID(i.Call) = c  then Begin
                                New(NodeTmp);
                                NodeTmp^ := i;
                                ReadNode := NodeTmp;
                                End
                           else ReadNode := nil;
 Close(NodeFile);
 IOCheck('closing nodes.clu');

End;

 { ***************************************************************** }

Procedure NList_Cmd(p:Byte);          { Kutsulista }
Var
  s    : String[80];
  f    : File;
  Buf  : Array[1..48] of NodeFRec;
  Got  : Integer;
  b    : Byte;
  m    : LongInt;
  k    : CallRec;
  v    : Boolean;
Begin

 Action(p,'Node file list');

 s := ' ';
 m := 0;
 k := UpCaseStr(Parse(1));
 If LowCaseCh[IBuffer[3]] = 'v'
   then v := True
   else v := False;
 Assign(f,DataPath + 'nodes.clu');
 Reset(f,SizeOf(NodeFRec));
 IOCheck('opening nodes.clu');

 Send(p,'Node file list: '+ Int2Str(FileSize(f)) + ' nodes' + Cr);

 Got := 48;
 While (not eof(f)) and (Got = 48)
  do Begin
     BlockRead(f,Buf,48,Got);
     IOCheck('reading nodes.clu');
     For b := 1 to Got
      do Begin
         If Length(s) > 68 then Begin
                                Send(p,s + Cr);
                                s := ' ';
                                End;
         If (Length(k) = 0) or WMatch(k,Buf[b].Call)
           then Begin
                s := s + PadLeft(10,Buf[b].Call);
                If v then s := s + PadLeft(5,Int2Str(Buf[b].Ver));
                Inc(m);
                End;
         End;
    End;

 If Length(s) > 0 then Send(p,s + Cr);
 If Length(k) <> 0
   then Send(p,Int2Str(m) + ' matches for the key ' + k + '.' + Cr);

 Close(f);
 IOCheck('closing nodes.clu');

End;

 { ***************************************************************** }
 { Tiedostojen lhettminen kyttjille                              }
 { ***************************************************************** }

Function SendFile(p:Byte;Const Filename:String):Boolean;
Var s : String;
Begin

 SendFile := True;
 New(FileBuf);

 Assign(cf,Filename);
 SetTextBuf(cf,FileBuf^,fBufSize);
 Reset(cf);
 If IOResult = 0
   then Begin
        While (IOResult = 0) and not eof(cf)
          do Begin
             ReadLn(cf,s);
             Send(p,s + Cr);
             End;
        Close(cf);
        End
   else SendFile := False;

 Dispose(FileBuf);

End;

 { ***************************************************************** }

Procedure SendFileHead(p:Byte;Const Filename:String;Lines:Word);
Var
  Pos : Word;
Begin

 If FileExists(Filename)
  then Begin
       Assign(BufFile,Filename);
       FBufInit(1);
       Pos := 0;
        Repeat
         Send(p,BReadLine + Cr);
         Inc(Pos);
        until (Pos = Lines) or BufDone;

       FBufClose; { Tiedostobufferi pois }
       End;

End;

 { ***************************************************************** }

Procedure SendFileTail(p:Byte;Const Filename:String;Lines:Word);
Var
  f     : File;       { Luettava tiedosto }
  fb    : ^FileBufType;  { Bufferi }
  fbPos : Word;       { Miss kohdin bufferia mennn }
  fbLen : Word;       { Paljonko bufferissa dataa }
  fbGet : Word;       { Paljonko bufferiin luetaan }
  fPos  : LongInt;    { Miss kohdin tiedostoa mennn }
  fSize : LongInt;    { Tiedoston koko }
  Ch    : Char;       { Luettu merkki }
  s     : String;     { Luettu rivi }
  Ln    : Word;       { Montako rivi saatu }
Begin

 If FileExists(Filename)
  then Begin
       s := '';
       Ln := 0;
       Assign(f,Filename);
       Reset(f,1);
       fSize := FileSize(f);
       If fSize > 0
        then Begin
             New(fb);
             fPos := fSize;
             fbPos := 0;
             Inc(Lines);

             If fSize < fBufSize
               then fbGet := fSize
               else fbGet := fBufSize;

              Repeat
                if fbPos = 0
                  then Begin
                       fPos := fPos - fbGet;
                       If fPos < 0 then fPos := 0;
                       Seek(f,fPos);
                       BlockRead(f,fb^,fbGet,fbLen);
                       IOCheck('reading error.log');
                       fbPos := fbLen;
                       End;
                If fb^[fbPos] = Lf
                  then Inc(Ln);
                Dec(fbPos);
              until (Ln = Lines) or ((fbPos = 0) and (fPos = 0));

             Inc(fbPos);
             If Ln = Lines
               then Inc(fbPos);

              Repeat
                s := s + fb^[fbpos];
                If fb^[fbPos] = Cr
                  then Begin
                       Send(p,s);
                       s := '';
                       Inc(fbPos); { LF:n yli! }
                       End;
                If fbPos >= fbLen
                  then Begin
                       fPos := fPos + fbGet;
                       Seek(f,fPos);
                       BlockRead(f,fb^,fbGet,fbLen);
                       IOCheck('reading error.log');
                       fbPos := 0;
                       End;
                Inc(fbPos);
              until (fbPos > fbLen) and (fPos + fbLen >= fSize);

             Dispose(fb);
             End;

        Close(f);
        End;

End;

 { ***************************************************************** }
 { Last.clu                                                          }
 { ***************************************************************** }

Procedure WriteLast(Const Call:CallRec;Const Event:String);
Var Rec : LastFileRec;
Begin

 Rec.Time := now;
 Rec.Call := StripSSID(Call);
 Rec.Event := Event;

 Reset(LastFile);
 Seek(LastFile,FileSize(LastFile));
 Write(LastFile,Rec);
 Close(LastFile);

 IOCheck('writing last.clu');

End;

 { ***************************************************************** }

Function Last2List(Info:LastFileRec):String;
Begin
 Last2List := PadLeft(7,Info.Call) + Info.Event + Cr;
End;

 { ***************************************************************** }

Procedure ReadLastLast(p:Byte;Num:Word);
Var
  i          : LongInt;
  HowMany    : Word;
  Info       : LastFileRec;
Begin

 Reset(LastFile);
 i := FileSize(LastFile);

 If Num > i then HowMany := i
            else HowMany := Num;

 Seek(LastFile,i-HowMany);

 Send(p,LastListHeader);
 For i := 1 to HowMany
  do Begin
     Read(LastFile,Info);
     IOCheck('reading last.clu');
     Send(p,Last2List(Info));
     End;

 Close(LastFile);

End;

 { ***************************************************************** }
 { Aputiedosto                                                       }
 { ***************************************************************** }

Procedure IndexHelpFile; { Tekee aputiedostosta indeksin }
Var
  b        : Byte;    { Silmukkamuuttuja }
  Helping  : Boolean; { Ollaanko menossa helppitekstiss }
  FileTime : LongInt; { Tiedostojen aika }
  KeyWords : Byte;
  KeyWord  : Array[1..11] of KeyWordType;
  Indeksi  : HelpIndexRec;

Begin

 ReWrite(HelpIndex);
 IOCheck('opening helpindx.clu');

 Assign(BufFile,TextPath + 'clusse.hlp');
 FBufInit(1); { Tiedostobufferi kyttn }

 Helping := False;
 KeyWords := 0;

 Repeat
   IBuffer := BReadLine;

   If (IBuffer[1] = '%') and not Helping
      then Begin { Keywordeja }
           IBuffer := IBuffer + Cr;

           Repeat
             Inc(KeyWords);
             KeyWord[KeyWords] := LowCaseStr(Parse(KeyWords));
           until (KeyWords = 11) or (KeyWord[KeyWords] = '');
           Dec(KeyWords);

           End;

   If (IBuffer[1] = '{') and not Helping
      then Begin { Kirjoitetaan indeksit }
           Indeksi.Position := BufFilePos;
           IBuffer := BReadLine;
           For b := 1 to Keywords
             do Begin
                Indeksi.Keyword := Keyword[b];
                Write(HelpIndex,Indeksi);
                End;

           Helping := True;
           KeyWords := 0;
           End;

   If (IBuffer[1] = '}') and Helping
     then Helping := False;

 until BufDone;

 GetFTime(BufFile,FileTime);
 SetFTime(HelpIndex,FileTime);

 FBufClose; { Tiedostobufferi pois }

End; { IndexHelpFile }

 { ***************************************************************** }

Procedure Help(p:Byte;Const Keyword:String);  { Lukee aputiedostoa }
Var
  Indeksi  : HelpIndexRec;
  Key      : String;
  S        : String;
Begin

 Key := LowCaseStr(KeyWord);
 Reset(HelpIndex);
 IOCheck('opening helpindx.clu');

 Repeat
  Read(HelpIndex,Indeksi);
  IOCheck('reading helpindx.clu');
 until (Pos(Key,Indeksi.KeyWord) = 1) or eof(HelpIndex);
 Close(HelpIndex);

 If (Pos(Key,Indeksi.KeyWord) = 1)
   then Begin { Haa! }
        Send(p,'Help: ');
        Assign(BufFile,TextPath + 'clusse.hlp');
        FBufInit(1);
        Seek(BufFile,Indeksi.Position);
        IOCheck('reading clusse.hlp');

        s := BReadLine;
        Repeat
          Send(p,s + Cr);
          s := BReadLine;
        until s = '}';

        FBufClose; { Tiedostobufferi pois }
        End
   else Send(p,'Sorry, no help found for ' + KeyWord + ' !' + Cr);

End; { Help }

 { ***************************************************************** }

Procedure MakeCharTableFile;            { Tekee clusse.chr suoran taulun }
Var
  Table      : CharTable;
  b          : Byte;
  CharTableF : File of CharTable;       { *.chr }
Begin

 Write(' o Creating clusse.chr - flat character conversion table...');

 For b := 0 to 255 do
  Table[Chr(b)] := Chr(b);

 Assign(CharTableF,'clusse.chr');
 Rewrite(CharTableF);

 Write(CharTableF,Table);
 Close(CharTableF);

 IOCheck('writing clusse.chr');

 WriteLn(' Done.');

 Halt(0);

End;

 { ***************************************************************** }
 { DX-lista                                                          }
 { ***************************************************************** }

Procedure WriteDx(Info:DXInfoP);        { Kirjoittaa tiedoston loppuun }
Var p : DxInfoP;
Begin

 Info^.FromCall := StripSSID(Info^.FromCall);
 Reset(DxFile);
 Seek(DxFile,FileSize(DxFile));
 Write(DxFile,Info^);
 Close(DxFile);

 IOCheck('writing dx.clu');

End;

 { ***************************************************************** }

Function Dx2List(Const Info:DxInfoRec):String;
Begin

 Dx2List := Format(True,PadRight(9,Freq2Str(Info.Freq)) + ' ' + PadLeft(13,Info.Call)
            + TimeStrS(Info.Time) + ' ' + PadLeft(6,DateStrSPad(Info.Time))
            + PadLeft(6,Info.FromCall), Info.Info);

End;

 { ***************************************************************** }
 { ***************************************************************** }

{
Function WMatch(Const exp, str:String):Boolean;
Var
   p, n, l  : Byte;
   done     : Boolean;
Begin

    WMatch := True;
    if exp = '*' then Exit;

    WMatch := False;
    Done   := False;
    n := 1;
    p := 1;
    l := Length(str);

    Repeat
       If exp[n] = '*'
         then Begin
              If n = Length(exp)
                then Done := True
                else Begin
                     inc(n);
                     While (p < l) and ((exp[n] <> str[p]) or (exp[n] = str[p+1]))
                       do inc(p);
                     End
              End
         else If (n <= Length(exp)) and ((exp[n] = str[p]) or (exp[n] = '?'))
                 then Begin
                      inc(n);
                      inc(p);
                      End
                 else Exit;
    Until (p > l) or done;

    If Length(exp) > n then Exit;

    WMatch := True;

End;
}

Function WMatch(exp, str:string):Boolean; Assembler;

{

  Compare exp with str, and allow wildcards in exp.

  The following wildcards are allowed:
 *ABC*        matches everything which contains ABC
 [A-C]*       matches everything that starts with either A,B or C
 [ADEF-JW-Z]  matches A,D,E,F,G,H,I,J,W,V,X,Y or Z
 ABC?         matches ABC, ABC1, ABC2, ABCA, ABCB etc.
 ABC[?]       matches ABC1, ABC2, ABCA, ABCB etc. (but not ABC)
 ABC*         matches everything starting with ABC

}

Var
  LastW : Word;
Asm

   cld
   push  ds
   lds   si,exp
   les   di,str
   xor   ah,ah
   lodsb
   mov   cx,ax
   mov   al,es:[di]
   inc   di
   mov   bx,ax
   or    cx,cx
   jnz   @ChkChr
   or    bx,bx
   jz    @ChrAOk
   jmp   @ChrNOk
   xor   dh,dh
@ChkChr:
   lodsb
   cmp   al,'*'
   jne   @ChkQues
   dec   cx
   jz    @ChrAOk
   mov   dh,1
   mov   LastW,cx
   jmp   @ChkChr
@ChkQues:
   cmp   al,'?'
   jnz   @NormChr
   inc   di
   or    bx,bx
   je    @ChrOk
   dec   bx
   jmp   @ChrOk
@NormChr:
   or    bx,bx
   je    @ChrNOk
   { From here to @No4DosChr is used for [0-9]/[?]/[!0-9] 4DOS wildcards... }
   cmp   al,'['
   jne   @No4DosChr
   cmp   word ptr [si],']?'
   je    @SkipRange
   mov   ah,byte ptr es:[di]
   xor   dl,dl
   cmp   byte ptr [si],'!'
   jnz   @ChkRange
   inc   si
   dec   cx
   jz    @ChrNOk
   inc   dx
@ChkRange:
   lodsb
   dec   cx
   jz    @ChrNOk
   cmp   al,']'
   je    @NChrNOk
   cmp   ah,al
   je    @NChrOk
   cmp   byte ptr [si],'-'
   jne   @ChkRange
   inc   si
   dec   cx
   jz    @ChrNOk
   cmp   ah,al
   jae   @ChkR2
   inc   si              {Throw a-Z < away}
   dec   cx
   jz    @ChrNOk
   jmp   @ChkRange
@ChkR2:
   lodsb
   dec  cx
   jz   @ChrNOk
   cmp  ah,al
   ja   @ChkRange        {= jbe @NChrOk; jmp @ChkRange}
@NChrOk:
   or   dl,dl
   jnz  @ChrNOk
   inc  dx
@NChrNOk:
   or   dl,dl
   jz   @ChrNOk
@NNChrOk:
   cmp  al,']'
   je   @NNNChrOk
@SkipRange:
   lodsb
   cmp    al,']'
   loopne @SkipRange
   jne    @ChrNOk
@NNNChrOk:
   dec    bx
   inc    di
   jmp    @ChrOk
@No4DosChr:
   cmp    es:[di],al
   jne    @ChrNOk
   inc    di
   dec    bx
@ChrOk:
   xor    dh,dh
   dec    cx
   jnz    @ChkChr        { Can't use loop, distance >128 bytes }
   or     bx,bx
   jnz    @ChrNOk
@ChrAOk:
   mov    al,1
   jmp    @EndR
@ChrNOk:
   or     dh,dh
   jz     @IChrNOk
   jcxz   @IChrNOk
   or     bx,bx
   jz     @IChrNOk
   inc    di
   dec    bx
   jz     @IChrNOk
   mov    ax,[LastW]
   sub    ax,cx
   add    cx,ax
   sub    si,ax
   dec    si
   jmp    @ChkChr
@IChrNOk:
   mov    al,0
@EndR:
   pop  ds

End;

Procedure ReadDx(p:Byte; sr:DxSearchRec);
Const
  hSize      = 400;
  tSize      = 100;
Type
  TableType  = Array[1..hSize] of DxInfoRec; { Osuttaville }
  dxtType    = Array[1..tSize] of DxInfoRec; { Lpikytville }
Var
  f          : File;
  n          : Word;
  from       : LongInt;
  po,                      { Paikka (etsittvss ryhmss) }
  Loc,                     { Paikka (koko kannassa) }
  Count      : Word;       { Montako lydetty }
  Table      : ^TableType; { Lydetyt }
  dxt        : ^dxtType;   { Etsittvt }
  Info       : DxInfoRec;  { Ksiteltv }
Begin

 If sr.Last > hSize
   then Begin
        Send(p,'Maximum of ' + Int2Str(hSize) + ' spots can be listed at a time.' + Cr);
        sr.Last := hSize;
        End;

 Send(p,DxListHeader);

 Count := 0;
 po := 0;

 Assign(f,DataPath + 'dx.clu');
 Reset(f,SizeOf(DxInfoRec));
 Loc := FileSize(f);
 If Loc = 0
   then Begin
        Close(f);
        Exit;
        End;

 New(dxt);
 New(Table);

 Repeat

   If po = 0
     then Begin
          If Loc < FileSize(f)
            then If Loc > tSize
                   then Begin           { Tiedoston keskelt }
                        from := Loc - tSize; { Mist }
                        n := tSize;          { Paljonko }
                        End
                   else Begin           { Tiedoston alusta }
                        from := 0;
                        n := Loc - 1;
                        End
            else If FileSize(f) > tSize   { Tiedoston lopusta }
                   then Begin           { Tiedostossa enemmn kuin 100 }
                        from := FileSize(f) - tSize;
                        n := tSize;
                        End
                   else Begin           { Koko tiedosto kerralla }
                        from := 0;
                        n := FileSize(f);
                        End;

          Seek(f,from);
          BlockRead(f,dxt^,n,po);
          End;

   Info := dxt^[po];

   If ( ((sr.CallT = 0) and WMatch(sr.Call, Info.Call))
        or ((sr.CallT = 1) and (Pos(Sr.Call,Info.Call) = 1))
        or ((sr.CallT = 2) and (Length(Sr.Call) <= Length(Info.Call))
           and (Pos(Sr.Call,Info.Call) = Length(Info.Call) - Length(sr.Call) + 1))
      )
      and WMatch(sr.From, Info.FromCall)
      and WMatch(sr.FromPc, Info.FromPc)
      and ( (Length(sr.InfoStr) = 0) or (Pos(sr.InfoStr,UpCaseStr(Info.Info)) > 0) )
      and ((sr.Band = 0) or OnABand(Info.Freq,sr.Band))
       then Begin
            Inc(Count);
            Table^[Count] := Info;
            End;

   Dec(po);
   Dec(Loc);

 until (Count = sr.Last) or ((From = 0) and (po = 0));

 Close(f);

 For Loc := Count downto 1
  do Send(p,Dx2List(Table^[Loc]));

 Dispose(Table);
 Dispose(dxt);

End;

Procedure List_Cmd(p:Byte);
Var
 sr   : DxSearchRec;
 b    : Byte;
 cmd,
 par  : String;
 w    : Word;
Begin

 sr := DefDxSearchRec;

 { Parse the command line }
 b := 1;
 Cmd := UpCaseStr(Parse(1));
 Par := UpCaseStr(Parse(2));
 While not (Cmd = '')
  do Begin
     w := Str2Word(Cmd);
     If w = 0
       then Begin
            If (Length(Cmd) > 1) and ((Cmd[1] = '/') or (Cmd[1] = '-'))
              then Delete(Cmd,1,1); { Cut parameter id's }
            Case Cmd[1] of
             'B' : Begin
                   sr.Band :=  GetBand(LowCaseStr(Par));
                   If sr.Band = 0
                     then Begin
                          Send(p,'Unknown band ' + Par + '.' + Cr);
                          Exit;
                          End;
                   Inc(b);
                   End;
             'C' : Begin
                   sr.Call := Par; { Match call }
                   Inc(b);
                   End;
             'P' : Begin
                   sr.CallT := 1;  { Match prefix }
                   sr.Call := Par;
                   Inc(b);
                   End;
             'S' : Begin
                   sr.CallT := 2;  { Match suffix }
                   sr.Call := Par;
                   Inc(b);
                   End;
             'F' : Begin
                   sr.From := Par;
                   Inc(b);
                   End;
             'N' : Begin
                   sr.FromPc := Par;
                   Inc(b);
                   End;
             'I' : Begin
                   sr.InfoStr := Par;
                   Inc(b);
                   End;
             'L' : Begin
                   sr.Last := Str2Word(Par);
                   Inc(b);
                   End;
{             'O' : sr.Full := True;}

            else Begin
                 Send(p,'Parameter ' + Cmd + ' not understood.' + Cr);
                 Exit;
                 End;
            End;
            End
       else sr.Last := w;
     Inc(b);
     Cmd := UpCaseStr(Parse(b));
     Par := UpCaseStr(Parse(b+1));
     End;

  ReadDx(p,sr);

End;

 { ***************************************************************** }

Procedure ReadDxLast(p:Byte;amount:Word);
Var
  sr   : DxSearchRec;
Begin

  sr := DefDxSearchRec;
  sr.Last := Amount;
  ReadDx(p,sr);

End;

 { ***************************************************************** }

Procedure SendDXMerge(p:Byte;ToPC:CallRec;Amount:Byte);
Var
  f   : File;
  Loc : LongInt;
Begin

  If Amount = 0 then Exit;
  If Amount > 100 then Amount := 100;

  Assign(f,DataPath + 'dx.clu');
  Reset(f,SizeOf(DxInfoRec));
  Loc := FileSize(f);
  Close(f);

End;

 { ***************************************************************** }
 { ***************************************************************** }

Procedure ImportDx;                           { Lukee dx.in tiedoston }
Var
 Info  : DxInfoP;
 Time  : DateTime;
 TimeI : LongInt;
 b     : Byte;
 s     : String;
Begin

 { Import-tiedoston formaatti:
  freq call time fromcall frompc info }

 If FileExists(CluPath + 'dx.in')
   then Begin
        Action(65,'Importing DX spots');
        AssignConf(CluPath + 'dx.in');

        Repeat

          ReadConfLine;
          New(Info);
          Info^.Freq := Str2Freq(Parse(0));
          Info^.Call := UpCaseStr(Parse(1));
          Time       := dt;
          s          := Parse(2);
          Time.Hour  := Str2Word(Copy(s,1,2));
          Time.Min   := Str2Word(Copy(s,3,2));
          Time.Sec   := 0;
          PackTime(Time,TimeI);
          Info^.Time := TimeI;
          Info^.FromCall := UpCaseStr(Parse(3));
          Info^.FromPC := UpCaseStr(Parse(4));
          b := FindParamStart(5);
          If (b > 0) { Infoa? }
            then Info^.info := Copy(ibuffer,b,length(ibuffer)-b+1)
            else Info^.Info := ' ';

          Protocol.Dx(Info);

        until eof(cf);

        CloseConf;
        DelFile(CluPath + 'dx.in');
        End;

End;

 { ***************************************************************** }
 { Announce-tiedosto                                                 }
 { ***************************************************************** }

Procedure WriteAnn(Info:AnnP);        { Kirjoittaa tiedoston loppuun }
Begin

 Info^.FromCall := StripSSID(Info^.FromCall);
 Reset(AnnFile);
 Seek(AnnFile,FileSize(AnnFile));
 Write(AnnFile,Info^);
 Close(AnnFile);

 IOCheck('writing announce.clu');

End;

 { ***************************************************************** }

Procedure Formats(p:Byte;Prefix:String;Text:String);
Var
  s      : String; { Uloslhtev }
  plen,            { Prefixin pituus }
  tlen,            { Textin pituus }
  w,               { Sanan alkukohta }
  lw,              { Sanan loppu }
  b  : Byte;       { Kuinka pitkll rivi mennn }
Begin

 { mahd. loppucr:t pois }
 While Text[Length(Text)] = Cr
   do Dec(Text[0]);

 s := Prefix;
 tlen := Length(Text);

 If tlen > 0 { Jos teksti yleens on... }
  then Begin
       plen := Length(Prefix);
       s := s + ' ';
       b := plen + 1;
       w := 1;
       While w <= tlen
        do begin
           { Sanan loppukohta }
           lw := w;
           Repeat
            Inc(lw)
           until (text[lw] = ' ') or (lw > tlen);

           If (b + (lw - w) > 77) { Jos menisi yli rivin }
              and not (lw - w + plen >= 77) { eik ole tyspitk sana }
                    then Begin
                         Send(p,s + cr);
                         s := Spaces(plen);
                         b := plen;
                         End;

           { Listn sana }
           s := s + Copy(text,w,lw-w);
           b := b + lw-w;

           { etsitn seuraavan alku }
           w := lw;
           While (Text[w] = ' ') and (w < tlen)
            do Inc(w);

           if (w <= tlen)
            then Begin
                 s := s + ' ';
                 Inc(b);
                 End;
           End

       End;

 Send(p,s + Cr);

End;

{ ***************************************************************** }

Procedure Ann2List(Const p:Byte; Const Info:AnnRec);
Begin

 Formats(p,PadLeft(7,Info.FromCall) + TimeStrS(Info.Time) + ' '
      + PadLeft(6,DateStrSPad(Info.Time)) + PadLeft(9,Info.ToPC),Info.Msg);

End;

 { ***************************************************************** }

Procedure ReadAnnLast(p:Byte;Num:Byte);
Var
  b          : LongInt;
  HowMany    : Byte;
  Info       : AnnRec;
Begin

 Reset(AnnFile);
 b := FileSize(AnnFile);

 If Num > b then HowMany := b
            else HowMany := Num;

 Seek(AnnFile,b-HowMany);

 Send(p,AnnListHeader);

 For b := 1 to HowMany
  do Begin
     Read(AnnFile,Info);
     IOCheck('reading announce.clu');
     Ann2List(p,Info);
     End;

 Close(AnnFile);

End;

 { ***************************************************************** }

Procedure LAString_Cmd(p:Byte);  { Etsii stringi viestist }
Var
  Info   : AnnRec;
  Sent,
  Found  : Boolean;
  Str    : String;
Begin

 Str := LowCaseStr(Parse(1));
 Action(p,'LAnn by string ' + Str);

 Sent := False;
 Found := False;
 Info.Msg := '';
 Reset(AnnFile);

 While not eof(AnnFile) do
   Begin
   Read(AnnFile,Info);
   IOCheck('reading announce.clu');
   If Pos(Str,LowCaseStr(Info.Msg)) > 0
     then Begin
          Found := True;
          If not Sent then Begin
                           Sent := True;
                           Send(p,AnnListHeader);
                           End;
          Ann2List(p,Info);
          End;
   End;

 Close(AnnFile);

 If not found
   then Send(p,'Sorry, string ' + Str + ' not found.' + Cr);

End;

 { ***************************************************************** }

Procedure LAFrom_Cmd(p:Byte); { Etsii lhettjn mukaan }
Var
  Info   : AnnRec;
  Sent,
  Found  : Boolean;
  Str    : String[10];
Begin

 Sent := False;
 Found := False;
 Str := UpCaseStr(Parse(1));
 Info.FromCall := '';

 Action(p,'LAnn from ' + Str);

 Reset(AnnFile);

 While not eof(AnnFile) do
   Begin
   Read(AnnFile,Info);
   IOCheck('reading announce.clu');
   If Pos(Str,UpCaseStr(Info.FromCall)) > 0
     then Begin
          Found := True;
          If not Sent then Begin
                           Sent := True;
                           Send(p,AnnListHeader);
                           End;
          Ann2List(p,Info);
          End;
   End;

 Close(AnnFile);

 If not found
  then Send(p,'Sorry, sender ' + Str + ' not found.' + Cr);

End;

 { ***************************************************************** }
 { WWV-tiedosto                                                      }
 { ***************************************************************** }

Procedure WriteWWV(Info:WWVP);                { Kirjoittaa tiedoston loppuun }
Begin

 Info^.FromCall := StripSSID(Info^.FromCall);
 Reset(WWVFile);
 Seek(WWVFile,FileSize(WWVFile));
 Write(WWVFile,Info^);
 Close(WWVFile);

 IOCheck('writing wwv.clu');

End;

 { ***************************************************************** }

Function WWV2List(Info:WWVRec):String;
Begin

 WWV2List :=  Format(True,' ' + PadLeft(4,Int2Str(Info.Hour)) + PadLeft(6,DateStrSPad(Info.Time))
            + PadLeft(7,Info.FromCall) + PadLeft(4,Int2Str(Info.SFI))
            + PadLeft(3,Int2Str(Info.A)) + PadLeft(2,Int2Str(Info.K)),
            + Info.Forecast);

End;

 { ***************************************************************** }

Procedure ReadWWVLast(p:Byte;Num:Byte);
Var
  b          : LongInt;
  HowMany    : Byte;
  Info       : WWVRec;
Begin

 Reset(WWVFile);
 b := FileSize(WWVFile);

 If Num > b then HowMany := b
            else HowMany := Num;

 Seek(WWVFile,b-HowMany);

 Send(p,'Hour Date  From   SFI A  K  Forecast' + Cr);

 For b := 1 to HowMany
  do Begin
     Read(WWVFile,Info);
     IOCheck('reading wwv.clu');
     Send(p,WWV2List(Info));
     End;

 Close(WWVFile);

End;

 { ***************************************************************** }

Function  CheckLastWWV(Hour,Day:Byte):Boolean; { Tarkistaa, onko ko. infoa viel }
Var
  Info       : WWVRec;
  b          : Byte;
  dat        : DateTime;
Begin

 Reset(WWVFile);
 b := FileSize(WWVFile);

 If b > 0
  then Begin
       Seek(WWVFile,b-1);
       Read(WWVFile,Info);
       UnPackTime(Info.Time,dat);
       If (Info.Hour = Hour) and (dat.Day = Day)
         then CheckLastWWV := False
         else CheckLastWWV := True;
       End
  else CheckLastWWV := True;

 Close(WWVFile);
 IOCheck('reading wwv.clu');

End;

 { ***************************************************************** }
 { News-tiedosto                                                     }
 { ***************************************************************** }

Procedure SendNews(p:Byte;n:NewsQP);
Var
 f : Text;
 i : LongInt;
 s : String;
Begin

 Send(p,'News: (' + DateStr(n^.Time) + ' ' + TimeStrS(n^.Time) + 'Z)' + Cr);
 Assign(f,TextPath + 'news.txt');
 Reset(f);
 IOCheck('opening news.txt');
 i := 0;
 Repeat
  ReadLn(f,s);
  IOCheck('reading news.txt');
  Inc(i);
 until i = n^.Start;
 i := 0;
 Repeat
  Send(p,s + Cr);
  ReadLn(f,s);
  IOCheck('reading news.txt');
  Inc(i);
 until i >= n^.Len;
 Close(f);

End;

 { ***************************************************************** }

Procedure ReadNewsAfter(p:Byte;moment:LongInt);      { Lukee uutiset ajan mukaan }
Var
  n : NewsQP;
Begin

 If NewsArticles = 0 then Exit;
 n := NewsQ;
 While assigned(n)
  do Begin
     If TimeDiff(n^.Time, moment) < 0
      then SendNews(p,n);
     n := n^.Next;
     End;

End;

 { ***************************************************************** }

Procedure ReadNewsLast(p:Byte;Num:Word);             { Lukee viimeisimmt n uutista }
Var
  n    : NewsQP;
  w    : Word;
  sent : Word;
Begin

 If NewsArticles <> 0
  then Begin
       n := NewsQ;
       w := 0;
       while Assigned(n)
        do Begin
           Inc(w);
           n := n^.Next;
           End;
       If w >= num
         then sent := w - num
         else sent := 0;
       n := NewsQ;
       w := 0;
       While w < sent
        do Begin
           n := n^.Next;
           Inc(w);
           End;
       sent := 0;
       While Assigned(n) and (sent < Num)
        do Begin
           SendNews(p,n);
           Inc(sent);
           n := n^.Next;
           End;
       End
  else Send(p,'Sorry, no news file found.' + Cr);

End;

 { ***************************************************************** }
 { MID taulukko                                                      }
 { ***************************************************************** }

 {
            If XMSPresent and (XMSLargestBlock > (BIs div 1024 + 1))
              and AllocateXMB(BIs div 1024 + 1,XHandle,'DB dxcc.idx')
              and BaseToXMB(BIs,BIfp,XHandle,0)
 }

Procedure MidToXms(b:Byte);
Begin

 If not (MidHandle = 0)
   then Begin
        xmsCheck(BaseToXMB(SizeOf(MidTableType),@Mid[b]^,MidHandle,b * SizeOf(MidTableType)));
        Dispose(Mid[b]);
        End;

End;

Procedure MidFromXms(b:Byte);
Begin

 If not (MidHandle = 0)
   then Begin
        New(Mid[b]);
        xmsCheck(XMBToBase(SizeOf(MidTableType),@Mid[b]^,MidHandle,b * SizeOf(MidTableType)));
        End;
End;

Procedure NewMid(m:MidType);          { Lis mid:n tauluun }
Begin

 Inc(Status.MidPos);
 If Status.MidPos = 1000
   then Begin
        Inc(Status.MidPosT);
        Status.MidPos := 0;
        End;

 If Status.MidPosT > MidTableSize then Status.MidPosT := 0;

 MidFromXms(Status.MidPosT);
 Mid[Status.MidPosT]^[Status.MidPos] := m;
 Reset(MidFile);
 Seek(MidFile,(Status.MidPosT * 1000 + Status.MidPos));
 Write(MidFile, Mid[Status.MidPosT]^[Status.MidPos]);
 Close(MidFile);
 IOCheck('writing mid.clu');
 MidToXms(Status.MidPosT);
 WriteStatus;

End;

Function MidCheck(m:MidType):Boolean; { Tarkistaa onko taulussa, true = ei ole }
Var
 b : Byte;
 w : Word;
 f : Boolean;
Begin

 f := True;

 for b := 0 to MidTableSize
  do Begin
     MidFromXms(b);
     For w := 0 to 999
        do If Mid[b]^[w] = m
          then Begin
               f := False;
               w := 999;
               End;
     MidToXms(b);
     If not f
       then b := MidTableSize;
     End;

 MidCheck := f;

End;

Procedure DumpMIDs; { Koko MID taulukko levylle }
Var
 f     : File of MidTableType;
 i     : Byte;
Begin

 Assign(f,DataPath + 'mid.clu');
 Rewrite(f);

 IOCheck('creating mid.clu');
 For i := 0 to MidTableSize
  do Begin
     Write(f,Mid[i]^);
     IOCheck('writing mid.clu');
     End;

 Close(f);
 IOCheck('closing mid.clu');

End;

Procedure InitMids;
Var
  i : Byte;
  w : Word;
  s : LongInt;
Begin

 s := ((MidTableSize + 1) * SizeOf(MidTableType)) div 1024 + 1;
 If not (XMSPresent and (XMSLargestBlock > s)
   and AllocateXMB(s,MidHandle,'MID table'))
     then Begin
          MidHandle := 0;
          MidTableMem := (MidTableSize + 1) * SizeOf(MidTableType);
          end
     else MidTableMem := 0;

 { Message ID's }
 Write(' o Mounting MID table - ');
 For i := 0 to MidTableSize
  do Begin
     New(Mid[i]);
     For w := 0 to 999 do Mid[i]^[w] := '';
     End;

 Assign(MidFile,DataPath + 'mid.clu');
 Assign(BufFile,DataPath + 'mid.clu');
 Reset(BufFile,SizeOf(MidType));

 If IOresult <> 0
   then Begin
        Write('not found, creating - ');
        DumpMIDs;
        Reset(BufFile,SizeOf(MidType));
        End
   else Begin
        s := 0;
        If FileSize(BufFile) = ((MidTableSize + 1) * 1000)
          then Begin
               Write('     0');
               For i := 0 to MidTableSize
                  do Begin
                     BlockRead(BufFile,Mid[i]^,1000);
                     IOCheck('reading mid.clu');
                     Inc(s,1000);
                     Write(BackSpaces(6) + PadRight(6,Int2Str(s)));
                     End;
               Write(BackSpaces(6));
               End
          else Begin
               Write('resizing from ' + Int2Str(FileSize(BufFile)) + ':      0');
               s := 0;
               Seek(BufFile,Status.MidPosT * 1000 + Status.MidPos);
               i := 0;
               w := 0;
               While not eof(BufFile) and (I <= MidTableSize)
                 do Begin
                    BlockRead(BufFile,Mid[i]^[w],1);
                    Inc(w);
                    If w = 1000
                     then Begin
                          Inc(i);
                          w := 0;
                          End;
                    Inc(s);
                    If s mod 100 = 0
                      then Write(BackSpaces(6) + PadRight(6,Int2Str(s)));
                    End;
               If FileSize(BufFile) < ((MidTableSize + 1) * 1000)
               then Begin
                    Seek(BufFile,0);
                    While (FilePos(BufFile) < ((Status.MidPosT + 1) * 1000
                             + Status.MidPos)) and not eof(BufFile)
                      do Begin
                         BlockRead(BufFile,Mid[i]^[w],1);
                         Inc(w);
                         If w = 1000
                           then Begin
                                Inc(i);
                                w := 0;
                                End;
                         Inc(s);
                         If s mod 100 = 0
                           then Write(BackSpaces(6) + PadRight(6,Int2Str(s)));
                         End;
                    End;
               Status.MidPosT := i;
               Status.MidPos := w;
               WriteStatus;
               Close(BufFile);
               DumpMIDs;
               Reset(BufFile,SizeOf(MidType));
               Write(BackSpaces(6));
               End;
        End;

 CWriteLn(Int2Str(FileSize(BufFile)) + ' records, '
         + Int2Str(FileSize(BufFile) * SizeOf(MidType)) + ' bytes.');
 For i := 0 to MidTableSize
   do MidToXms(i);
 Close(BufFile);

End;

 { ***************************************************************** }
 { Fortune                                                           }
 { ***************************************************************** }

Procedure IndexFortuneFile;
Var
  Ch         : Char;
  FileTime,
  Count      : LongInt;
  State      : Byte;
Begin

 Rewrite(FortuneIndex);
 IOCheck('creating frtnindx.clu');

 Assign(BufFile,TextPath + 'fortunes.txt');
 FBufInit(1); { Tiedostobufferi kyttn }
 State := 0;
 Count := 0;

 Repeat
   Ch := BReadFile;
   Inc(Count);
   If (State = 0) and (Ch = '%') then Inc(State) else
   if (State = 1) and (Ch = Char($0d)) then Begin
                                            Write(FortuneIndex,Count);
                                            IOCheck('writing fortune.ind');
                                            State := 0;
                                            End
                                       else State := 0;

 until BufDone;

 GetFTime(BufFile,FileTime);
 SetFTime(FortuneIndex,FileTime);

 FBufClose;

End;

 { ***************************************************************** }

Procedure Fortune(p:Byte);
Var
  FortunePos,
  Count,
  Rand         : LongInt;
  s            : String;
Begin
If Fortunes
 then Begin
      Reset(FortuneIndex);
      IOCheck('opening frtnindx.clu');
      Rand := Random(FileSize(FortuneIndex)-1); { Arvotaan... }
      Seek(FortuneIndex,Rand);
      Read(FortuneIndex,FortunePos);
      Close(FortuneIndex);
      IOCheck('reading frtnindx.clu');
      Inc(FortunePos);

      Count := 0;

      Assign(BufFile,TextPath + 'fortunes.txt');
      FBufInit(1); { Tiedostobufferi kyttn }

      Seek(BufFile,FortunePos);
      BufFilePos := FortunePos;
      s := BReadLine;
      Repeat
        Send(p,s + Cr);
        s := BReadLine;
      until s = '%';

      Send(p,Cr);
      FBufClose;
      End;
End;

 { ***************************************************************** }

Procedure LoginText(p:Byte);            { Login teksti }
Type
  TextArrayP = ^TextArray;
  TextArray  = Array[1..1700] of Char;
Var
  w : Word;
  s : String;
  t : TextArrayP;
Begin

 If not (LoginTextLen = 0)
  then Begin
       w := 1;
       s := '';
       t := LoginTextP;
       While w < LoginTextLen
         do Begin
            s := s + t^[w];
            If t^[w] = Cr
              then Begin
                   Send(p,s);
                   s := '';
                   Inc(w); { LF:n yli }
                   End;
            Inc(w);
            End;
       End;

End;

 { ***************************************************************** }

Procedure InitNews;
Var
  f     : Text;     { News-tiedosto }
  St    : String;   { datetime string }
  Dat   : DateTime; { Datetime }
  TimeI,            { Pakattu datetime }
  Pos,              { Miss mennn }
  Start,            { Alku }
  Len,              { Loppu }
  Num   : LongInt;  { Montako lydetty }
  NewsP : NewsQP;   { Pointteri muistiin }
  PrevP : ^NewsQP;  { Pointteri ed. pointteriin }
  b     : Byte;

 Procedure RCfgStr;
 Begin { RCfgStr }
   Repeat
     ReadLn(f,St);
     IOCheck('reading news.txt');
     Inc(Pos);
   Until (St[1] <> '#');
 End; { RCfgStr }

Begin

 Write(' o Mounting news file - ');
 Assign(f,TextPath + 'news.txt');
 Reset(f);
 PrevP := @NewsQ;
 If IOResult = 0
   then Begin { Otetaan pivmrt yls }
        Num := 0;
        Pos := 0;
        RCfgStr;
        While not Eof(f) { Luetaan tiedosto lpi }
         do Begin
            If (St[1] = '[') and (St[18] = ']') { Datetime on tss }
             then Begin
                  { Tulkitaan aika }
                  Dat.Day   := Str2Word(Copy(St,2,2));
                  Dat.Month := Str2Word(Copy(St,5,2));
                  Dat.Year  := Str2Word(Copy(St,8,4));
                  Dat.Hour  := Str2Word(Copy(St,13,2));
                  Dat.Min   := Str2Word(Copy(St,16,2));
                  Dat.Sec   := 0;
                  PackTime(Dat,TimeI);
                  Start := Pos;
                  Inc(Start);
                  { Etsitn loppu }
                  Len := -1;
                  Repeat
                    RCfgStr;
                    Inc(Len);
                  until (((St[1] = '[') and (St[18] = ']') and (Length(St) > 17)) or Eof(f));
                  If Eof(f) then Inc(Len);
                  { Muistiin }
                  New(NewsP);
                  PrevP^ := NewsP;
                  NewsP^.Next := nil;
                  PrevP := @NewsP^.Next;
                  NewsP^.Time := TimeI;
                  NewsP^.Start := Start;
                  NewsP^.Len := Len;
                  Inc(NewsArticles);
                  End;
            End;
        CWriteLn(Int2Str(NewsArticles) + ' articles found.');
        Close(f);
        End
   else CWriteLn('not found, disabled.');

End;

 { ***************************************************************** }

Procedure InitPaths;

 Procedure chk(Const pa:PathStr);
 Begin
    If not DirExists(pa)
     then Begin
          CWriteLn(' o Creating directory ' + pa + '...');
          Mkdir(Copy(pa,1,Length(pa)-1));
          IOCheck('creating directory ' + pa);
          End;
 End;

Begin

 { Init variables }
 ExpiryOK := True;
 LastExpiryDay := 255;
 ExpiryPhase := 0;
 Expired := False;
 ExpiryResult.dx.size := SizeOf(DxInfoRec);
 ExpiryResult.ann.size := SizeOf(AnnRec);
 ExpiryResult.wwv.size := SizeOf(WWVRec);
 ExpiryResult.last.size := SizeOf(LastFileRec);
 ExpiryResult.luser.size := SizeOf(LUserRec);
 ExpiryResult.nuser.size := SizeOf(NUserFRec);
 ExpiryResult.node.size := SizeOf(NodeFRec);
 NewsQ := nil;
 NewsArticles := 0;

 { Hakemistot }
 chk(DataPath);
 chk(LogPath);
 chk(UserPath);
 chk(IncomingPath);
 chk(uDataPath);
 chk(PgPath);

   If not DirExists(TextPath)
     then Begin
          WriteLn(' Text directory ' + TextPath + ' not found.' + Cr);
          Halt(1);
          End;

   If not DirExists(TempPath)
     then Begin
          WriteLn(' Temporary directory ' + TempPath + ' not found.');
          Halt(1);
          End;

End;

 { ***************************************************************** }

Procedure InitFiles;
Type
  DxtT = Array[1..100] of DxInfoRec;
Var
  i, HelpFileTime, HelpIndexTime : LongInt;
  w   : Word;
  Dx  : DxInfoRec;
  Ann : AnnRec;
  WWV : WWVRec;

  dxt : ^DxtT;

  Function LongMul(X, Y: Integer): Longint;
  inline($5A/$58/$f7/$EA);

Begin

 { Paikallinen kyttjtiedosto }

 Write(' o Mounting local user file - ');
 Assign(UserFile,DataPath + 'users.clu');
 Reset(UserFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(UserFile);
                       End;
 IOCheck('opening users.clu');
 CWriteLn(Int2Str(FileSize(UserFile)) + ' records.');
 Close(UserFile);

 { Koko verkon kyttjtiedosto }

 Write(' o Mounting network user file - ');
 Assign(NUserFile,DataPath + 'netusers.clu');
 Reset(NUserFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(NUserFile);
                       End;
 IOCheck('opening netusers.clu');
 CWriteLn(Int2Str(FileSize(NUserFile)) + ' records.');
 Close(NUserFile);

 { Nodetiedosto }

 Write(' o Mounting network node file - ');
 Assign(NodeFile,DataPath + 'nodes.clu');
 Reset(NodeFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(NodeFile);
                       End;
 IOCheck('opening nodes.clu');
 CWriteLn(Int2Str(FileSize(NodeFile)) + ' records.');
 Close(NodeFile);

 { DX-tiedosto }

 Write(' o Mounting DX file - ');
 Assign(DxFile,DataPath + 'dx.clu');
 Reset(DxFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(DxFile);
                       End;
 IOCheck('opening dx.clu');
 i := FileSize(DxFile);
 If i > 0
   then Begin
        Seek(DxFile,i-1);
        Read(DxFile,Dx);
        Index.Dx := Dx.Num;
        End
   else Index.Dx := 0;
 Close(DxFile);
 CWriteLn(Int2Str(i) + ' records, last index ' + Int2Str(Index.Dx) + '.');

 { Announce-tiedosto }

 Write(' o Mounting Announce file - ');
 Assign(AnnFile,DataPath + 'announce.clu');
 Reset(AnnFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(AnnFile);
                       End;
 IOCheck('opening announce.clu');
 i := FileSize(AnnFile);
 If i > 0 then Begin
               Read(AnnFile,Ann);
               Index.AnnFirst := Ann.Num;
               Seek(AnnFile,i-1);
               Read(AnnFile,Ann);
               Index.Ann := Ann.Num;
               End
          else Begin
               Index.AnnFirst := 0;
               Index.Ann := 0;
               End;

 CWriteLn(Int2Str(i) + ' records, last index ' + Int2Str(Index.Ann) + '.');
 Close(AnnFile);

 { WWV-tiedosto }

 Write(' o Mounting WWV file - ');
 Assign(WWVFile,DataPath + 'wwv.clu');
 Reset(WWVFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(WWVFile);
                       End;
 IOCheck('opening wwv.clu');
 i := FileSize(WWVFile);
 If i > 0 then Begin
               Read(WWVFile,WWV);
               Index.WWVFirst := WWV.Num;
               Seek(WWVFile,i-1);
               Read(WWVFile,WWV);
               Index.WWV := WWV.Num;
               End
          else Begin
               Index.WWVFirst := 0;
               Index.WWV := 0;
               End;
 CWriteLn(Int2Str(i) + ' records, last index ' + Int2Str(Index.WWV) + '.');
 Close(WWVFile);

 { Aputiedosto }

 Write(' o Mounting help file - ');
 Assign(BufFile,TextPath + 'clusse.hlp');
 Reset(BufFile,1);
 IOCheck('opening clusse.hlp');

 Assign(HelpIndex,DataPath + 'helpindx.clu');
 Reset(HelpIndex);

 If IOResult <> 0
   then Begin
        Write('Index file not found. Building... ');
        IndexHelpFile;
        End
   else Begin { Tarkistetaan onko indeksitiedosto ajan tasalla... }
        GetFTime(BufFile,HelpFileTime);
        GetFTime(HelpIndex,HelpIndexTime);
        If HelpFileTime <> HelpIndexTime
          then Begin
               Write('Help file changed. Reindexing... ');
               IndexHelpFile;
               End
          else Close(BufFile);
        End;

 CWriteLn(Int2Str(FileSize(HelpIndex)) + ' keywords.');
 Close(HelpIndex);

 { Fortune init }

 Write(' o Mounting fortunes - ');
 Assign(BufFile,TextPath + 'fortunes.txt');
 Reset(BufFile,1);
 If IOresult <> 0
   then Begin
        CWriteLn('fortunes.txt not found, disabled.');
        Fortunes := False;
        End
   else Begin
        Assign(FortuneIndex,DataPath + 'frtnindx.clu');
        Reset(FortuneIndex);

        If IOResult <> 0
         then Begin
              Write('index file not found. Building... ');
              IndexFortuneFile;
              End
         else Begin
              GetFTime(BufFile,HelpFileTime);
              GetFTime(FortuneIndex,HelpIndexTime);

              If HelpFileTime <> HelpIndexTime
                 then Begin
                      Write('Fortune file changed. Reindexing...');
                      IndexFortuneFile;
                      End
                 else Close(BufFile);
              End;
        CWriteLn(Int2Str(FileSize(FortuneIndex)) + ' fortunes.');
        Close(FortuneIndex);
        Fortunes := True;
        End;

 Write(' o Mounting last file - ');
 Assign(LastFile,DataPath + 'last.clu');
 Reset(LastFile);
 If IOresult <> 0 then Begin
                       Write('not found, creating - ');
                       Rewrite(LastFile);
                       End;
 IOCheck('opening last.clu');
 i := FileSize(LastFile);
 CWriteLn(Int2Str(i) + ' records.');
 Close(LastFile);

 { Status.clu }
 Write(' o Mounting status file - ');
 Assign(StatusFile,DataPath + 'status.clu');
 Reset(StatusFile);
 If IOResult <> 0
   then Begin
        Write('not found, creating - ');
        Rewrite(StatusFile);
        IOCheck('creating status.clu');
        Status.MidPosT := 1;
        Status.MidPos := 0;
        Status.EdWinLine := 0;
        WriteStatus;
        End
   else Begin
        Read(StatusFile,Status);
        IOCheck('reading status.clu');
        Close(StatusFile);
        End;
 EdWinLine := Status.EdWinLine;
 CWriteLn('Done.');

 InitMids;

 { text\Login.txt }
 LoginTextLen := 0;
 Assign(BufFile,TextPath + 'login.txt');
 Reset(BufFile,1);
 If IOResult = 0
   then Begin
        i := FileSize(BufFile);
        If (i > 1700)
         then i := 1700;
        GetMem(LoginTextP,i);
        BlockRead(BufFile,LoginTextP^,i);
        Close(BufFile);
        IOCheck('reading login.txt');
        LoginTextLen := i;
        End
   else LoginTextP := nil;

 { News }
 InitNews;

 { Databases }
 Database.Init;

End; { InitFiles }

 { ***************************************************************** }
Procedure Expire;                   { Vanhat jutut pois tiedostoista }
Var

  Time : DateTime;
  Days : LongInt;

  Pos, Size : LongInt;

 { **** }

 Procedure ExLUserFile;
 Var
   NewUserFile   : File of LUserFRec;         { temp\users.clu }
   LUs           : LUserFRec;
   sto           : Word;
 Begin
   Action(70,'Local users...');
   Pos := 0;
   sto := Conf^.Exp.Expirytimes.LUser;
   Assign(NewUserFile,TempPath + 'users.tmp');
   Rewrite(NewUserFile);
   Reset(UserFile);
   Size := FileSize(UserFile);
   ExpiryResult.luser.orig := size;
   IOCheck('opening users.tmp');

   While not eof(UserFile)
     do Begin
        Read(UserFile,LUs);
        IOCheck('reading users.clu');
        Inc(Pos);
        ProgressMeter(Pos/Size);
        UnPackTime(LUs.Time,Time);
        If ValidCall(LUs.Call) and (LUs.Group > 0) and (LUs.Group < GroupsAvail)
          and ((DayDiff(Time,Dt) <= sto) or (R_NeverExpire in Conf^.Groups[LUs.Group].Rights))
         then Begin
              Write(NewUserFile,LUs);
              IOCheck('writing users.tmp');
              End;
        End;

   Pos := FileSize(NewUserFile);
   ExpiryResult.luser.dest := Pos;
   Close(NewUserFile);
   Close(UserFile);
   MoveFile(TempPath + 'users.tmp', DataPath + 'users.clu');
   Action(70,'Local users: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');

 End;

 { **** }

 Procedure ExNUserFile;
 Type
   NUBufType     = Array[1..200] of NUserFRec;
 Var
   NewNUserFile  : File;       { netusers.tmp }
   NUBuf, OutBuf : ^NUBufType; { Bufferit }
   BPos, OPos    : Byte;       { Miss mennn }
   BGot          : Integer;    { Paljonko saatiin }
   sto           : Word;

   Procedure Flush;
   Begin
    If OPos > 0
     then Begin
          BlockWrite(NewNUserFile,OutBuf^,OPos);
          IOCheck('writing netusers.tmp');
          OPos := 0;
          End;
   End;

 Begin

   Action(70,'Network user file...');
   Pos := 0;
   sto := Conf^.Exp.Expirytimes.NUser;

   Assign(BufFile,DataPath + 'netusers.clu');
   Reset(BufFile,SizeOf(NUserFRec));
   Size := FileSize(BufFile);
   ExpiryResult.NUser.Orig := Size;

   If (Size > 0)
    then Begin
         Assign(NewNUserFile,TempPath + 'netusers.tmp');
         Rewrite(NewNUserFile,SizeOf(NUserFRec));
         IOCheck('opening netusers.tmp');
         New(NUBuf);
         New(OutBuf);
         BGot := 200;
         BPos := 200;
         OPos := 0;

          Repeat
            If BPos = BGot
              then Begin
                   BlockRead(BufFile,NUBuf^,200,BGot);
                   IOCheck('reading netusers.clu');
                   BPos := 0;
                   End;
            Inc(BPos);
            Inc(Pos);
            ProgressMeter(Pos/Size);
            UnPackTime(NUBuf^[BPos].Time,Time);
            If (DayDiff(Time,Dt) <= sto)
              then Begin
                   Inc(OPos);
                   OutBuf^[OPos] := NUBuf^[BPos];
                   If OPos = 200
                     then Flush;
                   End;
          until (BPos = BGot) and eof(BufFile);
          Flush;

         Pos := FileSize(NewNUserFile);
         ExpiryResult.NUser.Dest := Pos;
         Close(NewNUserFile);
         Close(BufFile);
         Dispose(NUBuf);
         Dispose(OutBuf);
         MoveFile(TempPath + 'netusers.tmp', DataPath + 'netusers.clu');
         Action(70,'Network users: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');
         End
    else Close(BufFile);

 End;

 { **** }

 Procedure ExNodeFile;
 Type
   NodeSortQP    = ^NodeSortQRec;
   NodeSortQRec  = Record
                   Rec   : NodeFRec;
                   Next  : NodeSortQP;
                   End;
 Var
   NewNodeFile   : File of NodeFRec;   { nodes.tmp }
   Buf           : Array[1..SizeOf(NodeFRec)] of Char;
   Rec           : NodeFP;
   b             : Byte;
   sto           : Word;

 Begin

   Action(70,'Node file...');
   Pos := 0;
   Rec := @Buf;
   sto := Conf^.Exp.Expirytimes.Node;

   Assign(BufFile,DataPath + 'nodes.clu');
   Reset(BufFile,1);
   Size := FileSize(BufFile) div SizeOf(NodeFRec);
   ExpiryResult.node.orig := Size;

   If (Size > 0)
    then Begin
         FBufInit(1);
         Assign(NewNodeFile,TempPath + 'nodes.tmp');
         Rewrite(NewNodeFile);
         IOCheck('opening nodes.tmp');

         While not BufDone
          do Begin
             For b := 1 to SizeOf(NodeFRec)
               do Buf[b] := BReadFile;
             UnPackTime(Rec^.Time,Time);
             Inc(Pos);
             ProgressMeter(Pos/Size);
             If ((DayDiff(Time,Dt) <= sto)) and ValidCall(Rec^.Call)
		and ValidCall(Rec^.Via) and (Rec^.Ver <> 0)
               then Begin
                    Write(NewNodeFile,Rec^);
                    IOCheck('writing nodes.tmp');
                    End;
             End;

         Pos := FileSize(NewNodeFile);
         ExpiryResult.node.dest := Pos;
         Close(NewNodeFile);
         FBufClose;
         MoveFile(TempPath + 'nodes.tmp', DataPath + 'nodes.clu');
         Action(70,'Nodes: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');
         End
    else Close(BufFile);

 End;

 { **** }

 Procedure ExDxFile;
 Type
   DxBufType     = Array[1..200] of DxInfoRec;
 Var
   NewDxFile     : File;        { dx.tmp }
   DxBuf, OutBuf : ^DxBufType;  { Bufferit }
   BPos, OPos    : Byte;        { Buffereiden miss-mennn }
   BGot          : Integer;     { Paljonko saatiin luettua }
   sto           : Word;

   Procedure Flush;
   Begin
    If OPos > 0
     then Begin
          BlockWrite(NewDxFile,OutBuf^,OPos);
          IOCheck('writing dx.tmp');
          OPos := 0;
          End;
   End;

 Begin

   Action(70,'DX file...');
   Pos := 0;

   Assign(BufFile,DataPath + 'dx.clu');
   Reset(BufFile,SizeOf(DxInfoRec));
   Size := FileSize(BufFile);
   ExpiryResult.dx.orig := size;

   If (Size > 0)
    then Begin
         Assign(NewDxFile,TempPath + 'dx.tmp');
         Rewrite(NewDxFile,SizeOf(DxInfoRec));
         IOCheck('opening dx.tmp');
         New(DxBuf);
         New(OutBuf);
         BGot := 200;
         BPos := 200;
         OPos := 0;
         sto := Conf^.Exp.Expirytimes.Dx;

          Repeat
            If BPos = BGot
              then Begin
                   BlockRead(BufFile,DxBuf^,200,BGot);
                   IOCheck('reading dx.clu');
                   BPos := 0;
                   End;
            Inc(BPos);
            Inc(Pos);
            ProgressMeter(Pos/Size);
            UnPackTime(DxBuf^[BPos].Time,Time);
            If (DayDiff(Time,Dt) <= sto)
              then Begin
                   Inc(OPos);
                   OutBuf^[OPos] := DxBuf^[BPos];
                   If OPos = 200
                     then Flush;
                   End;
          until (BPos = BGot) and eof(BufFile);
          Flush;

         Pos := FileSize(NewDxFile);
         ExpiryResult.Dx.Dest := Pos;
         Close(NewDxFile);
         Close(BufFile);
         Dispose(DxBuf);
         Dispose(OutBuf);
         MoveFile(TempPath + 'dx.tmp', DataPath + 'dx.clu');
         Action(70,'DX: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');
         End
    else Close(BufFile);

 End;

 { **** }

 Procedure ExAnnFile;
 Var
   NewAnnFile    : File of AnnRec;       { announce.clu }
   Ann           : AnnRec;
   sto           : Word;
 Begin

   Action(70,'Announce file...');
   Pos := 0;
   sto := Conf^.Exp.Expirytimes.Ann;
   Assign(NewAnnFile,TempPath + 'announce.tmp');
   Rewrite(NewAnnFile);
   Reset(AnnFile);
   Size := FileSize(AnnFile);
   ExpiryResult.Ann.Orig := Size;
   IOCheck('opening announce.tmp');

   While not eof(AnnFile)
     do Begin
        Read(AnnFile,Ann);
        IOCheck('reading announce.clu');
        Inc(Pos);
        ProgressMeter(Pos/Size);
        UnPackTime(Ann.Time,Time);
        If DayDiff(Time,Dt) <= sto then Write(NewAnnFile,Ann);
        IOCheck('writing announce.tmp');
        End;

   Pos := FileSize(NewAnnFile);
   ExpiryResult.Ann.Dest := Pos;
   Close(AnnFile);
   Close(NewAnnFile);
   MoveFile(TempPath + 'announce.tmp',DataPath + 'announce.clu');
   Action(70,'Ann: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');
   End;

 { **** }

 Procedure ExWWVFile;
 Var
   NewWWVFile    : File of WWVRec;       { wwv.clu }
   WWV           : WWVRec;
   sto           : Word;
 Begin

   Action(70,'WWV file...');
   Pos := 0;
   sto := Conf^.Exp.Expirytimes.WWV;
   Assign(NewWWVFile,TempPath + 'wwv.tmp');
   Rewrite(NewWWVFile);
   Reset(WWVFile);
   Size := FileSize(WWVFile);
   ExpiryResult.WWV.Orig := Size;
   IOCheck('opening wwv.tmp');

   While not eof(WWVFile)
     do Begin
        Read(WWVFile,WWV);
        IOCheck('reading wwv.clu');
        Inc(Pos);
        ProgressMeter(Pos/Size);
        UnPackTime(WWV.Time,Time);
        If DayDiff(Time,Dt) <= sto then Write(NewWWVFile,WWV);
        IOCheck('writing wwv.tmp');
        End;

   Pos := FileSize(NewWWVFile);
   ExpiryResult.WWV.Dest := Pos;
   Close(WWVFile);
   Close(NewWWVFile);
   MoveFile(TempPath + 'wwv.tmp', DataPath + 'wwv.clu');
   Action(70,'WWV: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');

End;

 { **** }

 Procedure ExLastFile;
 Var
  NewLastFile   : File of LastFileRec;  { last.tmp }
  Last          : LastFP;
  LastBuf       : Array[1..SizeOf(LastFileRec)] of Char;
  b             : Byte;
  sto           : Word;
 Begin
   Action(70,'History file...');
   Pos := 0;
   sto := Conf^.Exp.Expirytimes.Last;
   Last := @LastBuf;

   Assign(BufFile,DataPath + 'last.clu');
   Reset(BufFile,1);
   Size := FileSize(BufFile) div SizeOf(LastFileRec);
   ExpiryResult.Last.Orig := Size;

   If (Size > 0)
    then Begin
         FBufInit(1);
         Assign(NewLastFile,TempPath + 'last.tmp');
         Rewrite(NewLastFile);

         IOCheck('opening last.tmp');

         { Luetaan alku pois }
          Repeat
            For b := 1 to SizeOf(LastFileRec)
              do LastBuf[b] := BReadFile;
            UnPackTime(Last^.Time,Time);
            Inc(Pos);
            ProgressMeter(Pos/Size);
          until (DayDiff(Time,Dt) <= sto) or BufDone;

         { Loput levylle }
         If (DayDiff(Time,Dt) <= sto)
          then Begin
               Write(NewLastFile,Last^);
               While not BufDone
                do Begin
                   For b := 1 to SizeOf(LastFileRec)
                     do LastBuf[b] := BReadFile;
                   Write(NewLastFile,Last^);
                   IOCheck('writing last.tmp');
                   Inc(Pos);
                   ProgressMeter(Pos/Size);
                   End;
               End;

         Pos := FileSize(NewLastFile);
         ExpiryResult.Last.Dest := Pos;
         Close(NewLastFile);
         FBufClose;
         MoveFile(TempPath + 'last.tmp', DataPath + 'last.clu');
         Action(70,'History: ' + Int2Str(Pos) + ' (' + Percentage(Pos,Size) + ') OK.');
         End
    else Close(BufFile);

 End;

 { **** }

Begin

 Case ExpiryPhase of
  1 : ExLUserFile;
  2 : ExNUserFile;
  3 : ExNodeFile;
  4 : ExDxFile;
  5 : ExAnnFile;
  6 : ExWWVFile;
  7 : ExLastFile;
 End;

 ProgressMeter(0);

 ExpiryDelay := 5;
 Inc(ExpiryPhase);
 If (ExpiryPhase = 8)
  then Begin
       ExpiryPhase := 0;
       Expired := True;
       End;

End;

 { ***************************************************************** }

Procedure StartExpiry; { Aloittaa expiry-prosessin }
Begin

 If not ExpiryOK then Exit; { Ei kytss. }
 If ExpiryPhase = 0 then ExpiryPhase := 1;
 Expire;

End;

 { ***************************************************************** }

Procedure MinTimer; { Kerran minuutissa }
Begin

  If (Dt.Hour = Conf^.Exp.ExpiryHour) and (LastExpiryDay <> Dt.Day)
    then Begin
         StartExpiry;
         LastExpiryDay := Dt.Day;
         End;
  If ExpiryPhase > 0
    then Begin
         Dec(ExpiryDelay);
         If ExpiryDelay = 0
            then Expire;
         End;

End;

 { ***************************************************************** }

Procedure FileStatus_Cmd(p:Byte); { Statistiikkaa }

  Function Res(Entry:ExpiryResultEntry):String;
  Begin
    Res := PadRight(5,Int2Str(Entry.Orig)) + ' ' + PadRight(8,'(' + Int2Str(Entry.Orig * Entry.Size))
              + ')   ' + PadRight(5,Int2Str(Entry.Dest)) + ' '
              + PadRight(8,'(' + Int2Str(Entry.Dest * Entry.Size)) + ') - '
              + Percentage(Entry.Dest,Entry.Orig) + Cr
  End;

Begin

 Action(p,'Status - file system');
 Send(p,'File system status:' + Cr);
 Send(p,' Running on drive ' + Copy(CluPath,1,2) + ' ' + Int2Str(DiskFree(0) div 1024)
          + ' Kb free, disk size ' + Int2Str(DiskSize(0) div 1024) + ' Kb.' + Cr);
 If not Expired
   then Send(p,' Expiry not executed yet.' + Cr)
 else Begin
      Send(p,'Last expiry:  Original size     Destination size' + Cr
           + '  File type   Records   Bytes   Records   Bytes' + Cr);
      Send(p,' DX spots      ' + Res(ExpiryResult.dx)
           + ' Announcements ' + Res(ExpiryResult.ann));
      Send(p,' WWV messages  ' + Res(ExpiryResult.wwv)
           + ' User history  ' + Res(ExpiryResult.last));
      Send(p,' Local users   ' + Res(ExpiryResult.luser)
           + ' Network users ' + Res(ExpiryResult.nuser));
      Send(p,' Network nodes ' + Res(ExpiryResult.node));
      End;

End;

 { ***************************************************************** }

End.
