{$F-} {$R-} {$Q-} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Protocol;

  { Implements the main cluster networking core. Includes much
    PC-specific linking stuff, and some networking-related user
    commands. DO NOT MESS WITH THIS UNLESS YOU ARE REALLY SURE
    WHAT YOU'RE DOING IS SANE. YOU CAN EASILY CRASH THE WHOLE
    CLUSTER NETWORK BY SENDING BAD DATA TO A LINK. }

Interface
Uses Dos, ConfFile;
Type

  DxCallStr = String[15];

  tAwayString = String[80];

  CallQP    = ^CallQueue;
  CallQueue = Record
              Call : CallRec;
              Next : CallQP;
              End;

  LinkRecP  = ^LinkRec;

  NodeRecPP = ^NodeRecP;
  NodeRecP  = ^NodeRec;
  NodeRec   = Record
              Call    : CallRec;        { Callsign }
              Via     : LinkRecP;       { Via which link }
              Hops    : Byte;           { How many hops away (not accurate) }
              HopsOK  : Boolean;        { Is the hops value OK }
              Since   : LongInt;        { Linked since }
              Here    : Boolean;        { Here status for the node }
              Ver     : Word;           { PC version number }
              UsersK  : Boolean;        { User list known }
              UsersOK : Boolean;        { Is the user list valid }
              Users   : Word;           { How many users on the node (from PC50) }
              Rtt     : LongInt;        { Round-trip time (sec) }
              RttOK   : Boolean;        { Round-trip time measured? }
              Pinging : Boolean;        { Is this node being pinged }
              Locked  : Boolean;        { Local lock }
               { Semi-doubly linked list: }
              PrevP   : NodeRecPP;      { Pointer to this entry in the
                                          previous one }
              Next    : NodeRecP;       { Next entry }
              End;

  DxInfoP   = ^DxInfoRec;
  DxInfoRec = Record { dx.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              Call     : DxCallStr;    { DX callsign }
              Freq     : LongInt;      { Frequency, 1 desimaali }
              Reserved : Word;
              FromCall,                { Who submitted the spot }
              FromPC   : CallRec;      { and on what node }
              FromLink : LinkRecP;     { What link port did it come from }
              Info     : String[80];   { Misc text }
              End;

  AnnP      = ^AnnRec;
  AnnRec    = Record { announce.clu }
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              FromCall,                { From callsign }
              FromPc,                  { From node }
              ToPC     : CallRec;      { Distributed to node (* = full) }
              FromLink : LinkRecP;     { What link port did it come from }
              Sysop,                   { Only to sysops }
              Wx       : Boolean;      { Is it a WX spot }
              Msg      : String;       { The message itself }
              End;

  TalkRecP  = ^TalkRec;
  TalkRec   = Record
              Num      : LongInt;      { Index number }
              Time     : LongInt;      { Packed datetime }
              FromCall,                { From callsign  }
              FromPC,                  { From node }
              ToCall   : CallRec;      { Recipient's callsign }
              ToPc     : NodeRecP;     { Recipient's node }
              FromLink : LinkRecP;     { What link port did it come from }
              Msg      : String;       { The message }
              End;

  WWVP      = ^WWVRec;
  WWVRec    = Record { wwv.clu }
              Num       : LongInt;      { Index number }
              Time      : LongInt;      { When we got it in }
              Hour      : Byte;         { Hour of the WWV message }
              SFI, A    : Word;
              K         : Byte;
              Forecast  : String[80];
              FromCall,                { Who submitted this one }
              FromPc    : CallRec;      { ...on what node... }
              FromLink  : LinkRecP;     { What link port did it come from }
              End;

  NUserRecPP= ^NUserRecP;
  NUserRecP = ^NUserRec;
  NUserRec  = Record
              Time       : LongInt;      { Logged on since }
              Call       : CallRec;      { Callsign }
              Name       : CallRec;
              Pc         : NodeRecP;     { Node }
              Here       : Boolean;      { The here bit }
              AwayStrP   : ^tAwayString; { Away string }
              AwayTime   : LongInt;      { Away since }
              Sysop,                     { Onko sysop }
              Privileged : Boolean;      { Muuten vaan hyv jtk }
               { Semi-doubly linked list: }
              PrevP      : NUserRecPP;   { Pointer to this entry in the
                                           previous one }
              Next       : NUserRecP;    { Next entry }
              End;

  LinkModeT  = (LM_Normal, LM_Listen, LM_Incoming);
  LinkStateT = (LS_Disc, LS_Init, LS_Linked, LS_Backuped, LS_Held);
  DReasonT   = (DR_Unknown, { disc received }
                DR_NotCon,  { Never connected }
                DR_Sysop,
                DR_Remote,  { Remote node requested }
                DR_Loop,
                DR_PingTO,  { Ping timeout }
                DR_Held);   { Link held }

  LinkRec   = Record
              Call          : CallRec;    { Destination callsign }
              MyCall        : CallRec;    { Local callsign used }
              AxCall        : CallRec;    { Local AX.25 callsign used }
              Mode          : LinkModeT;  { Link mode }
              State         : LinkStateT; { Link state }
              Since         : LongInt;    { When the state last changed }
              DReason       : DReasonT;

              Proto         : Byte;      { Protocol:
                                             3 - CluLink
                                             4 - PacketCluster link
                                             5 - Conversd link (disabled) }

              Sock          : Byte;      { BPQ Socket }
              Ver           : Word;      { Version number }
              PC            : NodeRecP;  { Neighbour node record }

              Backuped      : LinkRecP;  { Which link this is a backup to }
              Backup        : LinkRecP;  { Which link is a backup for this one }

              { These ones only for PC links }
              CharSet       : Byte;      { Character conversion table used }
              PCBeaconInter : Word;      { PC50 beacon interval }
              PCBeaconTimer : Word;      { Timer used for the above }
              PCPollDx,                  { How many DX spots are merged on linkup }
              PCPollWWV     : Byte;      { The same for WWV }

              PingInterval,              { How often to ping (minutes) }
              PingTimer     : Word;      { Timer for the above }
              PingMaxRTT    : Word;      { Maximum RTT allowed (seconds) }

              Script        : NameStr;   { Connection script filename }

              DiscStrings   : Byte;      { If a protocol message is not
                                           understood, and one of these
                                           strings is found in the received
                                           message, the link is disconnected. }
              DiscStr       : Array[1..5] of String[10];

              TryAfter,                  { Relink after... (minutes) }
              LastTry       : Word;      { Minutes since last try }

              Tries,                     { How many tries after last disconnect }
              Failures,                  { How many link failures }

              Routes        : Word;      { How many routes on the link }
              LTimeout      : Word;      { Linker timeout }
              Traced        : Boolean;   { Traced? }

              Next          : LinkRecP;
              End;

  PingRecP  = ^PingRec; { Pinger list }
  PingRec   = Record
              Pc        : NodeRecP;  { Node being pinged }
              Time      : LongInt;   { Seconds pinged }
              MaxTime   : LongInt;   { Seconds to wait }
              PingedBy  : CallRec;   { Who is pinging }
              Next      : PingRecP;  { Next record }
              End;

  IndexRec  = Record { Index counters for various message types }
              DxFirst,
              Dx,
              AnnFirst,
              Ann,
              WWVFirst,
              WWV,
              Talk,
              Mail    : LongInt;
              End;

  CutLinkType = (nice, rude);

Const
  MaxLinks        = 10;

Var
  CluCall         : CallRec;      { Callsign of the local node }
  LocalNode       : NodeRecP;     { Pointer to the local Node record }
  NUserCount      : Word;         { How many users on the network }
  KUserCount      : Word;         { How many KNOWN users on the network }
  NodeCount       : Word;         { How many nodes }
  PCLinksC        : Byte;         { Links configured }

  PingJobs        : Word;         { Amount of pinger jobs }
  PingQueue       : PingRecP;     { Pinger list }

  Nodes           : NodeRecP;     { Nodes }
  Links           : LinkRecP;     { Links }
  Users           : NUserRecP;    { Users }
  Index           : IndexRec;     { Index }

  MaxUsers        : Word;         { Users high water mark }
  MaxLUsers       : Byte;         { Local users ... }
  MaxNodes        : Word;         { Nodes... }

  NAwayStrings    : Word;         { Away strings allocated }

  { Statistiikat: }
  PCReceived,
  PCUnknown,
  PCInvalid       : LongInt;

Const
  PingTimeout     = 1200;         { Pinger timeout }

Function  GetNode(Const Call:CallRec):NodeRecP;
Function  GetNUser(Const Call:CallRec):NUserRecP;
Function  GetNUserH(Const Call:CallRec;Pc:NodeRecP):NUserRecP;
Function  GuessNUser(var Call:CallRec):NUserRecP;

Function  GetLink(Call:CallRec):LinkRecP;
Function  PCLinks:Byte;
Function  PCLinksH:Byte;

Procedure CountUsers;                { Update NUserCount based on node table }
Procedure ClearNLocks;               { Clear node table locks }

Function  drStr(reason:DReasonT):String;

Procedure StartLinks;                       { Tries to link all links }
Procedure LinkMade(l:LinkRecP);             { Linking succesful }

Procedure Login(p:Byte; l:LinkRecP);

Procedure DropRoutes(l:LinkRecP);           { Drops all users and nodes behind a link }
Procedure Logout(p:Byte);                   { A link has been disconnected }
Procedure CutLinks(Method:CutLinkType;Const Reason:String); { Cuts all links NOW }

 { User commands }
Procedure Nodelist_Cmd(p:Byte);              { A list of users }
Procedure nRoutes_Cmd(p:Byte);               { A list of node routes }
Procedure NodeInfo_Cmd(p:Byte;Const Call:CallRec); { Information about a node }
Procedure Linklist_Cmd(p:Byte);              { A list of links }
Procedure Link_Cmd(p:Byte);                  { Modify link settings }
Procedure Userlist_Cmd(p:Byte);              { An user list }
Procedure UserlistH_Cmd(p:Byte;n:NodeRecP);  { An user list for a node }
Procedure ProtocolStatus_Cmd(p:Byte);        { Protocol statistics }
Procedure Merge_Cmd(p:Byte);                 { Request spot merging }

 { Pinger }
Procedure AddPing(Pc:NodeRecP;FromCall:CallRec;MaxTime:Word);
Procedure RemovePing(Pc:NodeRecP);               { Drop a ping }
Procedure AbortPing(Pc:NodeRecP;Const Reason:String);  { Abort a ping }
Procedure Ping_Cmd(p:Byte);                      { The Ping command for users }
Procedure PStat_Cmd(p:Byte);                  { PStat command for users }

 { Cluster events }
Function Dx(Info:DxInfoP):Boolean; { DX }
Procedure Announce(Info:AnnP);     { Announce }
Procedure Talk(Info:TalkRec);      { Talk }
Procedure WWV(Info:WWVRec);        { WWV }
Procedure SetHere(FromL:LinkRecP;Const Call:Callrec);                { User here }
Procedure SetAway(FromL:LinkRecP;Const Call:Callrec;Const Reason:tAwayString);  { User away }
Procedure SetUserData(n:NUserRecP;FromL:LinkRecP;Const UserCall:CallRec;
                      b:Byte;Const Data:String);                     { User data }

 { User list handling }
Procedure AddUser(u:NUserRecP);
Procedure DeleteUser(FromL:LinkRecP;Const Call:CallRec;Pc:NodeRecP;Time:LongInt);

 { Node list handling }
Procedure NodeAdd(h:NodeRecP);                { Add cluster node }
Procedure NodeDrop(h:NodeRecP;Const Reason:String); { Drop cluster node }

Procedure MinTimer;                { Called every minute }
Procedure SecTimer;                { Called every second }
Procedure Init;                    { Initialize the unit }
Procedure ReadConfig;              { Read the configuration file, links.ini }

 { ====================================================================== }

Implementation
Uses MultiTsk, CStrings, Screen, Bpq, Files, Config, Cluster,
     PCLink, CluLink, Unproto, Convers, Linker, Database, crc, Speech;

Var
  HopsCount  : Byte;

 { ====================================================================== }
 {  U S E R / N O D E   T A B L E   H A N D L I N G                       }
 { ====================================================================== }

 { Delete an user from the user list }

Procedure DelNUser(Target:NUserRecP);
Begin
 Target^.PrevP^ := Target^.Next;
 If assigned(Target^.Next)
   then Target^.Next^.PrevP := Target^.PrevP;
 If Assigned(Target^.AwayStrP)
   then Begin
        Dispose(Target^.AwayStrP);
        Dec(NAwayStrings);
        End;
 Dispose(Target);
 Dec(NUserCount);
 Dec(KUserCount);
End;

 { ====================================================================== }
 { Delete all users on a node }

Procedure DelNUsersH(Pc:NodeRecP);
Var p, Next : NUserRecP;
Begin
 p := Users;
 While assigned(p)
  do Begin
     Next := p^.Next;
     If p^.Pc = Pc then DelNUser(p);
     p := Next;
     End;
End;

 { ====================================================================== }
 { Add a node to the list }

Procedure NewNode(h:NodeRecP);
Var EdP : NodeRecPP;
    p   : NodeRecP;
Begin

 EdP := @Nodes;
 p := Nodes;

 While Assigned(p) and StrOrd(p^.Call,h^.Call)
   do Begin
      EdP := @EdP^^.Next;
      p := p^.Next;
      End;

 EdP^ := h;
 h^.Next := p;
 h^.PrevP := EdP;
 If Assigned(h^.Next)
   then h^.Next^.PrevP := @h^.Next;

 Inc(NodeCount);

End;

 { ====================================================================== }
 { Delete a node from the list }

Procedure DelNode(Target:NodeRecP);
Begin

 DelNUsersH(Target);
 If Target^.Pinging
   then AbortPing(Target,'Node vanished');
 Rdb_DelNode(Target);
 Target^.PrevP^ := Target^.Next;
 If Assigned(Target^.Next)
   then Target^.Next^.PrevP := Target^.PrevP;
 Dec(NodeCount);
 Dec(Target^.Via^.Routes);
 Dispose(Target);

End;

 { ====================================================================== }
 { Find a record from the node list }

Function GetNode(Const Call:CallRec):NodeRecP;
Var p : NodeRecP;
Begin
 p := Nodes;
 While Assigned(p) and (p^.Call <> Call)
   do p := p^.Next;
 GetNode := p;
End;

 { ====================================================================== }
 { Add an user to the list }

Procedure NewNUser(Const Uusi:NUserRecP);
Var EdP : NUserRecPP;
    p   : NUserRecP;
Begin
 EdP := @Users;
 p := Users;
 While Assigned(p) and StrOrd(p^.Call,Uusi^.Call)
   do Begin
      EdP := @EdP^^.Next;
      p := p^.Next;
      End;

 EdP^ := Uusi;
 Uusi^.PrevP := EdP;
 Uusi^.Next := p;
 If Assigned(Uusi^.Next)
   then Uusi^.Next^.PrevP := @Uusi^.Next;

 Inc(NUserCount);
 Inc(KUserCount);
 If NUserCount > MaxUsers { High water mark }
   then MaxUsers := NUserCount;

End;

 { ====================================================================== }
 { Find a record from the user list }

Function GetNUser(Const Call:CallRec):NUserRecP;
Var p : NUserRecP;
Begin
 p := Users;
 While Assigned(p) and (p^.Call <> Call) do p := p^.Next;
 GetNUser := p;
End;

Function GetNUserH(Const Call:CallRec;Pc:NodeRecP):NUserRecP;
Var p : NUserRecP;
Begin
 p := Users;
 While Assigned(p) and not ((p^.Call = Call) and (p^.Pc = Pc)) do p := p^.Next;
 GetNUserH := p;
End;

{
Function MatchLen(Const s1, s2:String):Byte;
Var
  b, m, l : Byte;
Begin

  b := 0; m := 0; l := 0;
  While (b < Length(m)) and (b < Length(s2))
   do Begin
      Inc(b);
      If (s1[m] = s2[b])
        then Begin
             Inc(m);
             If m > l then l := m;
             End
        else m := 0;
      End;

  MatchLen := l;

End;
}

Function GuessNUser(var Call:CallRec):NUserRecP;
Var
  u, p : NUserRecP;
  b    : Byte;
  m    : Word;
Begin
 p := Users;
 m := 0;
 b := Length(Call);
 If b <> 0 then
 While Assigned(p)
  do Begin
     { Match against the _end_ of the call: Copy(p^.Call,Length(p^.Call) - b + 1,b) = Call }
     { Match substring: }
     If Pos(Call, p^.Call) > 0
       then Begin
            If Call = p^.Call
             then Begin { Whoa, exact match! Accept this, even if there are others }
                   GuessNUser := p;
                   Exit;
                   End;
            Inc(m);
            u := p;
            End;
     p := p^.Next;
     End;
 If m = 1
   then Begin { Exactly one match }
        GuessNUser := u;
        Call := u^.Call;
        End
   else GuessNUser := nil;
End;

 { ====================================================================== }
 { Get a link for the destination call }

Function GetLink(Call:CallRec):LinkRecP;
Var
  l : LinkRecP;
Begin

 l := Links;
 While assigned(l) and not (l^.Call = Call)
  do l := l^.Next;

 GetLink := l;

End;

 { ====================================================================== }
 { How many links we have active, and how many held }

Function  PCLinks:Byte;
Var
  l : LinkRecP;
  b : Byte;
Begin

 b := 0;
 l := Links;
 While assigned(l)
   do Begin
      If l^.State = LS_Linked
        then Inc(b);
      l := l^.Next;
      End;

 PCLinks := b;

End;

Function  PCLinksH:Byte;
Var
  l : LinkRecP;
  b : Byte;
Begin

 b := 0;
 l := Links;
 While assigned(l)
   do Begin
      If l^.State = LS_Held
        then Inc(b);
      l := l^.Next;
      End;

 PCLinksH := b;

End;

 { ====================================================================== }
 { Calculate the total users count NUserCount, based on the node list }

Procedure CountUsers;
Var n : NodeRecP;
Begin
 NUserCount := 0;
 n := Nodes;
 While Assigned(n)
  do Begin
     NUserCount := NUserCount + n^.Users;
     n := n^.Next;
     End;
 If NUserCount > MaxUsers { High water mark }
   then MaxUsers := NUserCount;
End;

 { ====================================================================== }
 { Clear node table locks }

Procedure ClearNLocks;
Var n : NodeRecP;
Begin
 n := Nodes;
 While Assigned(n)
   do Begin
      n^.Locked := False;
      n := n^.Next;
      End;
End;

 { ====================================================================== }
 { Get link failure reason as a string }

Function  drStr(reason:DReasonT):String;
Const
  dStrs : Array[DR_Unknown..DR_Held] of String[15]
        = ('hard disconnect', 'never connected', 'by sysop',
           'remote request',  'loop detected',   'ping timeout', 'link held');
Begin

 If (reason >= DR_Unknown) and (reason <= DR_Held)
   then drStr := dStrs[reason]
   else drStr := 'weird ' + Int2Str(Byte(reason));

End;

 { ====================================================================== }
 { Drops all users and nodes behind a link }

Procedure DropRoutes(l:LinkRecP);
Var
  h, n : NodeRecP;
  s    : String;
Begin

 With l^
  do Begin
     s := Int2Str(Routes) + ' nodes vanished due to link failure';
     SendAll(M_Node,1,s + ' ' + TimeStrS(now) + 'Z.' + Cr);
     SendAll(M_Node,2,s + '.' + Cr);

     h := Nodes;
     While assigned(h)
       do Begin
          n := h^.Next;
          If h^.Via = l
            then Begin
                 PCHops := 0;
                 PcLink.Delnode(h,CluCall + ' <> ' + Call + ' link failed');
                 DelNode(h);                         { Remove from the list }
                 End;
          h := n;
          End;

     l^.Routes := 0;
     End;

 CountUsers;  { Calculate total users }

End;

 { ====================================================================== }
 {  L I N K   H A N D L I N G                                             }
 { ====================================================================== }

Procedure Login(p:Byte;l:LinkRecP);
Begin

 With l^
  do Begin
     If (State = LS_Disc) or (State = LS_Held)
       then Begin
            With BPQ.Sock[p]^
             do Begin
                Usr_InActive := 0;
                Link_InActive := 0;
                Paclen := 230;
                CharSet := l^.CharSet;
                If l^.Traced
                  then Begin
                       Traced := True;
                       Tracefile := Call + '.trc';
                       End;
                End;

            Port[p] := l;
            Sock := p;

            If State = LS_Held
              then Disconnect(p) { Held }
              else Begin
                   State := LS_Init;
                   SendLoopCheck(p);
                   SendCluID(p);
                   End;
            End
       else Begin { Whoa, duplikaatti! Katkaistaan molemmat... }
            DReason := DR_Held;
            Disconnect(p);
            Disconnect(Sock);
            End;
     End;

End;

 { ====================================================================== }
 { Initiate a link }

Procedure StartLink(l:LinkRecP);
Begin

 With l^
  do Begin
     State := LS_Init;
     LastTry := 0;
     Inc(Tries);
     Log(L_Link,'Trying to link ' + Call + '.');
     StartConnect(Script,Proto,l,LTimeOut);
     End;

End;

 { ====================================================================== }
 { Initiate all links that are disconnected at the moment }

Procedure StartLinks;
Var
  l : LinkRecP;
Begin

 l := Links;
 While assigned(l)
  do Begin
     If (l^.State = LS_Disc) and (l^.Mode <> LM_Incoming)
       then StartLink(l);
     l := l^.Next;
     End;

End;

 { ====================================================================== }
 { A link has been finished }

Procedure LinkMade(l:LinkRecP);
Begin

 With l^
  do Begin
     Action(66,'Linked to ' + Call);
     Log(L_Link,'Linked to ' + Call);
     WriteLast('Linker', DateStrSPad(now) + ' ' + TimeStrS(now) + ' - '
             + 'Linked to ' + Call);
     Cluster.LinkAdd(Call);
     State := LS_Linked;
     DReason := DR_Unknown;
     BPQ.Sock[Sock]^.Mode := SM_PCLink;
     Since := now;
     Tries := 0;
     PCBeaconTimer := 0;
     PingTimer := 0;
     If Mode <> LM_Incoming
       then EndConnect(Sock);
     End;

End;

 { ====================================================================== }
 { Drop all links immediately }

Procedure CutLinks(Method:CutLinkType;Const Reason:String);
Var
  l : LinkRecP;
Begin

 l := Links;
 While assigned(l)
  do Begin
     With l^ do If (State = LS_Init) or (State = LS_Linked)
    then Begin
         DReason := DR_Sysop;
         If (Method = rude) or (State = LS_Init) or (Mode = LM_Listen)
           then Disconnect(Sock)
           else Begin
                Send(Sock,'PC39^' + MyCall + '^' + Reason + '^' + Cr);
                Kick(Sock);
                End;
         If Tries = 0 then Inc(Tries); { Ettei seuraavalla minuutilla... }
         End;
     l := l^.Next;
     End;
End;

 { ====================================================================== }
 { Link has been disconnected 8-( }

Procedure Logout(p:Byte);
Var
  i : Byte;
Begin

 If Assigned(Port[p]) then
 With Port[p]^
  do Begin
     If State = LS_Held
       then Action(66,'Refused link from ' + Call)
       else Begin
            Action(66,'Disconnected ' + Int2Str(p));
            If State <> LS_Init
              then Begin
                   Log(L_Link,'Link to ' + Call + ' failed (' + drStr(DReason) + ').');
                   WriteLast('Linker', DateStrSPad(now) + ' ' + TimeStrS(now) + ' - '
                             + 'Link to ' + Call + ' failed.');
                   Cluster.LinkDelete(Call,DReason);
                   End;
            State := LS_Disc;
            End;

     DropRoutes(Port[p]);
     Inc(Failures);
     Since := now;
     Sock := 0;
     If Tries = 0
       then LastTry := TryAfter - 1
       else Begin
            LastTry := 0;
            If assigned(Backup)
             then Begin
                  State := LS_Backuped;
                  Backup^.State := LS_Disc;
                  End;
            End;
     End;

End;

 { ====================================================================== }
 {  U S E R   C O M M A N D S                                             }
 { ====================================================================== }

Procedure Nodelist_Cmd(p:Byte);
Var
  nL : NodeRecP;
  nR : NodeRecP;
  b  : Byte;
  l  : Byte;
  st : String[80];

 Function NodeEntry(n:NodeRecP):String;
 Var s : String[40];
 Begin
  With n^
     do Begin
        s := PadLeft(10,Call);
        If Assigned(Via)
          then s := s + PadLeft(10,Via^.Call)
          else s := s + '          ';
        If Here then s := s + 'H'
                else s := s + ' ';
        If Users = 0 then s := s + ' -   '
                     else s := s + ' ' + PadLeft(4,Int2Str(Users));
        If HopsOK then s := s + PadLeft(4,Int2Str(Hops))
                  else s := s + '-   ';
        If RttOK  then s := s + PadRight(3,Secs2StrS(Rtt))
                  else If Pinging
                         then s := s + ' ? '
                         else s := s + ' - ';
        s := s + ' ' + Int2Str(Ver);
        End;
  NodeEntry := s;
 End;

Begin

 Send(p,'Call      Via       H Usr Hop Rtt Ver');
 If NodeCount > 1
   then Send(p,'  Call      Via       H Usr Hop Rtt Ver' + Cr)
   else Send(p,Cr);
 nL := Nodes;
 nR := Nodes;
 l := NodeCount div 2;
 If Odd(NodeCount) and (NodeCount > 1) then l := l + 1;
 For b := 1 to l
   do nR := nR^.Next;
 If nL = nR then nR := nil;

 b := 0;
 Repeat

  Inc(b);

  If Assigned(nL)
   then Begin
        st := PadLeft(38,NodeEntry(nL));
        nL := nL^.Next;
        End;
  Inc(b);

  If Assigned(nR)
   then Begin
        st := st + ' ' + NodeEntry(nR);
        nR := nR^.Next;
        End;

  Send(p,st + Cr);

 Until (b >= NodeCount) or not assigned(nL);

End;

 { ====================================================================== }

Procedure nRoutes_Cmd(p:Byte);
Var
  l : LinkRecP;
  s : String;
  h : NodeRecP;
Begin

 Action(p,'Route list');
 Send(p,'Route list: ' + Int2Str(PCLinks) + ' links, ' + Int2Str(NodeCount) + ' nodes.' + Cr
      + 'Link      Routes' + Cr);
 l := Links;
 While assigned(l)
  do Begin
     With l^ do
     If (State = LS_Linked)
     then Begin
          s := PadLeft(10,Call) + '(' + Int2Str(Routes) + ')';
          If Mode = LM_Listen then s := s + ' (Listening)';

          h := Nodes;
          While assigned(h)
           do Begin
              If Length(s) > 67
                then Begin
                     Send(p,s + Cr);
                     s := '         ';
                     End;
              If h^.Via = l
                then s  := s + ' ' + h^.Call;
              h := h^.Next;
              End;
          Send(p,s + Cr);
          End;
     l := l^.Next;
     End;

End;

 { ====================================================================== }

Procedure NodeInfo_Cmd(p:Byte;Const Call:CallRec);
Var
 n   : NodeRecP;
 nf  : NodeFP;
 s   : String;
Begin

 Action(p,'Node ' + Call + ' info');
 n := GetNode(Call);

 If assigned(n)
  then Begin
       If Assigned(n^.Via)
         then Begin
              s := 'Linked via ' + n^.Via^.Call + ' since ' + DateStrS(n^.Since)
                   + ' ' + TimeStrS(n^.Since) + 'Z, ';
                   If n^.HopsOK then s := s + Int2Str(n^.Hops) + ' hops, ';
              End
         else s := '';

       s := s + Int2Str(n^.Users) + ' users';
       If (not n^.UsersOK) then s := s + ' (?)';
       s := s + ', PC version ' + Int2Str(n^.Ver) + ', RTT ';
       If n^.Pinging
         then s := s + 'is being measured.'
         else If n^.RttOK
                then s := s + Secs2Str(n^.Rtt) + '.'
                else s := s + 'not measured.';
       Send(p,Format(True,'Node ' + n^.Call + ':',s));
       End
  else Begin
       nf := ReadNode(Call);
       If Assigned(nf)
         then Begin
              s := 'Last seen ' + DateStrS(nf^.Time) + ' ' + TimeStrS(nf^.Time)
                 + 'Z via ' + nf^.Via + '. ';
              If nf^.HopsOK then s := s + Int2Str(nf^.Hops) + ' hops, ';
              s := s + 'PC version ' + Int2Str(nf^.Ver);
              If nf^.Rtt >= 0 then s := s + ', RTT ' + Secs2Str(nf^.Rtt);
              s := s + '.';
              Send(p,Format(True,'Node ' + nf^.Call + ':',s));
              Dispose(nf);
              End
         else Send(p,'Sorry, node ' + Call + ' not found.' + Cr);
       End;

End;

 { ====================================================================== }

Procedure PrintLink(p:Byte;l:LinkRecP);
Const
  StateStr : Array[LS_Disc..LS_Held] of String[7] = ('Disc   ','Init   ','Linked ','Backup ','Held   ');
  ModeStr  : Array[LM_Normal..LM_Incoming] of String[7] = ('Normal ','Listen ', 'In     ');
Begin

  With l^
   do Begin
      Send(p,' ' + PadLeft(9,Call) + ModeStr[Mode] + StateStr[State]
           + PadLeft(6,DateStrS(Since)) + PadLeft(6,TimeStrS(Since) + 'Z '));

      If (State <> LS_Linked) and (Mode <> LM_Incoming)
        then Send(p,PadLeft(6,Int2Str(Tries)))
        else Send(p,'-     ');

      If (State = LS_Disc) and (Mode <> LM_Incoming)
        then Send(p,PadLeft(5,Int2Str(TryAfter - LastTry) + 'm'))
        else Send(p,'-    ');

      Send(p,PadLeft(6,Int2Str(Failures)) + PadLeft(5,Int2Str(Stream[Sock]))
           + PadLeft(5,Int2Str(Ver)));

      If (State = LS_Init) or (State = LS_Linked)
        then Send(p,PadRight(4,Bytes2Str(BPQ.Sock[Sock]^.Tx))
                  + PadRight(5,Bytes2Str(BPQ.Sock[Sock]^.Rx)));

      Send(p,Cr);
      End;

End;

Procedure Linklist_Cmd(p:Byte);    { Lista linkeist }
Var
  l : LinkRecP;
Begin

 If PCLinksC > 0 then
    Begin
    Send(p,' Callsign Mode   State  Since       Tries Next Fails St   Ver  Tx   Rx' + Cr);
    l := Links;
    While assigned(l)
     do Begin
        PrintLink(p,l);
        l := l^.Next;
        End;

    End;

End;

 { ====================================================================== }

Procedure Link_Cmd(p:Byte);  { Modify link settings }
Var
  Cmd  : String;
  Call : CallRec;
  l    : LinkRecP;
Begin

 Cmd := Parse(1);
 Call := UpCaseStr(Parse(2));
 l := GetLink(Call);

 If Assigned(l)
   then Begin
        With l^ do
        Case LowCaseCh[Cmd[1]] of

          'h' : Begin { Hold }
                Action(p,'Held link to ' + Call);
                If (State = LS_Init) or (State = LS_Linked)
                  then Begin
                       DReason := DR_Sysop;
                       Disconnect(Sock);
                       Send(p,'Disconnecting... ');
                       End;
                State := LS_Held;
                Send(p,'Link held.' + Cr);
                End;

          'd' : Begin { Disconnect }
                If (State = LS_Init) or (State = LS_Linked)
                  then Begin
                       Send(p,'Disconnecting...' + Cr);
                       DReason := DR_Sysop;
                       Disconnect(Sock);
                       Action(p,'Disconnected link to ' + Call);
                       End
                  else Send(p,'Already disconnected.' + Cr);
                End;

          'c' : Begin { Connect }
                If not ((State = LS_Init) or (State = LS_Linked))
                  then Begin
                       State := LS_DIsc;
                       If not (Mode = LM_Incoming)
                         then Begin
                              Action(p,'Initiated link to ' + Call);
                              StartLink(l);
                              Send(p,'Linking...' + Cr);
                              End
                         else Begin
                              Action(p,'Unheld link to ' + Call);
                              Send(p,'Link unheld.' + Cr);
                              End;
                       End
                  else Send(p,'Already linked or linking.' + Cr);
                End;

        End;
        End
   else LinkList_Cmd(p);

End;

 { ====================================================================== }

Procedure Userlist_Cmd(p:Byte);
Var
  b : Byte;
  s : String;
  n : NodeRecP;
  u : NUserRecP;
Begin

 Send(p,'Node      Users' + Cr);

 n := Nodes;
 While Assigned(n)
  do Begin
     If n^.UsersK and (n^.Users > 0)
      then Begin { node }
           s := PadLeft(10,n^.Call);
           If n^.UsersOK
             then s := s + '(' + Int2Str(n^.Users) + ')'
             else s := s + '<' + Int2Str(n^.Users) + '>';
           u := Users;
           While Assigned(u)
            do Begin
               If (u^.PC = n)
                 then Begin
                    If (Length(s) > 65) then Begin
                                             Send(p,s + Cr);
                                             s := '         ';
                                             End;
                    s := s + ' ';
                    If not u^.Here then s := s + '(';
                    If CUserFound(LowCaseStr(u^.Call))
                      then s := s + LowCaseStr(u^.Call)
                      else s := s + u^.Call;
                    If not u^.Here then s := s + ')';
                    If u^.Sysop then s := s + '!'
                      else If u^.Privileged then s := s + '@';

                    End;
               u := u^.Next;
               End;
           Send(p,s + Cr);
           End;
     n := n^.Next;
     End;

End;

 { ====================================================================== }

Procedure UserlistH_Cmd(p:Byte;n:NodeRecP);
Var
  b : Byte;
  s : String;
  u : NUserRecP;
Begin

 Send(p,'Users at node ' + n^.Call + ': ' + Int2Str(n^.Users) + Cr);

 If not n^.UsersK
   then Send(p,'User list for the node is not available.' + Cr)
   else
 If (n^.Users > 0)
   then Begin { node }
        s := '';
        u := Users;
        While Assigned(u)
         do Begin
            If (u^.PC = n)
              then Begin
                   If (Length(s) > 65)
                     then Begin
                          s := s + CR;
                          Send(p,s);
                          s := '';
                          End;

                    s := s + ' ';
                    If not u^.Here then s := s + '(';
                    If CUserFound(LowCaseStr(u^.Call))
                      then s := s + LowCaseStr(u^.Call)
                      else s := s + u^.Call;
                    If not u^.Here then s := s + ')';
                    If u^.Sysop then s := s + '!'
                      else If u^.Privileged then s := s + '@';

                   End;
            u := u^.Next;
            End;
        Send(p,s + Cr);
        End;

End;

 { ====================================================================== }

Procedure ProtocolStatus_Cmd(p:Byte);        { Protocol statistics }
Var x, y : Byte;
Begin

 Action(p,'PC Protocol statistics');
 Send(p,'PC Protocol statistics: ' + Int2Str(PCReceived) + ' messages received, ' + Int2Str(PCUnknown)
      + ' unknown, ' + Int2Str(PCInvalid) + ' invalid.' + Cr);

 Send(p,' Details:   0      1      2      3      4      5      6      7      8      9' + Cr
      + ' ---------------------------------------------------------------------------');
 For y := 1 to 5
   do Begin
      Send(p,Cr + ' ' + PadLeft(3,Int2Str(y * 10)) + ': ');
      For x := 0 to 9
        do Send(p,PadRight(7,Int2Str(PCMsgStats[y * 10 + x])));
      End;
 Send(p,  Cr
        + 'Uptime: ' + Secs2Str(UpTime) + ' - since ' + DateStrS(StartUpTime) + ' '
        + TimeStrL(StartUpTime) + Cr);

End;

 { ====================================================================== }

Procedure Merge_Cmd(p:Byte);
Var
  DxC, WwvC : Byte;
  n         : NodeRecP;
Begin

  n := GetNode(UpCaseStr(Parse(1)));

  if (n = nil)
    then Begin
         Send(p, 'Node ' + Parse(1) + ' not found.' + Cr);
         Exit;
         End;

  DxC := Str2Byte(Parse(2));
  WwvC := Str2Byte(Parse(3));

  if (DxC = 0) and (WwvC = 0)
    then Begin
         Send(p, 'You must merge at least one DX or WWV spot.' + Cr);
         Exit;
         End;

  PC_RequestMerge(n, DxC, WwvC);
  Send(p,'Merging ' + Int2Str(DxC) + ' DX and ' + Int2Str(WwvC) + ' WWV spots from ' + n^.Call + '.' + Cr);

End;

 { ====================================================================== }
 {  P I N G E R                                                           }
 { ====================================================================== }

Procedure AddPing(Pc:NodeRecP;FromCall:CallRec;MaxTime:Word);
Var
  PingPrev  : ^PingRecP;
  PingP     : PingRecP;
Begin

 Action(68,FromCall + ' pings ' + Pc^.Call);
 Pc^.Pinging := True;

 PingP := PingQueue;
 PingPrev := @PingQueue;
 While Assigned(PingP)
   do Begin
      PingPrev := @PingP^.Next;
      PingP := PingP^.Next;
      End;

 New(PingP);
 Inc(PingJobs);
 PingPrev^ := PingP;

 PingP^.PingedBy := FromCall;
 PingP^.Time := 0;
 PingP^.MaxTime := MaxTime;
 PingP^.Pc := Pc;
 PingP^.Next := nil;

 SendPC(Pc,'PC51^' + Pc^.Call + '^' + Pc^.Via^.MyCall + '^1^' + Cr);

End;

 { ====================================================================== }

Procedure RemovePing(Pc:NodeRecP);
Var
  p, prev, next : PingRecP;
Begin

 p := PingQueue;
 prev := p;

 { Etsitn Pc }
 While Assigned(p) and (p^.Pc <> Pc)
   do Begin
      prev := p;
      p := p^.Next;
      End;

 If Assigned(p)
   then Begin { Lytyi }
        next := p^.Next;
        Dispose(p);
        Dec(PingJobs);
        If p = PingQueue
          then PingQueue := next
          else prev^.Next := next;
        End;

End;

 { ====================================================================== }

Procedure Ping_Cmd(p:Byte);
Var
  n     : NodeRecP;
  Call  : CallRec;
Begin

 Call := UpCaseStr(Parse(1));

 n := GetNode(Call);

 If assigned(n) { Onko nodea }
   then If n^.Pinging
          then Send(p,'Node ' + Call + ' is already being pinged.' + Cr)
          else If (n = LocalNode)
                 then Send(p,'Cannot ping local node. The RTT is 0 anyway...' + Cr)
                 else Begin
                      Send(p,'Pinging ' + Call + '...' + Cr);
                      AddPing(n,LUser[p]^.f^.Call,PingTimeout);
                      End
   else Send(p,'Node ' + Call + ' not found.' + Cr)

End;

 { ====================================================================== }

Procedure PStat_Cmd(p:Byte);
Var
 Ping : PingRecP;
Begin

 Action(p,'Pinger status');
 Send(p,'Pinging:' + Cr);
 If Assigned(PingQueue)
   then Begin
        Ping := PingQueue;
        Send(p,'Node      From      Time' + Cr);
        Repeat
        Send(p,PadLeft(10,Ping^.Pc^.Call) +
        PadLeft(10,Ping^.PingedBy) + Secs2Str(Ping^.Time) + Cr);
        Ping := Ping^.Next;
        until not assigned(Ping);
        End
   else Send(p,'None.' + Cr);

End;

 { ====================================================================== }

Procedure AbortPing(Pc:NodeRecP;Const Reason:String);
Var
  PointPrev,
  Point        : PingRecP;
  up           : Byte;
Begin

 Point := PingQueue; { Onko pingattavana }
 PointPrev := Point;

 While Assigned(Point) and (Point^.Pc <> Pc)
   do Begin { Etsitn pingrec }
      PointPrev := Point;
      Point := Point^.Next;
      End;

 If Assigned(Point) { Lytyik }
   then Begin { Tadaa. }
        up := GetLUser(Point^.PingedBy);
        If (up < 255) and (not LUser[up]^.Locked)
          then Begin
               Send(up,'Ping ' + Point^.Pc^.Call + ' failed - ' + Reason + Cr);
               Kick(up);
               End;
        RemovePing(Pc);
        End;

End;

 { ====================================================================== }
 {  C L U S T E R   E V E N T S                                           }
 { ====================================================================== }

 { Set additional information for user }

Procedure SetUserData(n:NUserRecP;FromL:LinkRecP;Const UserCall:CallRec;b:Byte;Const Data:String);
Var
 fp : NUserFP;
Begin

 If not ValidCall(UserCall)
  then Exit;

 fp := ReadNUser(UserCall);
 If not Assigned(fp)
   then Begin
        New(fp);
        With fp^
         do Begin
            Call := UserCall;
            PC := '';
            PCQuality := 0;
            Name := '';
            QTH := '';
            Index := 0;
            End;
        End;

  Case b of
    1: Begin
       fp^.Name := Data;
       If Assigned(FromL)
         then Action(67,fp^.Call + '''s name set to ' + Data);
       End;
    2: Begin
       fp^.QTH := Data;
       If Assigned(FromL)
         then Action(67,fp^.Call + '''s QTH set to ' + Data);
       End;
    4: If (fp^.PCQuality <= 7) and (Data <> fp^.PC)
         then Begin { Parempi tieto kotinodesta }
              fp^.PC := Data;
              fp^.PCQuality := 7;
              If Assigned(FromL)
                then Action(67,fp^.Call + '''s home node set to ' + Data);
              End;
  End;

 If Assigned(n)
   then n^.Name := fp^.Name;

 WriteNUser(fp);
 Dispose(fp);

 If not listened
   then PCLink.SetUserData(FromL,UserCall,b,Data);

End;

 { ====================================================================== }
 { Set the home node in the network user file, if necessary }

Procedure SetHomeNode(n:NUserRecP;UserCall,PC:CallRec;Q:Byte);
Var
 fp : NUserFP;
Begin

 If not (ValidCall(UserCall) and ValidCall(PC))
   then Exit;

 fp := ReadNUser(UserCall);

 If not Assigned(fp)
   then Begin
        New(fp);
        With fp^
         do Begin
            PC := '';
            PCQuality := 0;
            Call := UserCall;
            Name := '';
            QTH := '';
            Index := 0;
            End;
        End;

 If (fp^.PCQuality <= q)
   then Begin { Parempi tieto kotinodesta }
        fp^.PC := PC;
        fp^.PCQuality := q;
        WriteNUser(fp);
        End;

 If assigned(n)
   then n^.Name := fp^.Name;

 Dispose(fp);

End;

 { ====================================================================== }
 { Talk routing ... this is pretty complicated, but don't blame me for
   it! I didn't desing this! 8-)                                          }

Procedure Talk(Info:TalkRec);
Var p     : Byte;
    TInfo : TalkRec;
    u     : NUserRecP;
    h     : NodeRecP;
    s     : String[6];

   Procedure TalkBack(From:Byte); { Send a message to the sender }
   Begin
     TInfo.Time := Now;
     Case From of
       0 : TInfo.FromCall := CluCall;
       1 : TInfo.FromCall := Info.ToCall;
     End;
     TInfo.FromPc := CluCall;
     TInfo.ToCall := Info.FromCall;
     TInfo.ToPc := GetNode(Info.FromPC);
     TInfo.FromLink := nil;
     Talk(TInfo);
   End;

Begin

 If (Info.FromCall <> CluCall)
   then Begin
        Action(67,'Talk ' + Info.FromCall + ' > ' + Info.ToCall + ': ' + Info.Msg);
        SetHomeNode(nil,Info.FromCall,Info.FromPc,2);
        End;

 If Info.ToPC = localNode
  then Begin { This one is to a local user }
       If (Info.ToCall = CluCall) { Is this a message to the local node itself }
         then Begin
              If (Pos('away:',LowCaseStr(Info.Msg)) = 0) { Detect away talkback loops }
                 and (GetNode(Info.FromCall) = nil)      { and node<>node talk loops }
               then Begin
                     Case LowCaseCh[Info.Msg[1]] of { Remote commands... }
                       'e' : TInfo.Msg := Info.Msg; { echo }
                       's' : TInfo.Msg := 'The sysop of this node is ' + Conf^.Adm.SysopCall;
                       't' : TInfo.Msg := TimeStr(Now) + ', uptime ' + Secs2Str(UpTime);
                       'q' : TInfo.Msg := Conf^.QTHLoc;
                       '%',
                       'm' : TInfo.Msg := 'Mem fr ' + Int2Str(MaxAvail) + ' us ' + Int2Str(HeapUsed)
                                        + ' b, ' + Int2Str(HeapAllocs) + ' allocs.';
                       'h',  { Help }
                       '?' : TInfo.Msg := 'Commands: Echo Memory Qth Sysop Time Version';
                     else TInfo.Msg := 'Clusse ' + Versio + ' (' + CompileDate + ')';
                     End;
                    TalkBack(0);
                    End;
              End
         else Begin { Okay, this one is to a local user }
              p := GetLUser(Info.ToCall);
              If p <= UsrPorts
                then Begin { The user is logged on }
                     If (M_Talk in LUser[p]^.f^.Messages) and not LUser[p]^.Locked{ Does he accept talk messages }
                       then Begin
                            If (f_Beeps in LUser[p]^.f^.Flags) and (M_Talk in LUser[p]^.f^.Beeps)
                               and not ((LUser[p]^.M2 = 1) and (Copy(LUser[p]^.Str,1,Length(Info.FromCall)) = Info.FromCall))
                              then Send(p,Chr(7)); { Send him a beep, if he wants beeps and he is not in talk mode
                                                     with the sender of this message }
                            If f_Timestamp in LUser[p]^.f^.Flags { Timestamping }
                              then s := ' ' + TimeStrS(Info.Time) + 'Z'
                              else s := '';
                            Send(p,Format(True,Info.FromCall + ' talks' + s + ':',Info.Msg));
                            LUser[p]^.LastTalkFrom := Info.FromCall + '@' + Info.FromPC; { For TReply }
                            If Assigned(LUser[p]^.AwayStrP) and (Info.FromCall <> Info.ToCall)
                                and (Pos('away:',LowCaseStr(Info.Msg)) = 0)
                              then Begin { User is away, notify the sender }
                                   TInfo.Msg := 'I''m away: ' + LUser[p]^.AwayStrP^;
                                   TInfo.FromCall := LUser[p]^.f^.Call;
                                   TalkBack(1);
                                   End;
                            End
                       else Begin { User has disabled talk }
                            If LUser[p]^.Locked
                              then TInfo.Msg := 'User ' + Info.ToCall + ' is not able to talk right now.'
                              else TInfo.Msg := 'User ' + Info.ToCall + ' has disabled Talk messages.';
                            TalkBack(0);
                            End;
                     End
                else Begin { The user is not logged on }
                     If (Info.ToCall = CluCall) and (Info.FromCall = CluCall)
                       then Exit; { Catch a local loop (would cause a stack overflow) }
                     u := GetNUser(Info.ToCall);
                     If Assigned(u) and (u^.PC^.Via <> Info.FromLink) { Never route back, might loop }
                       then Begin { Forward the message to another cluster node (should check for loops!) }
                            Info.ToPc := u^.Pc;
                            PCLink.Talk(@Info);
                            End
                       else If (GetNode(Info.FromCall) = nil) { Don't talkback to a node, it might LOOP! }
                              then Begin { User is not on the node table }
                                   TInfo.Msg := 'User ' + Info.ToCall + ' is not known here.';
                                   TalkBack(0);
                                   End;
                     End;
             End;
       End
  else PCLink.Talk(@Info); { Route the message }

End;

 { ====================================================================== }

Function Dx(Info:DxInfoP):Boolean;        { DX }
Type
  St4Type  = Array[0..3] of Char;
  St4pType = ^St4Type;
Var
  Midi     : MidType;
  St4p     : St4pType;
  w        : Word;
Begin

 { Dupe checking }
 Midi[0] := #10;
 Midi[1] := #11;
 Move(Info^.Time,Midi[2],4);
 Move(Info^.Freq,Midi[6],4);
 w := CRC16Seed;
 Crc16l(@Info^.Call,Length(Info^.Call)+1,w);
 Midi[10] := Chr(w and $ff);

 If (Info^.Freq > 0) and ValidCall(Info^.FromCall) and ValidCall(Info^.FromPc)
    and MidCheck(Midi)
  then Begin
       NewMid(Midi); { New one, add to the Message ID table }
       Inc(Index.Dx);
       If Index.Dx >= 10000 then Index.Dx := 1; { Wraparound }
       Info^.Num := Index.Dx;

       Action(67,'DX de ' + Info^.FromCall + ': '
                  + Freq2Str(Info^.Freq) + ' ' + Info^.Call);

       UI_Dx(Info);      { Broadcast }
       Cluster.Dx(Info); { Notify the local users }
       If not Listened then PcLink.Dx(Info);  { Route }

       WriteDx(Info);    { Write to file }
       SetHomeNode(nil,Info^.FromCall,Info^.FromPc,2);

       If Conf^.Sound.SoundHW <> SHW_None
         then Speech.Dx(Info^.Freq,Info^.Call);

       Dx := True;
       End
  else Dx := False;
 Dispose(Info);

End;

 { ====================================================================== }

Procedure Announce(Info:AnnP);   { Announce }
Begin

 If ValidCall(Info^.FromCall) and ValidCall(Info^.FromPC)
  then Begin
       Inc(Index.Ann);
       If Index.Ann >= 10000 then Index.Ann := 1;
       Info^.Num := Index.Ann;

       Action(67,Info^.FromCall + ' shouts @' + Info^.ToPC + ': ' + Info^.Msg);

       If (Info^.ToPC = '*') or (Info^.ToPC = CluCall)
         then Begin
              Cluster.Announce(Info); { Notify local users }
              If not (Info^.Wx or Info^.Sysop)
                then Begin
                     UI_Ann(Info);   { Broadcast }
                     WriteAnn(Info); { Write to file }
                     End;
              End;

       If not Listened then PCLink.Announce(Info); { Route it to other links }
       SetHomeNode(nil,Info^.FromCall,Info^.FromPc,2);
       End;

 Dispose(Info);

End;

 { ====================================================================== }

Procedure WWV(Info:WWVRec);        { WWV }
Type
  St4Type  = Array[0..3] of Char;
  St4pType = ^St4Type;
Var
  b    : byte;
  dat  : DateTime;
  Midi : MidType;
  Arr  : Array[1..4] of Byte;
  St4p : St4pType;
Begin

 UnPackTime(Info.Time,Dat);
 Arr[1] := Dat.Day;
 Arr[2] := Dat.Month;
 Arr[3] := Dat.Year - 1900;
 Arr[4] := Info.Hour;
 St4p := @Arr;

 Midi := #23 + St4p^;
 If MidCheck(Midi)
  then Begin
       NewMid(Midi);
       Inc(Index.WWV);
       If Index.WWV >= 10000 then Index.WWV := 1;
       Info.Num := Index.WWV;

       Action(67,'WWW for hour ' + Int2Str(Info.Hour) + ' de ' + Info.FromCall);

       UI_Wwv(@Info);     { Broadcast }
       Cluster.WWV(Info); { Local users }
       If not Listened then PCLink.WWV(@Info); { Links }
       WriteWWV(@Info);   { File }
       SetHomeNode(nil,Info.FromCall,Info.FromPc,2);
       End;

End;

 { ====================================================================== }
 { User went away or came back }

Procedure SetHere(FromL:LinkRecP;Const Call:Callrec);
var
  u : NUserRecP;
  s : String[4];
Begin

 u := GetNUser(Call);
 if Assigned(u) and not (Assigned(FromL) and (u^.Pc = LocalNode)) and (u^.Here = False)
  then Begin
       u^.Here := True;
       u^.AwayTime := Now;
       If Assigned(u^.AwayStrP)
         then Begin
              Dispose(u^.AwayStrP);
              u^.AwayStrP := nil;
              Dec(NAwayStrings);
              End;
       Action(67,Call + ' came back.');
       Cluster.UserHere(u);
       If PCHops <= 98
         then SendPCAll(FromL,'PC24^' + Call + '^1^' + Hops2PCStr + '^' + Cr);
       End;

End;

 { ====================================================================== }
 { New-type away, includes a reason string }

Procedure SetAway(FromL:LinkRecP;Const Call:Callrec;Const Reason:tAwayString);
Var
  u : NUserRecP;
Begin

 u := GetNUser(Call);
 If Assigned(u) and not (Assigned(FromL) and (u^.Pc = localNode))
  then Begin
       If Reason <> ''
        then Begin
             If not assigned(u^.AwayStrP)
               then Begin { The user might just be changing the string! }
                    New(u^.AwayStrP);
                    Inc(NAwayStrings);
                    End;
             u^.AwayStrP^ := Reason;
             Action(67,Call + ' is away: ' + Reason);
             End
        else Action(67,Call + ' is away.');

       If (u^.Here) and (u^.pc^.hops <= 98) { Only send PC24 if the user did go away for the first
                    time. Changing the away string doesn't affect the PC. }
         then SendPCAll(FromL, 'PC24^' + Call + '^0^' + Hops2PCStr + '^' + Cr);

       u^.Here := false;
       u^.AwayTime := Now;
       Cluster.UserAway(u);
       End;

End;

 { ====================================================================== }
 { Add an user }

Procedure AddUser(u:NUserRecP);
Var
 b    : Byte;
 p, n : NUserRecP;
 s    : String;
Begin

 p := u;
 s := 'PC16^' + u^.Pc^.Call;
 b := 0;

 While Assigned(p) do
 Begin

 n := p^.Next;

 If (GetNUserH(p^.Call,p^.Pc) = nil) and ValidCall(p^.Call) { Did we know him before }
  then Begin { Ahh, a new one! }
       Inc(b);
       With p^.Pc^
        do Begin
           Inc(Users);
           UsersK := True;
           End;
       NewNUser(p);
       If not (p^.PC = LocalNode) { don't do this for local users! }
         then Begin
              Action(67,p^.Call + '@' + p^.Pc^.Call + ' login');
              Log(L_NUser,p^.Call + '@' + p^.Pc^.Call + ' login');
              End;
       Cluster.UserAdd(p);
       { Spread the word }
       s := s + '^' + p^.Call + ' - ';
       If p^.Here then s := s + '1'
                  else s := s + '0';
       SetHomeNode(p,p^.Call,p^.Pc^.Call,5);
       End
  else Dispose(p); { If we don't add him to the user list, we have to
                     dispose him! I missed this at first! }
 p := n;
 End;

 If not (b = 0)
  then Begin
       s := s + '^' + Hops2PCStr + '^' + Cr;
       If PCHops <= 98
         then SendPCAll(u^.Pc^.Via,s);
       End;
End;

 { ====================================================================== }
 { Add a cluster node }

Procedure NodeAdd(h:NodeRecP);
Var
  b   : Byte;
  p,n : NodeRecP;
  s   : String;
Begin

 s := 'PC19^';
 p := h;
 b := 0;
 While assigned(p)
  do Begin
     n := p^.Next;
     If (GetNode(p^.Call) = nil)
       then Begin
            Inc(b);
            With p^.Via^
             do Begin
                Inc(Routes);
                If p^.Call = Call
                  then Begin
                       PC := p; { It's our neighbour! }
                       Ver := p^.Ver;
                       End;
                End;

            NewNode(p);

            If NodeCount > MaxNodes { high water mark }
              then MaxNodes := NodeCount;

            Action(67,'Node ' + p^.Call + ' added.');
            Cluster.NodeAdd(p); { Notify local users }
            Log(L_Node,'Node ' + p^.Call + ' added');
            If p^.Here
              then s := s + '1'
              else s := s + '0';
            s := s + '^' + p^.Call + '^0^' + Int2Str(p^.Ver) + '^';
            End
       else Dispose(p); { If we don't add it to the node list, we have to
                          dispose it. }
     p := n;
     End;

 If b > 0
   then Begin
        s := s + Hops2PCStr + '^' + Cr;
        If PCHops <= 98
          then SendPCAll(h^.Via,s);
        End;

End;

Procedure NodeDrop(h:NodeRecP;Const Reason:String);    { Drop a cluster node }
Begin

 Action(67,'Node ' + h^.Call + ' vanished');
 Cluster.NodeDelete(h^.Call,Reason); { Notify local users }
 PCLink.DelNode(h,Reason);           { Tell others }
 Log(L_Node,'Node ' + h^.Call + ' vanished');
 DelNode(h);                         { Remove from the list }
 CountUsers;                         { Calculate total users }

End;

 { ====================================================================== }
 { Remove a cluster user }

Procedure DeleteUser(FromL:LinkRecP;Const Call:CallRec;Pc:NodeRecP;Time:LongInt);
Var
  u : NUserRecP;
Begin

 If Assigned(FromL) and (Pc = LocalNode) then Exit; { Check for a loop }
 u := GetNUserH(Call,Pc);

 If assigned(u) { Do we know him }
   then Begin
        u^.Time := Time;
        Cluster.UserDelete(u);
        If Assigned(FromL)
          then Begin
               Action(67,Call + '@' + Pc^.Call + ' logout');
               Log(L_NUser,Call + '@' + Pc^.Call + ' logout');
               End;
        DelNUser(u);
        Dec(Pc^.Users);
        If PCHops <= 98
          then SendPCAll(FromL,'PC17^' + Call + '^' + Pc^.Call + '^' + Hops2PCStr + '^' + Cr);
        End;
End;

 { ====================================================================== }
 { This is called every second }

Procedure SecTimer;
Var
 Point,
 Next   : PingRecP;
Begin

 { Handle the pinger list }
 Point := PingQueue;

 While Assigned(Point)
   do Begin
      Next := Point^.Next;
      Inc(Point^.Time);
      If (Point^.Time >= Point^.MaxTime)
        then With Point^.Pc^
              do Begin
                 Action(68,Call + ' timed out');
                 Pinging := False;

                 If (Point^.Pc = Via^.Pc) { Naapuri? }
                   then With Via^
                     do Begin
                        DReason := DR_PingTO;
                        Disconnect(Sock);
                        End;
                 AbortPing(Point^.Pc,'Timeout');
                 End;
      Point := Next;
      End;

 Database.SecTimer;

End;

 { ====================================================================== }
 { This one is called once every minute }

Procedure MinTimer;
Var
  l : LinkRecP;
Begin

  l := Links;
  While assigned(l)
   do Begin
      With l^
        do Begin

      If (State = LS_Disc) and (Mode <> LM_Incoming)
        then Begin
             Inc(LastTry);
             If LastTry >= TryAfter
               then StartLink(l);
             End;

      { PC50 user count beacon }

      If (State = LS_Linked) and ((Mode = LM_Normal) or (Mode = LM_Incoming)) and not (PCBeaconInter = 0)
        then Begin
             Inc(PCBeaconTimer);
             If PCBeaconTimer = PCBeaconInter
               then Begin
                    Idle := False;
                    PCBeaconTimer := 0;
                    Send(Sock,'PC50^' + CluCall + '^' + Int2Str(LUserCount) + '^H');
                    If (Mode = LM_Incoming)
                      then Send(Sock, '1^' + Cr) { Local users count }
                      else Send(Sock, '99^' + Cr);
                    Kick(Sock);
                    End;
             End;

      { Ping }

      If (State = LS_Linked) and not (PingInterval = 0)
        then Begin
             Inc(PingTimer);
             If PingTimer = PingInterval
               then Begin
                    If (Mode = LM_Listen)
                      then Begin { Just "ping" }
                           Send(Sock,'PC51^' + Call + '^' + MyCall + '^1^' + Cr);
                           Kick(Sock);
                           End
                      else AddPing(Pc,MyCall,PingMaxRTT); { really Ping }

                    PingTimer := 0;
                    End;
             End;

      End;
      l := l^.Next;
      End;

End;

 { ====================================================================== }
 { Initialize the protocol unit }

Procedure Init;
var
  b : Byte;
  w : Word;
Begin

 CluCall := Conf^.CluCall;
 For b := 1 to SockMax do Port[b] := nil;

 For b := 10 to 59 do PCMsgStats[b] := 0;


 NodeCount := 1;
 NUserCount := 0;
 KUserCount := 0;
 PingQueue := nil;

 MaxUsers := 0;
 MaxLUsers := 0;
 MaxNodes := 1;

 PCReceived := 0;
 PCUnknown := 0;
 PCInvalid := 0;

 Index.Mail := 0;

 { In PCLink.pas }
 PCHops := 0;
 Listened := False;

 { In convers.pas }
 CLinks := 0;
 CLinksC := 0;

 { Local node }
 New(Nodes);
 With Nodes^ do
   Begin
   Call      := CluCall;
   Via       := nil;
   Hops      := 0;
   HopsOK    := True;
   Here      := False;
   Since     := now;
   Ver       := PCVersion;
   Users     := 0;
   UsersOK   := True;
   UsersK    := True;
   Rtt       := 0;
   RttOK     := True;
   Pinging   := False;
   PrevP     := @Nodes;
   Next      := nil;
   End;

 LocalNode := Nodes;

End;

 { ====================================================================== }
 { Read the configuration file }

 { This is probably the WORST part of this unit ! }

 { Actually, only PC links are supported. Conversd links were nearly
   working (the convers unit can handle them, but no way to connect a
   conversd properly from the ax25 side 8-) }

 { Backup links are not working either }

Procedure ReadConfig;
Var
  w       : Word;
  l       : LinkRecP;
  PrevP   : ^LinkRecP;

  s       : String;    { A parameter }
  Prot    : Byte;      { Protocol defined }
  List,                { PC Listen mode }
  Hold,                { Held from the beginning }
  Incoming,            { This one is an incoming link }

  Loppui  : Boolean;

 Procedure RCmd; { Lukee link init tiedostosta komennon }
 Begin

 Repeat

  ReadConfLine;
  IBuffer := CleanStr(IBuffer);
  If IBuffer = 'End.'
    then Loppui := True;

 until ((IBuffer[1] <> '{') and (Length(IBuffer) > 0))
       or loppui;

 If Pos('{',IBuffer) > 0 then IBuffer := Copy(IBuffer,1,Pos('{',IBuffer)-1);
 IBuffer := IBuffer + Cr;
 If loppui then IBuffer := '';
 End;

 Procedure Err(str:String);
 Begin

   Write(CrLf + CrLf + '   Error in links.ini on line ' + Int2Str(ConfLineNr) + ':' + CrLf
         + '   ' + str + CrLf + CrLf);
   Halt(1);

 End;

Begin

 PrevP := @Links;

 Loppui := False;
 AssignConf(CluPath + 'links.ini');

 While NextConfBlock
  do Begin
     CWriteLn('');
     RCmd;

     If (UpCaseCh[IBuffer[1]] <> 'P')
      then Err('Protocol type should be the first command of a block');

     Prot := 0;

     s := UpCaseStr(Parse(1));
{
     If (s = 'CLU')  then Prot := 3;
}
     If (s = 'PC')   then Begin
                          Prot := 4;
                          w := 2;
                          List := False;
                          Hold := False;
                          Incoming := False;
                          s := LowCaseStr(Parse(w));
                          While Length(s) > 0
                           do Begin
                              If s = 'listen'
                                then List := True
                              else If s = 'hold'
                                     then hold := True
                              else If s = 'in'
                                     then incoming := True
                              else Err('Illegal type flag');
                              Inc(w);
                              s := LowCaseStr(Parse(w));
                              End;
                          If List and Incoming
                            then Err('A link cannot be both incoming and listen-only');
                          End;
{
     If (s = 'CONV') then Prot := 6;
}

     If not incoming
       then Inc(LinkPorts);

     If Prot = 0
       then Err('Illegal protocol type - only "PC" is accepted');

     If (Prot = 4) or (Prot = 3)
       then Begin
            Inc(PCLinksC);

            New(PrevP^);
            l := PrevP^;
            PrevP := @l^.Next;
            { Oletusarvot }
            With l^ do
              Begin
              Call := '';
              MyCall := CluCall;
              AxCall := CluCall;
              Backup := nil;
              Backuped := nil;
              If Hold then State := LS_Held
                      else State := LS_Disc;
              DReason := DR_NotCon;
              Proto := Prot;
              If List then Mode := LM_Listen
                      else Mode := LM_Normal;
              If Incoming
                then Mode := LM_Incoming;
              TryAfter := 15;
              LTimeout := 5;
              CharSet := 0;
              DiscStrings := 0;
              Traced := False;

              PCPollDx := 5;
              PCPollWWV := 2;
              PCBeaconInter := 15;

              PingInterval := 0;
              PingTimer := 0;
              PingMaxRTT := 0;

              { Lhtarvot }
              Sock := 0;
              Ver := 0;
              Since := now;
              Tries := 0;
              Failures := 0;
              Routes := 0;
              Next := nil;
              End;
            End;

{
     If Prot = 6
       then Begin
            Inc(CLinksC);
            New(CLink[CLinksC]);
            With Clink[CLinksC]^
             do Begin
                Name := '';
                TryAfter := 15;
                LTimeout := 5;

                State := 0;
                Sock := 0;
                Locked := False;
                Since := now;
                Tries := 0;
                Failures := 0;
                Timer := 0;
                Tx := 0;
                Rx := 0;
                RttT := 0;
                RttR := 0;
                End;
            End;
}

     Repeat

     RCmd;

     If (Copy(IBuffer,1,3) <> '---') and not loppui then
     Case UpCaseCh[IBuffer[1]] of

      'A' : Begin { Try interval }
            w := Str2Word(Parse(1));
            If (w < 2)
              then Err('Trying interval must be larger than 2');
            Case Prot of
              4 : Begin
                  l^.TryAfter := w;
                  l^.LastTry := w - 2;
                  End;
{
              6 : Begin
                  CLink[CLinksC]^.TryAfter := i;
                  CLink[CLinksC]^.LastTry := i - 2;
                  End;
}
            End;
            End;
{
      'B' : Begin
            s := UpCaseStr(Parse(1));
            If s = ''
              then Begin
                   WriteLn('    Backuped callsign not found from block ' + Int2Str(PCLinksC) + '!');
                   Halt(1);
                   End;
            Case prot of
              4 : Begin
                  For l := 1 to (PCLinksC - 1)
                   do Begin
                      If Link[l]^.Call = s
                        then Begin
                             Link[l]^.Backup := PCLinksC;
                             Link[l]^.Backuped := PCLinksC;
                             Link[PCLinksC]^.Backuped := l;
                             Link[PCLinksC]^.Backup := l;
                             End;
                  If Link[PCLinksC]^.Backuped = 0
                    then Begin
                         WriteLn('    Unknown backuped callsign in block ' + Int2Str(PCLinksC) + '!');
                         Halt(1);
                         End;
                  End;
                  End;
            End;
            Link[PCLinksC]^.State := LS_Backuped;
            Write(' - Backup for ' + s);
            End;
}

      'C' : Begin { Charset }
            w := Str2Word(Parse(1));
            If not ((w >= 0) and (w <= 5)) and Assigned(CharSet[w])
              then Err('Illegal charset value');
            l^.CharSet := w;
            End;

      'D' : Begin { Disc strings }
            w := 1;
            s := LowCaseStr(Parse(w));
            While (s <> '') and (w < 6)
             do Begin
                Inc(l^.DiscStrings);
                l^.DiscStr[w] := s;
                Inc(w);
                s := LowCaseStr(Parse(w));
                End;
            End;

      'I' : Begin { Destination callsign }
            s := UpCaseStr(Parse(1));
            If s = ''
              then Err('No destination callsign');
            Case prot of
              4 : Begin
                  l^.Call := s;
                  l^.Script := s;
                  End;
{
              6 : Begin
                  CLink[CLinksC]^.Name := s;
                  CLink[CLinksC]^.Script := s;
                  End;
}
            End;
            Write('   - Block ' + Int2Str(PCLinksC) + ': ' + s);
            If l^.Mode = LM_Listen
              then Begin
                   s := UpCaseStr(Parse(2));
                   If s = ''
                     then Err('Local listening node callsign not found for ' + l^.Call);
                   l^.MyCall := s;
                   l^.AxCall := s;
                   End;
            End;

      'L' : { Trace log }
            Case Prot of
              4 : l^.Traced := True;
            End;

      'M' : Case Prot of { How many spots are merged on linkup }
              4 : Begin
                  l^.PCPollDx := Str2Byte(Parse(1));
                  l^.PCPollWWV := Str2Byte(Parse(2));
                  End;
            End;

      'O' : Begin { Local AX.25 callsign }
            l^.AxCall := UpCaseStr(Parse(1));
            End;

      'Q' : Begin { Ping interval & max rtt }
            l^.PingMaxRtt := Str2Word(Parse(2));
            If l^.PingMaxRtt >= 30
              then Begin
                   w := Str2Word(Parse(1));
                   If (w >= 5)
                     then l^.PingInterval := w
                     else Err('Invalid pinging interval');
                   End
              else Err('Invalid max rtt');
            End;

      'S' : Begin { Linkup script name }
            s := Parse(1);
            Case Prot of
              4 : l^.Script := s;
{             6 : CLink[CLinksC]^.Script := s; }
            End;
            End;

      'T' : Begin { Linker timeout }
            w := Str2Word(Parse(1));
            If not ((w >= 2) and (w <= 60))
              then Err('Illegal timeout value');
            Case Prot of
              4 : l^.LTimeout := w;
{             6 : CLink[CLinksC]^.LTimeout := i; }
            End;
            End;

      'U' : Begin { PC50 user count beacon timer }
            w := Str2Word(Parse(1));
            If not ((w = 0) or (w >= 10))
              then Err('Illegal beacon timer value');
            Case Prot of
              4 : l^.PCBeaconInter := w;
            End;
            End;

     else Err('Illegal command');

     End;

     until Loppui or (Copy(IBuffer,1,3) = '---');

     If (Prot = 4) and (l^.Call = '')
       then Err('No destination callsign in block ' + Int2Str(PCLinksC));
     End;

 CloseConf;

 { Check the validity of the connection scripts }
 CWriteLn('');
 Write('   - Validating .CON script files:');
 l := Links;
 While assigned(l)
  do Begin
     If (l^.Mode <> LM_Incoming)
       then CheckConScript(l^.Script);
     l := l^.Next;
     End;
 CWriteLn(' - Done.');

End;

 { ====================================================================== }

End.
