{$F-} {$R+} {$Q+} {$V-} {$B-} {$X-}

  (*

    Clusse

    (c) Heikki Hannikainen 1994-1998

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    See the file "COPYING" for a full copy of the GNU GPL.

  *)

Unit Unproto;

  { Implements the unproto/broadcasting cluster API, which was intended
    as a way to save LOTS of bandwidth. A bit like the FBB/TPK unproto
    system. But without using connected mode at all. The information
    transmission is completely implemented, but the queries probably don't
    work too well. If they did, and we had a nice working Windoze client
    for the protocol, this would be a killer app. }

Interface
Uses Protocol, BPQ;

Procedure UI_Down;                       { Clusse going down }
Procedure UI_Index;                      { Indeksitiedot }

Procedure UI_Dx(Dx:DxInfoP);             { DX bandille }
Procedure UI_Ann(Ann:AnnP);              { Announce bandille }
Procedure UI_WWV(Wwv:WWVP);              { WWV bandille }

Procedure UI_Receive(Packet:UIPacketP);  { UI vastaanotto }
Procedure UI_ReceiveBC(Packet:UIPacketP);  { UI BC (=> DX) vastaanotto }

Procedure Init;

 { ===================================================================== }

Implementation
Uses Dos, CStrings, Screen, Files, ConfFile, Config, Filters;

Var
  DefUIDests   : Byte;
  DefUIDest    : Array[1..16] of UIPacketP;

 { ===================================================================== }

Function UIDateStr(TimeI:LongInt):String;
Var Dat : DateTime;
Begin

 UnPackTime(TimeI,Dat);
 UIDateStr := IntStr(Dat.Month) + IntStr(Dat.Day);

End;

 { ===================================================================== }

Procedure UIDateInt(Const timez,datez:String; var i:LongInt);
Var
  dat : DateTime;
Begin

 dat.Year := dt.Year;
 dat.Month := Str2Word(Copy(datez,1,2));
 dat.Day := Str2Word(Copy(datez,3,2));
 dat.Hour := Str2Word(Copy(timez,1,2));
 dat.Min := Str2Word(Copy(timez,3,2));
 dat.Sec := 0;
 PackTime(dat,i);

End;

 { ===================================================================== }

Procedure SendUIAll(Const Data:String);
Var b : Byte;
Begin

 For b := 1 to DefUIDests
  do Begin
     DefUIDest[b]^.Data := Data;
     SendUI(DefUIDest[b]);
     End;

End;

 { ===================================================================== }

Procedure UI_Down;                       { Clusse going down }
Begin

 SendUIAll('Q' + Cr);

End;

 { ===================================================================== }

 Function AllIndex:String;
 Begin
   AllIndex := 'I ' + Int2Str(Index.DxFirst) + '-' + Int2Str(Index.Dx) + ' '
                + Int2Str(Index.AnnFirst) + '-' + Int2Str(Index.Ann) + ' '
                + Int2Str(Index.WWVFirst) + '-'+ Int2Str(Index.WWV) + ' '
                + Conf^.QTHLoc + ' ' + CluID + Cr;
 End;

Procedure UI_Index;                      { Indeksitiedot }
Begin

 SendUIAll(AllIndex);

End;

 { ===================================================================== }

Procedure UI_Dx(Dx:DxInfoP);             { DX bandille }
Begin
 SendUIAll('D ' + Int2Str(Dx^.Num) + ' '
                + PadRight(9,Freq2Str(Dx^.Freq)) + ' '
                + PadLeft(13,Dx^.Call)
                + TimeStrS(Dx^.Time) + ' '
                + UIDateStr(Dx^.Time) + ' '
                + PadLeft(7,StripSSID(Dx^.FromCall))
                + Dx^.Info + Cr);
End;

 { ===================================================================== }

Procedure UI_Ann(Ann:AnnP);          { Announce bandille }
Begin
 SendUIAll('A ' + Int2Str(Ann^.Num) + ' '
                + PadLeft(7,StripSSID(Ann^.FromCall))
                + Ann^.ToPc + ' '
                + TimeStrS(Ann^.Time) + ' '
                + UIDateStr(Ann^.Time) + ' '
                + Ann^.Msg + Cr);
End;

 { ===================================================================== }

Procedure UI_WWV(Wwv:WWVP);          { WWV bandille }
Begin
 SendUIAll('W ' + Int2Str(Wwv^.Num) + ' ' + UIDateStr(Wwv^.Time) + ' H' + Int2Str(Wwv^.Hour) + ' S'
                + Int2Str(Wwv^.SFI) + ' A' + Int2Str(Wwv^.A) + ' K'
                + Int2Str(Wwv^.K) + ' ' + PadLeft(7,StripSSID(WWv^.FromCall)) + Wwv^.Forecast);
End;

 { ===================================================================== }

Function UI_Allowed(p:Byte):Boolean;
Var
  b : Byte;
Begin

 UI_Allowed := False;
 b := 1;
 While (b <= DefUIDests)
  do Begin
     If DefUIDest[b]^.Port = p + 1
       then UI_Allowed := True;
     Inc(b);
     End;

End;

 { ===================================================================== }

Procedure UI_Reply(Packet:UIPacketP;Const s:String);
Var
  pac : UIPacketRec;
  b   : Byte;
Begin

 With Packet^
  do Begin
     pac.Port := Port;
     pac.FromCall := AXCluCall;
     pac.ToCall := FromCall;
     pac.Digis := Digis;
     For b := Digis downto 1
      do pac.DigiPath[Digis - b + 1] := DigiPath[b];
     pac.Data := s;
     End;

 SendUI(@pac);

End;

 { ===================================================================== }

Procedure UI_Error(Packet:UIPacketP;Error:Byte);
Begin

 UI_Reply(Packet,'ER ' + Int2Str(Error) + Cr);

End;

 { ===================================================================== }

Procedure UI_Receive(Packet:UIPacketP);  { UI vastaanotto }
Var
  Cmd : String[4];

  Procedure UIrDx;
  Var
    DXInfo  : DXInfoP;
    b       : Byte;
  Begin
    New(DxInfo);
    With DxInfo^
     do Begin
        FromPc := CluCall;
        Freq := Str2Freq(Parse(1));
        Call := UpCaseStr(Parse(2));
        If Cmd[2] = 'D'
          then Begin
               UIDateInt(Parse(3),Parse(4),Time);
               FromCall := UpCaseStr(Parse(5));
               b := 6;
               End
          else Begin
               Time := Now;
               FromCall := Packet^.FromCall.Call;
               b := 3;
               End;
        b := FindParamStart(b);
        If (b > 0) { Infoa? }
          then Info := Copy(ibuffer,b,length(ibuffer)-b)
          else Info := ' ';
        If OnBand(Freq) and (Call <> '') and ValidCall(FromCall)
          then Begin
               If not Protocol.Dx(DxInfo)
                 then UI_Error(Packet,2);
               End
          else Begin
               UI_Error(Packet,12);
               Dispose(DxInfo);
               End;
        End;
  End;

Begin

 If not UI_Allowed(Packet^.Port)
   then Begin
        UI_Error(Packet,1);
        Exit;
        End;

 IBuffer := Packet^.Data;
 If Length(IBuffer) = 0
   then Begin
        UI_Error(Packet,10);
        Exit;
        End;

 Cmd := UpCaseStr(Copy(IBuffer,1,4));
 Case Cmd[1] of

  '?' : Case Cmd[2] of

         'A' : Begin
               End;

         'D' : Begin
               End;

         'W' : Begin
               End;

         'I' : Case Cmd[3] of

                'A' : UI_Reply(Packet,'IA ' + Int2Str(Index.AnnFirst) + '-' + Int2Str(Index.Ann) + Cr);
                'D' : UI_Reply(Packet,'ID ' + Int2Str(Index.DxFirst) + '-' + Int2Str(Index.Dx) + Cr);
                'W' : UI_Reply(Packet,'IW ' + Int2Str(Index.WWVFirst) + '-' + Int2Str(Index.WWV) + Cr);

               else UI_Reply(Packet,AllIndex);
               End;

         else UI_Error(Packet,11);
        End;

  'A' : Begin
        End;

  'D' : UIrDx;

  'W' : Begin
        End;

  else UI_Error(Packet,11);
 End;

End;

 { ===================================================================== }

Procedure UI_ReceiveBC(Packet:UIPacketP);  { UI BC (=> DX) vastaanotto }
Var
  Cmd : String[4];
Begin

 IBuffer := Packet^.Data;
 Cmd := UpCaseStr(Copy(IBuffer,1,4));

 If Cmd = 'QRZ' + Cr
   then Begin
        If not UI_Allowed(Packet^.Port)
          then Begin
               UI_Error(Packet,1);
               Exit;
               End;
        UI_Reply(Packet,AllIndex);
        End;

End;

 { ===================================================================== }

Procedure Init;
Var
  b     : Byte;
  w     : Byte;
  FromC : AX25Call;
  s     : CallRec;
Begin

 AXCluCall.Call := StripSSID(CluCall);
 AxCluCall.SSID := SSID(CluCall);
 FromC := AXCluCall;

 Write(' o Reading unproto.ini... ');
 If FileExists(CluPath + 'unproto.ini')
  then Begin
       AssignConf(CluPath + 'unproto.ini');
       DefUIDests := Str2Byte(GetConfLine);
       If DefUIDests <= 16
         then Begin
              For b := 1 to DefUIDests
               do Begin
                  NeedConfLine;
                  IBuffer := IBuffer + Cr;
                  New(DefUIDest[b]);
                  Inc(OtherStaticMem,SizeOf(UIPacketRec));
                  With DefUIDest[b]^ do
                  Begin
                  Port := Str2Byte(Parse(0));
                  If (Port = 0) or (Port > 16)
                   then Begin
                        WriteLn(CrLf + ' The port number must be between 1 and 16.');
                        Halt(1);
                        End;
                  FromCall := FromC;
                  ToCall.Call := 'DX';
                  ToCall.SSID := 0;
                  Digis := 0;
                  w := 0;
                  Repeat
                   Inc(w);
                   s := UpCaseStr(Parse(w));
                   If (s <> '')
                    then Begin
                         Inc(Digis);
                         DigiPath[Digis].Call := StripSSID(s);
                         DigiPath[Digis].SSID := SSID(s);
                         End;
                  until (s = '') or (Digis = 8);
                  End;
                  End;
              CWriteLn(Int2Str(DefUIDests) + ' routes enabled.');
              End
         else Begin
              WriteLn(' Maximum of 16 UI routes allowed.');
              Halt(1);
              End;
       CloseConf;
       End
  else Begin
       CWriteLn('Disabled, unproto.ini not found.');
       DefUIDests := 0;
       End;

End;

 { ===================================================================== }

End.

