
#include <stdio.h>

#include "net_pc.h"
#include "network.h"
#include "log.h"

int pc_msgstats[51];

char *hops2pcstr(int hops)
{
	static char s[6];
	
	snprintf(s, 3, "H%d", hops);
	s[3] = '\0';
	
	return s;
}

/*
 *	Send message to all PC links, except for the one it came from
 */

void pc_sendall(struct link_t *via, char *fmt, ...)
{
}

/*
 *	Handshaking
 */

void pc_sendloopcheck(struct link_t *l)
{
}

void pc_sendcluid(struct link_t *l)
{
}

void pc_handshake(struct link_t *l)
{
}


/*
 *	Node deletion
 */

void pc_nodedel(struct node_t *n, char *reason)
{
}

/*
 *	Cluster events
 */

void pc_dx(struct dx_t *dx)
{
}

void pc_announce(struct ann_t *ann)
{
}

void pc_wwv(struct wwv_t *wwv)
{
}

void pc_talk(struct talk_t *talk)
{
}

void pc_userhere(struct nuser_t *nu)
{
	if (pc_hops <= 98)
		pc_sendall(nu->node->via, "PC24^%s^1^%s^\n", nu->call, hops2pcstr(pc_hops));
	
	return;
}

/*
 *	Disconnection handler
 */

void pc_disc_handler(struct csock_t *s)
{
	log(L_LINK, "PC: %s disconnected", s->link->call);
	link_logout(s);
	
	return;
}

/*
 *	Input handler for the PC protocol
 */
 
int pc_handler(struct csock_t *s, void *data, int len)
{
	char *p = (char *)data;
	
	
	return 0;
}

