
#ifndef NET_PC_H
#define NET_PC_H

#include "network.h"

#define PCMAXLEN 240
#define pc_version 5480

struct pcmd {
	int	id;
	int	(*function)	(struct link_t *l, int argc, char **argv);
};

extern int pc_msgstats[51];

extern void pc_beacon(struct link_t *l);
extern void pc_ping(struct link_t *l, call_t *to, call_t *from, int flag);
extern void pc_reqclose(struct link_t *l, char *reason);

extern void pc_nodeadd(struct node_t *n);
extern void pc_nodedel(struct node_t *n, char *reason);

extern void pc_useradd(struct nuser_t *nu);
extern void pc_userdel(struct nuser_t *nu);
extern void pc_useraway(struct nuser_t *nu);
extern void pc_userhere(struct nuser_t *nu);

extern void pc_dx(struct dx_t *dx);
extern void pc_announce(struct ann_t *ann);
extern void pc_wwv(struct wwv_t *wwv);
extern void pc_talk(struct talk_t *t);

extern void pc_sendloopcheck(struct link_t *l);
extern void pc_sendcluid(struct link_t *l);
extern void pc_conn_handler(struct link_t *l);

extern void pc_disc_handler(struct csock_t *s);
extern int pc_handler(struct csock_t *s, void *data, int len);

#endif

