
/*
 *	cfg_links.c
 *
 *	links.conf directive parsing functions
 */

#include <string.h>
#include <stdio.h>

#include "hmalloc.h"
#include "network.h"
#include "cfg_links.h"
#include "log.h"
#include "timer.h"
#include "config.h"

struct link_t *thislink = NULL;

/*
 *	Verify that a Link keyword has been set before
 */

int require_link(struct link_t *link)
{
	if (!link) {
		log(L_CRIT, "You must specify a Link before setting any parameters for one.");
		return 1;
	}
	
	return 0;
}

/*
 *	Link
 */

int do_link(struct link_t **dest, int argc, char **argv)
{
	struct link_t *link;
	struct link_t *foo = *dest;
	
	if (argc != 2)
		return -1;
	
	link = hmalloc(sizeof(struct link_t));
	
	if (foo) {
		foo->next = link;
		link->prevp = &foo->next;
	} else {
		links = link;
		link->prevp = &links;
	}
	
	link->next = NULL;
	thislink = link;
	
	strcpy(link->name, hstrupr(argv[1]));
	strcpy(link->call, argv[1]);
	strcpy(link->mycall, (char *)clucall);
	strcpy(link->link_call, (char *)clucall);
	link->proto = lp_pc;
	link->state = ls_disc;
	link->since = now;
	link->dreason = dr_unknown;
	link->version = 0;
	link->sock = NULL;
	link->node = NULL;
	
	link_max++;
	
	return 0;
}

/*
 *	DestCall
 */

int do_destcall(struct link_t **dest, int argc, char **argv)
{
	return 0;
}

/*
 *	MyCall
 */

int do_mycall(struct link_t **dest, int argc, char **argv)
{
	return 0;
}

/*
 *	Protocol
 */

int do_protocol(struct link_t **dest, int argc, char **argv)
{
	struct link_t *this = *dest;
	
	if (require_link(this) || (argc != 2))
		return -1;
	
	if (!strcasecmp(argv[1], "pc"))
		this->proto = lp_pc;
	else {
		log(L_CRIT, "Unknown protocol: \"%s\"", argv[1]);
		return -1;
	}
	
	return 0;
}

/*
 *	Mode
 */

int do_mode(struct link_t **dest, int argc, char **argv)
{
	struct link_t *this = *dest;
	int i;
	
	if (require_link(this) || (argc < 2))
		return -1;
	
	for (i = 1; i < argc; i++) {
		if (!strcasecmp(argv[i], "incoming"))
			this->mode = lm_incoming;
		else {
			log(L_CRIT, "Unknown mode: \"%s\"", argv[i]);
			return -1;
		}
	}
	
	return 0;
}

/*
 *	Script
 */

int do_script(struct link_t **dest, int argc, char **argv)
{
	struct link_t *this = *dest;
	char *s;
	int i;

	if (require_link(this) || (argc < 2))
		return -1;
		
	for (i = 1; i < argc; i++) {
		if (*argv[i] == '/')
			s = hstrdup(argv[i]);
		else {
			s = hmalloc(strlen(base_d) + strlen(argv[i]) + 1);
			sprintf(s, "%s%s", base_d, argv[i]);
		}
		
		this->scripts = add_string(this->scripts, s);
	}
	
	return 0;
}

