/*************************************************************
 *  MBFWD.C - 11/10/86 - Autoforwarding.
 *************************************************************
 * PRMBS - Packet Radio Mailbox System  Copyright 1987
 *   by  Brian B. Riley (ka2bqe)
 *       Dave Trulli    (nn2z)
 * This code was initially based on a pre-release of the CBBS
 * code by W0RLI and VE3GYQ. It has been re-worked to the point
 * that only some structural resemblance remains. It is for the
 * most part orginal work of the authors, where other code has 
 * been incorporated appropriate credit is given.
 *    This code is hereby freely placed into the public domain
 * for use by any and all with the stipulations that (1) credit
 * line must be retained, both ours and in the case of other
 * code the appropriate authors and (2) no fee may be charged
 * for this code beyond simple expenses in transfer of the code
 * to another person to include postage, phone charges, media 
 * costs, mailers, etc)
 *************************************************************
 * 10Mar88 <br> major rewrite of forward cycle for  FWD, POLL, XCHNG
 *************************************************************/
 
#include "mb.h"
/*******************************************************************
 *
 *     #### needs to be re-written
 *
 *------------------------------------------------------------------
 *  The [PRMBS] 'protocol' - as applies to forwarding.
 *
 *     Any version of this code leads off response to connect with
 *  a "[PRMBS]\n". The forwarding subroutine eat() has been modified
 *  to look for this while its looking for the '>'. If it sees this, it
 *  responds with a "*** [PRMBS]\n" and sets a flag. With this flag set
 *  at both ends, the remote bbs uses a prompt [102]W2XXX> and the code
 * in eat() again will decode this as saying the far end has 102 KBytes
 * of message space over and above his MINDISK value. This 102 will be
 * placed into the variable 'rspace' and will be checked against each
 * message to be forwarded. In this way a message too big will be skipped
 * and the next message will be attempted or a disconnect will be issued
 * this will cut down on systems being crashed as well as not wasting time
 * running up the message only to have say 45K of a 60K message transmitted
 * and then disconnected and erased!
 *
 * Brian B. Riley  ka2bqe   10 dec 86
 ***********************************************************************/

#define MAXSCRIPTS	24	/* max number of scripts per entry */
#define SCRIPTBUF	640	/* size of script buffer */

#define UFWDM	32		/* max number of users in RAM file for forwarding */
#define BFWDM	32		/* max number of bbses in RAM file for forwarding */
#define SFWDM	64		/* max number of bbses in RAM file for forwarding */

char *event_fil, *callfil;
char *fwddir;

extern FILE *ufl;
extern char *EXstr;
extern char *sysop;
extern short	ext_resp;

int	flip_flop = FALSE;

#define FS_REJ	2
#define FS_LATR	3

short	rspace;		/* amount of space on remote PRMBS system	*/

static char *script[MAXSCRIPTS+1];
static char sbuf[SCRIPTBUF];

char pri_str[11];

char *pri_strd = "TPB$*";

int sbuffree;		/* size free space in buffer */
int fwd_kill		= FALSE;
int flood_kill		= FALSE;

int max_fwd_cnt		= 16;
int max_fwd_size	= 24;

/*
	dofwd() - finds messages to be 'exported' from this system to another
			  the medium is more or less transparent (serial, radio, disk)
*/

#define FWDM	128

dofwd(argc,argv,xfname,typ_str,maxcnt, maxsize)
int argc, maxcnt;
long	maxsize;
char **argv, *xfname, *typ_str;
{
  	char *fst, *p, *q, call[CALLLEN+1], fcall[CALLLEN+1];
  	char tmp_bbs[MTOLEN+1];
	  	
	FILE 	*fwfl;
	long int fil_xst();
	int 	i;
	int		curhdr;
	int 	blank_bbs	= FALSE;
	int 	fwdtot		= 0;
	int 	fwdcount	= 0;
	int		fwdn		= 0;
	long	msgblocksize= 0;
	char	*ntos();
	char 	tline[LINELEN];
	char 	fwdlist[FWDM * (CALLLEN+1)];
			
	strcpy(fcall,argv[0]);


		/* build list of calls to be forwarded */
	for (i=0 ; i < argc ; i++ ) {	

		fwdn = addfwd(argv[i],fwdlist,fwdn, FWDM);			

							  		/* no wildcards in filename*/
		if ((wildcard(argv[i]) == FALSE) 				&&
			(fwfl = fopen(sys_name(argv[i],"FWD"),"rt")) ){

			while (!rd_parse(tline,fwfl)) 
				fwdn = addfwd(fld[0],fwdlist,fwdn, FWDM);			

			fclose(fwfl);
		}


	} 
	
	for (p = typ_str ; *p ; p++) {

		curhdr = 0;		/* set pointer to start of file */
		while (curhdr = getnext(curhdr)) {	/* mail file loop */
			if (abort_dl()) 
				break;
			
				/* to be sent must be N and @BBS 		*/


			if (mmhs->stat != 'N')
				continue;

				/* check what message type we are forwarding */

			if (*p != '*') {
				if (*p == '$') {
					if (mmhs->fprty != '$')
						continue;
				} else {
					if (mmhs->fprty == '$' || mmhs->type != *p)
						continue;
				}
			}
				/* if forward window active and msg greater than window */
			if ((xfname == NULL) 			&& 
				(port->fwsize > 0) 			&& 
				(mmhs->size > port->fwsize) &&
				chktime(port->fwtmr)		) 
				continue;
			if ((stricmp(fcall, mmhs->to)	 == 0)						||
				(mmhs->route[0] && findfwd(mmhs->route,fwdlist,fwdn))	){
	
				if (fil_xst(msgname(mmhs->number)) == 0)
					continue;
				if (xfname == NULL ) {
						/* send 'flood' only to addressed bbs */
					if (mmhs->fprty == '$' && stricmp(fcall, mmhs->route) != 0)
						continue;

					/*
						You have something to go, if not connected at this 
						point, make the connection.
					*/
					
					if (!(port->mode & (FORWARD|REMOTE))) {
						if (!doscript() || eat() == ERROR) {
							distnc(port,T_O_DISC);
							return (ERROR);
						}
					}
					set_msgstat('B');	/* 'busy' the message out */
					if (msg_disp(fwd_msg(fcall,FALSE),fcall) == ERROR) 
						return (ERROR);
				} else {
					set_msgstat('B');	/* 'busy' the message out */
					token_lin = ntos(mmhs->rn);
					prtx("#$S ($M) $G @ $A\n");
	 				if (msg_disp(export_msg(xfname,EXstr),fcall) == FALSE) {
						return (ERROR); 
					}
	
				}			
				msgblocksize += mmhs->size;
				fwdcount++;
			}

			if ((maxcnt>0 && (fwdcount == maxcnt))			||
				(maxsize>0L && (msgblocksize > maxsize))	) {
				return(fwdcount);
			}
			
		}	/* mail file loop 			*/
	}		/* message type loop		*/

	return (fwdcount);

} /* dofwd */

/*
printf("flip-flop = %d  maxcnt = %d  fwdcount = %d\n",flip_flop,maxcnt,fwdcount);
*/

/***************************************************************
 * dopar() - send tnc parameters to directed port
 ***************************************************************/
dopar(fptr,prt_id)
char prt_id;
FILE *fptr;
{
	PORTS *tp;
	char *getmstr();
	

	if ((tp = findport(prt_id)) == NULL) {
		passlst(fptr);
		return;
	}
	
	device_cmds(tp,getmstr(fptr));

} /* dopar */

/***************************************************************
* doscript() - execute script statments
***************************************************************/
doscript()
 {
	int j;
	int i = 1;
	register char *p;
	char *ok 		= NULL;
	char *fail 		= NULL;
	char *bpqstr	= NULL;
	char c;
	int timeout, l2conn;
	int success = TRUE;
	FILE *capfl = NULL;
	char *fname = NULL;
	char *l2dest, *str1;
	char tline[LINELEN];			

	timeout = port->timeout;
	
	while (success) {

		if ((p = script[i++]) == NULL)			/* process this command */
			break;
		switch(*p++) {

		case '^':
			device_cmds(port,p);
			break;

		case '@':
			l2conn = make_connect(p,timeout);
			l2dest = p;
			success = (port->mode == FORWARD);
			break;

		case '%':
			if ( capfl !=NULL )		/* we gotta close no matter what */
				fclose(capfl);
			if ( *p == 'O') {
				if ((fname = p+2) != NULL)	{
					capfl = fopen(remnl(fname), "a+"); 
					fprintf(capfl,"\n----- @ %sz on %s -----\n",
						l_time,l_date);
				} else {
					capfl = NULL;
				}
			}
			break;
		case '&':		/* eat lines */
			j = atoi(p);
			while (j--) {
				if (!getdat(tline,sizeof(tline)-1,timeout)) {
					success = FALSE;
					break;
				}
			}
			break;
								
		case '.':
			success = snd_proc(p,ok,fail,capfl,timeout);
			break;

		case '!':
			timeout = atoi(p);
			if (timeout == 0 )
				timeout = port->timeout;
			break;

		case '+':
			if ( *p == '\0')
				ok = NULL;
			else
				ok = p;
			break;
		case '?':
			if ( *p == '\0')
				fail = NULL;
			else
				fail = p;
			break;

		default:
			printf("INVALID> %s\n",--p);
			success = FALSE;
			break;
		}
	}

	if (!l2conn)
		str1 = "Connect failed";
	else
		if (!success)
			str1 = "Script  failed";
		else
			str1 = "Script connect";

	sprintf(tline,"%s %-6s (%s)", str1, script[0], l2dest); 			

	log('T','C',port->id,tline);

	if ( capfl !=NULL ) 	/* in case dummy forgot to close */
		fclose(capfl);
	return (success);

 }


/*
	eat() - wait monitoring line looking for '>' after msg fwd
*/
eat()
{
	int prmpt, sys_type;
	char tline[LINELEN];
		
	while ((prmpt = prompt_line(tline)) != TRUE) {
		if (prmpt == ERROR) {
			return (ERROR);
		} else {
			if (smart_sys == ERROR) {
				if ((smart_sys = is_smart(tline)) != ERROR) {
					while ((prmpt = prompt_line(tline)) != TRUE) {
						if (prmpt == ERROR) {
							return (ERROR);
						}
					}
					prtx(mprmbs);
				}
			}
		}
	} 
	return(TRUE);
}

/* 
	export() - export mail to file
*/
export(argc,argv)
int argc;
char **argv;
{
  	char *fst, *p;
	char *exfname;
	int pmode, bid_mode;
	FILE *fwfl;
	
	exfname 	= argv[1];
	pmode 		= port->mode;
	port->mode 	= FORWARD;
	argc		-= 2;
	argv		+= 2;
	log('M','F','X',exfname);
	dofwd(argc,argv,exfname,"*",0,0L);
	port->mode 	= pmode;
	return (0);

} /* export */



/***************************************************************
 * findfwd() - match message to be forwarded to forward list
 ***************************************************************/
findfwd(cp, lp, n)
char *cp, *lp;
int n;

{
	register i;

	for (i = 0; i < n; i++, lp += (CALLLEN+1)) {
		if (stricmp(lp, cp) == 0)
			return(TRUE);
	}
	return(FALSE);
}

/*
	find_script() - go to CALLDIR and get script for this dude
*/

find_script(callstr,scrptnum)
char scrptnum, *callstr;
{
	FILE *scrfil;
	int i;
	char *p, *fst;
	char tline[LINELEN];
	
	if (scrfil = sysdir_open(callfil,"rt")) {
		while (!eat_line(tline,'>',scrfil)) {
			if (tline[1]   != scrptnum)
				continue;
			remnl(tline);
			if (strl2cmp(callstr,tline+3) != 0)
				continue;
			script[0] = callstr;
		
			return(get_script(scrfil));
		}
		fclose (scrfil);
		prtx_err(MSCRNF);
	} 
	return (FALSE);
}
 

/*
	fwd_body() - forwards out the body of the message
*/
fwd_body()
{
	
	tprintf("%s\n",mmhs->title);
	if (read_fil(msgname(mmhs->number),TRUE) != ERROR)
		outchar (CPMEOF);
	sendnl();
}


/*
	fwd_msg() - actually send out message 'RLI' protocol, normal
    forwarding of the message in current position in 'mmhs'
*/

fwd_msg(fcall,forced)
int forced;
char *fcall;
{
	char *fwd_send();
	char tline[LINELEN];

	int status = TRUE;

 	tprintf("%s\n",fwd_send());		/* send the 'send' line */
 		
	if (!forced) {
		if ((smart_sys == TCNET) 									||
			((mmhs->msgID[0] != '\0') 	&&
			 ((bid_able && mmhs->fprty == '$')  || mid_able))		){
				if (getdat(tline, sizeof(tline)-1, port->timeout)) {
					strupr(tline);
					switch (*tline) {
					case 'O':
						break;
					case 'N':
						status = FALSE;
						break;
					case 'L':
						status = FS_LATR;
						break;
					case 'R':
						status = FS_REJ;
						break;
					default:
						status = ERROR;
						break;
					}
				} else {
					status = ERROR;
				}
		}
	}
	if (status == TRUE)
		fwd_body();

	if (status != ERROR)
		if (eat() == ERROR)
			status = ERROR;
	return (status);							

} /* fwd_msg */

/*****************************************************************
 * fwd_send() - composes the send line of the message
 *****************************************************************/
char *fwd_send()
{
	char *fmt_token();
	char *p 	= NULL;
	char *tlin1 = "S$* $G";
	char buf[128];				
	char mmbbs[MTOLEN];

	
	strcpy(buf,tlin1);

	if (mmhs->bbs[0]) {
		strcpy(mmbbs,mmhs->bbs);
		if (!h_route) 
			pcall(mmbbs);
		strcat(buf," @ ");
		strcat(buf,mmbbs);
	}
	strcat(buf," < $P");

	if (mmhs->msgID[0]) {
		if ((mmhs->fprty == '$' && bid_able) ||
			mid_able) {
			strcat(buf," $$$8");
		}
	}
	return(fmt_token(buf));

}	

/*
	get_port_script() - gets port and script
*/
get_port_script(cp,ptc,sc_no)
char *cp, ptc, sc_no;
{
	PORTS *pp;
	if (pp = findport(ptc)) {
		if (find_script(cp,sc_no)) {		/* locate script 		*/
			ioport(pp);
			return(TRUE);
		}
	}
	return (FALSE);
}

/*
	get_script() - get the script from the front of a file
*/
get_script(scrfl)
FILE *scrfl;
{
	int 	i;
	int 	stat = TRUE;
	int 	nextslot = 1;
	char 	*bp, *fst;
	char	tline[LINELEN];
	

	sbuffree = SCRIPTBUF;
	bp = sbuf;

	while (stat = !rdline(tline, LINELEN, scrfl)) {
		if (iseof(tline))
			break;

		if (*tline != '^')
			remnl(tline);

		if (nextslot < MAXSCRIPTS) {
			i = strlen(tline) + 1;
			if ( i > sbuffree ) {
				prtx_err(MSCROVF);
				stat = FALSE;
			}
			strcpy(bp, tline);
			script[nextslot] = bp;
			bp += i;
			sbuffree -= i;
			nextslot++;
			script[nextslot] = NULL;		/* NULL next pointer	*/
		}
	}
	fclose(scrfl);		
	return(stat);
}


/*
	make_connect() - make a call on a tnc or modem
*/
make_connect(dest,timeout)
int	timeout;
char *dest;
{

	char tline[64];
	char *prefix = "";

	clear_parms();
	
	if (port->type & P_TNC)
		prefix = "d\nd\nc ";
		
	sprintf(tline,"%s%s\n",prefix,dest);
	device_cmds(port,tline);

	if (!(port->type & P_BPQ)) {
		if (iscon(timeout))
			eatChars();
		else
			return (FALSE);
	}
	port->mode = FORWARD;

	return(TRUE);
}

/*
	msg_disp() - message disposition - what to do after forwarding
 				 attempted
*/

msg_disp(msgstat,fw_call)
char *fw_call; 
int msgstat;
{
	char *fmt_token();
	
 	char	c = 'K';
	char	c1 = ' ';

	char	*tlin = "#$M $$$8";
	
		 	
	switch(msgstat) {
	case ERROR:
		tlin = "#$M - Failed";
		c1 = 'N';
		c  = 'N';
		break;

	case FALSE:	 /*	this is in effect : case REJ_DUPE: */
		c1 = 'D';
		if (mmhs->fprty != '$') {
			if (mid_able) {
				c  = 'D';
			} else {
				c  = 'R';
				c1 = 'R';
			}
		}
		break;
		
	case FS_LATR:
		c  = mmhs->stat;
		c1 = 'L';
		break;
		
	case FS_REJ:
		c  = 'R';
		c1 = 'R';
		break;
		
	case TRUE:	
		tlin = "#$M($]) for $G";
		break;
	}
	
	if (c == 'K') {
		if (mmhs->fprty != '$' && fwd_kill) {
			unlink(msgname(mmhs->number));
			c = 'X';
		}
	}
	log ('M', 'F', c1, fmt_token(tlin));
	set_msgstat(c);
	return (msgstat);
	
} /* msg_disp */


/*
	prompt_line() - gets line of data and checks for BBS prompt
*/
prompt_line(cp)
char *cp;
{
	if (getdat(cp, LINELEN-1, port->timeout)) 
		return (*(tail_ptr(cp)-1) == '>');
		
	return(ERROR);
}

/*
	retrieve_mail() - commands far side station to send mail and bulls
	if he has them. Assumes that you are connected
*/
retrieve_mail(fcall,fline)
char *fcall, *fline;
{
	/* jump to command mode and back to converse this is done so that
	   if we are on a tnc2 with DCD then we will be in transparent mode
	   for the message input and not be bothered with connect requests 
	   getting into the input data
	*/
	if (smart_sys > TRUE) {
		convtnc(2);
		tprintf("%s\n",fline);
		log ('M','F','>',fline);
		return (getmsgs(fcall));
	} else {
		return (ERROR);
	}
}

snd_proc(cp,ok,fail,tfil, timeout)
int timeout;
char *cp, *ok, *fail;
FILE *tfil;
{
	char tline[LINELEN];
	
	snd_script_str(cp);

	if ( tfil != NULL )
		fprintf(tfil,"%s\n",cp);

					/* wait for response */
	while (TRUE) {
		if (!getdat(tline,sizeof(tline)-1,timeout)) {
			return(FALSE);
		}
		if ( tfil != NULL )
			fprintf(tfil,"%s\n",tline);
		if ( ok == NULL					|| 
			strcmp(ok,"*") == 0			||
			strstr(tline,ok) != NULL 	){
			return(TRUE);
		}
		if ( fail != NULL) {
			if ( strcmp(fail,"*") == 0 || strstr(tline,fail) != NULL ) {
				return(FALSE);
			}
		}
	}
}

/*
	snd_script_str(s) - send chat string out tnc
*/
snd_script_str(s)
register char *s;
{
	while (*s) {
		if ( *s != '\\' )
			outchar(*s);
		else
			switch (*++s) {
				case 'r':
				case 'n':
					outchar('\r');
					break;
				case 'd':
					wwait(2);
					break;
				default:
					outchar('\\');
					outchar(*s);
					break;
			}
		s++;
	}
	sendnl();
}

/*
	reverse() - reverse forwarding - user triggered
		this proc specced in command table as NOLOK because LOKMSG will
		be invoked for each call of cmdparse();
*/

reverse(argc,argv)
int argc;
char **argv;
{
	int i;
	char tline[LINELEN];
	
			/* see if he is permitted 'pollf' priveleges	*/

	if (check_for_call(port->user->call,"pollf.rs") == FALSE)
		argc = 1;

	argv[0] = port->user->call;
	
	for (i = 0 ; i < argc && port->mode == REMOTE ; i++ ) {
		sprintf(tline,"fwd -t %s a %s",pri_str,argv[i]);
		printf("REVF> %s\n",tline);
		parse_cmd(swap,tline);
	}		

	outstr(mdone);
}



/*
	swap() - finds messages to be 'exported' from this system to another
		     the medium is more or less transparent (serial, radio, disk)
*/

swap(argc,argv)
int argc;
char **argv;
{
  	char *fst, *q, *p, *s, fcall[CALLLEN+1];
	char rev_fcmd[192];
	char con_port	= '\0';
	char scr_no		= '1';
	char *type_priority;
	
	int poll    = FALSE;	/* initiate poll anyway even if no mail			*/
	int push   	= FALSE;	/* initiate connect, send first, if ya have it,
							   then poll									*/
	int fwdonly	= FALSE;

	int	i;

	int	fwdcnt	= 0;
	int retcnt	= 1;

	int		maxcnt;
	long	maxsize;
	
	FILE *fwfl;
	PORTS *tp, *was;

	maxcnt		= max_fwd_cnt;			/* pick up defaults */
	maxsize		= (long) max_fwd_size * 1024L;

	was 		= port;

		/* check command - poll, push, or fwd -  swap assumed */
		
	if (strcmp(argv[0],"POLL") == 0)
		poll++;

	if (strcmp(argv[0],"PUSH") == 0) 
		push++;
	
	if (strcmp(argv[0],"FWD") == 0)
		fwdonly++;

	type_priority = pri_str;

	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s != '\0'; s++) {
			switch(*s) {
			case 'T':
				type_priority = argv[1];
				argc--;
				argv++;
				break;				
			case 'C':
				maxcnt = atoi(argv[1]);
				argc--;
				argv++;
				break; 				
			case 'S':
				maxsize = atol(argv[1]);
				argc--;
				argv++;
				break; 				
			}
		}
	}

		/* process port and script */	
	if (argc < 2)
		return(ERROR);
		
	p = argv[0];
	con_port = *p;
		if (*++p)
		scr_no	= *p;

	argc--;
	argv++;	

	pcall(argv[0]);
	strcpy(fcall,argv[0]);

	/* select port and script*/

	if (!(port->mode & (FORWARD|REMOTE)))	/* already connected*/
		if (get_port_script(fcall, con_port, scr_no) == FALSE) 
			return (ERROR);
	
	strcpy(rev_fcmd,"F>");

	if (poll) 
		for (i= 1 ; i < argc ; i++)
			sprintf(rev_fcmd,"%s %s",rev_fcmd, pcall(argv[i]));



		/*
			There really is no loop here. The while() is used to provide
			a quick exit out of the process by use of the break. Conventional
			programming wisdom(???) says use some if() constructs but they
			get	real messy, for this, so I used the while() and I have what 
			seems to be a clean flow. The loop should never close since the
			last statement is a break. <br> 26 Oct 89 / 18 Mar 93

			Return_count is initialized at 1 and forward count at 0. Then
			the forwarding loop will at least start. If its a POLL, forward
			count will always stay 0 and return count will be set each time.
			In a POLL any time its a 0 the POLL loop will break out. In normal
			forwarding any two sewunctial 0's - that is connect send some,
			POLL get nothing, send get nothing and you break out. Or send some
			POLL and get some, the try to send and have nothing , POLL and get
			nothing and you are out
		*/
		
	while (TRUE) {
	
		if (push || poll)
			if (!doscript() || (eat() == ERROR))
				break;
		
		while (fwdcnt + retcnt) {
		
			if (!poll) {
				if ((fwdcnt = dofwd(argc,argv,NULL,
									type_priority,maxcnt,maxsize)) == ERROR)
		    		break;
		    }
		    if ((fwdcnt+retcnt) == 0)
		    	break;
			if (fwdonly)
				break;
			if ((retcnt = retrieve_mail(fcall,rev_fcmd)) == ERROR)
				break;		     	
			if (eat() == ERROR)
				break;
				
		}			

		break;
	}



	if (port->mode & (FORWARD|FORCED|TIMEOUT|DISCON)) { 
		log('X','D', ' ', "");  /* say bye and tell the snoops */
		distnc(port,BYE_DISC);
		clear_parms();
	}
	ioport(was);

	return (0);

} /* swap */

fwd_type(argc,argv)
int argc;
char **argv;
{
	if (argc > 1)
		strnxcat(pri_str,argv[1],10);
	tprintf("Forwarding type priorities are \"%s\"\n",pri_str);
}
		
