/* 
	ulockf() - obtain write lock  for user file 
*/
ulockf()
{
	int fd;
	int i = 512;
	if (multiuser) {
		DEBUG("USER FILE LOCKED\n");
		while(--i ) {
			fd = open(ULOCKF, O_WRONLY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
			if ( fd == -1 && errno == EEXIST) {
				printf("ulock: (%03d) %s busy\n", i, usfile);
				giveaway(5);
			} else {
				close(fd);
				break;
			}
		
		}
		if ( i == 0 )
			printf("ulock: override lock\n");
	}
	
	if ((ufl = fopen(usfile, "r+b")) == NULL) {
		token_lin = usfile;
		fatal("ulockf: %s",err_string(MOPEN));
	}
	/* read the header */
	geturec(ufl, 0, (char *)ufhs);
	return;
}

/* 
	uulock() - remove write lock on user file
*/
uulockf()
{

	puturec(ufl, 0, (char *)ufhs);	/* write header record */

 	if ( fclose(ufl) != 0 ) 
		fatal("uulock: can't close %s\n",usfile);

	if (multiuser) 
		unlink(ULOCKF);
	
}
