
/*****************************************************************
 *  MBUSER.C - 11/13/86
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *
 *  All code contained herein is copyrighted by Brian B. Riley,
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials
 *  gained from other sources
 *
 *  This code is freely given into the public domain for any and
 *  all uses by such persons as so desire, with the proviso that
 *  this code and subsequent code based on large fragments of it
 *  must be distributed freely with the same proviso and copies of
 *  this copyright notice.
 *
 *  The only rights to compensation anyone shall have for providing
 *  this code or major recognizeable fragments thereof is for 
 *  reasonable reimbursement for expense of delivery, to include 
 *  telephone charges, media/package costs and/or postage.
 *
 *					Brian B. Riley, ka2bqe
 *					Indian Mills, New Jersey
 *
 *****************************************************************/

#include "mb.h"

char *usfile;
USER_HEADER *ufhs;
USER_RECORD *tuser;

#define KILL TRUE
#define EDIT FALSE

char *uheader = "   CALL  Log Created   Last Logged    LOG#  HiMsg L/P BCSLXP";
extern unsigned int highread,  new_highread;
extern long high_seq;

/* static char *users; */
FILE *ufl;


/*************************************************************
 * prtuser() - return user record print line for EU and DU commands
 *************************************************************/
char *prtuser(p,secure)
USER_RECORD *p;
int secure;
{
	static char buf[2*LINELEN];
	char *bbs_date();

	sprintf(buf,"\n%c %-6s %s",
		(p->options & U_CHANGE_BBS) ? '+' : ' ', 
		p->call, bbs_date(p->cr_date));
		
	sprintf(buf,"%s  %s @ %sz %4d %6ld %3d",
		buf, bbs_date(p->date), p->time, 
		p->log_count,p->msg_number, p->lines);
		
	if (secure) {
		sprintf(buf,"%s %c%c%c%c%c%c [%s]", buf,
			(p->options & U_BBS)	  ? 'B' : ' ',
			(p->options & U_PRIM_CON) ? 'C' : ' ',
			(p->options & U_SYSOP)	  ? 'S' : ' ',
			(p->options & U_LOCAL)	  ? 'L' : ' ',
			(p->options & U_EXCL)	  ? 'X' : ' ',
			(p->options & U_PROFILE)  ? 'P' : ' ',
			p->pswd);
	}
		
	sprintf(buf,"%s\n        %s\n        @%s\n        %s\n        %s %s\n        %s\n",
		buf, p->handle, lc(p->home_bbs), p->address,p->qth, p->zip,p->phone);

	return(buf);
}


aloc_user()
{
	/* Allocate space for User structures */
		
	ufhs	= (USER_HEADER *) mballoc(USER_RECSIZE);
	tuser 	= (USER_RECORD *) mballoc(USER_RECSIZE);

}

/*
	get_ufil() - get user oriented file and append to file
*/
get_ufil(tcall,fname,ext)
char *tcall, *fname, *ext;
{
	char *tname;
	
	tname = usr_name(tcall,ext);
	if (fil_xst(tname)) {
		fappend("  - - - - - -",fname);
		copfil(tname,fname,FALSE);
	}
}
/*
	get_u_info() - prepare user information text for REQUSR or local display
*/
get_u_info(fname,call)
char *fname, *call;
{
	unlink(fname);	/* start with empty file */
	if (lookup_usr(call,tuser)) {
		fappend(uheader,fname);
		fappend(prtuser(tuser,issysop()),fname);
		get_ufil(tuser->call, fname, "FNG");
		get_ufil(tuser->call, fname, "SGN");
		return (TRUE);
	} else {
		token_lin = call;
		fappend(err_string(MUSRNF2),fname);
		return(FALSE);
	}
}



/*************************************************************
 * list_user() - print user records, LU command
 *************************************************************/
list_user(argc,argv)
int argc;
char **argv;
{
	register int i,j;
	
	char *add2date();	
	USER_RECORD *urec;
	
	int found, ok;
	int mask;
	int at_bbs		= FALSE;
	int o_exclude	= FALSE;
	int o_local		= FALSE;
	int o_bbs		= FALSE;
	int o_sysop		= FALSE;
	int o_profile	= FALSE;
	int do_another;
	int rel_dat = 0;
			
	char comnd;
	
	char *fname, *s, c;
	
	comnd = *argv[0];

	if (comnd == 'I')
		if (argc < 2) 
	 		return(read_fil(sys_name(infofile,""),TRUE));

	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s != '\0'; s++) {
			uc(argv[0]);
			switch (*s) {
			case 'B':
				o_bbs++;
				break;
			case 'S':
				o_sysop++;
				break;
			case 'P':
				o_profile++;
				break;
			case 'E':
				o_exclude++;
				break;

			case 'X':
				rel_dat = atoi(argv[1]);
				argc--;
				argv++;
				break;
					
			}
		}
	}


	if (argc == 0) {
		argc 	= 1;
		argv[0] = "*";
	}
	
	for (i = 0 ; i < argc ; i++) {		/* look up individual calls */

		s = argv[i];

		tprintf("\nLooking for %s :\n",s);

		if (at_bbs = (*s == '@'))
			s++;

		if (comnd != 'E' && !at_bbs && !wildcard(s)) {
			get_u_info(msgtemp,s);
			if (fil_xst(msgtemp))
				read_fil(msgtemp,TRUE);
			continue;
		}


		found = 0;
		do_another = TRUE;

		ulockf();	/**** user file open/locked ****/
		for (j = 1 ; j  <= ufhs->count && do_another ; j++) {

			if (abort_dl())
				break;
			
			geturec(ufl, j, (char *)tuser);
			
			if (at_bbs) 
				ok = (strl2cmp(tuser->home_bbs,s) == 0);
			else
				ok = wildmatch(s,tuser->call); 

			if (ok && issysop()) {
				if (o_bbs) 
					ok = (tuser->options & U_BBS);
				else 
					if (o_exclude)
						ok = (tuser->options & U_EXCL);
					else
						if (o_sysop)
							ok = (tuser->options & U_SYSOP);
						else
							if (o_profile)
								ok = (tuser->options & U_PROFILE);
						
			}
			if (ok && rel_dat)
				ok = (strcmp(add2date(tuser->date,rel_dat),l_date) < 0);

			
			if (ok) {
				if (++found == 1) {
					outstr(uheader);
				}	

				if (stricmp(port->user->call,tuser->call) == 0)
					urec	= port->user;
				else
					urec	= tuser;

				outstr(prtuser(urec,issysop()));

				if (comnd == 'E') {
					c = '\r';
					if (!get_byte("E,K,Q,<cr> : ",&c))
						break;
		
					switch (c) {
					case 'K':
						urec->call[0]  = '*';
						outstr(prtuser(urec,issysop()));
						wrt_user(urec);
						ulockf();
						break;					
					case 'E':
						if (eurec(urec) == ERROR) {
							do_another = FALSE;
							break;
						}
						wrt_user(urec);
						ulockf();
					case 'Q':
						do_another = FALSE;
						break;
						
					default:
						break;
					}
				
				}
			}
		}
		uulockf();	/**** user file closed/unlocked */

		if (!found) {
			token_lin = s;
			if (!at_bbs && !wildcard(s) && issysop()) {
				if (get_yes_no(err_string(MNUSER)) == TRUE) {
					ulockf();	/* re-open and lock user file */
					mkuser(tuser,s);
					eurec(tuser);
					wrt_user(tuser);
				}
			} else {
				prtx_err(MUSRNF2);
			}
		}
	}
	return(0);
}



#define PARSE	TRUE
#define NOPARSE	FALSE



/**************************************************************
 * eurec(u) - edit a user record that is in buffer u
 *************************************************************/
eurec(u)
register USER_RECORD *u;
{
	
    if (!getedit("Is BBS    :")) return(ERROR);
    if (flds) {
        if (*fld[0] == 'Y') {
			u->options |= U_BBS; 
			if (u->home_bbs[0] == '\0')
				strcpy(u->home_bbs,u->call);
        } else {
			u->options &= ~U_BBS;  /* clear flag */
		}
	}

	if (u->options & U_BBS) {
	    if (!getedit("PRIME Cnct:")) return;
		if (flds)
		    if (*fld[0] == 'Y')	u->options |= U_PRIM_CON;
	   	 	else			u->options &= ~U_PRIM_CON;  /* clear flag */
	}
	


    if (!getedit("Is SYSOP  :")) return(ERROR);
	if (flds)
	    if (*fld[0] == 'Y')	u->options |= U_SYSOP; 
    	else			u->options &= ~U_SYSOP;  /* clear flag */

    if (!getedit("EXCLUDE   :")) return(ERROR);
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_EXCL; 
        else			u->options &= ~U_EXCL;  /* clear flag */

    if (!getedit("PROFILE   :")) return(ERROR);
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_PROFILE; 
        else			u->options &= ~U_PROFILE;  /* clear flag */

/*
    if (!getedit("Local User:")) return(ERROR);
    if (flds)
        if (*fld[0] == 'Y')	u->options |= U_LOCAL; 
        else			u->options &= ~U_LOCAL;  

*/
	
    if (!getedit("Lines/Page:")) return(ERROR);
    if (flds)
        u->lines = atoi(fld[0]);

	if (!getfield("Name      :",u->handle,NAMELEN,NOPARSE))	return(ERROR);
	if (!getfield("Password  :",u->pswd,12,PARSE))			return(ERROR);
/*
	if (!getfield("Language  :",u->msg_fl,1,PARSE))			return(ERROR);
*/	
	if ( getfield("Home BBS  :",u->home_bbs,MTOLEN,PARSE)) {
		check_BBS(u->home_bbs);
	} else 													return(ERROR);
	
/*
	if (!getfield("Home QTH  :",u->qth,QTHLEN,NOPARSE))		return(ERROR);
	if (!getfield("Home ZIP  :",u->zip,ZIPLEN,PARSE))		return(ERROR);
*/	
	outstr(prtuser(u,issysop()));

}

/*
 lookup_user() - look up user in user file. returns index 
                 which is user record number, or FALSE
                 assume mail file is open
*/
lookup_usr(call, buf)
char *call;
USER_RECORD *buf;
{
  int i;
  int rec = 0;

	ulockf();

	for (i = 1; i <= ufhs->count; i++) {
		geturec(ufl, i, (char *)buf);
		if (stricmp(call, buf->call) == 0) {
			rec = buf->rn;
			break;
		}
	}

	uulockf();

	return (rec);
}

/*
	mkstring() -  set user name/homebbs
*/
mkstring(argc,argv)
int argc;
char **argv;
{
	char buf[LINELEN], *p, *q, *r, *ntos();
	
	int	varsiz;
	USER_RECORD *log_user;
	extern int open_sys;
	unsigned int	y;
	long int		x;
			
	log_user = port->user;
	
		/*
			lock file and get fresh copy of the user record
		*/
	ulockf();
	if (log_user->rn)
		geturec(ufl, log_user->rn, (char *)buf);
	
	r = argv[0];
	switch (*r) {
#ifndef NEEDSPACE
	case 'L':
		prtx_err(MLANG);
		q = "language";
		p = log_user->msg_fl;
		varsiz = 1;	
		break;
#endif
	case 'A':
		q = "address";
		p = log_user->address;
		varsiz = ADDRLEN;
		break;

	case 'T':
		q = "telephone number";
		p = log_user->phone;
		varsiz = PHONELEN;
		break;

	case 'N':
		q = "name";
		p = log_user->handle;
		varsiz = NAMELEN;
		break;
	case 'Q':
		q = "QTH";
		p = log_user->qth;
		varsiz = QTHLEN;
		break;
	case 'Z':
		q = "ZIPcode";
		p = log_user->zip;
		varsiz = ZIPLEN;
		break;
	case 'H':
		q = "home BBS";
		p = log_user->home_bbs;
		check_BBS(argv[1]);
		varsiz = MTOLEN;
		break;
	case 'P':
		if ((port->type & P_TNC) 						||
			(!open_sys && (log_user->pswd[0] == '\0'))	){
			prtx_err(MPERM);
			return(0);
		}
		q = "password";
		p = log_user->pswd;
		varsiz = 12;
		break;
	case 'S':
		q = "high message read";
		p = ntos(highread);
		break;
	case 'L':
		q = "lines per page display";
		p = ntos(log_user->lines);
		break;
	}	

	if (argc > 1) {
		if (*r == 'S') {

			if (*argv[1] == 'T') {
				x = mfhs->next_msg - 1;
				y = mfhs->last;
			} else {
				if (y = getprev(atou(argv[1])+1)) {
					x = mmhs->number;
				} else {
					x = high_seq;
					y = highread;
				}
			}
			log_user->msg_number = x;
			new_highread = y;
			highread = y;
			high_seq = x;
			p = ntos(y);

		} else {
			if (*r == 'L') {
				log_user->lines = atoi(argv[1]);
				p = ntos(log_user->lines);
			} else
				strnxcat(p,argv[1],varsiz);

#ifndef NEEDSPACE
			if (*r == 'L')
				set_msgfl(argv[1]);
#endif
		}
	}		
	tprintf("Your %s is %s\n",q,p);
	wrt_user(log_user);
	return(0);
}

mkuser(buf, call)
USER_RECORD *buf;
char *call;
{
	fill(buf,'\0',USER_RECSIZE);	/* zero all bytes in record */

	strcpy(buf->call, pcall(call));

	strcpy(buf->date, l_date);
	strcpy(buf->cr_date, l_date);
	strcpy(buf->time, l_time);
	buf->wp_update_type = 'P';
	buf->options 		= (U_CHANGE_BBS+U_PROFILE);
	buf->lines			= 23;
	buf->rn 			= ++ufhs->count;
}


/*************************************************************
 * rduser() - got a user, see if we have him, read user 
 * 	 buffer, if not create user record
 *************************************************************/
rduser(call, buf)
char *call;
USER_RECORD *buf;
{

	if (lookup_usr(call,buf) == 0) {		/* must be a new user */

		ulockf();
		mkuser(buf,call);
		wrt_user(buf);
		return (TRUE);
	}
	return (FALSE); /* returns TRUE for user not found - new rec created */
}

/*************************************************************
* upduser() - update user record when he leaves 
*************************************************************/
upduser(buf)
USER_RECORD *buf;
{
	ulockf();
	
	buf->log_count++;
	buf->msg_number = high_seq;
	
	strcpy(buf->date, l_date);
	strcpy(buf->time, l_time);
	
		/* clear user table for this process ID */
    *(ufhs->users + pid*(CALLLEN+2+1)) = '\0';

	openlog();
	addcall(port->user->call, port->id);
	savelog();

	wrt_user(buf);
}

/*************************************************************
 * wrt_user() - write user record 
 *************************************************************/
void
wrt_user(buf)
USER_RECORD *buf;
{
	buf->options |= U_CHANGE_BBS;
	puturec(ufl, buf->rn, (char *)buf);
	uulockf();	/* update header, close, and unlock */
}

/********************************************************************
 * geturec() - read a record from an MB file
 ********************************************************************/
geturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs;
	int ret;

	offs = (long)rec * (long)USER_RECSIZE;
	
	if ( fseek(fid, offs, SEEK_SET))
		fatal("geturec: fseek\n");

	if ((ret = fread(buffer, USER_RECSIZE, 1, fid)) != 1)
		fatal("geturec: read err on $%04x\n",rec);

	return(FALSE);
}

/********************************************************************
 * puturec() - write a record to a MB file
 ********************************************************************/
puturec(fid, rec, buffer)
FILE *fid;
int rec;
char buffer[];
{
	long offs, off_ret;
	int ret;

	offs = (long)rec * (long)USER_RECSIZE;

	if ( fseek(fid, offs, SEEK_SET)) 
		fatal("putrec: fseek\n");
	
	ret = fwrite(buffer, USER_RECSIZE, 1, fid);
	fflush(fid);
	if ( ret != 1 ) {
		fatal("puturec: fwrite\n");
	}
	return (ret);
}

/*************************************************************
 * opnusr() - open user file get header values
 *************************************************************/
userinit()
{
	if ((ufl = fopen(usfile, "r+b")) == NULL) {
  		printf("\n\7 *** NO USER file present\n");
  		exit (5);
	}

	geturec(ufl, 0, (char *)ufhs);	/* Read the user file header.  */
	fclose(ufl);
	return (ufhs->count);
}


setlog_user(cp)
char *cp;
{
	ulockf();
	strcpy(ufhs->users+(pid*(CALLLEN+2+1)),cp);
	uulockf();
}


#include "mbmultiu.c"

