#include "mb.h"
#include "rose_ver.c"
#include <dos.h>
#include <varargs.h>

int verbose     = 0;
char workfnam1[68];
char workfnam2[68];

struct tm *ctim;

char l_time[5];
char l_date[7];

main(argc,argv)
int argc;
char *argv[];
{

	char *p, *s, line[LINELEN], *add2date();
	int curhdr, i, exitval = 0;
	
	char dat1[8], *dat2;
	int reldat = ERROR;
	
	FILE *bidfil, *outfil;
	printf("\n RSBIDMGR - ROSERVER/PRMBS BID File Manager");
	printf("\tver %s, %s\n",version,mbdate);
	
	while( --argc > 0 && (*++argv)[0] == '-') {
		for ( s = argv[0]+1; *s ; s++) {
			switch (tolower(*s)) {
			case 'v':
				verbose++;
				break;
			}
		}
	}
	
	if ( argc < 2 ) {
		fprintf(stderr," usage: rsbidmgr  [-v] bidfile {YYMMDD | #nnn}\n");
		fprintf(stderr,"  -v      - verbose mode (talking while you work!)\n");
		fprintf(stderr,"  bidfile - prmbs Bulletin  ID file name\n");
		fprintf(stderr,"  YYMMDD  - cutoff date for BID file\n");
		fprintf(stderr,"    or\n");
		fprintf(stderr,"   #nnn   - relative date in days back from today\n");
		exit(1);
	}
	
	strncpy(workfnam1,argv[0],63);
	if ((s = strchr(workfnam1,'.')) != NULL)
		*s = '\0';
	strcat(workfnam1,".$$");
	
	if ((bidfil = fopen(argv[0],"rt+")) == NULL) {
		printf("rsbidmgr: ERR open %s\n",argv[0]);
		exit(1);
	}
	if ((outfil = fopen(workfnam1,"wt+")) == NULL) {
		printf("rsbidmgr: ERR open %s\n",workfnam1);
		exit(1);
	}

	printf("\n\t... working\n");
	curtim();
	dat2 = argv[1];
	if (*dat2 == '#') {
		reldat = atoi(dat2+1);
		if (reldat == 0) {
			printf("\n\t\7 GET REAL!!! Gimme a decent date\n");
			exit(1);
		}
	} else {
		if (strcmp(dat2, "890101")<0) {
			printf("\n\t\7 GET REAL!!! Gimme a decent date\n");
			exit(1);
		}
	}
	
	while (!rdline(line,LINELEN, bidfil))  {
		remnl(line);
		if (verbose)
			printf("\n%s ",line);
		if ((p = strchr(line,' ')) !=  NULL) {
			while (*p && *p  == ' ') 
				p++;
			if (*p) {
				strnxcat(dat1,p, 6);
				if (reldat == ERROR) {
					if (strcmp(dat2,dat1)<0) {
						fprintf(outfil,"%s\n",line);
						continue;
					}
				} else {
					if (strcmp(l_date,add2date(dat1,reldat+2))<0) {
						fprintf(outfil,"%s\n",line);
						continue;
					}
				}
			}
		}
		if (verbose)
			printf("(DISCARDED)");
	}
	printf("\n");		
	fclose(bidfil);
	fclose(outfil);
	strncpy(workfnam2,argv[0],63);
	if ((s = strchr(workfnam2,'.')) != NULL)
		*s = '\0';
	
	strcat(workfnam2,".BAK");
	unlink(workfnam2);

	if ( rename(argv[0],workfnam2)) {
		printf("ERR rename of %s to %s failed\n",argv[0],workfnam2);
		exitval= 1;
	}

	if ( rename(workfnam1, argv[0])) {
		printf("ERR rename of %s to %s failed\n",workfnam1, argv[0]);
		exitval= 1;
	}

	printf("\t\7*** done\n");
	exit(exitval);
}

/*****************************************************************
 *   curtim() - Fill the globals with the current date and time
 *              by reading the system clock.
 *****************************************************************/

curtim()
{
 long ltime;
	time(&ltime);
	ctim = gmtime(&ltime);	
	(void) sprintf(l_time,"%02d%02d",ctim->tm_hour,ctim->tm_min);
	(void) sprintf(l_date,"%02d%02d%02d",ctim->tm_year,ctim->tm_mon+1,
			ctim->tm_mday);

       		/* month returned by localtime is 0-11 */
}
