/*****************************************************************
 *  MBMON.C - 11/15/86 - Monitoring ...
 *****************************************************************
 *   RATS - The Radio Amateurs Telecommunications Society
 *			presents
 *        [PRMBS] - Packet Radio MailBox System
 *        created and written by Brian B. Riley, KA2BQE
 *        with Dave Trulli, NN2Z
 *  
 *  All code contained herein is copyrighted by Brian B. Riley, 
 *  STORMYLEA Ltd.,  Jan 1987, except where specific credit is
 *  given in the procedure and or module headers for materials 
 *  gained from other sources
 *
 *  This code in generic IBMPC form for external TNCs attached to
 *  COM ports is freely given into the public domain for non-commer-
 *  cial use.
 *****************************************************************
 * This code is essentially unchanged from w0rli-cbbs v 0.62
 * it represents about 20 or 30 minor fixes by <br> and [djt]
 *****************************************************************/

#include "mb.h"

char *usrcon_fl = "usr_con.rs";
char *user_con;
int  user_con_cnt = 0;

char *s_hdr = "\n      Connected Users\n ---------------------------\n";
char *l_hdr = "\n                       Connected Users \n -----------------------------------------------------------\n";


#define CALLSTRLEN	1+CALLLEN+3
/**********************************************
 *  Add call to list.
 **********************************************/
addcall(cp, portid)
char *cp, portid;
{
	char *k, *sk, callstr[CALLSTRLEN+1];
	int i;
	int si = ERROR;
	char *chop_at();
	

	sprintf(callstr,"%c%-9.9s", portid, cp);
	
	for (i = 0, k = user_con ; i < user_con_cnt; i++, k += 20) {
		if (strnicmp(callstr,k,CALLSTRLEN) == 0) { 
			si = i; 
			sk = k; 
		}
	}
	if (si == ERROR) {
		si = user_con_cnt; 
		sk = user_con + (20 * user_con_cnt);
		if (si == USRCONLEN) { 
			si--; 
	  		sk -= 20; 
		} else { 
			user_con_cnt++;
		}
	}

	for (i = si, k = sk; i; i--, k -= 20)
		strncpy (k, k-20, 20);

	strncpy(user_con + 16, l_time, 4);
	strncpy(user_con + 10, l_date, 6);
	strncpy(user_con,callstr,CALLSTRLEN);
}

/*
	openlog() - Open the user connect file inot RAM array
*/
openlog()
{
	FILE *monfl;
	char *i, *j, *fst;
	char tline[LINELEN];

	fill(user_con,'\0',sizeof(user_con));
	
	if (monfl = sys_open(usrcon_fl, "rt")) {
		j = user_con;
		user_con_cnt = 0;
		while (!rdline(tline, LINELEN, monfl)) {
			if (iseof(tline))
				break;
			if (user_con_cnt <= USRCONLEN) {
				strncpy(j,tline,20);
				j += 20;
				user_con_cnt++;
			}		

		}
		fclose(monfl);
	}
}




/*
	savelog() - store the contents of the user log file to disk
*/
savelog()
{
	FILE *monfl;
	short i, j;

	if (monfl = sys_open(usrcon_fl, "wt")) {

		for (i = 0, j = 0; (i < user_con_cnt) && (i < USRCONLEN); i++, j += 20)
			fprintf (monfl, "%20.20s\n", user_con + j);

		fprintf (monfl, EOFstr);

		fclose (monfl);
	}
}

/*
	print_log() - display past users
*/
print_log()
{
	int i, j;
	char *p, *p1;

	openlog();

	outstr (user_con_cnt > (USRCONLEN/2) ? l_hdr : s_hdr);
	
	for (i=0, j=0; i < (USRCONLEN/2); i++, j += 20) {
		if (abort_dl())
			break;
		if (i == user_con_cnt)
			break;
		p = user_con+j;
		p1= user_con+((USRCONLEN/2)*20)+j;				
	 	tprintf(" %c %9.9s %s %4.4sz    ", 
	 		*p, p+1, bbs_date(p+10), p+16);
		if ( user_con_cnt > i + (USRCONLEN/2))
		 	tprintf(" %c %9.9s %s %4.4sz    ", 
		 		*p1, p1+1, bbs_date(p1+10), p1+16);
		
		sendnl();
    } 

/*
    sendnl();
*/
}
/*
	print_who() - display current users
*/
print_who()
{
	int i, j;
	char *p, *p1;
	extern USER_HEADER *ufhs;	


	if (multiuser) {
		ulockf();
		uulockf();
		p = ufhs->users;
		tprintf("\n       Current Users \n  ----------------------\n");
		for (i = 0 ; i < MAXPROCS ; i++, p += (CALLLEN+2+1)) {
			tprintf("   %d %-6.6s ",i, *p ? p : "<IDLE>");
			if ( i % 2 > 0 )
				sendnl();
		}
		sendnl();

	} else {
		prtx("Single user: $U\n");
	}

}
/*
check_who(cp)
char *cp;
{
	int i;
	char *p;
	extern USER_HEADER *ufhs;	
	extern int pid;

	if (multiuser) {
		ulockf();
		uulockf();
		p = ufhs->users;
		for (i = 0 ; i < MAXPROCS ; i++, p += (CALLLEN+2+1)) {
			if (pid == i)
				continue;
			if (stricmp(p,cp) == 0)
				return(TRUE);
		}
	}
	return(FALSE);

}
*/
