/**********************************************************************/
/*                                                                    */
/*     This include file contains the function prototypes for the     */
/*     C Memory Manager:                                              */
/*          ememavl                                                   */
/*          ememmax                                                   */
/*          emsize                                                    */
/*          efmalloc                                                  */
/*          seteptrs                                                  */
/*          set1eptr                                                  */
/*          set2eptrs                                                 */
/*          set3eptrs                                                 */
/*          effree                                                    */
/*          push_context                                              */
/*          pop_context                                               */
/*          effreeall                                                 */
/*                                                                    */
/**********************************************************************/
  
/**********************************************************************/
/* ememavl will return the total free expanaded memory (in bytes).    */
/**********************************************************************/
  
unsigned int ememavl (unsigned long *);
  
/**********************************************************************/
/* ememmax will return the largest allocateable block of free space.  */
/**********************************************************************/
  
unsigned int ememmax (unsigned int *);
  
/**********************************************************************/
/* emsize will return the size of the block identified by the token   */
/* passed in                                                          */
/**********************************************************************/
  
unsigned int emsize (unsigned int, unsigned int *);
  
/**********************************************************************/
/* efmalloc allocates a block of expanded memory.                     */
/**********************************************************************/
  
unsigned int efmalloc (unsigned int, unsigned int *);
  
/**********************************************************************/
/* seteptrs will attempt to provide access to the requested block(s). */
/**********************************************************************/
  
unsigned int seteptrs (unsigned int, unsigned int *, void far**);
  
/**********************************************************************/
/* set1eptr, set2eptrs, and set3eptrs are conveinence routines to call*/
/* seteptrs with 1, 2, and 3 blocks respectively.                     */
/**********************************************************************/
  
unsigned int set1eptr (unsigned int, void far**);
  
unsigned int set2eptrs (unsigned int, unsigned int, void far**, void far**);
  
unsigned int set3eptrs (unsigned int, unsigned int, unsigned int,
void far**, void far**, void far**);
  
/**********************************************************************/
/* effree will free a previously allocated block of memory.           */
/**********************************************************************/
  
unsigned int effree (unsigned int);
  
/**********************************************************************/
/* effreeall will free everything                                     */
/**********************************************************************/
  
unsigned int effreeall (void);
  
/**********************************************************************/
/* push the current context onto a stack                              */
/**********************************************************************/
  
unsigned int push_context (void);
  
/**********************************************************************/
/* pop the current context from a stack                               */
/**********************************************************************/
  
unsigned int pop_context (void);
  
/**********************************************************************/
/* map and jump to expanded memory                                    */
/**********************************************************************/
  
unsigned int map_and_jump (unsigned int, unsigned int);
  
/**********************************************************************/
/* map and call to expanded memory                                    */
/**********************************************************************/
  
unsigned int map_and_call (unsigned int, unsigned int);
  
/*====================================================================*/
