#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "kiss.h"
#include "ax25.h"
#include "trace.h"
#ifdef CRCSET
#include "crc.h"
#endif
#include "ip.h"

void
ki_dump(fp,bpp,check)
FILE *fp;
struct mbuf **bpp;
int check;
{
#ifdef CRCSET
	int para;
	int  val;

		trprintf(fp,"KISS: ");
		if(*bpp && (*(*bpp)->data & 0x80))
			if(check_crc(*bpp)){
				trprintf(fp," bad CRC!\n");
				return;
		}else{
			trprintf(fp,"CRC ");

	}

		para = PULLCHAR(bpp) & 0x7f;
		if (para == KISS_DATA){
			trprintf(fp,"DATA\n");
			ax25_dump(fp,bpp,check);
			return;

	}
	val = PULLCHAR(bpp);	
#endif
#ifndef CRCSET
	int port, para, val;
	para = PULLCHAR(bpp);
	port = para >> 4;

	if((para & 0x0f) == KISS_DATA) {
		if(port)
			trprintf(fp,"(%d) ",port);
		ax25_dump(fp,bpp,check);
		return;


	}

	val = PULLCHAR(bpp);
	trprintf(fp,"KISS: ");

#endif
	switch(para){
	case KISS_TXD:
		trprintf(fp,"TxDelay %lu ms\n",val * 10L);
		break;
	case KISS_P:
		trprintf(fp,"Persistence %u/256\n",val + 1);
		break;
	case KISS_ST:
		trprintf(fp,"SlotTime %lu ms\n",val * 10L);
		break;
	case KISS_TXT:
		trprintf(fp,"TxTail %lu ms\n",val * 10L);
		break;
	case KISS_FD:
		trprintf(fp,"%sduplex\n",val == 0 ? "Half" : "Full");
		break;
	case KISS_HW:
		trprintf(fp,"Hardware %u\n",val);
		break;
	case KISS_RETURN:
		trprintf(fp,"RETURN\n");
		break;
	default:
		trprintf(fp,"code %u arg %u\n",para,val);
		break;
	}
}

int
ki_forus(iface,bp)
struct iface *iface;
struct mbuf *bp;
{
	struct mbuf *bpp;
	int i = 0;

#ifndef CRCSET
	if((*bp->data & 0x0f) == KISS_DATA){
		if(dup_p(&bpp,bp,1,AXALEN) == AXALEN)
			i = ax_forus(iface,bpp);
			free_p(bpp);
		}
	return i;	
}
#endif
#ifdef CRCSET
		if(bp->data[0] != KISS_DATA)
			return 0;

		dup_p(&bpp,bp,1,AXALEN);
			i = ax_forus(iface,bpp);
		free_p(bpp);
	return i;
}
#endif
