/* Miscellaneous format conversion subroutines */
#define LINELEN 256
#include <ctype.h>
#include <stdio.h>
#include "global.h"
#include "netuser.h"
#include "domain.h"

int Net_error;

/* Convert Internet address in ascii dotted-decimal format (44.0.0.1) to
 * binary IP address
 */
int32
aton(s)
char *s;
{
	int32 n;
	int i;

	if(s == NULLCHAR)
		return 0;

	n = 0;

	for(i = 24; i >= 0; i -= 8) {
		/* Skip any leading stuff (e.g., spaces, '[') */
		while(*s != '\0' && !isdigit(*s))
			s++;
		if(*s == '\0')
			break;
		n |= (int32)atoi(s) << i;
		if((s = strchr(s,'.')) == NULLCHAR)
			break;
		s++;
	}
	return n;
}

/* Convert an internet address (in host byte order) to a dotted decimal ascii
 * string, e.g., 255.255.255.255\0
 */
char *
inet_ntoa(int32 a)
{
	static char buf[20], *name;

	if(DTranslate && (name = resolve_a(a,!DVerbose)) != NULLCHAR)
		sprintf(buf,"%.16s",name);
	else
		sprintf(buf,"%u.%u.%u.%u",
			hibyte(hiword(a)),lobyte(hiword(a)),
			hibyte(loword(a)),lobyte(loword(a)) );

	return buf;
}

/* Convert hex-ascii string to long integer */
long
htol(char *s)
{
	long ret = 0;
	char c;

	while((c = *s++) != '\0'){
		c &= 0x7f;
		if(c == 'x')
			continue;	/* Ignore 'x', e.g., '0x' prefixes */
		if(c >= '0' && c <= '9')
			ret = ret*16 + (c - '0');
		else if(c >= 'a' && c <= 'f')
			ret = ret*16 + (10 + c - 'a');
		else if(c >= 'A' && c <= 'F')
			ret = ret*16 + (10 + c - 'A');
		else
			break;
	}
	return ret;
}

char *
pinet(struct socket *s)
{
	static char buf[40], port[6];

	sprintf(buf,"%s:",inet_ntoa(s->address));

	switch(s->port) {
		case 7:			/* Echo data port */
			strcat(buf,"echo");
			break;
		case 9:			/* Discard data port */
			strcat(buf,"discard");
			break;
		case 20:		/* FTP Data port */
			strcat(buf,"ftp-data");
			break;
		case 21:		/* FTP Control port */
			strcat(buf,"ftp");
			break;
		case 23:		/* Telnet port */
			strcat(buf,"telnet");
			break;
		case 25:		/* Mail port */
			strcat(buf,"smtp");
			break;
		case 53:		/* Domain Nameserver */
			strcat(buf,"domain");
			break;
		case 79:		/* Finger port */
			strcat(buf,"finger");
			break;
		case 87:		/* Chat port */
			strcat(buf,"chat");
			break;
		case 109:		/* POP2 port */
			strcat(buf,"pop2");
			break;
		case 110:		/* POP3 port */
			strcat(buf,"pop3");
			break;
		case 119:		/* NNTP port */
			strcat(buf,"nntp");
			break;
                case 513:               /* Remote login */
                        strcat(buf,"rlogin");
                        break;
		case 1234:		/* Pulled out of the air */
			strcat(buf,"remote");
			break;
		case 3600:		/* conversd socket */
			strcat(buf,"convers");
			break;
		case 3601:
			strcat(buf,"xconvers");
			break;
		default:
			sprintf(port,"%u",s->port);
			strcat(buf,port);
			break;
	}
	return buf;
}

