PROGRAM REQTST;



VAR BOXPATH:STRING;



{ Berechnung der Unix-Zeit (Sekunden ab 1.1.1970). Joachim Schurig, DL8HBS }

{ time_t ist longint                                                       }

TYPE time_t = LONGINT;





const

    ix_ytable   :   array[70..137] of time_t=

                   ( 0,  31536000,  63072000,  94694400, 126230400, 157766400,

             189302400, 220924800, 252460800, 283996800, 315532800, 347155200,

             378691200, 410227200, 441763200, 473385600, 504921600, 536457600,

             567993600, 599616000, 631152000, 662688000, 694224000, 725846400,

             757382400, 788918400, 820454400, 852076800, 883612800, 915148800,

             946684800, 978220800,1009756800,1041292800,1072828800,1104451200,

            1135987200,1167523200,1199059200,1230681600,1262217600,1293753600,

            1325289600,1356912000,1388448000,1419984000,1451520000,1483142400,

            1514678400,1546214400,1577750400,1609372800,1640908800,1672444800,

            1703980800,1735603200,1767139200,1798675200,1830211200,1861833600,

            1893369600,1924905600,1956441600,1988064000,2019600000,2051136000,

            2082672000,2114294400   );



    ix_mtable   :   array[1..12] of time_t=

                            (   0, 2678400, 5097600, 7776000, 10368000,

                                13046400, 15638400, 18316800, 20995200,

                                23587200, 26265600, 28857600   );           





{UNIC-Zeit-Berechnungen von DL8HBS}

function calc_ixtime(d,m,y,h,mi,s:byte):LONGINT;

var erg     :   LONGINT;

begin

    erg := 0;

    if (y >= 80) and (y <= 137) then begin

        if (m >= 1) and (m <= 12) then begin

            erg := ix_ytable[y] + ix_mtable[m]

                    + longint(pred(d)) * 86400

                    + longint(h) * 3600

                    + longint(mi) * 60

                    + longint(s);

            if (m > 2) and ((y and 3 = 0) and (y <> 100)) then

                erg := erg + 86400;

        end;

    end;

    calc_ixtime := erg;

end;



procedure decode_ixtime(ix:time_t;var d,m,y,h,min,s:byte);

var zsum    :   time_t;

begin

    if ix >= 0 then begin

        y   := 137;

        while ix_ytable[y] > ix do dec(y);



        zsum    := ix - ix_ytable[y];

        m       := 12;



        if (ix > 63072000) and ((y and 3 = 0) and (y <> 100)) then

            zsum    := zsum - 86400;

            

        while ix_mtable[m] > zsum do dec(m);



        zsum    := zsum - ix_mtable[m];

        d       := succ(zsum div 86400);

        

        zsum    := zsum mod 86400;

        

        h       := zsum div 3600;

        min     := (zsum mod 3600) div 60;

        s       := zsum mod 60;







    end



    else begin

        d   := 1;

        m   := 1;

        y   := 70;

        h   := 0;

        min := 0;

        s   := 0;

    end;



end;





FUNCTION FindUniqueImportFilename: STRING;

VAR S,Hlp: STRING;

    DT: DateTime;

    aword: WORD;

    Lfd: WORD;

    i: BYTE;

BEGIN

  GetDate(DT.Year,DT.Month,DT.Day,aword);

  GetTime(DT.Hour,DT.Min,DT.Sec,aword);



  STR(DT.Month,Hlp);

  FOR i := 0 TO 1 DO IF LENGTH(Hlp)=i THEN Hlp := '0' + Hlp;

  STR(DT.Day,S);

  FOR i := 0 TO 1 DO IF LENGTH(S)=i THEN S := '0' + S;

  S := S + Hlp;



  STR(DT.Hour,Hlp);

  FOR i := 0 TO 1 DO IF LENGTH(Hlp)=i THEN Hlp := '0' + Hlp;

  S := S + Hlp;

  STR(DT.Min,Hlp);

  FOR i := 0 TO 1 DO IF LENGTH(Hlp)=i THEN Hlp := '0' + Hlp;

  S := S + Hlp;



  Lfd := 0;

  REPEAT

    STR(Lfd,Hlp);

    FOR i := 0 TO 2 DO IF LENGTH(Hlp)=i THEN Hlp := '0' + Hlp;



    Hlp := S+'.'+Hlp;

    inc(Lfd);

  UNTIL NOT FileDa(BoxPath+'IMPORT\'+Hlp);

  FindUniqueImportFilename := Hlp;

END;



VAR if,of:TEXT;

    filename,BOXPATH,Sender,title,mycall,

    Receiver,LifeTime,Distribution,BID,time,line:STRING;

    B:BYTE;time_l:time_t;val_result:INTEGER;

    day,mount,year,hout,minute,second:BYTE;

    path_bbs:STRING;count_per_line:BYTE;

BEGIN

  {$I-}

  BoxPath:=Paramstr(1);

  (* First we need to determine our own callsign, I get it from MCUT's 

     Configuration-File, your Server may get it from where you like ... *)

  Assign(if,BoxPath+'BOX.CFG');

  Reset(if); IF IORESULT<>0 THEN halt(3);

  REPEAT

    READLN(if,line);

    IF IORESULT<>0 THEN halt(3);

    For B:=1 TO length(line) do line[b]:=upcase(line[b]);

  UNTIL POS('SF_CALL',line)>0;

  close(if);

  mycall:=copy(line(pos('=',line)+1,255);

  if pos('-',mycall)>0 THEN mycall:=copy(mycall,1,pos('=',mycall)-1);

  FileName:=Paramstr(1)+Paramstr(2);

  Assign(if);Reset(if);IF IORESULT<>0 THEN halt(3);

  (* The first line of each BBS-File contains the callsigns of the S&F-neighbours,

     the bulletin shall be forwarded to. If already done, there is a * in front

     of the callsign. We ignore this here*)

  ReadLn(if);

  (* The second line contains the callsigns which have already read the bulletin *)

  ReadLn(if);

  (* Now wie read the header, the order is not fixed, so you have to read it

     line by line, until you read a "NNNN" *)

  REPEAT

    REALDN(if,line);

    (* Determine the sender of the Message *)

    IF COPY(line,1,3)='SND' THEN

    BEGIN

      Sender:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='REC' THEN

    BEGIN

      Receiver:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='SUB' THEN

    BEGIN

      Title:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='LTM' THEN

    BEGIN

      LifeTime:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='VER' THEN

    BEGIN

      Distribution:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='BID' THEN

    BEGIN

      BID:=COPY(line,5,255);

    END ELSE

    IF COPY(line,1,3)='UXT' THEN

    BEGIN

      time:=COPY(line,5,255);

    END;

  until line='NNNN';

  ASSIGN(of,FindUniqueImportFileName);

  REWRITE(of);

  WriteLn(of,'S '+sender+' < '+mycall);

  WriteLn(of,'REQTST-Server Reply:'+title);

  WriteLn(of);

  VAL('$'+time,time_l,val_result);

  decode_ixtime(time_l,day,month,year,hour,minute,second);

  WriteLn(of,'Your Message received at '+mycall+' the' ,day,'.',month,'.',year,

             ' ',hour,':',minute);

  WriteLn(of,'Your Message-Title:'+title);

  WriteLn(of,'Bulletin-ID:'+bid);

  WriteLn(of,'The Path of your Mail:');

  count_per_line:=0;

  REPEAT

    ReadLn(if,line);

    IF copy(line,1,2)='R:') THEN

    BEGIN

      Write(of,'!');

      path_bbs:=copy(line,pos('@',line)+1,255);

      IF path_bbs[1]=':' THEN Path_bbs:=copy(path_bbs,2,255);

      if pos(' ',Path_bbs)>0 THEN path_bbs:=copy(path_bbs,1,pos(' ',path_bbs)-1);

      if pos('.',Path_bbs)>0 THEN path_bbs:=copy(path_bbs,1,pos('.',path_bbs)-1);

      Write(of,path_bbs);

      inc(count_per_line);

      if count_per_line=10 THEN

      BEGIN

        WriteLn(of);

        count_per_line:=0;

      END;

    END;    

  UNTIL copy(line,1,2)<>'R:';         

  WriteLn(of);

  WriteLn(of,'The Body of your Message:');

  WHILE NOT EOF(if) DO

  BEGIN

    ReadLn(if,line);

    WriteLn(of,'>'+line');

  END;

  close(of);close(if);

  (* tell MCUT to kill the REQuest-Mail, we dont need it any more *)

  halt(2);  

  (* Thats all folks *);

END.  

