#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>

struct UserRec { unsigned char channel;
                 unsigned char mode; /*  0 = Do Nothing with File    */
                                     /*  1 = Kill File after execute */
                                     /*  2 = Send 'FileName' as text */
                                     /*  3 = Send Frame block        */
                                     /*  4 = Show Frame block        */
                 unsigned char filename_length;
                 char          filename[80];
               };

struct Channel_Rec { char          UserCall [10];
                     char          MyCall   [10];
                     char          ProgName [13];
                     char          PrgNme   [13];
                     unsigned char ExecLevel;
                     unsigned char ConnectMode;
                     unsigned int  Hours,Minutes,Seconds;
                     char          InitCall[10];
                   };

struct MHeardRec { char          call[10];
                   unsigned char Port;
                   struct ftime  Time;
                 };

int NPGInt;
struct MHeardRec MH[26];
struct Channel_Rec CR[21];
char *conmode[3] = {"disconnected","incoming","outgoing"};

int NPG_check()
{ int i = 0;
  void far *sptr;
  char tempstr[9];

  int OK = 0;
  i = 0;
  while ( (i<=255) && (!OK))
  { sptr = _dos_getvect(i);
    movedata((unsigned)FP_SEG(sptr),
             (unsigned)FP_OFF(sptr),
             (unsigned)FP_SEG(tempstr),(unsigned)FP_OFF(tempstr),8);

    tempstr[8] = '\0';
    if (strcmp(tempstr+2,"NwPkGn") == 0)  OK = 255;
                                     else i++;
  }

  return i;
}

unsigned int NPG_Version(void)
{ REGS regs;

  regs.h.ah = 0;
  int86(NPGInt,&regs,&regs);
  return regs.x.ax;
}

unsigned char NPG_SysopChannel(void)
{ REGS regs;

  regs.h.ah = 2;
  int86(NPGInt,&regs,&regs);
  return regs.h.al;
}


unsigned char NPG_Channels(void)
{ REGS regs;

  regs.h.ah = 3;
  int86(NPGInt,&regs,&regs);
  return regs.h.al;
}

void NPG_Mheard(void)
{ REGS regs;
  SREGS sregs;

  regs.h.ah = 4;
  int86x(NPGInt,&regs,&regs,&sregs);

  movedata(sregs.es,regs.x.bx,FP_SEG(MH),FP_OFF(MH),sizeof(MHeardRec)*26);

}

void NPG_ChannelRec(void)
{ REGS regs;
  SREGS sregs;

  regs.h.ah = 1;
  int86x(NPGInt,&regs,&regs,&sregs);

  movedata(sregs.es,regs.x.bx,FP_SEG(CR),FP_OFF(CR),sizeof(Channel_Rec)*(NPG_Channels()+1));

}



int main(int argc,  char *argv[])

{  int     f_handle;  /* file handle, for output to USERS.NPU */
   FILE    *f_text;   /* file handle, for output to user      */
   UserRec users;     /* structure with data for user         */
   int     i;
   struct  date    dt;
   struct  time    tm;
   char    MyCall[10],UserCall[10];

  if (argc<6) return 0;
  _fmode = O_BINARY;  /* set file-mode to binary */
  /* open/create a file (permission to read and write) */
  /* File will be used to store UserRec                */
  if ((f_handle = creat("users.npu", S_IREAD|S_IWRITE))==-1)
  {
    perror("Error:"); /* couldn't create file */
    return 0;
  }

  /* open/create a file for writing             */
  /* File will be used to store output for user */
  if ((f_text = fopen("temp.txt", "w+"))==NULL)
  {
    perror("Error:");
    return 0;
  }

  NPGInt = NPG_check();
  /* Show program info */
  fprintf(f_text,"C++ example program for NPG v1.03\r\n\r\n");

  /* Make a bar */
  for (i=0;i<80;i++) fprintf(f_text,"-");

  /* Skip a line */
  fprintf(f_text,"\r\n");

  fprintf(f_text,"NPG found at interrupt  : %u (%xh)\r\n",NPGInt,NPGInt);
  fprintf(f_text,"NPG version             : %i.%02i\r\n",NPG_Version() >> 8,NPG_Version() & 0xFF);
  fprintf(f_text,"Sysop at channel number : %2i\r\n",NPG_SysopChannel());
  fprintf(f_text,"Number of channels used : %2i\r\n\r\n",NPG_Channels());

  NPG_Mheard();

  for (i=0;i<26;i++)
  {  strncpy(MyCall,MH[i].call+1,9);
     MyCall[9] = '\0';
     if (strcmp(MyCall,"         ")!=0)
     {
       fprintf(f_text,"%3i %-12s port=%3i time= %02u:%02u:%02u  date= %2u/%02u/%4u\r\n",
	       i+1,MyCall,MH[i].Port,
               MH[i].Time.ft_hour,
               MH[i].Time.ft_min,
               MH[i].Time.ft_tsec*2,
               MH[i].Time.ft_day,
               MH[i].Time.ft_month,
               MH[i].Time.ft_year+1980);
     }
  }
 /* Skip a line */
  fprintf(f_text,"\r\n");

  NPG_ChannelRec();

  for (i=0;i<=NPG_Channels();i++)
  { strncpy(MyCall,CR[i].MyCall+1,9);
    MyCall[9] = '\0';
    strncpy(UserCall,CR[i].UserCall+1,9);
    UserCall[9] = '\0';

    switch (CR[i].ConnectMode)
    { case 0 : fprintf(f_text,"%3i My= %-10s",i,MyCall);
	       if (i==0) fprintf(f_text,"[monitor]\r\n");
		    else fprintf(f_text,"[disconnected]\r\n");
	       break;
      case 1: case 2:
	       fprintf(f_text,"%3i My= %-10sUsr= %-10s[%s] C-Time= %02i:%02i:%02i",
			      i,MyCall,UserCall,conmode[CR[i].ConnectMode],
			      CR[i].Hours,CR[i].Minutes,CR[i].Seconds);
	       if (strcmp(CR[i].PrgNme,"") != 0)
		      fprintf(f_text," Prg=%s\r\n",CR[i].PrgNme+1);
		 else fprintf(f_text,"\r\n");

	    break;

    }
  }


 /* Make a bar */
  for (i=0;i<80;i++) fprintf(f_text,"-");

  /* Skip a line */
  fprintf(f_text,"\r\n");

  /* init userrec */
  users.channel  = atoi(argv[5]); /* channel to send the data to            */
  users.mode     = 1;             /* send file and erase file after sending */
  strcpy(users.filename,"temp.txt"); /* set file to send */
  users.filename_length = strlen(users.filename); /* set filename length */
  write(f_handle,&users,sizeof(users));           /* write data to file  */


  /* close both files */
  close(f_handle);
  fclose(f_text);

  return 2;
}