#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>

void prnc(int c);
void process_line(char *line, FILE *faxprn);

void main(int argc, char *argv[])

{
FILE *fax;
FILE *faxprn;
char buff[100];
char home[100];
char *ptr;
int t, i;
int z, c, d, l;
long lines;
int li;
int inv = 0;
int rev = 0;
char lon[100];
char loff[100];
char gon[100];

char *mess = "FAXDUMP V 1.02 - (C) Jon Welch 24/02/92\n\n"
			 "Syntax : FAXDUMP <filename> (-I) (-R)\n";

	if (argc < 2) {
		fprintf(stderr, mess);
		exit(1);
	}

	for (i = 2; i < argc; ++i) {
		if (argv[i][0] == '-') {
			switch (toupper(argv[i][1])) {
				case 'I' : inv = 255;
						   break;
				case 'R' : rev = 1;
						   break;
			}
		}
	}

	strcpy(home, argv[0]);
	ptr = home + strlen(home) - 1;
	while (*ptr != '\\') {
		ptr--;
	}
	ptr[1] = 0;

	fax = fopen(argv[1], "rb");
	if (fax == NULL) {
		fprintf(stderr, "error : cannot open '%s'\n", argv[1]);
		exit(1);
	}

	fseek(fax, 0L, SEEK_END);
	lines = (ftell(fax) + 79L) / 80L;
	li = (int) lines;
	fseek(fax, 0L, SEEK_SET);

	sprintf(buff, "%sfaxdump.cfg", home);
	faxprn = fopen(buff, "rt");
	if (faxprn == NULL) {
		fprintf(stderr, "error : cannot open '%s'\n", buff);
		fclose(fax);
		return;
	}

	process_line(lon, faxprn);
	process_line(gon, faxprn);
	process_line(loff, faxprn);
	fclose(faxprn);

	for (i = 0; i < lon[0]; ++i) {
		prnc(lon[i + 1]);
	}

	for (z = 0; z < li; ++z) {

		memset(buff, inv, 80);
		fread(buff, 80, 1, fax);

		for (i = 0; i < gon[0]; ++i) {
			prnc(gon[i + 1]);
		}

		for (c = 0; c < 80; c++) {
			t = 0;
			for (d = 0; d < 8; ++d) {
				if (rev == 0) {
					t = t * 2 + (buff[c] & 128) / 128;
					buff[c] = (buff[c] * 2) & 255;
				} else {
					i = 79 - c;
					t = t * 2 + (buff[i] & 1);
					buff[i] = (buff[i] / 2) & 255;
				}
			}
			prnc(t ^ inv);
		}
		if (bioskey(1) != 0) {
			bioskey(0);
			break;
		}
	}
	fclose(fax);

	for (i = 0; i < loff[0]; ++i) {
		prnc(loff[i + 1]);
	}

}

void prnc(int c)

{
	biosprint(0, c, 0);
}

void process_line(char *line, FILE *faxprn)

{
int i;
char *ptr;
char *ptr1;
char buff[81];

	i = 0;
	while (fgets(buff, 81, faxprn)) {
		*strchr(buff, 10) = 0;
		if (strcmp(buff, "***") == 0) break;
		ptr1 = buff;
		ptr = strchr(ptr1, ',');
		do {
			if (*ptr1 == 39) {
				ptr1++;
				while (*ptr1 != 39) {
					line[++i] = *ptr1++;
				}
			} else {
				line[++i] = atoi(ptr1);
			}
			if (ptr) {
				ptr1 = ptr + 1;
				ptr = strchr(ptr1, ',');
			} else break;
		} while (1);
	}
	line[0] = i;
}
