/* SH/FTZ */

#include "sun.h"
#include "ftz.h"

/* int program_function; */
int p_ssn ;

/* int   d;      Tag im Jahr */
/* Date  date;    Datum       */
struct tm now;
time_t tim;
int p_jahr, p_monat;
float p_x1, p_y1, p_x2, p_y2;
char pps;
char *p_call1;
char *p_call2;
char *p_ps;
/* char *ch; */
Station_Profile profile;

/* Location target_location; */
/* Location user_location; */

/* Antennengewinn abhngig von Frequenz berechnen */
float sag(float f) 
{
    int i,max;
    float g=0,m;

    max=0;
    while (profile.mhz[max] > 0 && (max<PP-1) ) { max++; }
    if (max == 0) { g=0; /* keine Angabe */ }
    else if (max == 1) { g=profile.gain[0]; /* 1 Angabe vorhanden, konstant */ }
    else if (f<=profile.mhz[0]) { g=profile.gain[0]; /* Frequenz unterhalb der ersten Angabe */ }
    else if (f>=profile.mhz[max-1]) { g=profile.gain[max-1]; /* Frequenz oberhalb der letzten Angabe */ }
    else {

        /* Wenn wir hierher kommen, liegt der gewnschte Wert irgendwo in der Mitte */
        i=0;
        while (f > profile.mhz[i]) { i++; }

        m = (profile.gain[i]-profile.gain[i-1])/(profile.mhz[i]-profile.mhz[i-1]);
        g = profile.gain[i-1] + (f-profile.mhz[i-1])*m;
    }

    return g;
}

/* Minimaler Erhebungswinkel abhngig von Frequenz berechnen */
float angm_geht_noch_nicht(float f) 
{
    int i,max;
    float a=0,m;

    max=0;
    while (profile.mhz[max] > 0 && (max<PP-1) ) { max++; }
    if (max == 0) { a=0; /* keine Angabe */ }
    else if (max == 1) { a=profile.minang[0]; /* 1 Angabe vorhanden, konstant */ }
    else if (f<=profile.mhz[0]) { a=profile.minang[0]; /* Frequenz unterhalb der ersten Angabe */ }
    else if (f>=profile.mhz[max-1]) { a=profile.minang[max-1]; /* Frequenz oberhalb der letzten Angabe */ }
    else {

        /* Wenn wir hierher kommen, liegt der gewnschte Wert irgendwo in der Mitte */
        i=0;
        while (f > profile.mhz[i]) { i++; }

        m = (profile.minang[i]-profile.minang[i-1])/(profile.mhz[i]-profile.mhz[i-1]);
        a = profile.minang[i-1] + (f-profile.mhz[i-1])*m;
    }

    return a;
}

/* Sendeleistung abhngig von Frequenz berechnen */
float zkw(float f) 
{
    int i,max;
    float p=0,m;

    max=0;
    while (profile.mhz[max] > 0 && (max<PP-1) ) { max++; }
    if (max == 0) { p=0; /* keine Angabe */ }
    else if (max == 1) { p=profile.power[0]; /* 1 Angabe vorhanden, konstant */ }
    else if (f<=profile.mhz[0]) { p=profile.power[0]; /* Frequenz unterhalb der ersten Angabe */ }
    else if (f>=profile.mhz[max-1]) { p=profile.power[max-1]; /* Frequenz oberhalb der letzten Angabe */ }
    else {

        /* Wenn wir hierher kommen, liegt der gewnschte Wert irgendwo in der Mitte */
        i=0;
        while (f > profile.mhz[i]) { i++; }

        m = (profile.power[i]-profile.power[i-1])/(profile.mhz[i]-profile.mhz[i-1]);
        p = profile.power[i-1] + (f-profile.mhz[i-1])*m;
    }

    return p;
}

/* Ausfhren von SH/FTZ      */
void sh_ftz(int max_loc)
{
   int i,loc,valid; 

   valid=0;

   switch(locations[0].pref[0])
   {
      case '#':
         print_not_in_database(locations[0].name);
         break;
      case '?':
         print_data_not_available(locations[0].name);
         break;
      default:
         print_header(F_FTZ,"");

         p_x1 = (float) locations[0].loc.lat;
         p_y1 = (float) locations[0].loc.lon;

         time(&tim);
         now = *gmtime(&tim);
         p_jahr = now.tm_year;
         p_monat = now.tm_mon +1;

         p_ssn = pg_lookup_ssn(); 
         p_ps = &pps; 
         pps = 'S'; 

         profile=pg_lookup_stn_profile(locations[0].pref);
         for (i=0;i<PP;i++) {
             printf("Band=%6.2f MHz, Gain=%6.2f dB, Min. Ang=%6.2f, Power=%6.0f Watt\n",
		profile.mhz[i],
		profile.gain[i],
		profile.minang[i],
		profile.power[i]);
         }

         for (i=1;i<50;i++) {
             printf("f=%6.2f, G=%6.2fdB, A=%6.2f P=%6.2fW\n",(float) i,sag((float) i),
			angm_geht_noch_nicht((float) i),
			zkw((float) i));
         }

      for (loc=1;loc<max_loc;loc++) {
         switch(locations[loc].pref[0])
         {
            /* target location */  

            case '#':
                print_not_in_database(locations[loc].name);
                break;

            case '?':
                print_data_not_available(locations[loc].name);
                break;

            default:
                p_x2  = (float) locations[loc].loc.lat;
                p_y2  = (float) locations[loc].loc.lon;
                p_call1 = (char *) &locations[0].name;
                p_call2 = (char *) &locations[loc].name;
                ftz_kern(p_ssn,p_jahr,p_monat,p_x1,p_y1,p_x2,p_y2,p_ps,
                         p_call1,p_call2);  

            valid++;
        }
      }
      print_foot(valid,F_FTZ);
   }
}


void sh_ftz6(int max_loc)
{
    return;
}
