#include "sun.h"
#include "ftz.h"
#include "libpq-fe.h"

char	*pghost, *pgport, *pgoptions, *pgtty;
PGconn* conn;
char	cmd[255];

void exit_nicely(PGconn* conn)
{
  PQfinish(conn);
}

int pg_init()
{
   int rc;
   char dbName[16];

#ifdef DEBUG
  printf("Start pg_init\n");
#endif

  pghost = NULL;
  pgport = NULL;
  pgoptions = NULL;
  pgtty = NULL;
  strcpy(dbName,"clx_db");

  conn = PQsetdb(pghost, pgport, pgoptions, pgtty, dbName);

  if (PQstatus(conn) == CONNECTION_BAD)
  {
    fprintf(stderr,"Connection to database '%s' failed.\n", dbName);
    fprintf(stderr,"%s",PQerrorMessage(conn));
    exit_nicely(conn);
    rc = 0;
  } 
  else
  {
     rc = 1;
  }
  return(rc);
}

/* Sucht usercall in User-Datenbank                        */
/* Wenn gefunden, dann wird Location-Eintrag zurckgegeben */
/* Falls nicht, dann ist String in location.pref leer      */
/* Falls User gefunden, aber kein Locator eingegeben, dann */
/* dann ist String location.name leer 							  */
Location pg_lookup_us_data(char* user_call)
{
   int lat_deg,lat_min,lon_deg,lon_min;
   char ew,ns;
   PGresult* res;
   Location location;

#ifdef DEBUG
   printf("Start pg_lookup_dxcc_pfx\n");
#endif

   if (pg_init()==0) {
	printf("Postmaster not running.\n");
	exit(1);
   }

   strip_ssid(user_call);
   sprintf(cmd,"select us_qth,us_loc from us_data where us_call='%s'",user_call);

#ifdef DEBUG
   printf("CMD: %s\n",cmd);
#endif

   res = PQexec(conn,cmd);

   if ( PQntuples(res) < 1 )
   { 
     strcpy(location.pref,"---");
   }
   else
   {
      strcpy(location.pref,user_call);
      if ( ( sscanf(PQgetvalue(res,0,1),"%d %d %c %d %d %c",
			&lat_deg,&lat_min,&ns, &lon_deg,&lon_min,&ew ) > 0 ))
      {
#ifdef DEBUG
      	printf("LAT: %d %d %c   LON: %d %d %c\n",
            lat_deg,lat_min,ns,lon_deg,lon_min,ew);
#endif

      	location.loc.lat = lat_deg+(double) lat_min/60.0;
         if (ns == 's') location.loc.lat = -location.loc.lat;
	
      	location.loc.lon=lon_deg+(double) lon_min/60.0;
         if (ew == 'w') location.loc.lon = -location.loc.lon;

         strcpy(location.name,PQgetvalue(res,0,0));
         location.timezone=0.0;
         location.qrb=0;
         location.qtf=0;
         location.suntimes.rise=0;
         location.suntimes.set=0;
     }
     else
     {
      	strcpy(location.name,"");
     }
  }

  PQclear(res);
  PQfinish(conn);
  return location;
}

/* Sucht s_pfx in DXCC-Datenbank                           */
/* Wenn gefunden, dann werden Location-Eintraege ab der    */
/* Position start  in das globale Array Location abgelegt  */
/* und die Anzahl der Eintrge zurckgegeben               */
/* Falls nicht, dann wird 0 zurckgegeben                  */
int pg_lookup_dxcc_pfx(char *s_pfx, int start)
{
   PGresult* res;
   char	c_pfx[16],land_n[80];
   int	i,rows;
   
#ifdef DEBUG
  printf("Start pg_lookup_dxcc_pfx\n");
#endif

   if (pg_init()==0) {
	printf("Postmaster not running.\n");
	exit(1);
   }

/* Alt, bis Version 4.03: */
/* sprintf(cmd,"select  a.c_pfx, b.s_pfx, b.land_n, b.geo_loc[1],b.geo_loc[2] \
        	from dxcc_pfx a, dxcc_dat b \
                where '%s'::text ~ c_pfx AND a.s_pfx = b.s_pfx",s_pfx);
*/


/* Neu ab Version 4.04 */
   sprintf(cmd,"select  a.c_pfx, b.s_pfx, b.land_n, b.geo_loc[1],b.geo_loc[2] \
        	from dxcc_pfx a, dxcc_dat b \
                where ('%s'::text ~ a.c_pfx OR a.c_pfx = '^%s') \
                AND a.c_pfx = b.s_pfx",s_pfx,s_pfx);


#ifdef DEBUG
  printf("CMD: %s\n",cmd);
#endif

  res = PQexec(conn,cmd);
  rows = PQntuples(res);

  i=0;

  if ( rows >= 0 )
  {
     while (i<rows)
     {
      	 strcpy (c_pfx,PQgetvalue(res,i,1));
         strcpy (land_n,PQgetvalue(res,i,2));
         locations[start].loc.lat = atoi(PQgetvalue(res,i,3));
         locations[start].loc.lon = -1.0*atoi(PQgetvalue(res,i,4));
         strcpy(locations[start].pref,c_pfx);
         strcpy(locations[start].name,land_n);
         locations[start].timezone=0.0;
         locations[start].qrb=0;
         locations[start].qtf=0;
         locations[start].suntimes.rise=0;
         locations[start].suntimes.set=0;
         i++;
     }
  }
  PQclear(res);
  PQfinish(conn);
  return (1);
}


/* Ermitteln des letzten Eintrags von SSN aus den WWV-Daten */
int pg_lookup_ssn()

{
   int ssn,sf,rows; 
   PGresult* res;
   float a=0.7E-03;
   float b=0.75;
   float c=66.0;

#ifdef DEBUG
   printf("Start pg_lookup_ssn\n");
#endif
   ssn = 0;
   pg_init();

   /* select WWV spots from last 24 hours */
   sprintf(cmd,"select avg(wwv_sfi) from wwv_data \
	where wwv_date='today' and wwv_hour<=%d \
	or    wwv_date='yesterday' and wwv_hour>%d",
	now.tm_hour,now.tm_hour);

#ifdef DEBUG
   printf("CMD: %s\n",cmd);
#endif

   res = PQexec(conn,cmd);

#ifdef DEBUG
  printf(" gefundene Datensaetze: %3d\n", PQntuples(res));
#endif

   rows = PQntuples(res); 
   if ( rows < 1 )
   { 
     ssn = 0; 
   }
   else
   {
      sf = atoi(PQgetvalue(res,0,0));
      if ( sf == 0 ) {
	ssn = 0;
      } else {
      	ssn = (int) ((-b+sqrt(b*b-4.0*a*(c- (float) sf)))/(2.0*a));
      }

#ifdef DEBUG
      printf("\nSolar data :ssn %4d, sfi %4d, time %4d UTC \n",
          ssn,sf,now.tm_hour);
#endif

   }

   PQclear(res);
   PQfinish(conn);
   return ssn;
}

Station_Profile pg_lookup_stn_profile(char* user_call)
{
	Station_Profile profile;
	PGresult* res;
        char ftz_data[8192],*p,name[8];
	int i;
	float value;

   for (i=0;i<PP;i++) {
        profile.mhz[i] = 0;
        profile.gain[i] = 0;
        profile.minang[i] = 0;
        profile.power[i] = 0;
   }

   if (pg_init()==0) {
	printf("Postmaster not running.\n");
	exit(1);
   }
   sprintf(cmd,"select ftz_data from us_data where us_call='%s'",user_call);

#ifdef DEBUG
   printf("CMD: %s\n",cmd);
#endif

   res = PQexec(conn,cmd);

   strcpy(ftz_data,DEFAULT_FTZ_DATA);

   if ( PQntuples(res) >= 1 )
   { 
     strcpy(ftz_data,PQgetvalue(res,0,0));
   }

   if (strlen(ftz_data) == 0) {
     strcpy(ftz_data,DEFAULT_FTZ_DATA);
   }

   if (strcmp(strupr(ftz_data),"P1") == 0) {
     strcpy(ftz_data,PROF1);
   }

   if (strcmp(strupr(ftz_data),"P2") == 0) {
     strcpy(ftz_data,PROF2);
   }

   if (strcmp(strupr(ftz_data),"P3") == 0) {
     strcpy(ftz_data,PROF3);
   }

   if (strcmp(strupr(ftz_data),"P4") == 0) {
     strcpy(ftz_data,PROF4);
   }

   if (strcmp(strupr(ftz_data),"P5") == 0) {
     strcpy(ftz_data,PROF5);
   }

#ifdef DEBUG
   printf("ftz_data: >>%s<<\n",ftz_data);
#endif


/* 
 * Nachricht #7159 von dj0zy:                                                      
 * hi ben,
 * ja das ist die schwaeche von strtok. ich habe mir selber dafuer eine 
 * klasse im clx geschrieben, um die strtok auch schachteln zu koennen. 
 * es laeuft aber nur unter c++. fuer dein fall gibt's aber eine 
 * ander einfache loesung: hier nur der mittlere teil -
 *  
 * value = atof(strchr(p, '=') + 1);
 * *strchr(p, '=') = '\0';
 * strcpy(name, p);
 *  
 * wie schon zuletzt erwaehnt, funktioniert nur dann, wenn du auf eine
 * syntax-pruefung sicher verzichten kannst.
 *  
 * 73 de franta
 *
 */

 /* Syntaxprfung!? Bisher keine! */
 
   i=-1;
   p=strtok(ftz_data,"/ \t\n");
   while(p && (i<PP) ) {
#ifdef DEBUG
        printf("String: %s -> ",p);
#endif
        value = atof(strchr(p, '=') + 1);
        *strchr(p, '=') = '\0';
        strcpy(name, p);
#ifdef DEBUG
        printf("Name: %s, Value: %f\n",name,value);
#endif
        if (strcmp(name,"B") == 0) { i++; profile.mhz[i] = value; }
        if (strcmp(name,"G") == 0) { profile.gain[i] = value; }
        if (strcmp(name,"A") == 0) { profile.minang[i] = value; }
        if (strcmp(name,"P") == 0) { profile.power[i] = value; }
        p=strtok(NULL,"/ \t\n");
   }

   ipp=i;
   return profile;
}
