/************************/
/* Defines  		*/
/************************/
#define USAGE       1201
#define NOAVAIL     1203
#define NOINDB      1204
#define SUN_HEAD    1205
#define SUN_LOC     1206
#define OUT_SUN     1207
#define HEAD_LOC    1208
#define OUT_HEADING 1209
#define OUT_HEAD_LP 1210
#define COUNT       1211
#define ENTER_LOC   1212
#define HEAD_HEAD   1213
#define GRAY_HEAD   1214
#define GRAY_LOC    1215
#define OUT_GRAY    1216
#define COORD_HEAD  1217
#define OUT_COORD   1218
#define TRIG_HEAD   1219
#define OUT_TRIG    1220
#define ERR_TRIG    1221
#define USAGE_TRIG  1222
#define MOON_HEAD   1225
#define MOON_LOC    1226
#define OUT_MOON    1227
#define USAGE_FTZ   1231
#define FTZ_HEAD    1233
#define FTZ6_HEAD   1234

#define NIL 0  		/* Dummy-Funktion   */
#define HEADING	1	/* Funktion SH/HEAD, SH/DISTANCE */
#define SUN 2		/* Funktion SH/SUN  */
#define GRAYLINE 3  	/* Funktion SH/GRAYLINE */
#define COORDINATES 4  	/* Funktion SH/COORDINATES, SH/LOCATOR */
#define TRIGPOINT 5  	/* Funktion SH/SCATTER, SH/TRIGPOINT */
#define MOON 6  	/* Funktion SH/MOON */
#define F_FTZ 7  	/* Funktion SH/FTZMUF */
#define F_FTZ6 8  	/* Funktion SH/FTZMUF6 */
#define FTZ_PROF 9  	/* Funktion SH/FTZ_PROFILE */
#define MAXLOCATION 1000

/*******************/
/* Include Dateien */
/*******************/
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

/************/
/* Typedefs */
/************/
typedef struct  /* enthlt Tag/Monat */
{
	int	day;
	int	month;
	char	lit_month[16];
} Date;

typedef struct	/* enthlt Sunrise/set-Times */
{
	int rise;
	int set;
} Sun;

typedef struct	/* enthlt Sunrise/set-Times sowie Graylinezeiten */
{
   int dawn;
	int rise;
	int set;
   int dusk;
   int gcase;
} Grayline;

typedef struct  /* enthlt Breiten-/Lngengrad */
{
        double lat;
        double lon;
} Loc;

typedef struct  /* QTH-Record */
{
        char pref[10];
        char name[31];
        Loc  loc;
        float  timezone;
        Sun  suntimes;
        int  qrb;
        int  qtf;
} Location;

typedef struct	/* enthlt Moonrise/set-Times und Azimut/Elevation */
{
	int rise;
	int set;
        double az;
        double el;
} Moon;

typedef struct	/* enthlt Azimut/Elevation */
{
        double az;
        double el;
} Azel;


/********************************************/
/* Globale Variablen                        */
/********************************************/

#ifndef MAIN
extern int program_function;	/* legt die Funktion des Programms fest */
extern int     d;      /* Tag im Jahr */
extern Date    date;   /* Datum       */
extern Location locations[MAXLOCATION+1];
extern int qrb,qtf;
extern char progname[128];
extern char dirname[128];
extern int num_arg[16];
#endif


/********************************************/
/* Globale Funktionen                       */
/********************************************/

Sun sunrisetimes(double x,double y);
Moon moonrisetimes(double x,double y);
Grayline graylinetimes(double x,double y);
char *min2tim(int time);
char *strip_ssid(char *s);
char *get_date();
char *strupr(char *s);
char *strlwr(char *s);
int isloc(char *s);
int isnum(char *s);
Location r_locator(char *loc);
int scan_locations(char *s_pfx, int start);
Location pg_lookup_us_data(char *user_call);
int pg_lookup_dxcc_pfx(char *s_pfx,int start);
void dx(double l1, double b1, double lf, double bf);
void locator(Loc l,char *locator);
float moon_phase();

void sh_trigpoint(int max_loc, int nn);
void sh_head(int max_loc);
void sh_coordinates(int max_loc);
void sh_grayline(int max_loc);
void sh_sun(int max_loc);
void sh_moon(int max_loc);
void sh_ftz(int max_loc);
void sh_ftz6(int max_loc);
void sh_ftz_profile(int max_loc);

/********************************************/
/* Funktionen in output.c                   */
/********************************************/

#ifndef OUTPUT
void print_dashes(int i);
void write_syslog(char *text);
void print_data_not_available(char *us_cl);
void print_not_in_database(char *us_cl);
void print_enter_location(char *us_cl);
void print_usage(char *s);
void print_sunrise_sunset(char *us_cl,char *location,char *sr,char *ss);
void print_moonrise_moonset(char *us_cl,char *location,char *sr,char *ss, char *az, char *el);
void print_grayline(char *us_cl,char *location,char *dwn,char *sr,char *ss,char *dsk);
void print_heading(char *us_cl,char *location,int qtf1,int km,int miles,int qtf);
void print_coordinates(Location l, char *locator);
void print_header(int mode,char *call);
void print_foot(int count,int mode);
void write_syslog_noopen(char *filename);
void print_sh_trigpoint_usage(char *s);
void print_trigpoint(char *locator,int qtf,int km);
void print_trigpoint_err();
#endif
