/* 

Dieser Code wurde mehr oder weniger wortwrtlich aus dem BASIC-Listing
von OE5VRL bersetzt. Ich habe nur wenige nderungen vorgenommen, da 
ich die Berechnungen selber nicht nachvollzogen habe. Bei ggf. notwendigen
nderungen am BASIC-Code, knnen diese hier hier leicht nachgezogen
werden.

DL6RAI am 12.11.1998

*/


#include "sun.h"

void sh_trigpoint(int max_loc, int nn)
{
   int valid,i,m,n; 
   double lh,bh,lf,be,bf,bg,dm,dz,dy,dxx,rad,cn,ao,xi,xg,xh,
          an,xb,ym,xa,yl,bo,lo,xd,yk,xc,yj,re,
          yh,yi,ya,yb,yc,yd,ye,zg,yf,za,xe,xl,
          zb,xk,xj,by,bx,lx,le,lg,ix,s1,s3,zc,xm,zf,zh,zi;
   Loc l1,l2;
   char qthloc[8],out[128];
   
   valid=0;

   /* printf("MAXLOC: %d\n",max_loc); */
   /* printf("NUMARG: %d\n",nn); */

   if ( nn != 2 ) {
         print_sh_trigpoint_usage(progname);
         return;
   }

   if (max_loc >= 3) {
          m=1; n=2; 
   } else if (max_loc == 2) {
          m=0; n=1;
   } else {
         print_sh_trigpoint_usage(progname);
         return;
   }

   if (locations[m].pref[0] == '#' || locations[m].pref[0] == '?') {
	print_enter_location(locations[m].name);
	return;
   }

   if (locations[n].pref[0] == '#' || locations[n].pref[0] == '?') {
	print_enter_location(locations[n].name);
	return;
   }


   rad = M_PI/180.0;
   re = 6371 * rad;

   le = locations[m].loc.lon;
   lf = le*rad;
   be = locations[m].loc.lat;
   bf = be*rad;
   yi = (double) num_arg[1];

   lg = locations[n].loc.lon;
   lh = lg*rad;
   bg = locations[n].loc.lat;
   bh = bg*rad;
   yh = (double) num_arg[0];

   /* Berechnung1 */
   dm = lh - lf;
   dz = cos(dm) * cos(bh) * cos(bf) + sin(bh) * sin(bf);
   dy = atan(sqrt(1-dz*dz)/dz);
   dxx = dy/rad;
   cn = tan(bh) * cos(bf) - sin(bf) * cos(dm);
   ao = atan(sin(dm) / cn);
   xi = lf - lh;
   xg = (sin(bh) - cos(dy) * sin(bf)) / (sin(dy) * cos(bf));
   xh = atan(sqrt(1 - xg*xg) / xg) / rad;
   if (xi > 0 && xh > 0) {
	xh = 360 - xh;
   } else { 
	if (xi > 0) { xh = 180 - xh; }
	if (xh < 0) { xh = xh + 180; }
   }

   if (cn <= 0) {
	ao = ao + M_PI;
   }
   an = ao/rad;

   xb = dxx;
   ym = xh;
   xa = dy;
   yl = xg;

   /* Vertauschen1 */
   bo = bf; 
   lo = lf;
   bf = bh; 
   lf = lh;
   bh = bo; 
   lh = lo;

   /* Berechnung1 */

   /* Dieser Teil ist schon berechnet */
   dm = lh - lf;
   dz = cos(dm) * cos(bh) * cos(bf) + sin(bh) * sin(bf);
   dy = atan(sqrt(1-dz*dz)/dz);
   dxx = dy/rad;

   cn = tan(bh) * cos(bf) - sin(bf) * cos(dm);
   ao = atan(sin(dm) / cn);
   xi = lf - lh;
   xg = (sin(bh) - cos(dy) * sin(bf)) / (sin(dy) * cos(bf));
   xh = 180 / M_PI * atan(sqrt(1 - xg*xg) / xg);
   if (xi > 0 && xh > 0) {
	xh = 360 - xh;
   } else {
	if (xi > 0) { xh = 180 - xh; } 
	if (xh < 0) { xh = xh + 180; }
   }
   if (cn <= 0) {
	ao = ao + M_PI;
   }
   an = ao/rad;

   xd = dxx;
   yk = xh;
   xc = dy;
   yj = xg;

   /* 
   printf("QTH-1 bis QTH-2 %6.2f km, %6.2f Grad\n",xb*re,ym);
   printf("QTH-2 bis QTH-1 %6.2f km, %6.2f Grad\n",xd*re,yk);
   */

   if ((int) (ym*0.5+0.5) / 0.5 == (int) (yh*0.5+0.5) / 0.5 ) {
       /* printf("Berechnung unmglich, da alle Punkte auf einer Linie!\n"); */
       print_trigpoint_err();
       return;
   }

   if ((int) (fabs(ym - yh) * 0.5) / 0.5 == 180) {
       /* printf("Berechnung unmglich, da alle Punkte auf einer Linie!\n"); */
       print_trigpoint_err();
       return;
   }

   /* Innenwinkel1 */
   if (fabs(ym - yh) < 180) {
       yb = fabs(yh - ym);
   } else {
       yb = 360 - fabs(yh - ym);
   }
   ya = rad * yb;

   /* Innenwinkel2 */
   if (fabs(yk - yi) < 180) {
       yd = fabs(yi - yk);
   } else {
       yd = 360 - fabs(yi - yk);
   }
   yc = rad * yd;

   /* Dreieck2 */
   zg = -cos(ya) * cos(yc) + sin(ya) * sin(yc) * cos(xa);
   ye = atan(sqrt(1 - zg*zg) / zg);
   if (ye < 0) {
       ye = ye + M_PI;
   }
   yf = ye/rad;

   za = (cos(yc) + cos(ya) * cos(ye)) / (sin(ya) * sin(ye));
   xe = atan(sqrt(1 - za*za) / za);
   if (xe < 0) {
       xe = xe + M_PI;
   }
   xl = xe/rad;

   zb = (cos(ya) + cos(ye) * cos(yc)) / (sin(ye) * sin(yc));
   xk = atan(sqrt(1 - zb*zb) / zb);

   if (xk < 0) {
       xk = xk + M_PI;
   }
   xj = xk/rad;

   /* Vertauschen2 */
   bh = bf; 
   lh = lf;
   bf = bo; 
   lf = lo;
  
   /* Dreieck3 */
   if (yh == 0) {
       by = bf + xe;
       bx = by / rad;
       lx = le;
   } else if (yh == 180.0) {
       by = bf - xe;
       bx = by / rad;
       lx = le;
   }  else if (yi == 0.0) {
       by = bh + xk;
       bx = by / rad;
       lx = lg;
   } else if (yi == 180.0) {
       by = bh - xk;
       bx = by / rad;
       lx = lg;
   } else {
       if (yh < 180) {
           ix = yh * rad;
       } else if (yh > 180) {
           ix = 2 * M_PI - (yh * rad);
       } else {
           /* printf("Kein Kriterium zutreffend!!!\n"); */
           print_trigpoint_err();
           return;
       }

        s1 = M_PI / 2 - bf;
        s3 = xe;
        zc = cos(s3) * cos(s1) + sin(s3) * sin(s1) * cos(ix);
        xm = atan(sqrt(1 - zc*zc) / zc);
        zf = sin(s3) * sin(ix) / sin(xm);
        zh = atan(zf / sqrt(1 - zf*zf));
        zi = zh / rad;
        by = M_PI / 2 - xm;
        bx = by / rad;

        if (yh < 180) {
           lx = le + zi;
        } else {
           lx = le - zi;
        }
   }

   l2.lat = bx;
   l2.lon = lx;
   /* printf("Berechnete Schnittpunkt-Koordinaten: %6.2fN %6.2fE\n",bx,lx); */
   locator(l2,qthloc);

   /*
   printf("Scatterpunkt: Lat: %6.2f, Lon: %6.2f, Locator: %s\n",
	bx,lx,qthloc);
   */

   sprintf(out,"%s (Lat: %6.2f, Lon: %6.2f)",qthloc,bx,lx);
   print_header(TRIGPOINT,out);
   print_trigpoint(locations[m].name,num_arg[0],(int) (xl*re));
   print_trigpoint(locations[n].name,num_arg[1],(int) (xj*re));

   /* 
   printf("Beamrichtung aus %s: %d Grad, Entfernung: %6.1f km\n",
	locations[m].name,num_arg[0],xl*re);

   printf("Beamrichtung aus %s: %d Grad, Entfernung: %6.1f km\n",
	locations[n].name,num_arg[1],xj*re);
   */

   for (i=n+1;i<=max_loc-1;i++) {
	l1.lat = locations[i].loc.lat;
	l1.lon = locations[i].loc.lon;
	/* printf("Next location: %s (Lat: %6.2f, Lon %6.2f\n",
		locations[i].name,l1.lat,l1.lon); */
        if (locations[i].pref[0] == '#' || locations[i].pref[0] == '?') {
            print_enter_location(locations[i].name);
        } else {
            dx(l1.lon,l1.lat,l2.lon,l2.lat);
            print_trigpoint(locations[i].name,qtf,qrb);
	}
   }

   print_foot(valid,TRIGPOINT);
}








/* Original-Code von OE5VRL (rainscatter.bas)

OE5VRL > DL3MBG   05.05.96 17:54 201 Lines 5033 Bytes #81 @DB0AAB.#BAY.DEU.EU
Read: DL3MBG DK0OG DG5CH DG3MFL DF7RG DL6RAI 
Subj: Basic-Regenscatterprogramm
Path: !DB0AAB!DB0WGS!
Sent: 960505/1506z @:DB0WGS.#BAY.DEU.EU [Mailbox Wegscheid JN68VO] BCM1.37b
From: OE5VRL @ DB0WGS.#BAY.DEU.EU  (Rudi)
To  : DL3MBG @ DB0AAB.#BAY.DEU.EU

CONST PI = 3.141592654#: RE = 6371 * PI / 180
LE = 14.31666: BE = 48.43828
LF = LE * PI / 180: BF = BE * PI / 180
5
GOSUB Eingabe1
GOSUB Eingabe2
GOSUB Berechnung1
XB = DX: YM = XH
XA = DY: YL = XG
GOSUB Vertauschen1
GOSUB Berechnung1
XD = DX: YK = XH
XC = DY: YJ = XG
PRINT "QTH-1 bis QTH-2 "; XB * RE; "km "; YM; "Grad"
PRINT "QTH-2 bis QTH-1 "; XD * RE; "km "; YK; "Grad"
IF INT(YM * .5 + .5) / .5 = INT(YH * .5 + .5) / .5 THEN
   PRINT "Berechnung unmglich, da alle Punkte auf einer Linie!"
   END
END IF
IF INT(ABS(YM - YH) * .5) / .5 = 180 THEN
   PRINT "Berechnung unmglich, da alle Punkte auf einer Linie!"
   END
END IF
GOSUB Innenwinkel1
GOSUB Innenwinkel2
GOSUB Dreieck2
PRINT "QTH-1 bis Scatterpunkt "; XL * RE; "km"
PRINT "QTH-2 bis Scatterpunkt "; XJ * RE; "km"
GOSUB Vertauschen2
GOSUB Dreieck3
GOSUB WWKoordinaten
PRINT "WW-Loc von Scatterpunkt ******** "; X$
PRINT "                        *********************"
GOTO 5
END

Eingabe1:
INPUT "QTH-1 WW_Loc (Eigener Stanort=RETURN) "; E$
M = LEN(E$): FOR I = 1 TO M: B$(I) = MID$(E$, I, 1): NEXT I
IF M = 6 THEN
   IF ASC(B$(1)) >= 97 THEN B$(1) = CHR$(ASC(B$(1)) - 32)
   IF ASC(B$(2)) >= 97 THEN B$(2) = CHR$(ASC(B$(2)) - 32)
   IF ASC(B$(5)) >= 97 THEN B$(5) = CHR$(ASC(B$(5)) - 32)
   IF ASC(B$(6)) >= 97 THEN B$(6) = CHR$(ASC(B$(6)) - 32)
   LE = (ASC(B$(1)) - 65) * 20 - 180 + VAL(B$(3)) * 2 + (ASC(B$(5)) - 65) / 12 + 1 / 24
   LF = LE * PI / 180
   BE = (ASC(B$(2)) - 65) * 10 - 90 + VAL(B$(4)) + (ASC(B$(6)) - 65) / 24 + 1 / 48
   BF = BE * PI / 180
ELSEIF M = 0 THEN
   LE = 14.31666: BE = 48.43828
   LF = LE * PI / 180: BF = BE * PI / 180
ELSE
   END
END IF
RETURN

Eingabe2:
INPUT "QTH-2 WW-Loc "; L$
M = LEN(L$): FOR I = 1 TO M: A$(I) = MID$(L$, I, 1): NEXT I
IF M <> 6 THEN END
INPUT " QTF von QTH-1 zum Scatterpunkt "; YH
INPUT " QTF von QTH-2 zum Scatterpunkt "; YI
IF YH < 0 OR YH >= 360 OR YI < 0 OR YI >= 360 THEN
   PRINT "Die Winkel mssen zwischen 0 und 360 liegen"
   END
END IF
IF ASC(A$(1)) >= 97 THEN A$(1) = CHR$(ASC(A$(1)) - 32)
IF ASC(A$(2)) >= 97 THEN A$(2) = CHR$(ASC(A$(2)) - 32)
IF ASC(A$(5)) >= 97 THEN A$(5) = CHR$(ASC(A$(5)) - 32)
IF ASC(A$(6)) >= 97 THEN A$(6) = CHR$(ASC(A$(6)) - 32)
LG = (ASC(A$(1)) - 65) * 20 - 180 + VAL(A$(3)) * 2 + (ASC(A$(5)) - 65) / 12 + 1 / 24
LH = LG * PI / 180
BG = (ASC(A$(2)) - 65) * 10 - 90 + VAL(A$(4)) + (ASC(A$(6)) - 65) / 24 + 1 / 48
BH = BG * PI / 180
RETURN

Berechnung1:
DM = LH - LF
DZ = COS(DM) * COS(BH) * COS(BF) + SIN(BH) * SIN(BF)
DY = ATN(SQR(1 - DZ ^ 2) / DZ)
DX = DY * 180 / PI
CN = TAN(BH) * COS(BF) - SIN(BF) * COS(DM)
AO = ATN(SIN(DM) / CN)
XI = LF - LH
XG = (SIN(BH) - COS(DY) * SIN(BF)) / (SIN(DY) * COS(BF))
XH = 180 / PI * ATN(SQR(1 - XG ^ 2) / XG)
IF XI > 0 AND XH > 0 THEN
   XH = 360 - XH
ELSE
   IF XI > 0 THEN XH = 180 - XH
   IF XH < 0 THEN XH = XH + 180
END IF
IF CN <= 0 THEN AO = AO + PI
IF CN > 0 AND AN < 0 THEN AO = AO + 2 * PI
AN = AO * 180 / PI
RETURN

Vertauschen1:
BO = BF: LO = LF
BF = BH: LF = LH
BH = BO: LH = LO
RETURN

Vertauschen2:
BH = BF: LH = LF
BF = BO: LF = LO
RETURN

Innenwinkel1:
IF ABS(YM - YH) < 180 THEN
   YB = ABS(YH - YM)
ELSE
   YB = 360 - ABS(YH - YM)
END IF
YA = PI / 180 * YB
RETURN

Innenwinkel2:
IF ABS(YK - YI) < 180 THEN
   YD = ABS(YI - YK)
ELSE
   YD = 360 - ABS(YI - YK)
END IF
YC = PI / 180 * YD
RETURN

Dreieck2:
ZG = -COS(YA) * COS(YC) + SIN(YA) * SIN(YC) * COS(XA)
YE = ATN(SQR(1 - ZG ^ 2) / ZG)
IF YE < 0 THEN
   YE = YE + PI
END IF
YF = YE * 180 / PI
ZA = (COS(YC) + COS(YA) * COS(YE)) / (SIN(YA) * SIN(YE))
XE = ATN(SQR(1 - ZA ^ 2) / ZA)
IF XE < 0 THEN
   XE = XE + PI
END IF
XL = XE * 180 / PI
ZB = (COS(YA) + COS(YE) * COS(YC)) / (SIN(YE) * SIN(YC))
XK = ATN(SQR(1 - ZB ^ 2) / ZB)
IF XK < 0 THEN
   XK = XK + PI
END IF
XJ = XK * 180 / PI
RETURN

Dreieck3:
IF YH = 0 THEN
   BY = BF + XE: BX = BY * 180 / PI
   LX = LE
   RETURN
ELSEIF YH = 180 THEN
   BY = BF - XE: BX = BY * 180 / PI
   LX = LE
   RETURN
ELSEIF YI = 0 THEN
   BY = BH + XK: BX = BY * 180 / PI
   LX = LG
   RETURN
ELSEIF YI = 180 THEN
   BY = BH - XK: BX = BY * 180 / PI
   LX = LG
   RETURN
END IF
IF YH < 180 THEN
   IX = YH * PI / 180
ELSEIF YH > 180 THEN
   IX = 2 * PI - (YH * PI / 180)
ELSE
   PRINT "Kein Kriterium zutreffend!!!"
   STOP
END IF
S1 = PI / 2 - BF: S3 = XE
ZC = COS(S3) * COS(S1) + SIN(S3) * SIN(S1) * COS(IX)
XM = ATN(SQR(1 - ZC ^ 2) / ZC)
ZF = SIN(S3) * SIN(IX) / SIN(XM)
ZH = ATN(ZF / SQR(1 - ZF ^ 2))
ZI = ZH * 180 / PI
BY = PI / 2 - XM: BX = BY * 180 / PI
IF YH < 180 THEN
   LX = LE + ZI
ELSE
   LX = LE - ZI
END IF
RETURN

WWKoordinaten:
X1 = INT((LX + 180) / 20) + 65
X2 = INT((BX + 90) / 10) + 65
X3$ = STR$(INT(((LX + 180) - ((X1 - 65) * 20)) / 2))
X4$ = STR$(INT((BX + 90) - ((X2 - 65) * 10)))
X5 = INT(((LX + 180) - ((X1 - 65) * 20) - (VAL(X3$) * 2)) * 12) + 65
X6 = INT(((BX + 90) - ((X2 - 65) * 10) - (VAL(X4$))) * 24) + 65
X$ = CHR$(X1) + CHR$(X2) + RIGHT$(X3$, LEN(X3$) - 1) + RIGHT$(X4$, LEN(X4$) - 1) + CHR$(X5) + CHR$(X6)
RETURN

------Nachricht von OE5VRL 1.2.1999--------

Hallo Ben
Der Georg hat ja meine Nachricht gleich an dich weitergeleitet. ich wute
einfach den Call nicht mehr.
Ich hab ein paar Bsp. gerechnet damit du vergleichen kannst. Natrlich mu
es den gleichen Schnittpkt ergeben, wenn man
JN78DK 330 JN58TC 60         oder
JN58TC 60 JN78DK 330      rechnet.
Bsp.:
LOC1  qtf1 LOC2 qtf2     Entfernung 1    Entfernung 2     Schnittpkt.

JN78DK 330 JN58TC 60     63              188              JN68WW
JN58TC 60 JN78DK 330     188              63              JN68WW
JN78DK 230 JN58TC 210    485             328              JN45SM
JN58TC 120 JN78DK 150    284             401              JN86BF

Ich hoffe, da ich dir damit helfen konnte.


*/ 
