/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef BUFFERS_H
#define BUFFERS_H

#include "qqueue.h"
#include <iostream.h>
#include <fstream.h>
#include <ncurses.h>
// we don't want to use the 'clear' macro in ncurses.h - it will interfere with iostream::clear()
#undef clear
#include "prog_defs.h"
typedef unsigned char uchar;

class Display_buffer_with_scroll: public Qqueue<char> {
public:
    enum scroll_mode{line, halfpage, page};
protected:
    const int display_cols;
    const int display_lines;
    int scrollend_flag;   // if scroll_end != 0, then we have already scrolled to
                          // the start of the buffer
    char* last_scrolladr;
    char* buffer_read_scrollptr;
    char* goup_line(char*);
    char* godown_line(char*);
    char* goup_page(scroll_mode);
    char* godown_page(scroll_mode);
    int display_length;
    int firstline;        // set TRUE by scrollback() before calling goup_line(), and is
			  // automatically reset FALSE by goup_line() on that call
public:
    char* buffer_read_ptr;
    int add_item(char);
    int front(extract_mode);
    int back(extract_mode);
    void scrollback(scroll_mode);
    void scrollforward(scroll_mode);
    void exitscroll(void);
    void buffer_read(void);
    const void* is_scrolling(void) const {return last_scrolladr;}
    int is_endofscroll(void) const {return scrollend_flag;}
    void reset(void);
    char* text(void) const; // this will return C string of the contents of
                            // the display buffer - it must be deleted after use
                            // to avoid a memory leak
    Display_buffer_with_scroll(int itembuffer_length, int discard_flag,
	int display_cols, int display_lines);
    ~Display_buffer_with_scroll(void) {delete[] buffer_read_ptr;}
};


/*
Note: There will have been a valid scroll down if is_scrolling() returns a value !=0
before scrolling.

There will have been a valid scroll up if:
(i) is_endofscroll() returns 0 before the scroll takes place, and
(ii) after scrolling, is_scrolling() returns a value != 0, so indicating that there
is a buffer filled greater than to a screen size to scroll into.

*/

class Display_buffer_with_curses: public Display_buffer_with_scroll {
public:
    void scrollup(WINDOW*, scroll_mode);
    void scrolldown(WINDOW*, scroll_mode);
    void scrollout(WINDOW*);  // the same as redisplay, except it beeps if not scrolling
    void redisplay(WINDOW*);  // displays last page in the buffer
    void display_first_page(WINDOW*);
    void clear_display(WINDOW*);
    Display_buffer_with_curses(int itembuffer_length, int discard_flag,
        int display_cols, int display_lines):Display_buffer_with_scroll(itembuffer_length,
        discard_flag, display_cols, display_lines) {}
};

/////////////////////////////////////////////////////////////////////////////////////////


class Transmit_buffer: private Qqueue<char> {
    int line_lettercount;  // used to indicate whether we are at the beginning of a line
    int can_transmit_delete_flag;
    int foundCMDinbuffer;
public:
    void set_can_transmit_delete(int setting) {can_transmit_delete_flag = setting;}
    int add_letter(char);
    int extract_letter(void);
    int view_letter(void);
    int erase_letter(void);
    int letters_free(void) const {return Qqueue<char>::is_free();}
    int is_empty(void) const {return Qqueue<char>::is_empty();}
    int letters_used(void) const {return Qqueue<char>::is_used();}
    void reset(void);
    Transmit_buffer(void): Qqueue<char>(TR_BUFFER_SIZE, 0), line_lettercount(0),
        can_transmit_delete_flag(FALSE), foundCMDinbuffer(FALSE) {}
};

///////////////////////////////////////////////////////////////////////////////////////

class FileBuffer: public Qqueue<char> {
public:
    enum Buffer_mode{text, binary, s_plus};
private:
    Buffer_mode buffer_mode;
    int stream;
    int port;
public:
    //    void set_buffer_mode(Buffer_mode mode) {buffer_mode = mode;}
    Buffer_mode get_buffer_mode(void) const {return buffer_mode;}
    int get_stream(void) const {return stream;}
    int get_port(void) const {return port;}
    virtual void end_loading(void) = 0;
    virtual int load_buffer(void) = 0;
    FileBuffer(Buffer_mode a, int b, int c): Qqueue<char>(FILE_BUFFER_SIZE, 0),
                 buffer_mode(a), stream(b), port(c) {}
    virtual ~FileBuffer(void){}
};


#endif
