// dlist.h

/* Copyright (C) 1999 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/


#ifndef DLIST_H
#define DLIST_H

// The following two template classes provide for creating a double-linked list of object pointers.

// When applied to the Screen class in screen.h, this enables objects derived from the Screen
// class to be grouped into "forms" which can allbe brought to the foreground together when
// a popup window is closed, or to maintain a list of popup windows which are to be kept in
// the foreground even if the window in the background is written to.  For this reason,
// Screen::show() is a virtual function

// The program also keeps lists of FileBuffer and DownloadFile objects

template <class Type> class DList; // forward declaration

template <class Type> class DListNode {
private:
    friend class DList<Type>;
    Type* item_p;
    DListNode* prev;
    DListNode* next;
    DListNode(Type* item_to_add, DListNode* node_p): item_p(item_to_add), prev(node_p), next(0) {} // private class
};

class DList_enum {
public:
    enum Direction {up, down};        // because of template rules in early compilers
    enum End {bottom_end, top_end};   // such as gcc 2.7.2.x, any enumerated type
                                      // declaration must be included in a wrapper class
				   
};                                

template <class Type> class DList: public DList_enum {
private:
    DListNode<Type>* top;
    DListNode<Type>* bottom;
    DListNode<Type>* inspect_pos; // advanced after inspection from position last inspected
    DListNode<Type>* extract_pos; // points to position last inspected (current WinNode)
public:
    int is_empty(void) const {return (top == 0);}
    void add(Type*);
    const Type* extract(void); // extracts current DListNode (as last returned by inspect() and 
                               // now pointed to by extract_pos) out of the list
                               // returns the address of item extracted or 0 if nothin to be extracted
                               // or inspect() has not been employed since last reset

    const Type* inspect(DList_enum::Direction); // returns address of item in current DListNode, or 0 if
                                                // at end of list (sets inspect_pos to next entry, if any)
                                                // and leaves extract_pos pointing to the last object
                                                // inspected

    void reset(DList_enum::End end) {if (end == DList_enum::top_end) inspect_pos = top;
                                     else inspect_pos = bottom;
                                     extract_pos = 0;}
    void clear_list(void);
    DList(void): top(0), bottom(0), inspect_pos(0), extract_pos(0) {}
    ~DList(void) {clear_list();}
};

#endif
