/* Copyright (C) 1999, 2000 Chris Vine, G3XXF

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <iostream.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "download.h"
#include "dlist.cpp" // contains template definitions

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE -1
#endif

extern Prog_func prog_func;

int DownloadFile::open_file(const char* filename) {
    fileout.open(filename, ios::out | ios::noreplace);
    if (!fileout) return FALSE;
    return TRUE;
}

DownloadList::DownloadList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    download_status[stream][port] = DownloadList::off;
	}
    }
}

int PrintFile::start_store(void) {
    int return_val = FALSE;
    char* temp_p;
    int count = 0;
    do {  // we will have 3 iterations through the loop in case some other user
          // has been allocated the same temporary file name before we open it
        temp_p = tmpnam(0);
        fileout.open(temp_p, ios::out | ios::noreplace);
	count++;
    } while (!fileout && count < 4);

    if (fileout)  {
        filename = new char[strlen(temp_p) + 1];
	if (!filename) {
	    cerr << "Memory allocation error in PrintFile::PrintFile()" << endl;
	    exit(MEM_ERROR);
	}
	strcpy(filename, temp_p);
	return_val = TRUE;
    }
    return return_val;
}

void PrintFile::print(void) {
    if (filename) {
        fileout.close();

	int rd_fd = open(filename, O_RDONLY);
	if (rd_fd < 0) {
	    cerr << "File open error in PrintFile::~PrintFile()" << endl;
	    exit(FILEOPEN_ERROR);
	}
	char buffer[BUFSIZ];
	size_t read_bytes = read(rd_fd, buffer, BUFSIZ);
	if (read_bytes > 0) { // we don't want to use popen if there is nothing to read
	                      // or lpr will complain of an empty pipe
	    FILE* pipe_fp = popen(prog_func.print_cmd, "w");
	    do {
	        fwrite(buffer, sizeof(char), read_bytes, pipe_fp);
	    } while ((read_bytes = read(rd_fd, buffer, BUFSIZ)) > 0);
	    fclose(pipe_fp);
	}

	close(rd_fd);
	unlink(filename);
	delete[] filename;
	filename = 0;
    }
}

void PrintFile::cancel(void) {
    if (filename) {
        fileout.close();
	unlink(filename);
	delete[] filename;
	filename = 0;
    }
}

PrintList::PrintList(void) {
    int port;
    int stream;
    for (port = 0; port < 2; port++) {
        for (stream = 0; stream < MAXUSERS; stream++) {
	    print_status[stream][port] = PrintList::off;
	}
    }
}
