/************************************************************************/
/*                                                                      */
/*                                                                      */
/*    *****                       *****                                 */
/*      *****                   *****                                   */
/*        *****               *****                                     */
/*          *****           *****                                       */
/*  ***************       ***************                               */
/*  *****************   *****************                               */
/*  ***************       ***************                               */
/*          *****           *****           TheNetNode                  */
/*        *****               *****         Portable                    */
/*      *****                   *****       Network                     */
/*    *****                       *****     Software                    */
/*                                                                      */
/* This file is part of "TheNetNode" - Software Package                 */
/*                                                                      */
/* Copyright (C) 1998  NORD><LINK e.V. Braunschweig                     */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the NORD><LINK ALAS (Allgemeine Lizenz fr     */
/* Amateurfunk Software) as published by Hans Georg Giese (DF2AU)       */
/* on 13/Oct/1992; either version 1, or (at your option) any later      */
/* version.                                                             */
/*                                                                      */
/* This program is distributed WITHOUT ANY WARRANTY only for further    */
/* development and learning purposes. See the ALAS (Allgemeine Lizenz   */
/* fr Amateurfunk Software).                                           */
/*                                                                      */
/* You should have received a copy of the NORD><LINK ALAS (Allgemeine   */
/* Lizenz fr Amateurfunk Software) along with this program; if not,    */
/* write to NORD><LINK e.V., Hinter dem Berge 5, D-3300 Braunschweig    */
/*                                                                      */
/* Dieses Programm ist PUBLIC DOMAIN, mit den Einschrnkungen durch     */
/* die ALAS (Allgemeine Lizenz fr Amateurfunk Software), entweder      */
/* Version 1, verffentlicht von Hans Georg Giese (DF2AU),              */
/* am 13.Oct.1992, oder (wenn gewnscht) jede sptere Version.          */
/*                                                                      */
/* Dieses Programm wird unter Haftungsausschlu vertrieben, aus-        */
/* schlielich fr Weiterentwicklungs- und Lehrzwecke. Nheres          */
/* knnen sie der ALAS (Allgemeine Lizenz fr Amateurfunk Software)     */
/* entnehmen.                                                           */
/*                                                                      */
/* Sollte dieser Software keine ALAS (Allgemeine Lizenz fr Amateurfunk */
/* Software) beigelegen haben, wenden Sie sich bitte an                 */
/* NORD><LINK e.V., Hinter dem Berge 5, D-38108 Braunschweig            */
/*                                                                      */
/*                                                                      */
/************************************************************************/

#include "tnn.h"

/**************************************************************************\
*                                                                          *
* "check no activity"                                                      *
*                                                                          *
* Alle aktiven Links (lnktbl, Linkstatus "Information Transfer") auf       *
* "keine Aktivitaet" abtesten. Ist der Keine-Aktivitaet-Timer aktiv (!= 0) *
* und nach Dekrementieren abgelaufen, Disconnect einleiten.                *
*                                                                          *
* ACHTUNG: Diese Funktion muss sekuendlich aufgerufen werden,              *
*          wird aber nur fuer TheNetNode benoetigt.                        *
*                                                                          *
\**************************************************************************/
void chknoa(void)
{
  MBHEAD *mbp;
  int     port;
  LHEAD  *llp;

  for (port = 0, llp = &l2actl[0];     /* alle Ports durchgehen         */
       port < L2PNUM;
       port++, llp++)
    for (lnkpoi  = (LNKBLK *)llp->head;
         lnkpoi != (LNKBLK *)llp;      /* alle Links des Ports pruefen  */
         lnkpoi  = lnkpoi->next) {
      if (!(--lnkpoi->noatou))
      {
        mbp = (MBHEAD *) allocb();
        mbp->l2link = lnkpoi;                   /* Linkpointer und      */
        mbp->type = 2;                          /* Typ (2=L2) setzen    */
        putchr('\r', mbp);
        putalt(alias, mbp);
        putid(myid, mbp);
        putstr("> Timeout (", mbp);
        putnum(ininat, mbp);                   /* Timeout in s ausgeben    */
        putstr("s)\r", mbp);
        seteom(mbp);                          /* Text an User senden...    */

        if (lnkpoi->state == L2SRBS)          /* remote busy?              */
          lnkpoi->flag |= L2FDIMM;            /* sofort abwerfen           */
        else
          lnkpoi->flag |= L2FDSLE;            /* sonst wenn alles raus     */
      }
    }
}

/**************************************************************************\
*                                                                          *
* "new link"                                                               *
*                                                                          *
* Link (lnkpoi) neu aufbauen.                                              *
*                                                                          *
\**************************************************************************/
void newlnk(void)
{
  reslnk();                             /* Sequenzvars/Timer ruecksetzen  */
  setiSRTT();                           /* RTT-Timer neu starten          */
  l2stma(stbl19);                       /* LOCAL START COMMAND            */
}

/**************************************************************************\
*                                                                          *
* "disconnect link"                                                        *
*                                                                          *
* Disconnect-Wunsch an aktuellen Link (lnkpoi) :                           *
*                                                                          *
*   Linkstatus "Disconnected"                                              *
*   -> Ax.25-Parameter "frisch"                                            *
*                                                                          *
*   Linkstatus "Link Setup" oder "Disconnect Request"                      *
*   -> Link NICHT aufloesen, nur Flag vormerken fuer l2rest                *
*                                                                          *
*   sonst                                                                  *
*   -> Empfangsinfoframeliste loeschen, Linkstatus bleibt, Flag "nach      *
*      Loswerden aller zu sendenden Infoframes disconnecten" setzen        *
*                                                                          *
\**************************************************************************/
void dsclnk(void)
{
  WORD lstate;

  if ((lstate = lnkpoi->state) == L2SDSCED)           /* Disced, nur     */
    inilbl();                                         /* AX-Pars neu     */
  else {
    dealml((LEHEAD *)&lnkpoi->rcvdil);                /* RX-Infoframe-   */
    lnkpoi->rcvd = 0;                                 /* loeschen und    */

    if (   lstate == L2SLKSUP                         /* Linksetup oder  */
        || lstate == L2SDSCRQ                         /* Discreq,        */
        || lstate == L2SHTH                           /* oder wartet     */
        || (lnkpoi->flag & L2FDSLE))
      lnkpoi->flag |= L2FDIMM;                        /* sofort weg      */
    else
      lnkpoi->flag |= L2FDSLE;                        /* wenn alles raus */
  }
}

/**************************************************************************\
*                                                                          *
* "information to link"                                                    *
*                                                                          *
* Infobuffer, auf den imbp zeigt, an in diesem Buffer festgelegten Link    *
* (l2link) zwecks Aussendung als Paket weitergeben. Wenn nocgnc == YES     *
* keine "Erstickungskontrolle", sonst conctl beachten (s.u.).              *
* Der Infobuffer wird bei Weitergabe an den Link mit der normalen Level 2  *
* PID versehen, der Keine-Aktivitaets-Timer wird neu gestartet.            *
*                                                                          *
* Return:  TRUE  - imbp wurde angenommen und an den Link weitergegeben     *
*          FALSE - imbp wurde nicht angenommen wegen Congestion Control    *
*                  = Grenze der pro Link maximal zu speichernden Pakete    *
*                    (conctl) wuerde ueberschritten werden                 *
*                                                                          *
\**************************************************************************/
BOOLEAN itolnk(int pid, BOOLEAN nocgnc, MBHEAD *imbp)
{
  LNKBLK *linkp;
#if 0
  extern void coredump(void);
#endif

  linkp = imbp->l2link;

/* DEBUG */
  if (linkp->state == L2SDSCED) {
    LNKBLK *l_bak;

    l_bak = lnkpoi; /* damit wir das im Dump sehen */
    lnkpoi = linkp;
    notify(1, "send to disc'ed link %6.6s > %6.6s via %s",
           linkp->srcid, linkp->dstid, linkp->viaidl);
#if 0
    coredump();
#endif
    dealmb((MBHEAD *)ulink((LEHEAD *)imbp));
    lnkpoi = l_bak;
    return (TRUE);
  }

  if (linkp->state == L2SDSCRQ)
   {
    dealmb((MBHEAD *)ulink((LEHEAD *)imbp));
    return(TRUE);
   }

  if (linkp->tosend < conctl || nocgnc == TRUE)
  {
    imbp->l2fflg = pid;                        /* PID bernehmen       */
    relink(ulink((LEHEAD *)imbp),              /* -> ab in den Link    */
                 (LEHEAD *)linkp->sendil.tail);
    ++linkp->tosend;                           /* ein Sendepaket mehr  */
    linkp->noatou = ininat;                    /* wieder Aktivitaet    */
    return (TRUE);                             /* ... imbp angenommen  */
  }
  return (FALSE);                              /* ... imbp abgelehnt   */
}

/*************************************************************************\
*                                                                         *
*       Informationstransfer von Layer 2 nach Layer X                     *
*       ---------------------------------------------                     *
*                                                                         *
*      Infopakete aus dem aktuellen Link (lnkpoi) an hoehere Level        *
*      weiterreichen. conctl gibt an, ob der hoehere Level die            *
*      Erstickungskontrolle" (hier = Beruecksichtigung der maximal        *
*      noch anzunehmenden I-Pakete) machen soll (NO) oder in jedem        *
*      Fall alle uebermittelten I-Pakete annehmen muss (YES). Falls       *
*      die I-Pakete vom hoeheren Level angenommen wurden, Empfangs-       *
*      zaehler rcvd und Aktivitaetstimer noatou entsprechend updaten.     *
*      Es wird l2link in den Framekoepfen der weitergereichten Pakete     *
*      auf lnkpoi gesetzt und type auf 2 fuer "Level 2".                  *
*                                                                         *
*      Solange noch empfangene Pakete vorhanden sind, werden diese        *
*      an andere Layer durch Aufruf von fmlink() uebertragen. Bei ge-     *
*      setztem Ueberfuellungskontroll-Flag (conctl == TRUE) wird die      *
*      Uebertragung abgebrochen, wenn der andere Layer keine weiteren     *
*      Daten mehr aufnehmen kann.                                         *
*                                                                         *
*      Nach erfolgter Uebertragung wird die Anzahl der uebertragenen      *
*      Zeichen fuer die Statistik gezaehlt und der No-Activity-Timer      *
*      neu gesetzt.                                                       *
*                                                                         *
\*-----------------------------------------------------------------------*/

void i2tolx(BOOLEAN conctl)
{
  MBHEAD *mbp;               /* Zeiger auf Framekopf weiterzureichendes I*/

  if (   (lnkpoi->state == L2SDSCRQ)
      || (lnkpoi->flag & (L2FDSLE | L2FDIMM)))
   {
    dealml((LEHEAD *)&lnkpoi->rcvdil);
    lnkpoi->rcvd = 0;
    return;
   }

  while (lnkpoi->rcvd != 0) {          /* solange I's aus Link vorhanden */
    mbp = (MBHEAD *) lnkpoi->rcvdil.head;
    mbp->l2link = lnkpoi;                                  /* Linkzeiger */
    mbp->type = 2;                                         /* Level 2 !  */
    if (!fmlink(conctl, mbp))          /* I an hoeheren Level geben      */
       return;                         /* Abbruch, wenn nicht angenommen */
    lnkpoi->noatou = ininat;           /* angenommen, wieder Aktivitaet  */
    --lnkpoi->rcvd;                    /* Empfangspaketezaehler updaten  */
  }
}


/**************************************************************************\
*                                                                          *
* "serve received N(R)"                                                    *
*                                                                          *
* Aktuell empfangenes N(R) (rxfctl) des aktuellen Links (lnkpoi) auswerten *
* und entsprechend verfahren (s.u.).                                       *
*                                                                          *
* Return:  YES - aktuell empfangenes N(R) ist okay oder                    *
*                Linkzustand laesst N(R)-Empfang nicht zu                  *
*          NO  - aktuell empfangenes N(R) ist falsch                       *
*                                                                          *
\**************************************************************************/
BOOLEAN srxdNR(void)
{
  WORD rxdNR;                   /* emfangenes N(R)                       */
  WORD newok;                   /* Anzahl neu bestaetigte I's            */
  WORD outstd;                  /* Anzahl ausstehende (unbestaetigte I's */
  WORD l2state;                 /* Link-Status                           */
  #define ackedI() ((rxdNR - lnkpoi->lrxdNR) & 0x07)

  if ((l2state = lnkpoi->state) >= L2SIXFER) /* darf N(R) kommen ?         */
  {
    rxdNR = ((rxfctl >> 5) & 0x07);          /* Sequenznummer lesen        */

    if (   (outstd = outsdI()) != 0          /* Wenn I's ausstehen und     */
        && (newok  = ackedI()) != 0          /* neue bestaetigt wurden:    */
       )
      if (newok <= outstd) {                 /* und nicht zuviel bestaet.  */

        if (((lnkpoi->RTTvs - lnkpoi->lrxdNR) & 0x07) >= newok)
          clrRTT();                          /* RTT-Messung ok, stoppen    */

        lnkpoi->lrxdNR = rxdNR;              /* dann N(R) annehmen,        */
        clrT1();                             /* T1 stoppen,                */
                                             /* Sind alle ausstehenden I's */
        if (newok == outstd)                 /* bestaetigt worden ?        */
        {                                    /* ja:                        */
          if (lnkpoi->priold != -1)          /*   bei Downlink-Aktivitaet: */
            lnkpoi->damapm = lnkpoi->priold; /*       Prioritaet reseten   */
          lnkpoi->priold = -1;               /*   Priori-Flag loeschen     */
          clearDT(0);                        /*   DAMA-Timer loeschen <<<< */
        }
        else
          setT1();                           /* T1 neu starten             */

        while (newok-- != 0)                 /* Alle bestaetigten Frames   */
        {                                    /* aus der Liste entfernen    */
          dealmb((MBHEAD *)ulink((LEHEAD *)lnkpoi->sendil.head));
          --lnkpoi->tosend;
        }
      } else {                            /* Mehr I's bestaetigt als       */
        sdfrmr((char)0x08);               /* ausstehen. Das geht nicht.    */
        return(FALSE);                    /* FRMR erzeugen, N(R) falsch    */
      }

    if (   l2state == L2SWA               /* Falls warten auf Bestaetigung */
        || l2state == L2SWADBS
        || l2state == L2SWARBS
        || l2state == L2SWABBS
       )
      if (!rxfCR && rxfPF != 0) {         /* Wenn RR mit Final war, dann   */
         clrT1();                         /* T1 stoppen                    */
         clrRTT();                        /* RTT stoppen, Messung gueltig  */
         lnkpoi->VS = lnkpoi->lrxdNR;     /* V(S)                          */
         clearDT(0);                      /* DAMA-Timer loeschen           */
      } else
      if (!lnkpoi->T1)                    /* T1 neu starten                */
        setT1();
  }

  return (TRUE);
}

/**************************************************************************\
*                                                                          *
* "is next I"                                                              *
*                                                                          *
* Testen, ob das aktuell empfangene I-Frame (rxf...) das naechste fuer den *
* aktuellen Linkblock (lnkpoi) erwartete I-Frame ist, wenn der Linkzustand *
* Informationstransfer zulaesst. Bei nicht erwarteter Sequenznummer        *
* entsprechende Statetable abarbeiten.                                     *
*                                                                          *
* Return :  YES - I-Frame ist das naechste erwartete oder Linkzustand      *
*                 laesst keinen Informationstransfer zu                    *
*           NO  - sonst                                                    *
*                                                                          *
\**************************************************************************/
BOOLEAN isnxti(void)
{
  WORD iseqno;                                    /* I Sequence Number    */

  if (lnkpoi->state >= L2SIXFER)                          /* I-Transfer ? */
    if ((iseqno = (rxfctl >> 1) & 0x07) == lnkpoi->VR)    /* I erwartet ? */
      if (((lnkpoi->ltxdNR + 7) & 0x07) != iseqno)        /* kein Ueber-  */
      {                                                   /* lauf ?       */
        if (!(lnkpoi->flag & L2FBUSY))           /* wenn nicht busy, neue */
          lnkpoi->VR = (iseqno + 1) & 0x07;      /* V(R) setzen           */
      }
      else
      {
         sdfrmr((char)0x01);
         return (FALSE);
      }
    else
    {                                           /* unerwartetes Info:     */
      l2stma(!rxfPF ? stbl26 : stb26b);         /* INVALID N(S) RECEIVED  */
      if (dama(lnkpoi->liport) && rxfPF)        /* I-Poll ?          <=== */
        polDAMA();                              /* ja: mu meckern ! <=== */
      return (FALSE);
    }

  return (TRUE);         /* I richtig oder Linkzustand ohne I-Transfer    */
}

/**************************************************************************\
*                                                                          *
* "initialize link"                                                        *
*                                                                          *
* Aktuellen Linkblock (lnkpoi) initialisieren. Sequenzvariablen und Timer  *
* initialisieren, Quellcall/Zielcall/via-Liste/ Port setzen aus der        *
* txf...-Liste.                                                            *
*                                                                          *
\**************************************************************************/
void inilnk(void)
{
  reslnk();                                  /* Sequenzvars/Timer init.   */
  cpyid(lnkpoi->srcid,txfhdr  + L2IDLEN);    /* Quellcall                 */
  cpyid(lnkpoi->dstid,txfhdr);               /* Zielcall                  */
  cpyidl(lnkpoi->viaidl,txfhdr + L2ILEN);    /* via-Liste                 */
  lnkpoi->liport = txfprt;                   /* Port                      */
  setiSRTT();                                /* RTT                       */
  lnkpoi->pollcnt = 0;          /* Anzahl verbotener Polls des DAMA-Users */
  lnkpoi->noatou = ininat;      /* Timeout initialisieren                 */
}

/**************************************************************************\
*                                                                          *
* "set initial SRTT"                                                       *
*                                                                          *
* Anfangswert fuer Smoothed Round Trip Timer setzen                        *
*                                                                          *
\**************************************************************************/
void setiSRTT(void)
{
  char       *viap;                     /* Zeiger in via-Liste            */
  UWORD      n;                         /* Digizaehler                    */

  viap = lnkpoi->viaidl;                /* Anfang via-Liste               */
  n = 0;                                /* noch kein Digi gezaehlt        */
  while (*viap != '\0') {               /* Digianzahl ermitteln           */
    if (!(viap[L2IDLEN-1] & L2CH))
      ++n;
    viap += L2IDLEN;
  }
  n *= 2;
  ++n;                                         /* Digianzahl * 2 + 1      */

  lnkpoi->SRTT = portpar[lnkpoi->liport].IRTT * n;
}

/**************************************************************************\
*                                                                          *
* "clear link"                                                             *
*                                                                          *
* Aktuellen Link (lnkpoi) aufloesen. Alle Sequenzvariablen und Timer       *
* zuruecksetzen, Sende- und Empfangsinfoframelise loeschen, Linkblock neu  *
* mit AX.25-Parametern besetzen.                                           *
*                                                                          *
\**************************************************************************/
void clrlnk(void)
{
  reslnk();                           /* Sequenzvars/Timer ruecksetzen  */
  dealml((LEHEAD *)&lnkpoi->rcvdil);  /* Empfangsinfoliste loeschen     */
  dealml((LEHEAD *)&lnkpoi->sendil);  /* Sendeinfoliste loeschen        */
  dealml((LEHEAD *)&lnkpoi->damail);  /* DAMA-Puffer loeschen           */
  lnkpoi->rcvd = lnkpoi->tosend = 0;  /* entsprechende Zaehler loeschen */
  inilbl();                           /* Linkblock "frisch"             */
}

/**************************************************************************\
*                                                                          *
* "reset link"                                                             *
*                                                                          *
* Aktuellen Link (lnkpoi) zuruecksetzen. Alle Sequenzvariablen und Timer   *
* initialisieren.                                                          *
*                                                                          *
\**************************************************************************/
void reslnk(void)
{
  lnkpoi->VS =
  lnkpoi->VR =
  lnkpoi->ltxdNR =
  lnkpoi->lrxdNR =
  lnkpoi->RTT =
  lnkpoi->flag = 0;
  resptc(g_uid(lnkpoi, L2_USER));
  clrDAMA();
  lnkpoi->SRTT = portpar[lnkpoi->liport].IRTT;
  clrT1();
  clrT2();
}

/**************************************************************************\
*                                                                          *
* "initialize link block"                                                  *
*                                                                          *
* Aktuellen Linkblock (lnkpoi) mit AX.25-Parametern initialisieren.        *
* Loeschen des Quellrufzeichens, Setzen von FRACK, MAXFRAME, RETRY,        *
* AX25V2.                                                                  *
*                                                                          *
\**************************************************************************/
void inilbl(void)
{
  lnkpoi->liport = 0;
  clrDAMA();
}

/**************************************************************************\
*                                                                          *
* "info to layer x and clear link"                                         *
*                                                                          *
* Empfangsdaten ohne Flowcontrol in den Layer hochmelden und dann          *
* Link zuruecksetzen.                                                      *
*                                                                          *
\**************************************************************************/

void i2xclr(void) {
  i2tolx(TRUE);
  clrlnk();
}

/**************************************************************************\
*                                                                          *
* "number of outstanding I's"                                              *
*                                                                          *
* Anzahl der ausstehenden Info-Frames des aktuellen Linkblock (lnkpoi)     *
* berechnen.                                                               *
*                                                                          *
\**************************************************************************/
char outsdI(void) {
  return ( (lnkpoi->VS - lnkpoi->lrxdNR) & 0x07 );
}

/**************************************************************************\
*                                                                          *
* "is tx window open"                                                      *
*                                                                          *
* Kann der Sender des aktuellen Linkblocks noch Informationen aufnehmen?   *
* Geliefert wird die Anzahl der Frames, die noch in das aktuelle Fenster   *
* passen.                                                                  *
*                                                                          *
\**************************************************************************/
char itxwnd(void) {
  int outstd, n, k;

  if (lnkpoi->tosend) {             /* ueberhaupt was zu senden?     */
    switch (lnkpoi->state) {        /* duerfen wir was senden?       */
      case L2SIXFER :
      case L2SRS    :
      case L2SDBS   :
      case L2SRSDBS :
        outstd = outsdI();          /* soviel stehen noch aus        */
        n = lnkpoi->tosend;         /* und soviel ist noch uebrig    */
        k = portpar[lnkpoi->liport].maxframe;
        if (   (outstd < k)         /* Fenster noch nicht voll       */
            && (n > outstd))        /* und Sendebuffer nicht leer    */
          return (fullduplex(lnkpoi->liport) ? 1 : k);
    }
  }
  return (0);                       /* senden momentan nicht erlaubt */
}

/**************************************************************************\
*                                                                          *
* "send outstanding I's"                                                   *
*                                                                          *
* Aus dem aktuellen Linkblock (lnkpoi) soviele I-Frames senden, wie im     *
* Moment unbestaetigt ausstehen.                                           *
* Es wird der komplette Durchgang wiederholt (ab dem 1. unbestaetigtem)    *
* Frame.                                                                   *
* WICHTIG: Nicht senden, wenn wir auf die Antwort der Gegenstation         *
*          warten (wir haben Poll gesendet). Dann kommt sowieso der        *
*          Final demnaechst und wir koennen weitersenden.                  *
*                                                                          *
\**************************************************************************/
void sdoi(void)
{
  UWORD n;                              /* Anzahl I's zu senden           */

  switch (lnkpoi->state) {              /* nur wenn der State stimmt      */
      case L2SIXFER :
      case L2SRS    :
      case L2SDBS   :
      case L2SRSDBS :
        if ((n = outsdI()) != 0) {      /* wieviel darf ich?              */
          lnkpoi->VS = lnkpoi->lrxdNR;  /* V(S) resetten                  */
          sdi(0, n);                    /* I's senden                     */
        }
        break;
  }
}

/**************************************************************************\
*                                                                          *
* "send I"                                                                 *
*                                                                          *
* Aus dem aktuellen Linkblock (lnkpoi) maximal max I-Frames aus der        *
* Infomessageliste aufbauen und senden. Die Frames werden als Command-     *
* frames ohne Poll/Final-Bit gesendet. V(S) wird fuer jedes gesendete      *
* Frame erhoeht modulo 7. Timer 2 wird abgeschaltet.                       *
*                                                                          *
\**************************************************************************/
void sdi(int outstd, int max)
{
  WORD n, m, k;                               /* Zaehler zu sendende Infos */
  MBHEAD *sendip;                             /* Kopfzeiger Infobuffer     */
  MBHEAD *fbp;                                /* Kopfzeiger Framebuffer    */

  sendip = (MBHEAD *) lnkpoi->sendil.head;    /* erstes Frame              */
  for (n = 0; n < outstd; n++)
    sendip = (MBHEAD *) sendip->nextmh;       /* soviele uebergehen        */

  if (max > lnkpoi->tosend - outstd)          /* maximal soviel wie da ist */
    max = lnkpoi->tosend - outstd;

  k = portpar[lnkpoi->liport].maxframe;

  if (max + outstd > k)                       /* und nicht uebers Fenster  */
    max =   outstd < k
          ? k - outstd                        /* Rest bis zum Fensterende  */
          : 0;                                /* Fenster wurde verkleinert */

  for ( n  = 1;
        n <= max;                                  /* aus der Linkblock-   */
        ++n,  sendip = (MBHEAD *) sendip->nextmh   /* infoliste senden     */
      )                                            /* wenn vorhanden       */
  {
    stxfad();                                 /* Frameadresse aufbauen     */
    txfCR = L2CCR;                            /* Command !                 */

    txfctl = setNR((char)(lnkpoi->VS << 1));  /* Controlbyte I setzen      */
    ++lnkpoi->VS;                             /* V(S) erhoehen             */
    lnkpoi->VS &= 0x07;                       /* modulo 7                  */

    k = portpar[lnkpoi->liport].maxframe;

    txfPF = 0;                                /* normalerweise ohne POLL   */
    if (   (((lnkpoi->lrxdNR + k) & 0x07) == lnkpoi->VS)
        || (lnkpoi->tosend == outsdI())) {
      if (dama(lnkpoi->liport))
        txfPF = L2CPF;                        /* letztes Frame mit POLL!   */
      fbp = makfhd(L2FT1ST);                  /* Ja, T1 und RTT Zeitmessung*/
    } else
      fbp = makfhd(0x00);                     /* Nein, T1/RTT nicht starten*/

    putchr(sendip->l2fflg, fbp);              /* Frame aufbauen, PID       */

    /*
     *  Frame aufspalten, wenn zu lang. Gesplittet werden aber nur
     *  Frames mit Standard-AX.25-PID (ohne L3-Protokoll). Die maximale
     *  Laenge ist 256 Bytes bzw wenn niedriger der MTU-Wert fuer den
     *  jeweiligen Port.
     */
    if (sendip->l2fflg == L2CPID)
      m = 256; /* Fest auf 256 Bytes begrenzen */
    else
      m = min(L2MILEN, portpar[lnkpoi->liport].mtu);

    if (splcpy(m,fbp,sendip) == TRUE)        /* Ein Frame mehr zu senden  */
        ++lnkpoi->tosend;

    sdl2fr(fbp, FALSE);                      /* Frame senden              */
    clrT2();                                 /* Timer 2 abschalten        */
  }
}

/**************************************************************************\
*                                                                          *
* "split copy"                                                             *
*                                                                          *
* Die Bytes aus dem Messagebuffer, auf dessen Kopf mbhd zeigt, in den      *
* Framebuffer, auf dessen Kopf fbp zeigt, kopieren. Es werden hoechstens   *
* max Bytes kopiert, hat die Message mehr Bytes, so wird ein neuer         *
* Messagebuffer angelegt, die restlichen Messagebytes werden in diesen     *
* Buffer kopiert, der neue Buffer wird hinter den alten Messagebuffer      *
* gehaengt, der Putcount des alten Buffers wird auf max gestellt, das      *
* "more follows"-Flag morflg des neuen Buffers wird geloescht, l2fflg wird *
* uebertragen.                                                             *
*                                                                          *
* Return :  YES - der Messagebuffer wurde aufgesplittet                    *
*           NO  - sonst                                                    *
*                                                                          *
\**************************************************************************/

BOOLEAN splcpy(WORD max, MBHEAD *fbp, MBHEAD *mbhd)
{
  char huge *mbbpsa;                    /* Sicherung mbbp                 */
  BOOLEAN split;                        /* TRUE: Split erfolgt            */
  WORD mbgcsa;                          /* Sicherung mbgc                 */
  WORD mbgc2;                           /* mbgc alt -> mbpc alt           */
  WORD n;                               /* Zaehler                        */
  MBHEAD *mbhd2;                        /* Kopfzeiger neuer Messagebuffer */

  split = FALSE;                        /* zunaechst nichts gesplittet    */
  mbbpsa = mbhd->mbbp;                  /* Bufferpointer sichern          */
  mbgcsa = mbhd->mbgc;                  /* Getcounter sichern             */
  for (n = 0; mbhd->mbgc < mbhd->mbpc && n < max; ++n)
    putchr(getchr(mbhd),fbp);           /* maximal max Bytes kopieren     */
  if (mbhd->mbgc < mbhd->mbpc)          /* noch Bytes ueber -> Split !    */
  {
    mbgc2 = mbhd->mbgc;                 /* Getcount fuer spaeter merken   */
    mbhd2 = (MBHEAD *) allocb();        /* neuen Buffer erzeugen          */
    while (mbhd->mbgc < mbhd->mbpc)     /* die restlichen Bytes in diesen */
      putchr(getchr(mbhd),mbhd2);       /* Buffer kopieren                */
    rwndmb(mbhd2);                      /* neuen Buffer rewinden          */
    mbhd2->morflg = FALSE;              /* noch dem neuen folgt keiner    */
    mbhd2->l2fflg = mbhd->l2fflg;       /* Frameflag uebertragen          */
    relink((LEHEAD *)mbhd2
           ,(LEHEAD *)mbhd);            /* neu. Buf. hinter alten haengen */
    mbhd->mbpc = mbgc2;                 /* alter Buffer nur max Zeichen ! */
    split = TRUE;                       /* wir mussten splitten           */
  }
  mbhd->mbbp = mbbpsa;                  /* Bufferpointer restaurieren     */
  mbhd->mbgc = mbgcsa;                  /* Getcount restaurieren          */
  return (split);                       /* Split oder nicht               */
}

/**************************************************************************\
*                                                                          *
* "send UI"                                                                *
*                                                                          *
* UI-Frame aufbauen und senden. Das UI-Frame wird an ID dest geschickt     *
* ueber den Port port und die via-Liste (nullterminiert) vial, als Quelle  *
* wird source genommen, die Infobytes des Frames stehen im Messagebuffer,  *
* auf dessen Kopf mbhd zeigt, die PID wird aus l2fflg dieses Buffers       *
* genommen.                                                                *
*                                                                          *
\**************************************************************************/
void sdui(char *vial, char *dest, char *source, char port, MBHEAD *mbhd)
{
  MBHEAD *fbp;

  cpyid(txfhdr + L2IDLEN,source);
  cpyid(txfhdr,dest);
  cpyidl(txfhdr + L2ILEN,vial);
  txfprt = port;
  txfCR = L2CCR;
  txfPF = 0;
  txfctl = L2CUI;
  putchr(mbhd->l2fflg,fbp = makfhd(0));
  while (mbhd->mbgc < mbhd->mbpc)
    putchr(getchr(mbhd),fbp);
  sdl2fr(fbp, TRUE);
}

/**************************************************************************\
*                                                                          *
* "already connected"                                                      *
*                                                                          *
* Hat dieses Rufzeichen auf diesem Port schon einmal connected?            *
*                                                                          *
\**************************************************************************/
BOOLEAN multiconn(int port, char *id) {
  LHEAD  *llp;
  LNKBLK *lp;

  llp = &l2actl[port];
  for (lp  = (LNKBLK *)llp->head;
       lp != (LNKBLK *)llp;         /* alle Links des Ports pruefen     */
       lp  = lp->next)
    if (cmpcal(lp->realid, id))
      return (TRUE);
  return (FALSE);
}

/**************************************************************************\
*                                                                          *
* "level 2 new state"                                                      *
*                                                                          *
* In einen neuen Zustand uebergehen. Da hier die aktiven Links gezaehlt    *
* werden, duerfen Status-Wechel nur hier durchgefuehrt werden.             *
*                                                                          *
\**************************************************************************/
void l2newstate(WORD newstate)
{
  WORD      oldstate;
  PORTINFO *p;
  int       port;

  oldstate = lnkpoi->state;         /* alten Status merken              */
  lnkpoi->state = newstate;
  if ( oldstate && !newstate) {     /* ein Link wird abgebaut           */
    relink(ulink((LEHEAD *)lnkpoi), /* aus der aktiv-Liste nehmen       */
           (LEHEAD *)l2frel.tail);  /* in die Freiliste haengen         */
    nmblks--;                       /* nun haben wir einen weniger      */
    (p = &portpar[port = lnkpoi->liport])->nmblks--;
    if (!multiconn(port, lnkpoi->realid)) {      /* letzter Connect?    */
      p->nmbstn--;
      autopers(port);               /* Port-Parameter anpassen          */
    }
    getMCs();                       /* Veraenderung DAMA melden         */
  }
  if (!oldstate &&  newstate) {     /* ein Link wird aufgebaut          */
    if (++nmblks > nmblks_max)      /* Maximalwert fuer die Statistik   */
      nmblks_max = nmblks;
    (p = &portpar[port = lnkpoi->liport])->nmblks++;
    if (!multiconn(port, lnkpoi->realid)) {      /* erster Connect?     */
      p->nmbstn++;
      autopers(port);               /* Port-Parameter anpassen          */
    }
    relink(ulink((LEHEAD *)lnkpoi), /* Link aus der frei-Liste nehmen   */
           (LEHEAD *)l2actl[lnkpoi->liport].tail);
    getMCs();                       /* Veraenderung DAMA melden         */
  }
}

/**************************************************************************\
*                                                                          *
* "acknowledge link"                                                       *
*                                                                          *
* Diese Funktion wird vom L7 aufgerufen, um eine eingehende HTH-           *
* Verbindung zu bestaetigen. Es wird lediglich ein Flag gesetzt, in        *
* l2rest wird dann die eigentliche Reaktion ausgeloest.                    *
*                                                                          *
\**************************************************************************/
void acklnk(LNKBLK *lp)
{
  if (lp->state == L2SHTH)
    lp->flag |= L2FACK;
}

/**************************************************************************\
*                                                                          *
* "reject link"                                                            *
*                                                                          *
* Diese Funktion wird vom L7 aufgerufen, um eine eingehende HTH-           *
* Verbindung abzulehnen (Partner ist Busy).                                *
*                                                                          *
\**************************************************************************/
void rejlnk(LNKBLK *lp)
{
  if (lp->state == L2SHTH)
    lp->flag |= L2FREJ;
}

/**************************************************************************\
*                                                                          *
* "get link"                                                               *
*                                                                          *
* Einen Link anhand port, srcid, dstid und vial suchen und liefern. Wenn   *
* wir noch keinen Link haben, dann einen neuen (leeren) liefern.           *
*                                                                          *
\**************************************************************************/
LNKBLK *getlnk(UBYTE liport, char *srcid, char *dstid, char *viaidl)
{
  LHEAD  *llp;
  LNKBLK *lp;
  char   *p;

  llp = &l2actl[liport];          /* auf dem entsprechenden Port      */
  for (lp  = (LNKBLK *)llp->tail;
       lp != (LNKBLK *)llp;       /* alle Links des Ports pruefen     */
       lp  = lp->prev) {
    if (cmpid(lp->srcid,srcid))
      if (   cmpid(lp->dstid,dstid)
          && cmpidl(lp->viaidl,viaidl)) {
        ulink((LEHEAD *)lp);
        relink((LEHEAD *)lp, (LEHEAD *)llp->tail);
        return (lp);              /* wir haben einen Link gefunden    */
      }
  }

  if ((LHEAD *)l2frel.head == &l2frel)
    return (NULL);                /* wir haben keinen freien Link     */

  if (   (!fvalca(VCpar, dstid))
      || (nmbfre < 78))          /* falsches Call oder kein Speicher?*/
    return (NULL);

  lp = (LNKBLK *)l2frel.head;
  cpyid(lp->srcid, srcid);        /* Werte setzen                     */
  cpyid(lp->dstid, dstid);
  cpyidl(lp->viaidl, viaidl);
  lp->liport = liport;
  /* In den Linkblock wird ein Zeiger auf das Rufzeichen abgelegt, das
   * in Wirklichkeit der Ansprechpartner dieses Linkes ist.
   * Es ist das Erste Rufzeichen im via-Feld ohne H-Bit oder das Ziel-
   * rufzeichen selbst.
   */
  for (p = lp->viaidl; *p; p += L2IDLEN)
    if ((p[L2IDLEN - 1] & L2CH) == 0) break;
  lp->realid = *p ? p : lp->dstid;
  return (lp);                    /* leeren Block liefern             */
}

#ifdef PID8
/**************************************************************************\
*                                                                          *
* "pid 8 fragmentierung"                                                   *
*                                                                          *
* Ein PID 8 Frame empfangen und ggfs mit vorhergehenden Frames zusammen-   *
* basteln.                                                                 *
*                                                                          *
\**************************************************************************/
MBHEAD *pid8frag(MBHEAD *fbp)
{
}
#endif

/* End of L2B.C */
