#include <stdio.h>
#include <stdlib.h>
#include "sgp.h"

int main(int argc, char **argv){  
FILE *fptle, *fpdb;
SAT *sats;

if((fptle = fopen(argv[1], "r")) == NULL) 
  { fprintf(stderr, "Unable to open %s\n",argv[1]); return 1; }
if((sats = sgp_sat_read(fptle)) == NULL) {
  fprintf(stderr, "No objects?\n"); return 1; }
fclose(fptle);

 if((fpdb=fopen("sat.db", "w"))==NULL)
 { fprintf(stderr, "Unable to open sat.db\n"); return 1; }

 while(sats!=NULL){
   fprintf(fpdb,"[%5ld%c]\t%s\n", sats->norad, sats->eclass, sats->name);
   fprintf(fpdb,"Group\n");
   fprintf(fpdb,"Beacon\n");
   fprintf(fpdb,"\n\n");
   sats=sats->next;
 }


 fclose(fpdb);
 return 0;
}
