/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <math.h>
#include "trk.h"

/* L'Azimuth e` quello dei navigatori: 0 a NORD */


/* Trasformazione di coordinate dal sistema geocentrico IJK a 
   quello topocentrico locale SEZ; gli angoli sono in 
   radianti, tetha e` il tempo siderale locale
*/
void ijk2sez(double i, double j, double k, double lat, double theta,
	     double *s, double *e, double *z){

  *s=sin(lat)*cos(theta)*i+sin(lat)*sin(theta)*j-cos(lat)*k;
  *e=-sin(theta)*i+cos(theta)*j;
  *z=cos(lat)*cos(theta)*i+cos(lat)*sin(theta)*j+sin(lat)*k;

}


/* Da fare */
void sez2ijk(double s, double e, double z, double lat, double theta,
	     double *i, double *j, double *k){

}

/* Trasformazione dal sistema topocentrico locale SEZ a quello 
   altazimutale locale AZ, EL; gli angoli sono in radianti
*/
void sez2azel(double s, double e, double z,
	      double *az, double *el, double *r){

  *r=sqrt(s*s+e*e+z*z);
  *el=asin(z/ *r); *az=atan2(-e, s);
}

/* Trasformazione dal sistema equatoriale celeste RA, Dec a quello
   altazimuthale locale AZ, EL; angoli in radianti, theta tempo siderale 
   locale.
*/
void radec2azel(double ra, double dec, double theta, double lat,
		double *az, double *el){
  double h;

  h=theta-ra;                                           /* Angolo orario */
  *az=atan2(sin(h), cos(h)*sin(lat)-tan(dec)*cos(lat))+M_PI;
  *el=asin(sin(lat)*sin(dec)+cos(lat)*cos(dec)*cos(h));
}

/* Trasformazione dal sistema altazimutale locale RA, Dec a quello 
   equatoriale celeste; angoli in radianti, theta tempo siderale 
   locale.
*/
void elaz2radec(double az, double el, double theta, double lat,
		double *ra, double *dec){

  *ra=theta-atan2(-sin(az), tan(el)*cos(lat)-cos(az)*sin(lat));
  *dec=asin(sin(lat)*sin(el)+cos(lat)*cos(el)*cos(az));
}

/* Trasformazione dal sistema topocentrico IJK a quello equatoriale 
   celeste RA, Dec; angoli in radianti.
*/
void ijk2radec(double i, double j, double k, double *ra, double *dec){

  *ra=atan2(j, i);
  *dec=asin(k/sqrt(i*i+j*j+k*k));

}

/* Trasformazione dal sistema equatoriale celeste RA, Dec a quello 
   topocentrico IJK; angoli in radianti, la distanza dal centro del sistema
   topocentrico e` posta unitaria.
*/
void radec2ijk(double ra, double dec, double *in, double *jn, double *kn){

  *in=cos(ra); *jn=sin(ra); *kn=sin(dec);

}
