/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

/*
Conversione QTHlocator <-> lon,lat e controllo coerenza fra i due

                          ver 1.0   -  8/3/2001
			  ver 2.0   -  ?/?/?    Ingresso dati onnivoro
 */
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define __VERSION "2.0"

/* Campi che vengono trovati nella scansione della linea di comando */
#define NONE    0
#define QTH     1
#define LON     2
#define LAT     4

int lonlat2qthloc(float, float, char*), qthloc2lonlat(char*, float*, float*);


int main(int argc, char **argv){
int i;
char qth[7], qthchk[7];
float lon, lat;

 if(argc<2){
   printf("QTHloc <-> lon,lat  converter:  use -h for help\n");
   return 0;
 }

 if(argc>4) {
   printf("QTHloc <-> lon,lat  converter:  too many parameter!\n");
   return 0;
 }


 for(i=1; i<argc; i++) {
   if(strncmp(argv[i], "-h", 2)==0) {
     printf("QTHloc <-> lon,lat  converter                     \
by Lapo Pieri (IK5NAX)\n\n");
     printf("qthconv [lon lat] [qthloc] [-h] [-v]\n");
     printf("  -h (this) help\n");
     printf("  -v print qthconv version\n\n");
     printf(\
"If lon is given lat must follow, if only lon, lat are given qthloc will be\n\
calculated, if only qthloc is given lon,lat will be calculated, if both \n\
qthloc and lon,lat are given consistency between them is checked.\n\n");
     return 0;
   }
   if(strncmp(argv[i], "-v", 2)==0) {
     printf("qthconv version %s\n", __VERSION); return 0;
   }
 }


 if(argc==2) {                             /* Dovrebbe essere solo il qth */
   sscanf(argv[1], "%s", qth);   
   if(qthloc2lonlat(qth, &lon, &lat)==-1) {
     printf("Bad data\n"); return 1; }
   printf("%s -> Lon= %10.5f\tLat= %10.5f\n", qth, lon, lat);
   return 0;
 }

 if(argc==3) {                             /* Dovrebbero essere lon, lat */
   if(sscanf(argv[1], "%f", &lon)==0 || sscanf(argv[2], "%f", &lat)==0) {
     printf("Bad data\n"); return 1; }
   if(lonlat2qthloc(lon, lat, qth)==-1) {
     printf("Bad data\n"); return 1; }
   printf("Lon= %10.5f\tLat= %10.5f -> %s\n", lon, lat, qth);
   return 0;
 }

 if(argc==4) {                              /* Confronto lon, lat <-> qth */
   if((argv[1][0]>'0'&&argv[1][0]<'9')||argv[1][0]=='-'||argv[1][0]=='+') {
     if(sscanf(argv[1], "%f", &lon)==0||sscanf(argv[2], "%f", &lat)==0|| 
	sscanf(argv[3], "%s", qth)==0) { printf("Bad data\n"); return 1; }
   }
   else {
     if(sscanf(argv[1], "%s", qth)==0||
	sscanf(argv[2], "%f", &lon)==0||sscanf(argv[3], "%f", &lat)==0) 
       { printf("Bad data\n"); return 1; }
   }
     lonlat2qthloc(lon, lat, qthchk); qthchk[7]='\0'; qth[7]='\0';
     for(i=0; i<6; i++) qth[i]=toupper(qth[i]);
     printf("Lon= %10.5f\tLat= %10.5f and %s ", lon, lat, qth);
     if(strncmp(qth, qthchk, 6)==0) printf("match\n");
     else { 
       printf("do NOT match"); 
       if(strncmp(qth, qthchk, 4)==0) 
	 printf(" (but %c%c%c%c match)\n", qth[0], qth[1], qth[2], qth[3]);
       else
	 printf(" (neither %c%c%c%c match)\n", qth[0], qth[1], qth[2], qth[3]);
	   }
     return 0;
 }
 
 return 0;
}
