/*
 * TRK - Satellite tracking program based on Norad SGP/SDP model with
 *       curses interface
 *
 *	by Lapo Pieri IK5NAX  2000-2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send bugs reports, comments, critique, etc, to ik5nax@amsat.org
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int lonlat2qthloc(float, float, char*), qthloc2lonlat(char*, float*, float*);

typedef struct observer{
  char name[16];       /* Nome convenzionale */
  char descr[70];      /* Descrizione */

  struct observer *prev;   /* linked list */
  struct observer *next;   /* linked list */

  float lat;           /* Latitudine geodetica positiva verso nord [rad] */
  float lon;           /* Longitudine geodetica positiva verso est [rad] */
  float h0;            /* Altezza sul livello del mare [km] */
  char qth[6];         /* QTH locator 6 caratteri [maiuscoli] */
}OBS;

int printobs(OBS *obs){
    
  while(obs!=NULL){
    printf("Obs: %s\n", obs->name);
    printf("\"%s\"\n", obs->descr);
    printf("Lat %f\tLon %f\tAlt %f\tQTH %s\n", obs->lat, obs->lon, obs->h0, 
	   obs->qth);
    obs=obs->next;
    printf("\n");
  }
  
  printf("\n");
  return 0;
}
 

int main(int argc, char **argv){
  FILE *fpobs;
  char lb[80], b[80];
  int n, e=1, chk;
  OBS *obs, *h, *t;
  float v, lon, lat;

  if(argc<2){
    printf("\nshowobs <observerdatabasefiel>\n");
    printf("\n Show database observer (generally called obs.dat)\n\n");
    return 0;
  }

  if((fpobs=fopen(argv[1], "r"))==NULL) {
    fprintf(stderr, "Unable to open %s\n", argv[1]); return 1;
  }

  obs=NULL; h=NULL; t=NULL;

  while(e){
    for(n=0; n<80; n++) lb[n]=0;

    /* Controllo della fine del file */
    if(fgets(lb, 80, fpobs)==NULL) { e=0; lb[0]='['; }

    /* Il carattere "#" e` per i commenti */
    if(lb[0]=='#') continue;

    /* Se e` stato trovato un carattere "[" ... */
    if(lb[0]=='[') {          
      if(obs!=NULL) {              /* ...ma non e` il primo osservatore */
                                   /* allora si puo` salvare la struttura obs
				      nella lista concatenata: non ho ben
				      chiaro come funzioni tutto cio` ma 
				      copiando dal file tle.c (proveniente dal
				      programma COLA) tutto funziona...
				   */

/* Prima si fanno pero` alcuni controlli e si riempiono i campi mancanti */

	chk=0;
	/* Se lon e lat non sono stati letti si cerca di ottenerli dal QTH */
	if(obs->lat>90.&&obs->lon>180.){
	  if(obs->qth[0]==0) chk=1;                   /* Non ci sono ne' lon,
							 lat, ne qth... */
	  else if(qthloc2lonlat(obs->qth, &lon, &lat)<0) chk=2; /* Errore
								   formato 
								   QTHloc */
	  else { obs->lon=lon; obs->lat=lat; }
	}

	/* Altrimenti si verifica che siano concordi con il QTH */
	else if(obs->qth[0]!=0) {
	  lonlat2qthloc(obs->lon, obs->lat, b);
	  if(strcmp(b, obs->qth)!=0) chk=3;
	}

	/* Se invece il QTH non c'e` fra i dati lo si calcola */
	else{
	  lonlat2qthloc(obs->lon, obs->lat, b);
	  strcpy(obs->qth, b);
	}

	/* Di controlli da fare ce ne sarebbero ancora, come ad esempio solo
	   lon o solo lat, ecc..., ma per ora bastano questi.
	*/

/* Se i dati sono buoni, si salvano con il metodo delle liste concatenate */
	if(chk==0){
	  if(h==NULL)
	    h=obs;
	  if(t!=NULL)
	    t->next=obs;
	  obs->prev=t;
	  t=obs;
	}
      
	/* Se invece i dati non sono buoni non c'e` bisogno di fare nulla,
	   a meno che non si vogliano fare delle segnalazioni, come ad 
	   esempio:
	*/
	else{
	  switch(chk){
	  case 1:
	    fprintf(stderr, "No lon, lat, neither QTHloc for [%s]!\n",
		    obs->name); break;
	  case 2:  
	    fprintf(stderr, "Error in QTHloc format for [%s]\n", obs->name);
	    break;
	  case 3:
	    qthloc2lonlat(obs->qth, &lon, &lat);
	    fprintf(stderr, "QTHloc do not match for [%s]: should be %s or \
lon %7.3f, lat %7.3f\n", obs->name, b, lon, lat);
	    break;

	  default: printf("Unknown error!\n"); break;
	  }
	
	}
      }

      /* Ora si puo` riservare la memoria per una nuova struttura; con il
	 sistema delle liste concatenate non e` necessario liberare la
	 memoria con free(obs).
      */
      obs=(OBS *)malloc(sizeof(OBS));
      
      /* Si impongono dei valori non validi o nulli per verificare cosa sia
	 stato assegnato o meno prima di salvare la struttura
      */
      obs->lat=91.;
      obs->lon=181.;
      obs->h0=0.;      
      obs->qth[0]=0;
      obs->descr[0]=0;
      obs->name[0]=0;

      n=1;
      if(e!=0){
      while(lb[n]!=']') { obs->name[n-1]=lb[n]; n++; }
      obs->name[n-1]=0;
      }
}

    
    /* Se invece la riga non inizia ne' con un "#", ne' con una "[", allora 
       bisogna analizzare il tipo di dato
    */
    else{      

      /* Le stringhe andrebbero trasformate tutte maiuscole */
      if(strncmp(lb, "lon", strlen("lon"))==0){ 
  	if(sscanf(lb+strlen("lon")+1, "%f", &v)!=EOF)
	  obs->lon=v;	
	else 
	  obs->lon=181.;
      }
      if(strncmp(lb, "lat", strlen("lat"))==0){ 
  	if(sscanf(lb+strlen("lat")+1, "%f", &v)!=EOF)
	  obs->lat=v;	
	else
	  obs->lat=91.;
      }
      if(strncmp(lb, "height", strlen("height"))==0){ 
  	if(sscanf(lb+strlen("height")+1, "%f", &v)!=EOF)
	  obs->h0=v;
	else
	  obs->h0=0.;
      }
      if(strncmp(lb, "QTHloc", strlen("QTHloc"))==0){ 
  	if(sscanf(lb+strlen("QTHloc")+1, "%s", b)!=EOF)
	  strcpy(obs->qth, b);
	else
	  obs->qth[0]=0;
      }
      /* Questa gestione delle stringhe e` fatta malino, non ci sono controlli
	 sulla lunghezza, si assume che le linee siano terminate da un solo
	 carattere (0x0d), insomma e` da rifare per benino, anche se cosi` 
	 funziona
      */
      if(strncmp(lb, "Descr", strlen("Descr"))==0){ 
  	strncpy(obs->descr, lb+strlen("Descr")+1,
		strlen(lb+strlen("Descr")+1)-1);
	obs->descr[strlen(lb+strlen("Descr")+1)-1]=0;
      }
/* Se il campo non e` riconosciuto viene semplicemente ignorato, forse
   si potrebbe fare di meglio...
*/

    }
  }

  /* Questo e` per l'ultimo osservatore letto, forse il ciclo potrebbe essere
     fatto meglio, ma non ho capito bene come funziona nemmeno questo
  */
  /*
  t->next=obs;
  obs->prev=t;
  t=obs;
  */

  /* L'inizio della lista concatenata inizia da h */
  printobs(h);

  fclose(fpobs);
  return 0;
}
