/*****************************************************************************/

/*
 *	xfhdlcchpar.c  -- kernel hdlc radio modem driver channel parameter setting utility.
 *
 *	Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 *
 * History:
 *   0.1  14.12.96  Started
 */

/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <linux/hdlcdrv.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <netinet/in.h>
#include <linux/if_ether.h>
#include <forms.h>
#include "xfhdlcchpar.h"

/* ---------------------------------------------------------------------- */

static int sock_sm;
static struct ifreq ifr_sm;
static char *progname;
static FD_chpar *fd_chpar;

/* ---------------------------------------------------------------------- */

int do_hdlcdrv_ioctl(int cmd, struct hdlcdrv_ioctl *par)
{
	struct ifreq ifr = ifr_sm;
	
	ifr.ifr_data = (caddr_t)par;
	par->cmd = cmd;
	return ioctl(sock_sm, SIOCDEVPRIVATE, &ifr);
}

/* ---------------------------------------------------------------------- */

void cb_update(FL_OBJECT *ob, long data)
{
	int ret;
	struct hdlcdrv_ioctl bhi;

	bhi.data.cp.tx_delay = 0.1*fl_get_slider_value(fd_chpar->txdelay);
	bhi.data.cp.tx_tail = 0.1*fl_get_slider_value(fd_chpar->txtail);
	bhi.data.cp.slottime = 0.1*fl_get_slider_value(fd_chpar->slottime);
	bhi.data.cp.ppersist = fl_get_slider_value(fd_chpar->ppersist);
	bhi.data.cp.fulldup = !!fl_get_button(fd_chpar->fulldup);
	ret = do_hdlcdrv_ioctl(HDLCDRVCTL_SETCHANNELPAR, &bhi);
	if (ret < 0) 
		perror("ioctl (HDLCDRVCTL_SETCHANNELPAR)");
}

/* ---------------------------------------------------------------------- */

void cb_quit(FL_OBJECT *ob, long data)
{
	exit(0);
}

/* ---------------------------------------------------------------------- */

static const char *usage_str = 
"[-i smif]\n"
"  -i: specify the name of the baycom kernel driver interface\n\n";

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	int ret;
	char *name_sm = "sm0";
	struct hdlcdrv_ioctl bhi;

	progname = *argv;
	printf("%s: Version 0.1; (C) 1996 by Thomas Sailer HB9JNX/AE4WA\n", *argv);
	fl_initialize(&argc, argv, 0, 0, 0);
	while ((ret = getopt(argc, argv, "i:")) != -1) {
		switch (ret) {
		case 'i':
			name_sm = optarg;
			break;
		default:
			printf("usage: %s %s", *argv, usage_str);
			exit(-1);
		}
	}
	if ((sock_sm = socket(PF_INET, SOCK_PACKET, htons(ETH_P_AX25))) < 0) {
		perror("socket");
		exit(-1);
	}
	strcpy(ifr_sm.ifr_name, name_sm);

	fd_chpar = create_form_chpar();
	fl_set_object_label(fd_chpar->ifname, name_sm);
	/*
	 * set channel params
	 */
	ret = do_hdlcdrv_ioctl(HDLCDRVCTL_GETCHANNELPAR, &bhi);
	if (ret < 0) {
		perror("ioctl (HDLCDRVCTL_GETCHANNELPAR)");
		exit(1);
	}
	fl_set_slider_step(fd_chpar->txdelay, 10);
	fl_set_slider_value(fd_chpar->txdelay, bhi.data.cp.tx_delay*10);
	fl_set_slider_step(fd_chpar->txtail, 10);
	fl_set_slider_value(fd_chpar->txtail, bhi.data.cp.tx_tail*10);
	fl_set_slider_step(fd_chpar->slottime, 10);
	fl_set_slider_value(fd_chpar->slottime, bhi.data.cp.slottime*10);
	fl_set_slider_step(fd_chpar->ppersist, 1);
	fl_set_slider_value(fd_chpar->ppersist, bhi.data.cp.ppersist);
	fl_set_button(fd_chpar->fulldup, !!bhi.data.cp.fulldup);
	fl_show_form(fd_chpar->chpar, FL_PLACE_CENTER, FL_FULLBORDER, 
		     "HDLC channel parameters");
	for (;;)
		fl_do_forms();
	exit(0);
}
