/*****************************************************************************/

/*
 *	xfhdlcst.c  -- kernel hdlc radio modem driver status display utility.
 *
 *	Copyright (C) 1996  Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Please note that the GPL allows you to use the driver, NOT the radio.
 *  In order to use the radio, you need a license from the communications
 *  authority of your country.
 *
 *
 * History:
 *   0.1  14.12.96  Started
 */

/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <linux/hdlcdrv.h>
#include <linux/soundmodem.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <netinet/in.h>
#include <linux/if_ether.h>
#include <forms.h>
#include "xfhdlcst.h"

/* ---------------------------------------------------------------------- */

static int sock_sm;
static struct ifreq ifr_sm;
static char *progname;

/* ---------------------------------------------------------------------- */

int do_hdlcdrv_ioctl(int cmd, struct hdlcdrv_ioctl *par)
{
	struct ifreq ifr = ifr_sm;
	
	ifr.ifr_data = (caddr_t)par;
	par->cmd = cmd;
	return ioctl(sock_sm, SIOCDEVPRIVATE, &ifr);
}

/* ---------------------------------------------------------------------- */

static int do_sm_ioctl(int cmd, struct sm_ioctl *par)
{
	struct ifreq ifr = ifr_sm;
	
	ifr.ifr_data = (caddr_t)par;
	par->cmd = cmd;
	return ioctl(sock_sm, SIOCDEVPRIVATE, &ifr);
}

/* ---------------------------------------------------------------------- */

void cb_quit(FL_OBJECT *ob, long data)
{
	exit(0);
}

/* ---------------------------------------------------------------------- */

static const char *usage_str = 
"[-i smif]\n"
"  -i: specify the name of the baycom kernel driver interface\n\n";

/* ---------------------------------------------------------------------- */

int main(int argc, char *argv[])
{
	FD_hdlcst *fd_hdlcst;
	FL_OBJECT *obj;
	int ret;
	char *name_sm = "sm0";
	struct hdlcdrv_ioctl bhi;
	struct sm_ioctl smi;
	char buf[32];

	progname = *argv;
	printf("%s: Version 0.1; (C) 1996 by Thomas Sailer HB9JNX/AE4WA\n", *argv);
	fl_initialize(&argc, argv, 0, 0, 0);
	while ((ret = getopt(argc, argv, "i:")) != -1) {
		switch (ret) {
		case 'i':
			name_sm = optarg;
			break;
		default:
			printf("usage: %s %s", *argv, usage_str);
			exit(-1);
		}
	}
	if ((sock_sm = socket(PF_INET, SOCK_PACKET, htons(ETH_P_AX25))) < 0) {
		perror("socket");
		exit(-1);
	}
	strcpy(ifr_sm.ifr_name, name_sm);

	fd_hdlcst = create_form_hdlcst();
	fl_set_timer(fd_hdlcst->timer, 0.1);
	/*
	 * set driver and modem name
	 */
	ret = do_hdlcdrv_ioctl(HDLCDRVCTL_GETMODE, &bhi);
	if (ret < 0) {
		fl_hide_object(fd_hdlcst->modename);
		perror("ioctl (HDLCDRVCTL_GETMODE)");
	} else 
		fl_set_object_label(fd_hdlcst->modename, bhi.data.modename);
	ret = do_hdlcdrv_ioctl(HDLCDRVCTL_DRIVERNAME, &bhi);
	if (ret < 0) {
		fl_hide_object(fd_hdlcst->drivername);
		perror("ioctl (HDLCDRVCTL_DRIVERNAME)");
	} else 
		fl_set_object_label(fd_hdlcst->drivername, bhi.data.drivername);
	/*
	 * check for soundmodem driver
	 */
	ret = do_sm_ioctl(SMCTL_GETDEBUG, &smi);
	if (ret < 0) {
		fl_hide_object(fd_hdlcst->tdemodcyc);
		fl_hide_object(fd_hdlcst->tmodcyc);
		fl_hide_object(fd_hdlcst->tintfreq);
		fl_hide_object(fd_hdlcst->tdmares);
		fl_hide_object(fd_hdlcst->demodcyc);
		fl_hide_object(fd_hdlcst->modcyc);
		fl_hide_object(fd_hdlcst->intfreq);
		fl_hide_object(fd_hdlcst->dmares);
	}
	fl_show_form(fd_hdlcst->hdlcst, FL_PLACE_CENTER, FL_FULLBORDER, "HDLC driver state");
	while ((obj = fl_do_forms())) {
		fl_freeze_form(fd_hdlcst->hdlcst);
		if (obj == fd_hdlcst->timer)
			fl_set_timer(fd_hdlcst->timer, 0.5);
		/*
		 * display state
		 */
		ret = do_hdlcdrv_ioctl(HDLCDRVCTL_GETSTAT, &bhi);
		if (ret >= 0) {
			fl_set_button(fd_hdlcst->ptt, bhi.data.cs.ptt);
			fl_set_button(fd_hdlcst->dcd, bhi.data.cs.dcd);
			sprintf(buf, "%d", bhi.data.cs.stats.tx_packets);
			fl_set_object_label(fd_hdlcst->txpacket, buf);
			sprintf(buf, "%d", bhi.data.cs.stats.tx_errors);
			fl_set_object_label(fd_hdlcst->txerror, buf);
			sprintf(buf, "%d", bhi.data.cs.stats.rx_packets);
			fl_set_object_label(fd_hdlcst->rxpacket, buf);
			sprintf(buf, "%d", bhi.data.cs.stats.rx_errors);
			fl_set_object_label(fd_hdlcst->rxerror, buf);
		}
		ret = do_sm_ioctl(SMCTL_GETDEBUG, &smi);
		if (ret >= 0) {
			sprintf(buf, "%d", smi.data.dbg.int_rate);
			fl_set_object_label(fd_hdlcst->intfreq, buf);
			sprintf(buf, "%d", smi.data.dbg.mod_cycles);
			fl_set_object_label(fd_hdlcst->modcyc, buf);
			sprintf(buf, "%d", smi.data.dbg.demod_cycles);
			fl_set_object_label(fd_hdlcst->demodcyc, buf);
			sprintf(buf, "%d", smi.data.dbg.dma_residue);
			fl_set_object_label(fd_hdlcst->dmares, buf);
		} 
		fl_unfreeze_form(fd_hdlcst->hdlcst);
	}
	exit (0);
}
