
/* CON_FILT.EXE example file.

   Written by an anonymous. Thanks to him. 
   Adapted by F6FBB and added MD5.

   This server use the CON_FILT.PSW file, that have this format:
   Every empty line, or line that start with the '#' are ignored.
   The first valid line are password request prompt.
   The second line is the filter mode, 0 for OPEN SYTEM, 1 for CLOSED SYSTEM.
   The others line are the callsign, without ssid, flag and its password, like:
   CALL FLAG PASSWORD
   CALL FLAG PASSWORD
   ... etc.

   NOTE: PASSWORD is not needed if FLAG=0


   OPEN SYSTEM MODE
   If the call is not declared in the con_filt.psw file, the user will be
   connected without password request, userful for bbs forward, or user that
   do not want password.
   If a callsign is declared:
   if FLAG=0, the callsign is excluded, disconneted.
   if FLAG=1, the callsign is connected after the password request.

   CLOSE SYSTEM MODE
   Only the callsign declared in the con_filt.psw may access to the system,
   the other will be disconneted.
   For declared callsign:
   if FLAG=0, the connection is accepted without password request.
   if FLAG=1, the connection is accepted, but the password will be requested.

   >  Prompt must be long at most 80 characters
   >  Password my be long at most 255 characters, without space.
   >  This program, if renamed C_FILTER.EXE, run also under FBB 5.15a and upper

   The server use a temporary file XXXXXX.CFT, where XXXXXX is the callsign of
   the user, to store the calculated password and date time of any unsuccesful
   logon; you do not need to touch this file, all management will be done by
   con_filt; the temporary file will be automatically deleted when not more
   needed.

   The server use both the standard 5 letters password and the MD2 (c)RSA
   alghoritm. The user may answer in standard or md2 mode, the server will
   decode automatically the corrected mode.

   The line arguments given to the CON_FILT from TstHost are :
   - Callsign (format as IK1GKJ).
   - Level number (0 is the first time, up to 255).
   - reserved, always 0
   - reserved, always 0
   - reserved, always 0
   - reserved, always 1
   - Received data (each word is a new argument).

   The CON_FILT program end with an exit value. This value tells the PMS what do:
   - 0 accept connection.
   - 1 the program will be called again and the level number is incremented.
   - 2 the user will be disconnected.

 */

#define STRICT
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <ctype.h>

#ifdef __LINUX__
#include <unistd.h>
#endif

#ifdef __WINDOWS__
#include <io.h>
#include <windows.h>
#endif

#include "global.h"
#include "md2.h"
#include "md5.h"

#ifdef __LINUX__
#define stricmp strcasecmp
#define FAR
#endif


#ifdef __WIN32__
#ifndef FAR
#define FAR
#endif
#endif

static void fcat (char FAR * buf, char *str);
static int error (char FAR * buffer);	/* this function exit with a value of 2 */

char call[8] = "", call1[8] = "", buffer[400] = "", tmp[100] = "", UserFile[20] = "",
  BbsPrompt[81] = "", Password[256] = "", ExcludeMessage[] = "\n*** Sorry, you can not access to this system.\n",
  ReadOnlyMessage[] = "\n*** Warning, read-only access !\n";
int pass[5], Port, level, SystemMode, UserFlag;
long timet;
FILE *pf;
unsigned char MD2digest[16];
MD2_CTX MD2context;
unsigned char MD5digest[16];
MD5_CTX MD5context;
int lg;

#ifdef __WINDOWS__
int _export FAR PASCAL svc_main (int ac, char FAR ** av, char FAR * r_buf, int len)
{
#endif

#ifdef __LINUX__
int main (int ac, char **av)
{
	char *r_buf = NULL;
	int len = 0;

#endif

/* FIRST GET LEVEL NUMBER AND THE CALLSIGN, MAKE USER FILE NAME */
	int i = 0, found = 0, jj;
	int OldPasswd;
	char *ptr;

	if (r_buf)
		r_buf[0] = '\0';

	lg = len;

	if (ac < 7)
		return error (r_buf);
	level = atoi (av[2]);

	Port = atoi (av[6]);		/* THIS AND NEXT INSTRUCTION ARE ONLY FOR FBB */
	if (!Port)
		return 0;				/* PORT 0 IS CONSOLLE UNDER FBB */

	if (sscanf (av[1], "%7[!a-zA-Z0-9]", call) != 1)
		return error (r_buf);
	sprintf (UserFile, "%s.cft", call);

/* AT CONNECTION, READ IN CON_FILT.PSW, TO SEARCH FOR THE USER CALLSIGN
   THE FIRST VALID LINE IN THE FILE ARE THE PMS REQUEST PASSWORD PROMPT
   NEXT THE SISTEM OPEN/CLOSE MODE
   NEXT THE USER CALL FLAG PASSWORD */
	if (!level)
	{
#ifdef __WINDOWS__
		if ((pf = fopen ("con_filt.psw", "rt")) == NULL)
			return error (r_buf);
#endif
#ifdef __LINUX__
		if ((pf = fopen ("con_filt.psw", "r")) == NULL)
			return error (r_buf);
#endif
		/* i = 0; */
		while (fgets (buffer, 399, pf))
		{
			/* Epurer la ligne !!! */
			ptr = buffer;
			while ((*ptr) && (!isgraph (*ptr)))
				++ptr;
			if (*ptr == 0 || *ptr == '\n' || *ptr == '#')
				continue;

			/* strupr(ptr); */

			if (i == 0)
			{
				if (sscanf (ptr, " %80[^\n]", BbsPrompt) != 1)
					return error (r_buf);
				i++;
				continue;
			}

			if (i == 1)
			{
				OldPasswd = 1;
				if (sscanf (ptr, " %d %d", &SystemMode, &OldPasswd) < 1)
					return error (r_buf);
				i++;
				continue;
			}

			jj = sscanf (ptr, " %7[!a-zA-Z0-9] %d %255s", call1, &UserFlag, Password);
			if (jj < 2 || (jj < 3 && UserFlag))
				return error (r_buf);
			if (stricmp (call, call1))
				continue;
			found = 1;
			break;
		}
		if (ferror (pf))
			return (error (r_buf));
		fclose (pf);

		if (atoi (av[4]) == -1)
		{

			/* Remote BBS authentication */

			ptr = av[7];

			while ((*ptr) && (*ptr != '['))
				++ptr;

			if (*ptr == '\0')
			{
				fcat (r_buf, "*** No MD string\n");
				return (0);
			}

			/* i = */ sscanf (ptr + 1, "%ld", &timet);

			sprintf (buffer, "%010ld%s", timet, Password);

			MD5Init (&MD5context);

			MD5Update (&MD5context, (unsigned char *) buffer, strlen (buffer));

			MD5Final (MD5digest, &MD5context);


			/* NOW CONVERT 16 MD2 CHARACTERS TO LITERAL 32 BYTE HEX NOTATION */
			for (i = 0; i < 16; i++)
				sprintf (&tmp[i * 2], "%02x", MD5digest[i]);
			tmp[32] = '\n';
			tmp[33] = '\0';
			fcat (r_buf, tmp);
			return (0);
		}

		if (SystemMode == 0)	/* IN OPEN SYSTEM MODE */
		{						/* CALL NOT FOUND, ACCEPT CONNECTION */
			if (!found)
				return (0);		/* WITHOUT PASSWORD */
			if (!UserFlag)		/* IF FLAG=0, CALLSIGN IS EXCLUDED */
			{
				fcat (r_buf, ExcludeMessage);
				return (2);		/* OTHERWISE ASK FOR THE PASSWORD */
			}
		}
		else
		{						/* IN CLOSED SYSTEM MODE */
			if (!found)
			{
				if (SystemMode == 2)	/* IN OPEN SYSTEM MODE */
				{				/* CALL NOT FOUND, ACCEPT READ-ONLY CONNECTION */
					fcat (r_buf, ReadOnlyMessage);
					return (3);
				}
				else
				{				/* CALL NOT FOUND, DISCONNECT */
					fcat (r_buf, ExcludeMessage);
					return (2);
				}
			}
			if (!UserFlag)
				return (0);		/* FLAG=0, CONNECT WITHOUT PASSWORD */
		}						/* OTHERWISE ASK FOT THE PASSWORD */

		/* NEXT CALCULATE 5 RANDOM NUMERS FOR STANDARD PASSWORD */
		level = strlen (Password);

#ifdef __WINDOWS__
		randomize ();
		for (i = 0; i < 5; i++)
			pass[i] = random (level);
#endif

#ifdef __LINUX__
		srandom (time (NULL));
		for (i = 0; i < 5; i++)
			pass[i] = random () % level;
#endif

		/* NEXT MAKE THE MD2 PASSWORD, FIRST GET CURRENT DATE TIME, THIS
		   VALUE IS ALSO USED TO MAKE AN UNIQUE 10 CHARACTERS STRING.
		   TO THOSE 10 CHAR WILL BE ADD THE USERS PASSWORD,
		   THE RESULTING STRING WILL BE PASSED TO THE MD2 ALGHORITM */

		timet = time (NULL);

		/* OPEN THE USER FILENAME, IF THE FILE DO NOT EXIST, WILL BE CREATED
		   OTHERWISE WILL BE OPENED FOR READ AND WRITE */
#ifdef __WINDOWS__
		if ((pf = fopen (UserFile, access (UserFile, 0) ? "wt" : "rt+")) == NULL)
			return error (r_buf);
#endif
#ifdef __LINUX__
		if ((pf = fopen (UserFile, access (UserFile, 0) ? "w" : "r+")) == NULL)
			return error (r_buf);
#endif

		/* NOTE THAT THE FIRST LINE OF THE FILE HAVE ALWAYS THE SAME SIZE, THIS
		   LINE IS USED TO STORE THE CALCULATED ANSWER, FIRST THE 5 LETTER MODE
		   A SPACE, AND NEXT THE 32 BYTE MD2 */
		rewind (pf);
		fprintf (pf, "%c%c%c%c%c %ld %s\n", Password[pass[0]], Password[pass[1]],
				 Password[pass[2]], Password[pass[3]], Password[pass[4]], timet, Password);

		/* NOW GO TO THE END OF FILE, AND STORE THE DATE TIME FOR THIS LOGON */
		fseek (pf, 0L, SEEK_END);
		fprintf (pf, "%s", ctime (&timet));
		if (ferror (pf))
			return error (r_buf);
		fclose (pf);

		/* AT THE END, SEND TO THE USER THE PROMPT, THE 5 NUMBERS, AND MD2
		   REQUEST PASSWORD */
		if (OldPasswd)
		{
			sprintf (tmp, "\n%s %d %d %d %d %d [%010ld]\n",
					 BbsPrompt, pass[0] + 1, pass[1] + 1, pass[2] + 1, pass[3] + 1, pass[4] + 1, timet);
		}
		else
		{
			sprintf (tmp, "\n%s [%010ld]\n", BbsPrompt, timet);
		}
		fcat (r_buf, tmp);
		return 1;				/* CON_FILT MUST BE CALLED AGAIN */
	}


/* LEVEL 1, CON_FILT RECEIVE THE PASSWORD ANSWER FROM THE USER */

/* FIRST OPEN THE USER FILE AND RETRIEVE THE 5 LETTER AND MD2 CORRECTED DATA */
#ifdef __WINDOWS__
	if ((pf = fopen (UserFile, "rt")) == NULL)
		return error (r_buf);
#endif
#ifdef __LINUX__
	if ((pf = fopen (UserFile, "r")) == NULL)
		return error (r_buf);
#endif

	if (!fgets (buffer, 399, pf))
		return error (r_buf);

	if (sscanf (buffer, " %5s %ld %255s", BbsPrompt, &timet, Password) != 3)
		return error (r_buf);
//  i = 0;

	ptr = av[7];
	while (*ptr)
	{
		if (!isprint (*ptr))
			*ptr = '\0';
		++ptr;
	}

/* IF exact password, return ok */
	i = stricmp (av[7], Password);

	if (i)
	{
/* IF USER ANSWER IS EXACTLY 32 BYTE LONG, TREAT THE DATA LIKE MD2, OTHERWISE
   LIKE A 5 LETTERS PASSWORD */
		if (strlen (av[7]) == 32)
		{
			/* Try MD5 */

			sprintf (buffer, "%010ld%s", timet, Password);
			MD5Init (&MD5context);
			MD5Update (&MD5context, (unsigned char *) buffer, level + 10);
			MD5Final (MD5digest, &MD5context);

			/* NOW CONVERT 16 MD2 CHARACTERS TO LITERAL 32 BYTE HEX NOTATION */
			for (i = 0; i < 16; i++)
				sprintf (&tmp[i * 2], "%02x", MD5digest[i]);

			i = stricmp (av[7], tmp);	/* yes, use md5 password, ignoring case */

			if (i == 0)
			{
				/* Try MD2 */
				MD2Init (&MD2context);
				MD2Update (&MD2context, (unsigned char *) buffer, level + 10);
				MD2Final (MD2digest, &MD2context);

				/* NOW CONVERT 16 MD2 CHARACTERS TO LITERAL 32 BYTE HEX NOTATION */
				for (i = 0; i < 16; i++)
					sprintf (&tmp[i * 2], "%02x", MD2digest[i]);

				i = stricmp (av[7], tmp);	/* yes, use md2 password, ignoring case */

			}
		}
		else
			i = strcmp (av[7], BbsPrompt);
	}

/* IF INCORRECT PASSWORD, DISCONNECT THE USER, CLOSE BUT NOT DELETE THE
   USERS FILE */
	if (i)
	{
		fcat (r_buf, "\n*** Password error.\n");
		fclose (pf);
		return 2;
	}

/* RIGHT PASSWORD, BEFORE DELETE THE USER FILE, SEND TO THE USER ALL
   UNSUCCESFUL LOGON REGISTERED IN THE FILE (IF EXIST) */

/* REMEMBER THAT THE LAST LINE IN THE FILE IS >THIS CONNECTION TIME<
   AND MUST NOT BE SEND, SINCE THIS CONNETCTION WAS SUCCESFUL */
	fgets (tmp, 80, pf);
	while (fgets (buffer, 80, pf))
	{
		if (level)
		{
			level = 0;
			fcat (r_buf, "\n*** WARNING -> Attempt to connect and password failure on:\n");
		}
		fcat (r_buf, tmp);
		strcpy (tmp, buffer);
	}
	fcat (r_buf, "\n");
	fclose (pf);
	unlink (UserFile);
	return 0;
}

static void fcat (char FAR * buf, char *str)
{
#ifdef __WINDOWS__
	int len = strlen (str);

	if (lg > len)
	{
		strcat (buf, str);
		lg -= len;
	}
	else
	{
		lg = 0;
	}
#endif
#ifdef __LINUX__
	fputs (str, stdout);
#endif
}

static int error (char FAR * buf)
{
	fcat (buf, "\n*** Connection filtering: System error.\n");
	return (2);
}
